/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;

public class PdfStructureAttributes
extends PdfObjectWrapper<PdfDictionary> {
    public PdfStructureAttributes(PdfDictionary attributesDict) {
        super(attributesDict);
    }

    public PdfStructureAttributes(String owner) {
        super(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.O, PdfStructTreeRoot.convertRoleToPdfName(owner));
    }

    public String getPdfOwner() {
        PdfName pdfName = (PdfName)((PdfDictionary)this.getPdfObject()).get(PdfName.O);
        return pdfName == null ? null : pdfName.getValue();
    }

    public PdfStructureAttributes(PdfNamespace namespace) {
        super(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.O, PdfName.NSO);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.NS, (PdfObject)namespace.getPdfObject());
    }

    public PdfStructureAttributes addEnumAttribute(String attributeName, String attributeValue) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        ((PdfDictionary)this.getPdfObject()).put(name, new PdfName(attributeValue));
        this.setModified();
        return this;
    }

    public PdfStructureAttributes addTextAttribute(String attributeName, String attributeValue) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        ((PdfDictionary)this.getPdfObject()).put(name, new PdfString(attributeValue, "UnicodeBig"));
        this.setModified();
        return this;
    }

    public PdfStructureAttributes addIntAttribute(String attributeName, int attributeValue) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        ((PdfDictionary)this.getPdfObject()).put(name, new PdfNumber(attributeValue));
        this.setModified();
        return this;
    }

    public PdfStructureAttributes addFloatAttribute(String attributeName, float attributeValue) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        ((PdfDictionary)this.getPdfObject()).put(name, new PdfNumber(attributeValue));
        this.setModified();
        return this;
    }

    public String getAttributeAsEnum(String attributeName) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        PdfName attrVal = ((PdfDictionary)this.getPdfObject()).getAsName(name);
        return attrVal != null ? attrVal.getValue() : null;
    }

    public String getAttributeAsText(String attributeName) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        PdfString attrVal = ((PdfDictionary)this.getPdfObject()).getAsString(name);
        return attrVal != null ? attrVal.toUnicodeString() : null;
    }

    public Integer getAttributeAsInt(String attributeName) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        PdfNumber attrVal = ((PdfDictionary)this.getPdfObject()).getAsNumber(name);
        return attrVal != null ? Integer.valueOf(attrVal.intValue()) : (Integer)null;
    }

    public Float getAttributeAsFloat(String attributeName) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        PdfNumber attrVal = ((PdfDictionary)this.getPdfObject()).getAsNumber(name);
        return attrVal != null ? Float.valueOf(attrVal.floatValue()) : (Float)null;
    }

    public PdfStructureAttributes removeAttribute(String attributeName) {
        PdfName name = PdfStructTreeRoot.convertRoleToPdfName(attributeName);
        ((PdfDictionary)this.getPdfObject()).remove(name);
        this.setModified();
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

