/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.event.PdfDocumentEvent;
import com.itextpdf.kernel.pdf.layer.PdfLayer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PageFlushingHelper {
    private static final DeepFlushingContext pageContext = PageFlushingHelper.initPageFlushingContext();
    private PdfDocument pdfDoc;
    private boolean release;
    private HashSet<PdfObject> currNestedObjParents = new HashSet();
    private Set<PdfIndirectReference> layersRefs = new HashSet<PdfIndirectReference>();

    public PageFlushingHelper(PdfDocument pdfDoc) {
        this.pdfDoc = pdfDoc;
    }

    public void unsafeFlushDeep(int pageNum) {
        if (this.pdfDoc.getWriter() == null) {
            throw new IllegalArgumentException("Flushing writes the object to the output stream and releases it from memory. It is only possible for documents that have a PdfWriter associated with them. Use PageFlushingHelper#releaseDeep method instead.");
        }
        this.release = false;
        this.flushPage(pageNum);
    }

    public void releaseDeep(int pageNum) {
        this.release = true;
        this.flushPage(pageNum);
    }

    public void appendModeFlush(int pageNum) {
        if (this.pdfDoc.getWriter() == null) {
            throw new IllegalArgumentException("Flushing writes the object to the output stream and releases it from memory. It is only possible for documents that have a PdfWriter associated with them. Use PageFlushingHelper#releaseDeep method instead.");
        }
        PdfPage page = this.pdfDoc.getPage(pageNum);
        if (page.isFlushed()) {
            return;
        }
        page.getDocument().dispatchEvent(new PdfDocumentEvent("EndPdfPage", page));
        boolean pageWasModified = ((PdfDictionary)page.getPdfObject()).isModified();
        page.setModified();
        this.release = true;
        pageWasModified = this.flushPage(pageNum) || pageWasModified;
        PdfArray annots = ((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.Annots);
        if (annots != null && !annots.isFlushed()) {
            this.arrayFlushIfModified(annots);
        }
        PdfObject thumb = ((PdfDictionary)page.getPdfObject()).get(PdfName.Thumb, false);
        this.flushIfModified(thumb);
        PdfObject contents = ((PdfDictionary)page.getPdfObject()).get(PdfName.Contents, false);
        if (contents instanceof PdfIndirectReference) {
            if (contents.checkState((short)8) && !contents.checkState((short)1)) {
                PdfObject contentsDirectObj = ((PdfIndirectReference)contents).getRefersTo();
                if (contentsDirectObj.isArray()) {
                    this.arrayFlushIfModified((PdfArray)contentsDirectObj);
                } else {
                    contentsDirectObj.flush();
                }
            }
        } else if (contents instanceof PdfArray) {
            this.arrayFlushIfModified((PdfArray)contents);
        } else if (contents instanceof PdfStream) {
            this.flushIfModified(contents);
        }
        if (!pageWasModified) {
            ((PdfDictionary)page.getPdfObject()).getIndirectReference().clearState((short)8);
            this.pdfDoc.getCatalog().getPageTree().releasePage(pageNum);
            page.unsetForbidRelease();
            ((PdfDictionary)page.getPdfObject()).release();
        } else {
            page.releaseInstanceFields();
            ((PdfDictionary)page.getPdfObject()).flush();
        }
    }

    private boolean flushPage(int pageNum) {
        PdfPage page = this.pdfDoc.getPage(pageNum);
        if (page.isFlushed()) {
            return false;
        }
        boolean pageChanged = false;
        if (!this.release) {
            this.pdfDoc.dispatchEvent(new PdfDocumentEvent("EndPdfPage", page));
            this.initCurrentLayers(this.pdfDoc);
        }
        PdfDictionary pageDict = (PdfDictionary)page.getPdfObject();
        PdfDictionary resourcesDict = page.initResources(false);
        PdfResources resources = page.getResources(false);
        if (resources != null && resources.isModified() && !resources.isReadOnly()) {
            resourcesDict = (PdfDictionary)resources.getPdfObject();
            pageDict.put(PdfName.Resources, (PdfObject)resources.getPdfObject());
            pageDict.setModified();
            pageChanged = true;
        }
        if (!resourcesDict.isFlushed()) {
            this.flushDictRecursively(resourcesDict, null);
            this.flushOrRelease(resourcesDict);
        }
        this.flushDictRecursively(pageDict, pageContext);
        if (this.release) {
            if (!((PdfDictionary)page.getPdfObject()).isModified()) {
                this.pdfDoc.getCatalog().getPageTree().releasePage(pageNum);
                page.unsetForbidRelease();
                ((PdfDictionary)page.getPdfObject()).release();
            }
        } else {
            if (this.pdfDoc.isTagged() && !this.pdfDoc.getStructTreeRoot().isFlushed()) {
                page.tryFlushPageTags();
            }
            if (!this.pdfDoc.isAppendMode() || ((PdfDictionary)page.getPdfObject()).isModified()) {
                page.releaseInstanceFields();
                ((PdfDictionary)page.getPdfObject()).flush();
            } else {
                this.pdfDoc.getCatalog().getPageTree().releasePage(pageNum);
                page.unsetForbidRelease();
                ((PdfDictionary)page.getPdfObject()).release();
            }
        }
        this.layersRefs.clear();
        return pageChanged;
    }

    private void initCurrentLayers(PdfDocument pdfDoc) {
        if (pdfDoc.getCatalog().isOCPropertiesMayHaveChanged()) {
            List<PdfLayer> layers = pdfDoc.getCatalog().getOCProperties(false).getLayers();
            for (PdfLayer layer : layers) {
                this.layersRefs.add(((PdfDictionary)layer.getPdfObject()).getIndirectReference());
            }
        }
    }

    private void flushObjectRecursively(PdfObject obj, DeepFlushingContext context) {
        if (obj == null) {
            return;
        }
        boolean avoidReleaseForIndirectObjInstance = false;
        if (obj.isIndirectReference()) {
            PdfIndirectReference indRef = (PdfIndirectReference)obj;
            if (indRef.refersTo == null || indRef.checkState((short)1)) {
                return;
            }
            obj = indRef.getRefersTo();
        } else {
            if (obj.isFlushed()) {
                return;
            }
            if (this.release && obj.isIndirect()) {
                assert (obj.isReleaseForbidden() || obj.getIndirectReference() == null);
                avoidReleaseForIndirectObjInstance = true;
            }
        }
        if (this.pdfDoc.isDocumentFont(obj.getIndirectReference()) || this.layersRefs.contains(obj.getIndirectReference())) {
            return;
        }
        if (obj.isDictionary() || obj.isStream()) {
            if (!this.currNestedObjParents.add(obj)) {
                return;
            }
            this.flushDictRecursively((PdfDictionary)obj, context);
            this.currNestedObjParents.remove(obj);
        } else if (obj.isArray()) {
            if (!this.currNestedObjParents.add(obj)) {
                return;
            }
            PdfArray array = (PdfArray)obj;
            for (int i = 0; i < array.size(); ++i) {
                this.flushObjectRecursively(array.get(i, false), context);
            }
            this.currNestedObjParents.remove(obj);
        }
        if (!avoidReleaseForIndirectObjInstance) {
            this.flushOrRelease(obj);
        }
    }

    private void flushDictRecursively(PdfDictionary dict, DeepFlushingContext context) {
        for (PdfName key : dict.keySet()) {
            DeepFlushingContext innerContext = null;
            if (context != null) {
                if (context.isKeyInBlackList(key)) continue;
                innerContext = context.getInnerContextFor(key);
            }
            PdfObject value = dict.get(key, false);
            this.flushObjectRecursively(value, innerContext);
        }
    }

    private void flushOrRelease(PdfObject obj) {
        if (this.release) {
            if (!obj.isReleaseForbidden()) {
                obj.release();
            }
        } else {
            this.makeIndirectIfNeeded(obj);
            if (!this.pdfDoc.isAppendMode() || obj.isModified()) {
                obj.flush();
            } else if (!obj.isReleaseForbidden()) {
                obj.release();
            }
        }
    }

    private void flushIfModified(PdfObject o) {
        if (o != null && !(o instanceof PdfIndirectReference)) {
            this.makeIndirectIfNeeded(o);
            o = o.getIndirectReference();
        }
        if (o != null && o.checkState((short)8) && !o.checkState((short)1)) {
            ((PdfIndirectReference)o).getRefersTo().flush();
        }
    }

    private void arrayFlushIfModified(PdfArray contentsArr) {
        for (int i = 0; i < contentsArr.size(); ++i) {
            PdfObject c = contentsArr.get(i, false);
            this.flushIfModified(c);
        }
    }

    private void makeIndirectIfNeeded(PdfObject o) {
        if (o.checkState((short)64)) {
            o.makeIndirect(this.pdfDoc);
        }
    }

    private static DeepFlushingContext initPageFlushingContext() {
        Set<PdfName> ALL_KEYS_IN_BLACK_LIST = null;
        Map<PdfName, DeepFlushingContext> NO_INNER_CONTEXTS = Collections.emptyMap();
        DeepFlushingContext actionContext = new DeepFlushingContext(new LinkedHashSet<PdfName>(Arrays.asList(PdfName.D, PdfName.SD, PdfName.Dp, PdfName.B, PdfName.Annotation, PdfName.T, PdfName.AN, PdfName.TA)), NO_INNER_CONTEXTS);
        DeepFlushingContext aaContext = new DeepFlushingContext(actionContext);
        LinkedHashMap<PdfName, DeepFlushingContext> annotInnerContexts = new LinkedHashMap<PdfName, DeepFlushingContext>();
        DeepFlushingContext annotsContext = new DeepFlushingContext(new LinkedHashSet<PdfName>(Arrays.asList(PdfName.P, PdfName.Popup, PdfName.Dest, PdfName.Parent, PdfName.V)), annotInnerContexts);
        annotInnerContexts.put(PdfName.A, actionContext);
        annotInnerContexts.put(PdfName.PA, actionContext);
        annotInnerContexts.put(PdfName.AA, aaContext);
        DeepFlushingContext sepInfoContext = new DeepFlushingContext(new LinkedHashSet<PdfName>(Collections.singletonList(PdfName.Pages)), NO_INNER_CONTEXTS);
        DeepFlushingContext bContext = new DeepFlushingContext(ALL_KEYS_IN_BLACK_LIST, NO_INNER_CONTEXTS);
        LinkedHashMap<PdfName, DeepFlushingContext> presStepsInnerContexts = new LinkedHashMap<PdfName, DeepFlushingContext>();
        DeepFlushingContext presStepsContext = new DeepFlushingContext(new LinkedHashSet<PdfName>(Collections.singletonList(PdfName.Prev)), presStepsInnerContexts);
        presStepsInnerContexts.put(PdfName.NA, actionContext);
        presStepsInnerContexts.put(PdfName.PA, actionContext);
        LinkedHashMap<PdfName, DeepFlushingContext> pageInnerContexts = new LinkedHashMap<PdfName, DeepFlushingContext>();
        DeepFlushingContext pageContext = new DeepFlushingContext(new LinkedHashSet<PdfName>(Arrays.asList(PdfName.Parent, PdfName.DPart)), pageInnerContexts);
        pageInnerContexts.put(PdfName.Annots, annotsContext);
        pageInnerContexts.put(PdfName.B, bContext);
        pageInnerContexts.put(PdfName.AA, aaContext);
        pageInnerContexts.put(PdfName.SeparationInfo, sepInfoContext);
        pageInnerContexts.put(PdfName.PresSteps, presStepsContext);
        return pageContext;
    }

    private static class DeepFlushingContext {
        Set<PdfName> blackList;
        Map<PdfName, DeepFlushingContext> innerContexts;
        DeepFlushingContext unconditionalInnerContext;

        public DeepFlushingContext(Set<PdfName> blackList, Map<PdfName, DeepFlushingContext> innerContexts) {
            this.blackList = blackList;
            this.innerContexts = innerContexts;
        }

        public DeepFlushingContext(DeepFlushingContext unconditionalInnerContext) {
            this.blackList = Collections.emptySet();
            this.innerContexts = null;
            this.unconditionalInnerContext = unconditionalInnerContext;
        }

        public boolean isKeyInBlackList(PdfName key) {
            return this.blackList == null || this.blackList.contains(key);
        }

        public DeepFlushingContext getInnerContextFor(PdfName key) {
            return this.innerContexts == null ? this.unconditionalInnerContext : this.innerContexts.get(key);
        }
    }
}

