/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.colors;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCmyk
extends Color {
    public static final DeviceCmyk CYAN = new DeviceCmyk(100, 0, 0, 0);
    public static final DeviceCmyk MAGENTA = new DeviceCmyk(0, 100, 0, 0);
    public static final DeviceCmyk YELLOW = new DeviceCmyk(0, 0, 100, 0);
    public static final DeviceCmyk BLACK = new DeviceCmyk(0, 0, 0, 100);

    public DeviceCmyk() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public DeviceCmyk(int c, int m, int y, int k) {
        this((float)c / 100.0f, (float)m / 100.0f, (float)y / 100.0f, (float)k / 100.0f);
    }

    public DeviceCmyk(float c, float m, float y, float k) {
        float[] fArray = new float[4];
        float f = c > 1.0f ? 1.0f : (fArray[0] = c > 0.0f ? c : 0.0f);
        float f2 = m > 1.0f ? 1.0f : (fArray[1] = m > 0.0f ? m : 0.0f);
        float f3 = y > 1.0f ? 1.0f : (fArray[2] = y > 0.0f ? y : 0.0f);
        fArray[3] = k > 1.0f ? 1.0f : (k > 0.0f ? k : 0.0f);
        super(new PdfDeviceCs.Cmyk(), fArray);
        if (c > 1.0f || c < 0.0f || m > 1.0f || m < 0.0f || y > 1.0f || y < 0.0f || k > 1.0f || k < 0.0f) {
            Logger LOGGER = LoggerFactory.getLogger(DeviceCmyk.class);
            LOGGER.warn("Some of colorant intensities are invalid: they are bigger than 1 or less than 0. We will force them to become 1 or 0 respectively.");
        }
    }

    public static DeviceCmyk makeLighter(DeviceCmyk cmykColor) {
        DeviceRgb rgbEquivalent = DeviceCmyk.convertCmykToRgb(cmykColor);
        DeviceRgb lighterRgb = DeviceRgb.makeLighter(rgbEquivalent);
        return DeviceCmyk.convertRgbToCmyk(lighterRgb);
    }

    public static DeviceCmyk makeDarker(DeviceCmyk cmykColor) {
        DeviceRgb rgbEquivalent = DeviceCmyk.convertCmykToRgb(cmykColor);
        DeviceRgb darkerRgb = DeviceRgb.makeDarker(rgbEquivalent);
        return DeviceCmyk.convertRgbToCmyk(darkerRgb);
    }
}

