/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GsubLookupType4
extends OpenTableLookup {
    private Map<Integer, List<int[]>> ligatures = new HashMap<Integer, List<int[]>>();

    public GsubLookupType4(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        if (line.getIdx() >= line.getEnd()) {
            return false;
        }
        boolean changed = false;
        Glyph g = line.get(line.getIdx());
        boolean match = false;
        if (this.ligatures.containsKey(g.getCode()) && !this.openReader.isSkip(g.getCode(), this.lookupFlag)) {
            OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
            gidx.setLine(line);
            List<int[]> ligs = this.ligatures.get(g.getCode());
            for (int[] lig : ligs) {
                match = true;
                gidx.setIdx(line.getIdx());
                for (int j = 1; j < lig.length; ++j) {
                    gidx.nextGlyph(this.openReader, this.lookupFlag);
                    if (gidx.getGlyph() != null && gidx.getGlyph().getCode() == lig[j]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                line.substituteManyToOne(this.openReader, this.lookupFlag, lig.length - 1, lig[0]);
                break;
            }
        }
        if (match) {
            changed = true;
        }
        line.setIdx(line.getIdx() + 1);
        return changed;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        this.openReader.rf.readShort();
        int coverage = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int ligSetCount = this.openReader.rf.readUnsignedShort();
        int[] ligatureSet = new int[ligSetCount];
        for (int k = 0; k < ligSetCount; ++k) {
            ligatureSet[k] = this.openReader.rf.readUnsignedShort() + subTableLocation;
        }
        List<Integer> coverageGlyphIds = this.openReader.readCoverageFormat(coverage);
        for (int k = 0; k < ligSetCount; ++k) {
            this.openReader.rf.seek(ligatureSet[k]);
            int ligatureCount = this.openReader.rf.readUnsignedShort();
            int[] ligature = new int[ligatureCount];
            for (int j = 0; j < ligatureCount; ++j) {
                ligature[j] = this.openReader.rf.readUnsignedShort() + ligatureSet[k];
            }
            ArrayList<int[]> components = new ArrayList<int[]>(ligatureCount);
            for (int j = 0; j < ligatureCount; ++j) {
                this.openReader.rf.seek(ligature[j]);
                int ligGlyph = this.openReader.rf.readUnsignedShort();
                int compCount = this.openReader.rf.readUnsignedShort();
                int[] component = new int[compCount];
                component[0] = ligGlyph;
                for (int i = 1; i < compCount; ++i) {
                    component[i] = this.openReader.rf.readUnsignedShort();
                }
                components.add(component);
            }
            this.ligatures.put(coverageGlyphIds.get(k), components);
        }
    }
}

