/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.utils.JacksonJson;

public class GitLabApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Response.StatusType statusInfo;
    private int httpStatus;
    private String message;
    private Map<String, List<String>> validationErrors;
    private MultivaluedMap<String, String> headers;

    public GitLabApiException(String message) {
        super(message);
        this.message = message;
    }

    public GitLabApiException(String message, int httpStatus) {
        super(message);
        this.message = message;
        this.httpStatus = httpStatus;
    }

    public GitLabApiException(Response response) {
        this.statusInfo = response.getStatusInfo();
        this.httpStatus = response.getStatus();
        this.headers = response.getStringHeaders();
        if (response.hasEntity()) {
            try {
                String message;
                this.message = message = (String)response.readEntity(String.class);
                MediaType mediaType = response.getMediaType();
                if (mediaType != null && "json".equals(mediaType.getSubtype())) {
                    JsonNode json = JacksonJson.toJsonNode(message);
                    JsonNode jsonMessage = json.get("message");
                    if (jsonMessage != null) {
                        if (jsonMessage.isObject()) {
                            StringBuilder buf = new StringBuilder();
                            this.validationErrors = new HashMap<String, List<String>>();
                            Iterator fields = jsonMessage.fields();
                            while (fields.hasNext()) {
                                Map.Entry field = (Map.Entry)fields.next();
                                String fieldName = (String)field.getKey();
                                ArrayList<String> values = new ArrayList<String>();
                                this.validationErrors.put(fieldName, values);
                                for (JsonNode value : (JsonNode)field.getValue()) {
                                    values.add(value.asText());
                                }
                                if (values.size() <= 0) continue;
                                buf.append(buf.length() > 0 ? ", " : "").append(fieldName);
                            }
                            if (buf.length() > 0) {
                                this.message = "The following fields have validation errors: " + buf.toString();
                            }
                        } else if (jsonMessage.isArray()) {
                            ArrayList<String> values = new ArrayList<String>();
                            for (JsonNode value : jsonMessage) {
                                values.add(value.asText());
                            }
                            if (values.size() > 0) {
                                this.message = String.join((CharSequence)"\n", values);
                            }
                        } else {
                            this.message = jsonMessage.isTextual() ? jsonMessage.asText() : jsonMessage.toString();
                        }
                    } else {
                        JsonNode jsonError = json.get("error");
                        if (jsonError != null) {
                            this.message = jsonError.asText();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public GitLabApiException(Exception e) {
        super(e);
        this.message = e.getMessage();
    }

    @Override
    public final String getMessage() {
        return this.message != null ? this.message : this.getReason();
    }

    public final String getReason() {
        return this.statusInfo != null ? this.statusInfo.getReasonPhrase() : null;
    }

    public final int getHttpStatus() {
        return this.httpStatus;
    }

    public boolean hasValidationErrors() {
        return this.validationErrors != null;
    }

    public Map<String, List<String>> getValidationErrors() {
        return this.validationErrors;
    }

    public final MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.httpStatus;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.statusInfo == null ? 0 : this.statusInfo.hashCode());
        result = 31 * result + (this.validationErrors == null ? 0 : this.validationErrors.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GitLabApiException other = (GitLabApiException)obj;
        if (this.httpStatus != other.httpStatus) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.statusInfo == null ? other.statusInfo != null : !this.statusInfo.equals(other.statusInfo)) {
            return false;
        }
        if (this.validationErrors == null ? other.validationErrors != null : !this.validationErrors.equals(other.validationErrors)) {
            return false;
        }
        return Objects.equals(this.headers, other.headers);
    }
}

