/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksuid;

import com.github.ksuid.Hex;
import com.github.ksuid.Ksuid;
import com.github.ksuid.KsuidGenerator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public final class Main {
    private final PrintStream printStream;
    private final IntConsumer exit;
    private final Random random;
    private final Clock clock;
    private final Flags flags = new Flags();
    private final Map<String, Consumer<Ksuid>> printers;

    public static void main(String ... args) {
        Main main = new Main(System.out, System::exit, new SecureRandom(), Clock.systemUTC());
        main.run(args);
    }

    Main(PrintStream printStream, IntConsumer exit, Random random, Clock clock) {
        this.printStream = printStream;
        this.exit = exit;
        this.random = random;
        this.clock = clock;
        this.printers = new HashMap<String, Consumer<Ksuid>>();
        this.printers.put("string", this::printString);
        this.printers.put("inspect", this::printInspect);
        this.printers.put("time", this::printTime);
        this.printers.put("timestamp", this::printTimestamp);
        this.printers.put("payload", this::printPayload);
        this.printers.put("raw", this::printRaw);
        this.printers.put("template", this::printTemplate);
    }

    public void run(String ... args) {
        try {
            this.tryRun(args);
        }
        catch (CliException e) {
            this.printStream.println(e.getMessage());
            this.printUsage(1);
        }
    }

    private void tryRun(String ... args) {
        this.parseFlags(args);
        Consumer<Ksuid> printer = this.printers.get(this.flags.format);
        ArrayList ksuids = new ArrayList();
        KsuidGenerator ksuidGenerator = new KsuidGenerator(this.random);
        if (this.flags.positionalArguments.isEmpty()) {
            IntStream.range(0, this.flags.count).forEach(any -> {
                Instant now = Instant.now(this.clock);
                Ksuid ksuid = ksuidGenerator.newKsuid(now);
                ksuids.add(ksuid);
            });
        }
        this.flags.positionalArguments.forEach(arg -> ksuids.add(this.parse((String)arg)));
        ksuids.forEach(ksuid -> {
            if (this.flags.verbose) {
                this.printStream.printf("%s: ", ksuid);
            }
            printer.accept((Ksuid)ksuid);
        });
    }

    private Ksuid parse(String arg) {
        try {
            return Ksuid.fromString(arg);
        }
        catch (IllegalArgumentException e) {
            throw new CliException("Error when parsing \"" + arg + "\": Valid encoded KSUIDs are 27 characters");
        }
    }

    private void parseFlags(String ... args) {
        boolean positionArgsOnly = false;
        Iterator<String> iterator = Arrays.asList(args).iterator();
        block16: while (iterator.hasNext()) {
            String flag = iterator.next();
            if (!flag.startsWith("-")) {
                positionArgsOnly = true;
            }
            if (positionArgsOnly) {
                this.flags.positionalArguments.add(flag);
                continue;
            }
            Supplier<String> value = () -> {
                if (!iterator.hasNext()) {
                    throw new CliException("flag needs an argument: " + flag);
                }
                return (String)iterator.next();
            };
            switch (flag) {
                case "-n": {
                    String countValue = value.get();
                    try {
                        this.flags.count = Integer.parseInt(countValue);
                        continue block16;
                    }
                    catch (Exception e) {
                        throw new CliException("invalid value \"" + countValue + "\" for flag -n: parse error");
                    }
                }
                case "-f": {
                    String formatValue = value.get();
                    if (!this.printers.containsKey(formatValue)) {
                        throw new CliException("Bad formatting function: " + formatValue);
                    }
                    this.flags.format = formatValue;
                    continue block16;
                }
                case "-t": {
                    this.flags.templateText = value.get();
                    continue block16;
                }
                case "-v": {
                    this.flags.verbose = true;
                    continue block16;
                }
                case "-h": {
                    this.printUsage(0);
                    continue block16;
                }
            }
            throw new CliException("flag provided but not defined: " + flag);
        }
    }

    private void printUsage(int exitCode) {
        this.printStream.print("Usage of ksuid:\n  -f string\n        One of string, inspect, time, timestamp, payload, raw, or template. (default \"string\")\n  -n int\n        Number of KSUIDs to generate when called with no other arguments. (default 1)\n  -t string\n        The Go template used to format the output.\n  -v    Turn on verbose mode.\n");
        this.exit.accept(exitCode);
    }

    private void printString(Ksuid ksuid) {
        this.printStream.println(ksuid);
    }

    private void printInspect(Ksuid ksuid) {
        this.printStream.println(ksuid.toInspectString());
    }

    private void printTime(Ksuid ksuid) {
        this.printStream.println(ksuid.getTime());
    }

    private void printTimestamp(Ksuid ksuid) {
        this.printStream.println(ksuid.getTimestamp());
    }

    private void printPayload(Ksuid ksuid) {
        this.printByteArray(ksuid.getPayload());
    }

    private void printRaw(Ksuid ksuid) {
        this.printByteArray(ksuid.asRaw());
    }

    private void printTemplate(Ksuid ksuid) {
        String result = this.flags.templateText;
        result = result.replace("{{.String}}", ksuid.toString());
        result = result.replace("{{.Raw}}", ksuid.asRaw());
        result = result.replace("{{.Time}}", ksuid.getTime());
        result = result.replace("{{.Timestamp}}", ksuid.getTimestamp() + "");
        result = result.replace("{{.Payload}}", ksuid.getPayload());
        this.printStream.println(result);
    }

    private void printByteArray(String hexBytes) {
        try {
            this.printStream.write(Hex.hexDecode(hexBytes));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class CliException
    extends RuntimeException {
        private static final long serialVersionUID = -7135545958349833195L;

        public CliException(String msg) {
            super(msg);
        }
    }

    private static class Flags {
        private int count = 1;
        private String format = "string";
        private String templateText = "";
        private boolean verbose;
        private final List<String> positionalArguments = new ArrayList<String>();

        private Flags() {
        }
    }
}

