/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksuid;

final class Hex {
    static final char[] HEX_CHARACTERS = "0123456789ABCDEF".toCharArray();

    private Hex() {
        throw new AssertionError((Object)"static utility class");
    }

    static byte[] hexDecode(String hex) {
        return hex != null ? Hex.parseHexBinary(hex) : null;
    }

    static String hexEncode(byte[] bytes) {
        return bytes != null ? Hex.printHexBinary(bytes) : null;
    }

    private static String printHexBinary(byte[] bytes) {
        StringBuilder r = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            r.append(HEX_CHARACTERS[b >> 4 & 0xF]);
            r.append(HEX_CHARACTERS[b & 0xF]);
        }
        return r.toString();
    }

    private static byte[] parseHexBinary(String hex) {
        int len = hex.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hex string needs to be even-length: " + hex);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = Hex.hexToBin(hex.charAt(i));
            int l = Hex.hexToBin(hex.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hex: " + hex);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }
}

