/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.mac;

public class MacProperties {
    private final MacDigestAlgorithm macDigestAlgorithm;
    private final MacAlgorithm macAlgorithm;
    private final KeyWrappingAlgorithm keyWrappingAlgorithm;

    public MacProperties(MacDigestAlgorithm macDigestAlgorithm) {
        this(macDigestAlgorithm, MacAlgorithm.HMAC_WITH_SHA_256, KeyWrappingAlgorithm.AES_256_NO_PADD);
    }

    public MacProperties(MacDigestAlgorithm macDigestAlgorithm, MacAlgorithm macAlgorithm, KeyWrappingAlgorithm keyWrappingAlgorithm) {
        this.macDigestAlgorithm = macDigestAlgorithm;
        this.macAlgorithm = macAlgorithm;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
    }

    public MacDigestAlgorithm getMacDigestAlgorithm() {
        return this.macDigestAlgorithm;
    }

    public MacAlgorithm getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public KeyWrappingAlgorithm getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    public static String macDigestAlgorithmToString(MacDigestAlgorithm macDigestAlgorithm) {
        switch (macDigestAlgorithm) {
            case SHA_256: {
                return "SHA256";
            }
            case SHA_384: {
                return "SHA384";
            }
            case SHA_512: {
                return "SHA512";
            }
            case SHA3_256: {
                return "SHA3-256";
            }
            case SHA3_384: {
                return "SHA3-384";
            }
            case SHA3_512: {
                return "SHA3-512";
            }
        }
        return null;
    }

    public static enum KeyWrappingAlgorithm {
        AES_256_NO_PADD;

    }

    public static enum MacAlgorithm {
        HMAC_WITH_SHA_256;

    }

    public static enum MacDigestAlgorithm {
        SHA_256,
        SHA_384,
        SHA_512,
        SHA3_256,
        SHA3_384,
        SHA3_512;

    }
}

