/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksuid;

import com.github.ksuid.Base62;
import com.github.ksuid.Hex;
import com.github.ksuid.KsuidGenerator;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.StringJoiner;

public class Ksuid
implements Comparable<Ksuid>,
Serializable {
    static final int EPOCH = 1400000000;
    public static final int PAYLOAD_BYTES = 16;
    private static final int TIMESTAMP_BYTES = 4;
    private static final int TOTAL_BYTES = 20;
    private static final int PAD_TO_LENGTH = 27;
    private static final Comparator<Ksuid> COMPARATOR = Comparator.comparingInt(Ksuid::getTimestamp).thenComparing(Ksuid::getPayload);
    private static final long serialVersionUID = 3069563682618421304L;
    private final int timestamp;
    private final byte[] payload;
    private final byte[] ksuidBytes;

    private Ksuid(Builder builder) {
        if (builder.ksuidBytes != null) {
            if (builder.ksuidBytes.length != 20) {
                throw new IllegalArgumentException("ksuid is not expected length of 20 bytes");
            }
            this.ksuidBytes = builder.ksuidBytes;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.ksuidBytes);
            this.timestamp = byteBuffer.getInt();
            this.payload = new byte[16];
            byteBuffer.get(this.payload);
        } else {
            if (builder.payload.length != 16) {
                throw new IllegalArgumentException("payload is not expected length of 16 bytes");
            }
            this.timestamp = builder.timestamp;
            this.payload = builder.payload;
            this.ksuidBytes = ByteBuffer.allocate(20).putInt(this.timestamp).put(this.payload).array();
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Ksuid newKsuid() {
        return KsuidGenerator.createKsuid();
    }

    public static Ksuid fromString(String ksuidString) {
        return new Builder().withKsuidString(ksuidString).build();
    }

    public static Ksuid fromInstant(Instant instant) {
        return KsuidGenerator.getInstance().newKsuid(instant);
    }

    public byte[] asBytes() {
        return Arrays.copyOf(this.ksuidBytes, this.ksuidBytes.length);
    }

    @Deprecated
    public String asString() {
        return this.toString();
    }

    public String asRaw() {
        return Hex.hexEncode(this.ksuidBytes);
    }

    public Instant getInstant() {
        return Instant.ofEpochSecond((long)this.timestamp + 1400000000L);
    }

    public String getTime() {
        return this.getTime(ZoneId.systemDefault());
    }

    public String getTime(ZoneId zoneId) {
        return String.format("%1$tF %1$tT %1$tz %1$tZ", this.getInstant().atZone(zoneId));
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public String getPayload() {
        return Hex.hexEncode(this.payload);
    }

    public String toInspectString() {
        return String.format("REPRESENTATION:%n%n  String: %1$s%n     Raw: %2$s%n%nCOMPONENTS:%n%n       Time: %3$s%n  Timestamp: %4$d%n    Payload: %5$s%n", this.toString(), this.asRaw(), this.getTime(), this.getTimestamp(), this.getPayload());
    }

    public String toLogString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("string = " + this.toString()).add("timestamp = " + this.timestamp).add("payload = " + Arrays.toString(this.payload)).add("ksuidBytes = " + Arrays.toString(this.ksuidBytes)).toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ksuid)) {
            return false;
        }
        Ksuid that = (Ksuid)o;
        return Objects.equals(this.timestamp, that.timestamp) && Arrays.equals(this.payload, that.payload) && Arrays.equals(this.ksuidBytes, that.ksuidBytes);
    }

    public final int hashCode() {
        int result = Objects.hash(this.timestamp);
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + Arrays.hashCode(this.ksuidBytes);
        return result;
    }

    public String toString() {
        return Base62.base62Encode(this.ksuidBytes, 27);
    }

    @Override
    public int compareTo(Ksuid other) {
        Objects.requireNonNull(other, "other ksuid must not be null");
        return COMPARATOR.compare(this, other);
    }

    public static final class Builder {
        private int timestamp;
        private byte[] payload;
        private byte[] ksuidBytes;

        private Builder() {
        }

        public Builder withTimestamp(int timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withPayload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public Builder withKsuidBytes(byte[] ksuidBytes) {
            this.ksuidBytes = ksuidBytes;
            return this;
        }

        public Builder withKsuidString(String ksuidString) {
            this.ksuidBytes = Base62.base62Decode(ksuidString);
            return this;
        }

        public Ksuid build() {
            return new Ksuid(this);
        }
    }
}

