/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksuid;

import java.math.BigInteger;
import java.util.stream.IntStream;

final class Base62 {
    static final char[] BASE_62_CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    static final BigInteger BASE = BigInteger.valueOf(BASE_62_CHARACTERS.length);
    private static final int BYTE_BITS = 8;
    private static final double DIGIT_BITS = Math.log(BASE_62_CHARACTERS.length) / Math.log(2.0);

    private Base62() {
        throw new AssertionError((Object)"static utility class");
    }

    static String base62Encode(byte[] bytes) {
        return Base62.base62Encode(bytes, 0);
    }

    static String base62Encode(byte[] bytes, int length) {
        int size = (int)Math.ceil((double)(bytes.length * 8) / DIGIT_BITS);
        StringBuilder sb = new StringBuilder(size);
        byte[] tempBuffer = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, tempBuffer, 1, bytes.length);
        BigInteger value = new BigInteger(tempBuffer);
        while (value.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] quotientAndRemainder = value.divideAndRemainder(BASE);
            sb.append(BASE_62_CHARACTERS[Math.abs(quotientAndRemainder[1].intValue())]);
            value = quotientAndRemainder[0];
        }
        while (length > 0 && sb.length() < length) {
            sb.append('0');
        }
        return sb.reverse().toString();
    }

    static byte[] base62Decode(String s) {
        return IntStream.range(0, s.length()).mapToObj(s::charAt).map(Base62::indexOf).map(BigInteger::valueOf).reduce(BigInteger.ZERO, (result, index) -> result.multiply(BASE).add((BigInteger)index)).toByteArray();
    }

    static int indexOf(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 61;
        }
        throw new IllegalArgumentException("'" + c + "' is not a valid Base62 character");
    }
}

