/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Release;
import org.gitlab4j.api.models.ReleaseParams;

public class ReleasesApi
extends AbstractApi {
    public ReleasesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Release> getReleases(Object projectIdOrPath) throws GitLabApiException {
        return this.getReleases(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<Release> getReleases(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Release>(this, Release.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases");
    }

    public Stream<Release> getReleasesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getReleases(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Release getRelease(Object projectIdOrPath, String tagName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName));
        return (Release)response.readEntity(Release.class);
    }

    public Optional<Release> getOptionalRelease(Object projectIdOrPath, String tagName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getRelease(projectIdOrPath, tagName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Release createRelease(Object projectIdOrPath, ReleaseParams params) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, params, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases");
        return (Release)response.readEntity(Release.class);
    }

    public Release updateRelease(Object projectIdOrPath, ReleaseParams params) throws GitLabApiException {
        String tagName = params.getTagName();
        if (tagName == null || tagName.trim().isEmpty()) {
            throw new RuntimeException("params.tagName cannot be null or empty");
        }
        Response response = this.put(Response.Status.OK, params, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName));
        return (Release)response.readEntity(Release.class);
    }

    public void deleteRelease(Object projectIdOrPath, String tagName) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName));
    }
}

