/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.webview;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.events.WebviewHtmlUpdateData;
import com.sina.weibo.agent.events.WebviewViewProviderData;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.theme.ThemeChangeListener;
import com.sina.weibo.agent.theme.ThemeManager;
import com.sina.weibo.agent.webview.WebViewCreationCallback;
import com.sina.weibo.agent.webview.WebViewInstance;
import com.sina.weibo.agent.webview.WebviewMessageProxy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$J\u0018\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001dH\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$H\u0002J\u001a\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00192\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u0001J\u000e\u0010.\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0019J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0016H\u0002J\u0010\u00101\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0016H\u0002J\u000e\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u000204J\b\u00105\u001a\u0004\u0018\u00010\u0016J\u0006\u00106\u001a\u00020\u0011J\u0006\u00107\u001a\u00020\u0011J\u0010\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u0016H\u0002J\u000e\u0010:\u001a\u00020\u00112\u0006\u00103\u001a\u00020;J\b\u0010<\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/sina/weibo/agent/webview/WebViewManager;", "Lcom/intellij/openapi/Disposable;", "Lcom/sina/weibo/agent/theme/ThemeChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "proxy", "Lcom/sina/weibo/agent/webview/WebviewMessageProxy;", "getProxy", "()Lcom/sina/weibo/agent/webview/WebviewMessageProxy;", "setProxy", "(Lcom/sina/weibo/agent/webview/WebviewMessageProxy;)V", "addProxy", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "latestWebView", "Lcom/sina/weibo/agent/webview/WebViewInstance;", "creationCallbacks", "", "Lcom/sina/weibo/agent/webview/WebViewCreationCallback;", "resourceRootDir", "Ljava/nio/file/Path;", "currentThemeConfig", "Lcom/google/gson/JsonObject;", "isDarkTheme", "", "isDisposed", "themeInitialized", "initializeThemeManager", "resourceRoot", "", "onThemeChanged", "themeConfig", "sendThemeConfigToWebViews", "saveHtmlToResourceDir", "html", "filename", "addCreationCallback", "callback", "disposable", "removeCreationCallback", "notifyWebViewCreated", "instance", "notifyWebViewDispose", "registerProvider", "data", "Lcom/sina/weibo/agent/events/WebviewViewProviderData;", "getLatestWebView", "refreshLatestWebView", "disposeWebView", "refreshWebView", "webViewInstance", "updateWebViewHtml", "Lcom/sina/weibo/agent/events/WebviewHtmlUpdateData;", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nWebViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewManager.kt\ncom/sina/weibo/agent/webview/WebViewManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1084:1\n1869#2,2:1085\n1869#2,2:1087\n*S KotlinDebug\n*F\n+ 1 WebViewManager.kt\ncom/sina/weibo/agent/webview/WebViewManager\n*L\n225#1:1085,2\n242#1:1087,2\n*E\n"})
public final class WebViewManager
implements Disposable,
ThemeChangeListener {
    @NotNull
    private Project project;
    @Nullable
    private WebviewMessageProxy proxy;
    @NotNull
    private final Logger logger;
    @Nullable
    private volatile WebViewInstance latestWebView;
    @NotNull
    private final List<WebViewCreationCallback> creationCallbacks;
    @Nullable
    private volatile Path resourceRootDir;
    @Nullable
    private JsonObject currentThemeConfig;
    private boolean isDarkTheme;
    private boolean isDisposed;
    private boolean themeInitialized;

    public WebViewManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(WebViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.creationCallbacks = new ArrayList();
        this.isDarkTheme = true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Nullable
    public final WebviewMessageProxy getProxy() {
        return this.proxy;
    }

    public final void setProxy(@Nullable WebviewMessageProxy webviewMessageProxy) {
        this.proxy = webviewMessageProxy;
    }

    public final void addProxy(@NotNull WebviewMessageProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.proxy = proxy;
    }

    public final void initializeThemeManager(@NotNull String resourceRoot) {
        Intrinsics.checkNotNullParameter((Object)resourceRoot, (String)"resourceRoot");
        if (this.isDisposed | this.themeInitialized) {
            return;
        }
        this.logger.info("Initialize theme manager");
        ThemeManager themeManager = ThemeManager.Companion.getInstance();
        themeManager.initialize(resourceRoot);
        themeManager.addThemeChangeListener(this);
        this.themeInitialized = true;
    }

    @Override
    public void onThemeChanged(@NotNull JsonObject themeConfig, boolean isDarkTheme) {
        Intrinsics.checkNotNullParameter((Object)themeConfig, (String)"themeConfig");
        this.logger.info("Received theme change event, isDarkTheme: " + isDarkTheme + ", config: " + themeConfig.size());
        this.currentThemeConfig = themeConfig;
        this.isDarkTheme = isDarkTheme;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String os = string2;
        try {
            JsonObject jsonObject2;
            JsonObject jsonObject3;
            JsonObject $this$onThemeChanged_u24lambda_u240 = jsonObject3 = new JsonObject();
            boolean bl = false;
            $this$onThemeChanged_u24lambda_u240.addProperty("os", SystemInfo.isMac ? "darwin" : os);
            $this$onThemeChanged_u24lambda_u240.addProperty("theme", this.isDarkTheme ? "dark" : "light");
            JsonObject statusObj = jsonObject3;
            JsonObject $this$onThemeChanged_u24lambda_u241 = jsonObject2 = new JsonObject();
            boolean bl2 = false;
            $this$onThemeChanged_u24lambda_u241.addProperty("type", "globalStatus");
            $this$onThemeChanged_u24lambda_u241.add("status", (JsonElement)statusObj);
            JsonObject globalStatus = jsonObject2;
            WebViewInstance webViewInstance = this.getLatestWebView();
            if (webViewInstance != null) {
                String string3 = globalStatus.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                webViewInstance.postMessageToWebView(string3);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to send global status to webview", (Throwable)e);
        }
        this.sendThemeConfigToWebViews(themeConfig);
    }

    private final void sendThemeConfigToWebViews(JsonObject themeConfig) {
        this.logger.info("Send theme config to WebView");
        try {
            WebViewInstance webViewInstance = this.getLatestWebView();
            if (webViewInstance != null) {
                webViewInstance.sendThemeConfigToWebView(themeConfig);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to send theme config to WebView", (Throwable)e);
        }
    }

    private final Path saveHtmlToResourceDir(String html, String filename) {
        block7: {
            block6: {
                if (this.resourceRootDir == null) break block6;
                Path path = this.resourceRootDir;
                Intrinsics.checkNotNull((Object)path);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block7;
            }
            this.logger.warn("Resource root directory does not exist, cannot save HTML content");
            throw new IOException("Resource root directory does not exist");
        }
        Path path = this.resourceRootDir;
        Path filePath = path != null ? path.resolve(filename) : null;
        try {
            if (filePath != null) {
                this.logger.info("HTML content saved to: " + filePath);
                String string = html;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Files.write(filePath, byArray, new OpenOption[0]);
                return filePath;
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("Failed to save HTML content: " + filePath, (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCreationCallback(@NotNull WebViewCreationCallback callback, @Nullable Disposable disposable) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            List<WebViewCreationCallback> list = this.creationCallbacks;
            synchronized (list) {
                boolean $i$a$-synchronized-WebViewManager$addCreationCallback$22 = false;
                this.creationCallbacks.add(callback);
                if (disposable != null) {
                    Disposer.register((Disposable)disposable, () -> WebViewManager.addCreationCallback$lambda$3$lambda$2(this, callback));
                }
                Unit $i$a$-synchronized-WebViewManager$addCreationCallback$22 = Unit.INSTANCE;
            }
            WebViewInstance webViewInstance = this.latestWebView;
            if (webViewInstance == null) break block4;
            WebViewInstance webview = webViewInstance;
            boolean bl = false;
            ApplicationManager.getApplication().invokeLater(() -> WebViewManager.addCreationCallback$lambda$5$lambda$4(callback, webview));
        }
    }

    public static /* synthetic */ void addCreationCallback$default(WebViewManager webViewManager, WebViewCreationCallback webViewCreationCallback, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        webViewManager.addCreationCallback(webViewCreationCallback, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCreationCallback(@NotNull WebViewCreationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        List<WebViewCreationCallback> list = this.creationCallbacks;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.creationCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyWebViewCreated(WebViewInstance instance) {
        List list;
        List<WebViewCreationCallback> list2 = this.creationCallbacks;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.creationCallbacks);
        }
        List callbacks2 = list;
        ApplicationManager.getApplication().invokeLater(() -> WebViewManager.notifyWebViewCreated$lambda$9(callbacks2, instance, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyWebViewDispose(WebViewInstance instance) {
        List list;
        List<WebViewCreationCallback> list2 = this.creationCallbacks;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.creationCallbacks);
        }
        List callbacks2 = list;
        ApplicationManager.getApplication().invokeLater(() -> WebViewManager.notifyWebViewDispose$lambda$12(callbacks2, instance, this));
    }

    public final void registerProvider(@NotNull WebviewViewProviderData data) {
        WebViewInstance webview;
        Object object;
        Map map;
        String title;
        IRPCProtocol protocol;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.logger.info("Register WebView provider and create WebView instance: " + data.getViewType());
        PluginContext traceCtx = PluginContext.Companion.getInstance(this.project);
        String traceId = traceCtx.getTraceId();
        Long traceStart = traceCtx.getTraceStartNanos();
        if (traceId != null && traceStart != null) {
            long deltaMs = (System.nanoTime() - traceStart) / (long)1000000;
            this.logger.info("[Perf][traceId=" + traceId + "] registerProvider(viewType=" + data.getViewType() + ") after " + deltaMs + " ms from trace start");
        }
        Map<String, Object> extension = data.getExtension();
        try {
            String fsPath;
            Map location;
            Object object2 = extension.get("location");
            Map map2 = location = object2 instanceof Map ? (Map)object2 : null;
            Object v = map2 != null ? map2.get("fsPath") : null;
            String string = fsPath = v instanceof String ? (String)v : null;
            if (fsPath != null) {
                Path path = Paths.get(fsPath, new String[0]);
                this.logger.info("Get resource directory path from extension: " + path);
                Intrinsics.checkNotNull((Object)path);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                }
                this.resourceRootDir = path;
                this.initializeThemeManager(fsPath);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get resource directory from extension", (Throwable)e);
        }
        if ((protocol = ((PluginContext)this.project.getService(PluginContext.class)).getRPCProtocol()) == null) {
            this.logger.error("Cannot get RPC protocol instance, cannot register WebView provider: " + data.getViewType());
            return;
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String viewId = string;
        Object object3 = data.getOptions().get("title");
        String string2 = object3 instanceof String ? (String)object3 : null;
        if (string2 == null) {
            string2 = title = data.getViewType();
        }
        if ((map = (object = data.getOptions().get("state")) instanceof Map ? (Map)object : null) == null) {
            map = MapsKt.emptyMap();
        }
        Map state = map;
        this.latestWebView = webview = new WebViewInstance(data.getViewType(), viewId, title, state, this.project, data.getExtension(), this.proxy);
        this.logger.info("Create WebView instance: viewType=" + data.getViewType() + ", viewId=" + viewId);
        this.notifyWebViewCreated(webview);
    }

    @Nullable
    public final WebViewInstance getLatestWebView() {
        return this.latestWebView;
    }

    public final void refreshLatestWebView() {
        block0: {
            WebViewInstance webViewInstance = this.latestWebView;
            if (webViewInstance == null) break block0;
            WebViewInstance it = webViewInstance;
            boolean bl = false;
            this.refreshWebView(it);
        }
    }

    public final void disposeWebView() {
        block0: {
            WebViewInstance webViewInstance = this.latestWebView;
            if (webViewInstance == null) break block0;
            WebViewInstance it = webViewInstance;
            boolean bl = false;
            this.notifyWebViewDispose(it);
        }
    }

    private final void refreshWebView(WebViewInstance webViewInstance) {
        WebViewInstance webview;
        WebViewInstance $this$refreshWebView_u24lambda_u2415 = webViewInstance;
        boolean bl = false;
        IRPCProtocol protocol = ((PluginContext)$this$refreshWebView_u24lambda_u2415.getProject().getService(PluginContext.class)).getRPCProtocol();
        if (protocol == null) {
            this.logger.error("Cannot get RPC protocol instance, cannot register WebView provider: " + webViewInstance.getViewType());
            return;
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String newViewId = string;
        this.latestWebView = webview = new WebViewInstance($this$refreshWebView_u24lambda_u2415.getViewType(), newViewId, $this$refreshWebView_u24lambda_u2415.getTitle(), $this$refreshWebView_u24lambda_u2415.getState(), $this$refreshWebView_u24lambda_u2415.getProject(), $this$refreshWebView_u24lambda_u2415.getExtension(), this.proxy);
        this.notifyWebViewCreated(webview);
    }

    public final void updateWebViewHtml(@NotNull WebviewHtmlUpdateData data) {
        WebViewInstance webViewInstance;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PluginContext traceCtx = PluginContext.Companion.getInstance(this.project);
        String traceId = traceCtx.getTraceId();
        Long traceStart = traceCtx.getTraceStartNanos();
        if (traceId != null && traceStart != null) {
            long deltaMs = (System.nanoTime() - traceStart) / (long)1000000;
            this.logger.info("[Perf][traceId=" + traceId + "] updateWebViewHtml(handle=" + data.getHandle() + ", size=" + data.getHtmlContent().length() + ") after " + deltaMs + " ms from trace start");
        }
        WebViewInstance webViewInstance2 = this.getLatestWebView();
        String encodedState = StringsKt.replace$default((String)String.valueOf(webViewInstance2 != null ? webViewInstance2.getState() : null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        String str = "<script type=\"text/javascript\" nonce=\"ABCDEF1234567890ABCDEF1234567890\">";
        data.setHtmlContent(StringsKt.replace$default((String)data.getHtmlContent(), (String)str, (String)("\n                        " + str + "\n                        // First define the function to send messages\n                        window.sendMessageToPlugin = function(message) {\n                            // Convert JS object to JSON string\n                            // console.log(\"sendMessageToPlugin: \", message);\n                            const msgStr = JSON.stringify(message);\n                            " + ((webViewInstance = this.getLatestWebView()) != null && (webViewInstance = webViewInstance.getJsQuery()) != null ? webViewInstance.inject("msgStr") : null) + "\n                        };\n                        \n                        // Inject VSCode API mock\n                        globalThis.acquireVsCodeApi = (function() {\n                            let acquired = false;\n                        \n                            let state = JSON.parse('" + encodedState + "');\n                        \n                            if (typeof window !== \"undefined\" && !window.receiveMessageFromPlugin) {\n                                console.log(\"VSCodeAPIWrapper: Setting up receiveMessageFromPlugin for IDEA plugin compatibility\");\n                                window.receiveMessageFromPlugin = (message) => {\n                                    // console.log(\"receiveMessageFromPlugin received message:\", JSON.stringify(message));\n                                    // Create a new MessageEvent and dispatch it to maintain compatibility with existing code\n                                    const event = new MessageEvent(\"message\", {\n                                        data: message,\n                                    });\n                                    window.dispatchEvent(event);\n                                };\n                            }\n                        \n                            return () => {\n                                if (acquired) {\n                                    throw new Error('An instance of the VS Code API has already been acquired');\n                                }\n                                acquired = true;\n                                return Object.freeze({\n                                    postMessage: function(message, transfer) {\n                                        // console.log(\"postMessage: \", message);\n                                        window.sendMessageToPlugin(message);\n                                    },\n                                    setState: function(newState) {\n                                        state = newState;\n                                        window.sendMessageToPlugin(newState);\n                                        return newState;\n                                    },\n                                    getState: function() {\n                                        return state;\n                                    }\n                                });\n                            };\n                        })();\n                        \n                        // Clean up references to window parent for security\n                        delete window.parent;\n                        delete window.top;\n                        delete window.frameElement;\n                        \n                        console.log(\"VSCode API mock injected\");\n                        "), (boolean)false, (int)4, null));
        this.logger.info("Received HTML update event: handle=" + data.getHandle() + ", html length: " + data.getHtmlContent().length());
        WebViewInstance webView = this.getLatestWebView();
        if (webView != null) {
            try {
                if (this.resourceRootDir != null) {
                    String filename = "index-" + this.project.hashCode() + ".html";
                    this.saveHtmlToResourceDir(data.getHtmlContent(), filename);
                    String url = "http://localhost:12345/" + filename;
                    this.logger.info("Load WebView HTML content via HTTP: " + url);
                    webView.loadUrl(url);
                } else {
                    this.logger.warn("HTTP server not running or resource directory not set, loading HTML content directly");
                    WebViewInstance.loadHtml$default(webView, data.getHtmlContent(), null, 2, null);
                }
                this.logger.info("WebView HTML content updated: handle=" + data.getHandle());
                if (this.currentThemeConfig != null) {
                    ApplicationManager.getApplication().invokeLater(() -> WebViewManager.updateWebViewHtml$lambda$16(webView, this));
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to update WebView HTML content", (Throwable)e);
                WebViewInstance.loadHtml$default(webView, data.getHtmlContent(), null, 2, null);
            }
        } else {
            this.logger.warn("WebView instance not found: handle=" + data.getHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDisposed) {
            this.logger.info("WebViewManager has already been disposed, ignoring repeated call");
            return;
        }
        this.isDisposed = true;
        this.logger.info("Releasing WebViewManager resources...");
        try {
            ThemeManager.Companion.getInstance().removeThemeChangeListener(this);
        }
        catch (Exception e) {
            this.logger.error("Failed to remove listener from theme manager", (Throwable)e);
        }
        try {
            Path path = this.resourceRootDir;
            if (path != null) {
                Path it = path;
                boolean bl = false;
                File indexFile = it.resolve("index-" + this.project.hashCode() + ".html").toFile();
                if (indexFile.exists() && indexFile.isFile()) {
                    boolean deleted = indexFile.delete();
                    if (deleted) {
                        this.logger.info("index-" + this.project.hashCode() + ".html file deleted");
                    } else {
                        this.logger.warn("Failed to delete index-" + this.project.hashCode() + ".html file");
                    }
                } else {
                    this.logger.info("index-" + this.project.hashCode() + ".html file does not exist, no need to clean up");
                }
            }
            this.resourceRootDir = null;
        }
        catch (Exception e) {
            this.logger.error("Failed to clean up index-" + this.project.hashCode() + ".html file", (Throwable)e);
        }
        try {
            WebViewInstance webViewInstance = this.latestWebView;
            if (webViewInstance != null) {
                webViewInstance.dispose();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to release WebView resources", (Throwable)e);
        }
        this.currentThemeConfig = null;
        List<WebViewCreationCallback> list = this.creationCallbacks;
        synchronized (list) {
            boolean bl = false;
            this.creationCallbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.logger.info("WebViewManager released");
    }

    private static final void addCreationCallback$lambda$3$lambda$2(WebViewManager this$0, WebViewCreationCallback $callback) {
        this$0.removeCreationCallback($callback);
    }

    private static final void addCreationCallback$lambda$5$lambda$4(WebViewCreationCallback $callback, WebViewInstance $webview) {
        $callback.onWebViewCreated($webview);
    }

    private static final void notifyWebViewCreated$lambda$9(List $callbacks, WebViewInstance $instance, WebViewManager this$0) {
        Iterable $this$forEach$iv = $callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebViewCreationCallback callback = (WebViewCreationCallback)element$iv;
            boolean bl = false;
            try {
                callback.onWebViewCreated($instance);
            }
            catch (Exception e) {
                this$0.logger.error("Exception occurred when calling WebView creation callback", (Throwable)e);
            }
        }
    }

    private static final void notifyWebViewDispose$lambda$12(List $callbacks, WebViewInstance $instance, WebViewManager this$0) {
        Iterable $this$forEach$iv = $callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebViewCreationCallback callback = (WebViewCreationCallback)element$iv;
            boolean bl = false;
            try {
                callback.onWebViewDisposed($instance);
            }
            catch (Exception e) {
                this$0.logger.error("Exception occurred when calling WebView creation callback", (Throwable)e);
            }
        }
    }

    private static final void updateWebViewHtml$lambda$16(WebViewInstance $webView, WebViewManager this$0) {
        try {
            JsonObject jsonObject2 = this$0.currentThemeConfig;
            Intrinsics.checkNotNull((Object)jsonObject2);
            $webView.sendThemeConfigToWebView(jsonObject2);
        }
        catch (Exception e) {
            this$0.logger.error("Failed to send theme config to WebView", (Throwable)e);
        }
    }
}

