/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.webview;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.SerializableObjectWithBuffers;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostWebviewViewsProxy;
import com.sina.weibo.agent.webview.LocalResHandler;
import com.sina.weibo.agent.webview.WebviewMessageProxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.misc.BoolRef;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000201J\u0006\u0010.\u001a\u00020#J\b\u00105\u001a\u000203H\u0002J\u0012\u00106\u001a\u0002032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u00107\u001a\u0002032\u0006\u00108\u001a\u00020\u0003J\u000e\u00109\u001a\u0002032\u0006\u00108\u001a\u00020\u0003J\u001c\u0010:\u001a\u0002032\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007J\u000e\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020\u0003J\u001a\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020\u00032\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u0003J\u000e\u0010@\u001a\u0002032\u0006\u0010A\u001a\u00020\u0003J\u0006\u0010B\u001a\u000203J\b\u0010C\u001a\u000203H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/sina/weibo/agent/webview/WebViewInstance;", "Lcom/intellij/openapi/Disposable;", "viewType", "", "viewId", "title", "state", "", "", "project", "Lcom/intellij/openapi/project/Project;", "extension", "proxy", "Lcom/sina/weibo/agent/webview/WebviewMessageProxy;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lcom/sina/weibo/agent/webview/WebviewMessageProxy;)V", "getViewType", "()Ljava/lang/String;", "getViewId", "getTitle", "getState", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getExtension", "getProxy", "()Lcom/sina/weibo/agent/webview/WebviewMessageProxy;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "getBrowser", "()Lcom/intellij/ui/jcef/JBCefBrowser;", "isDisposed", "", "jsQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "getJsQuery", "()Lcom/intellij/ui/jcef/JBCefJSQuery;", "setJsQuery", "(Lcom/intellij/ui/jcef/JBCefJSQuery;)V", "gson", "Lcom/google/gson/Gson;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "isPageLoaded", "isBrowserInitialized", "currentThemeConfig", "Lcom/google/gson/JsonObject;", "sendThemeConfigToWebView", "", "themeConfig", "injectTheme", "setupJSBridge", "sendMsgToPluginHost", "message", "postMessageToWebView", "enableResourceInterception", "loadUrl", "url", "loadHtml", "html", "baseUrl", "executeJavaScript", "script", "openDevTools", "dispose", "coderider-kilo-jetbrains"})
public final class WebViewInstance
implements Disposable {
    @NotNull
    private final String viewType;
    @NotNull
    private final String viewId;
    @NotNull
    private final String title;
    @NotNull
    private final Map<String, Object> state;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, Object> extension;
    @Nullable
    private final WebviewMessageProxy proxy;
    @NotNull
    private final Logger logger;
    @NotNull
    private final JBCefBrowser browser;
    private boolean isDisposed;
    @Nullable
    private JBCefJSQuery jsQuery;
    @NotNull
    private final Gson gson;
    @NotNull
    private final CoroutineScope coroutineScope;
    private boolean isPageLoaded;
    private volatile boolean isBrowserInitialized;
    @Nullable
    private JsonObject currentThemeConfig;

    public WebViewInstance(@NotNull String viewType, @NotNull String viewId, @NotNull String title, @NotNull Map<String, ? extends Object> state, @NotNull Project project, @NotNull Map<String, ? extends Object> extension, @Nullable WebviewMessageProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)viewType, (String)"viewType");
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        this.viewType = viewType;
        this.viewId = viewId;
        this.title = title;
        this.state = state;
        this.project = project;
        this.extension = extension;
        this.proxy = proxy;
        Logger logger = Logger.getInstance(WebViewInstance.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setOffScreenRendering(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        this.browser = jBCefBrowser;
        this.gson = new Gson();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
        this.setupJSBridge(this.proxy);
        this.enableResourceInterception(this.extension);
        this.browser.loadURL("about:blank");
    }

    @NotNull
    public final String getViewType() {
        return this.viewType;
    }

    @NotNull
    public final String getViewId() {
        return this.viewId;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Map<String, Object> getState() {
        return this.state;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Map<String, Object> getExtension() {
        return this.extension;
    }

    @Nullable
    public final WebviewMessageProxy getProxy() {
        return this.proxy;
    }

    @NotNull
    public final JBCefBrowser getBrowser() {
        return this.browser;
    }

    @Nullable
    public final JBCefJSQuery getJsQuery() {
        return this.jsQuery;
    }

    public final void setJsQuery(@Nullable JBCefJSQuery jBCefJSQuery) {
        this.jsQuery = jBCefJSQuery;
    }

    public final void sendThemeConfigToWebView(@NotNull JsonObject themeConfig) {
        Intrinsics.checkNotNullParameter((Object)themeConfig, (String)"themeConfig");
        this.currentThemeConfig = themeConfig;
        if (this.isDisposed | !this.isPageLoaded) {
            this.logger.warn("WebView has been disposed or not loaded, cannot send theme config:" + this.isDisposed + "," + this.isPageLoaded);
            return;
        }
        this.injectTheme();
    }

    public final boolean isPageLoaded() {
        return this.isPageLoaded;
    }

    private final void injectTheme() {
        if (this.currentThemeConfig == null) {
            return;
        }
        try {
            String cssContent = null;
            JsonObject jsonObject2 = this.currentThemeConfig;
            Intrinsics.checkNotNull((Object)jsonObject2);
            if (jsonObject2.has("cssContent")) {
                JsonObject jsonObject3 = this.currentThemeConfig;
                Intrinsics.checkNotNull((Object)jsonObject3);
                cssContent = jsonObject3.get("cssContent").getAsString();
                JsonObject jsonObject4 = this.currentThemeConfig;
                Intrinsics.checkNotNull((Object)jsonObject4);
                JsonObject themeConfigCopy = jsonObject4.deepCopy();
                themeConfigCopy.remove("cssContent");
                if (cssContent != null) {
                    String injectThemeScript = StringsKt.trimIndent((String)("\n                        (function() {\n                            console.log(\"Ready to inject CSS variables into WebView\")\n                            function injectCSSVariables() {\n                                if(document.documentElement) {\n                                    // Convert cssContent to style attribute of html tag\n                                    try {\n                                        // Extract CSS variables (format: --name:value;)\n                                        const cssLines = `" + cssContent + "`.split('\\n');\n                                        const cssVariables = [];\n                                        \n                                        // Process each line, extract CSS variable declarations\n                                        for (const line of cssLines) {\n                                            const trimmedLine = line.trim();\n                                            // Skip comments and empty lines\n                                            if (trimmedLine.startsWith('/*') || trimmedLine.startsWith('*') || trimmedLine.startsWith('*/') || trimmedLine === '') {\n                                                continue;\n                                            }\n                                            // Extract CSS variable part\n                                            if (trimmedLine.startsWith('--')) {\n                                                cssVariables.push(trimmedLine);\n                                            }\n                                        }\n                                        \n                                        // Merge extracted CSS variables into style attribute string\n                                        const styleAttrValue = cssVariables.join(' ');\n                                        \n                                        // Set as style attribute of html tag\n                                        document.documentElement.setAttribute('style', styleAttrValue);\n                                        console.log(\"CSS variables set as style attribute of HTML tag\");\n                                    } catch (error) {\n                                        console.error(\"Error processing CSS variables:\", error);\n                                    }\n                                    \n                                    // Keep original default style injection logic\n                                    if(document.head) {\n                                        // Inject default theme style into head, use id=\"_defaultStyles\"\n                                        let defaultStylesElement = document.getElementById('_defaultStyles');\n                                        if (!defaultStylesElement) {\n                                            defaultStylesElement = document.createElement('style');\n                                            defaultStylesElement.id = '_defaultStyles';\n                                            document.head.appendChild(defaultStylesElement);\n                                        }\n                                        \n                                        // Add default_themes.css content\n                                        defaultStylesElement.textContent = `\n                                            html {\n                                                scrollbar-color: var(--vscode-scrollbarSlider-background) var(--vscode-editor-background);\n                                            }\n                                            \n                                            body {\n                                                overscroll-behavior-x: none;\n                                                background-color: transparent;\n                                                color: var(--vscode-editor-foreground);\n                                                font-family: var(--vscode-font-family);\n                                                font-weight: var(--vscode-font-weight);\n                                                font-size: var(--vscode-font-size);\n                                                margin: 0;\n                                                padding: 0 0px;\n                                                overflow-x: hidden;   /* prevent horizontal scrollbar */\n                                                overflow-y: auto;     /* allow vertical scrolling only */\n                                            }\n                                            \n                                            img, video {\n                                                max-width: 100%;\n                                                height: auto;        /* keep aspect ratio and avoid vertical overflow */\n                                                display: block;      /* remove inline baseline gaps that can trigger overflow */\n                                            }\n                                            \n                                            a, a code {\n                                                color: var(--vscode-textLink-foreground);\n                                            }\n                                            \n                                            p > a {\n                                                text-decoration: var(--text-link-decoration);\n                                            }\n                                            \n                                            a:hover {\n                                                color: var(--vscode-textLink-activeForeground);\n                                            }\n                                            \n                                            a:focus,\n                                            input:focus,\n                                            select:focus,\n                                            textarea:focus {\n                                                outline: 1px solid -webkit-focus-ring-color;\n                                                outline-offset: -1px;\n                                            }\n                                            \n                                            code {\n                                                font-family: var(--monaco-monospace-font);\n                                                color: var(--vscode-textPreformat-foreground);\n                                                background-color: var(--vscode-textPreformat-background);\n                                                padding: 1px 3px;\n                                                border-radius: 4px;\n                                            }\n                                            \n                                            pre code {\n                                                padding: 0;\n                                            }\n                                            \n                                            blockquote {\n                                                background: var(--vscode-textBlockQuote-background);\n                                                border-color: var(--vscode-textBlockQuote-border);\n                                            }\n                                            \n                                            kbd {\n                                                background-color: var(--vscode-keybindingLabel-background);\n                                                color: var(--vscode-keybindingLabel-foreground);\n                                                border-style: solid;\n                                                border-width: 1px;\n                                                border-radius: 3px;\n                                                border-color: var(--vscode-keybindingLabel-border);\n                                                border-bottom-color: var(--vscode-keybindingLabel-bottomBorder);\n                                                box-shadow: inset 0 -1px 0 var(--vscode-widget-shadow);\n                                                vertical-align: middle;\n                                                padding: 1px 3px;\n                                            }\n                                            \n                                            ::-webkit-scrollbar {\n                                                width: 10px;\n                                                height: 10px;\n                                            }\n                                            \n                                            ::-webkit-scrollbar-corner {\n                                                background-color: var(--vscode-editor-background);\n                                            }\n                                            \n                                            *, *::before, *::after { box-sizing: border-box; }\n                                            html, body { width: 100%; height: 100%; }\n                                            \n                                            ::-webkit-scrollbar-thumb {\n                                                background-color: var(--vscode-scrollbarSlider-background);\n                                            }\n                                            ::-webkit-scrollbar-thumb:hover {\n                                                background-color: var(--vscode-scrollbarSlider-hoverBackground);\n                                            }\n                                            ::-webkit-scrollbar-thumb:active {\n                                                background-color: var(--vscode-scrollbarSlider-activeBackground);\n                                            }\n                                            ::highlight(find-highlight) {\n                                                background-color: var(--vscode-editor-findMatchHighlightBackground);\n                                            }\n                                            ::highlight(current-find-highlight) {\n                                                background-color: var(--vscode-editor-findMatchBackground);\n                                            }\n                                        `;\n                                        console.log(\"Default style injected to id=_defaultStyles\");\n                                    }\n                                } else {\n                                    // If html tag does not exist yet, wait for DOM to load and try again\n                                    setTimeout(injectCSSVariables, 10);\n                                }\n                            }\n                            // If document is already loaded\n                            if (document.readyState === 'complete' || document.readyState === 'interactive') {\n                                console.log(\"Document loaded, inject CSS variables immediately\");\n                                injectCSSVariables();\n                            } else {\n                                // Otherwise wait for DOMContentLoaded event\n                                console.log(\"Document not loaded, waiting for DOMContentLoaded event\");\n                                document.addEventListener('DOMContentLoaded', injectCSSVariables);\n                            }\n                        })()\n                    "));
                    this.logger.info("Injecting theme style into WebView(" + this.viewId + "), size: " + cssContent.length() + " bytes");
                    this.executeJavaScript(injectThemeScript);
                }
                String themeConfigJson = this.gson.toJson((JsonElement)themeConfigCopy);
                Intrinsics.checkNotNull((Object)themeConfigJson);
                String message = StringsKt.trimIndent((String)("\n                    {\n                        \"type\": \"theme\",\n                        \"text\": \"" + StringsKt.replace$default((String)themeConfigJson, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\"\n                    }\n                "));
                this.postMessageToWebView(message);
                this.logger.info("Theme config without cssContent has been sent to WebView");
            } else {
                String themeConfigJson = this.gson.toJson((JsonElement)this.currentThemeConfig);
                Intrinsics.checkNotNull((Object)themeConfigJson);
                String message = StringsKt.trimIndent((String)("\n                    {\n                        \"type\": \"theme\",\n                        \"text\": \"" + StringsKt.replace$default((String)themeConfigJson, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\"\n                    }\n                "));
                this.postMessageToWebView(message);
                this.logger.info("Theme config has been sent to WebView");
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to send theme config to WebView", (Throwable)e);
        }
    }

    private final void setupJSBridge(WebviewMessageProxy proxy) {
        block0: {
            JBCefJSQuery jBCefJSQuery = this.jsQuery = JBCefJSQuery.create((JBCefBrowser)this.browser);
            if (jBCefJSQuery == null) break block0;
            jBCefJSQuery.addHandler(arg_0 -> WebViewInstance.setupJSBridge$lambda$1(arg_0 -> WebViewInstance.setupJSBridge$lambda$0(this, proxy, arg_0), arg_0));
        }
    }

    public final void sendMsgToPluginHost(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IRPCProtocol protocol = ((PluginContext)this.project.getService(PluginContext.class)).getRPCProtocol();
        if (protocol != null) {
            SerializableObjectWithBuffers<List<byte[]>> serializeParam = new SerializableObjectWithBuffers<List<byte[]>>(CollectionsKt.emptyList());
            protocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostWebviews()).onMessage(this.viewId, message, serializeParam);
        } else {
            this.logger.error("Cannot get RPC protocol instance, cannot handle message: " + message);
        }
    }

    public final void postMessageToWebView(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.isDisposed) {
            String script = StringsKt.trimIndent((String)("\n                if (window.receiveMessageFromPlugin) {\n                    window.receiveMessageFromPlugin(" + message + ");\n                } else {\n                    console.warn(\"receiveMessageFromPlugin not available\");\n                }\n            "));
            this.executeJavaScript(script);
        }
    }

    public final void enableResourceInterception(@NotNull Map<String, ? extends Object> extension) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        try {
            Map location;
            Object object = extension.get("location");
            Map map = location = object instanceof Map ? (Map)object : null;
            Object v = map != null ? map.get("fsPath") : null;
            String fsPath = v instanceof String ? (String)v : null;
            JBCefClient jBCefClient = this.browser.getJBCefClient();
            Intrinsics.checkNotNullExpressionValue((Object)jBCefClient, (String)"getJBCefClient(...)");
            JBCefClient client = jBCefClient;
            client.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(this){
                final /* synthetic */ WebViewInstance this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                    WebViewInstance.access$getLogger$p(this.this$0).debug("WebView console message: [" + level + "] " + message + " (line: " + line + ", source: " + source + ")");
                    return true;
                }
            }, this.browser.getCefBrowser());
            client.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(this){
                final /* synthetic */ WebViewInstance this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                    block1: {
                        ExtHostWebviewViewsProxy extHostWebviewViewsProxy;
                        WebViewInstance.access$getLogger$p(this.this$0).info("WebView loading state changed: isLoading=" + isLoading + ", canGoBack=" + canGoBack + ", canGoForward=" + canGoForward);
                        if (isLoading || WebViewInstance.access$isBrowserInitialized$p(this.this$0)) break block1;
                        WebViewInstance.access$setBrowserInitialized$p(this.this$0, true);
                        WebViewInstance.access$getLogger$p(this.this$0).info("JCEF browser initialized and ready: " + this.this$0.getViewType() + "/" + this.this$0.getViewId());
                        IRPCProtocol iRPCProtocol = ((PluginContext)this.this$0.getProject().getService(PluginContext.class)).getRPCProtocol();
                        if (iRPCProtocol != null && (extHostWebviewViewsProxy = iRPCProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostWebviewViews())) != null) {
                            extHostWebviewViewsProxy.resolveWebviewView(this.this$0.getViewId(), this.this$0.getViewType(), this.this$0.getTitle(), this.this$0.getState(), null);
                        }
                    }
                }

                public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                    CefFrame cefFrame = frame;
                    WebViewInstance.access$getLogger$p(this.this$0).info("WebView started loading: " + (cefFrame != null ? cefFrame.getURL() : null) + ", transition type: " + transitionType);
                    WebViewInstance.access$setPageLoaded$p(this.this$0, false);
                }

                public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                    CefFrame cefFrame = frame;
                    WebViewInstance.access$getLogger$p(this.this$0).info("WebView finished loading: " + (cefFrame != null ? cefFrame.getURL() : null) + ", status code: " + httpStatusCode);
                    WebViewInstance.access$setPageLoaded$p(this.this$0, true);
                    WebViewInstance.access$injectTheme(this.this$0);
                }

                public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    WebViewInstance.access$getLogger$p(this.this$0).info("WebView load error: " + failedUrl + ", error code: " + errorCode + ", error message: " + errorText);
                }
            }, this.browser.getCefBrowser());
            client.addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(this, fsPath){
                final /* synthetic */ WebViewInstance this$0;
                final /* synthetic */ String $fsPath;
                {
                    this.this$0 = $receiver;
                    this.$fsPath = $fsPath;
                }

                public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                    CefRequest cefRequest = request;
                    WebViewInstance.access$getLogger$p(this.this$0).info("onBeforeBrowse,url:" + (cefRequest != null ? cefRequest.getURL() : null));
                    Object object = request;
                    boolean bl = object != null && (object = object.getURL()) != null ? !StringsKt.startsWith$default((String)object, (String)"http://localhost", (boolean)false, (int)2, null) : false;
                    if (bl) {
                        BrowserUtil.browse((String)request.getURL());
                        return true;
                    }
                    return false;
                }

                public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
                    WebViewInstance.access$getLogger$p(this.this$0).debug("getResourceRequestHandler,fsPath:" + this.$fsPath);
                    if (this.$fsPath != null) {
                        Object object = request;
                        boolean bl = object != null && (object = object.getURL()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"localhost", (boolean)false, (int)2, null) : false;
                        if (bl) {
                            Path path = Paths.get(this.$fsPath, new String[0]);
                            Intrinsics.checkNotNull((Object)path);
                            return (CefResourceRequestHandler)new LocalResHandler(((Object)path).toString(), request);
                        }
                    }
                    return null;
                }
            }, this.browser.getCefBrowser());
            client.addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(this){
                final /* synthetic */ WebViewInstance this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String targetUrl, String targetFrameName) {
                    WebViewInstance.access$getLogger$p(this.this$0).info("onBeforePopup,targetUrl=" + targetUrl + ", targetFrame=" + targetFrameName);
                    String string = targetUrl;
                    if (string == null) {
                        return false;
                    }
                    String url = string;
                    if (!StringsKt.startsWith$default((String)url, (String)"http://localhost", (boolean)false, (int)2, null)) {
                        BrowserUtil.browse((String)url);
                        return true;
                    }
                    return false;
                }
            }, this.browser.getCefBrowser());
            this.logger.info("WebView resource interception enabled: " + this.viewType + "/" + this.viewId);
        }
        catch (Exception e) {
            this.logger.error("Failed to enable WebView resource interception", (Throwable)e);
        }
    }

    public final void loadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!this.isDisposed) {
            this.logger.info("WebView loading URL: " + url);
            this.browser.loadURL(url);
        }
    }

    public final void loadHtml(@NotNull String html, @Nullable String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        if (!this.isDisposed) {
            this.logger.info("WebView loading HTML content, length: " + html.length() + ", baseUrl: " + baseUrl);
            if (baseUrl != null) {
                this.browser.loadHTML(html, baseUrl);
            } else {
                this.browser.loadHTML(html);
            }
        }
    }

    public static /* synthetic */ void loadHtml$default(WebViewInstance webViewInstance, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        webViewInstance.loadHtml(string, string2);
    }

    public final void executeJavaScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (!this.isDisposed) {
            this.logger.debug("WebView executing JavaScript, script length: " + script.length());
            this.browser.getCefBrowser().executeJavaScript(script, this.browser.getCefBrowser().getURL(), 0);
        }
    }

    public final void openDevTools() {
        if (!this.isDisposed) {
            this.browser.openDevtools();
        }
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.browser.dispose();
            this.isDisposed = true;
            this.logger.info("WebView instance released: " + this.viewType + "/" + this.viewId);
        }
    }

    private static final JBCefJSQuery.Response setupJSBridge$lambda$0(WebViewInstance this$0, WebviewMessageProxy $proxy, String message) {
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($proxy, message, this$0, null){
            int label;
            final /* synthetic */ WebviewMessageProxy $proxy;
            final /* synthetic */ String $message;
            final /* synthetic */ WebViewInstance this$0;
            {
                this.$proxy = $proxy;
                this.$message = $message;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[SWITCH], 4[CASE]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return null;
    }

    private static final JBCefJSQuery.Response setupJSBridge$lambda$1(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(WebViewInstance $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$isBrowserInitialized$p(WebViewInstance $this) {
        return $this.isBrowserInitialized;
    }

    public static final /* synthetic */ void access$setBrowserInitialized$p(WebViewInstance $this, boolean bl) {
        $this.isBrowserInitialized = bl;
    }

    public static final /* synthetic */ void access$setPageLoaded$p(WebViewInstance $this, boolean bl) {
        $this.isPageLoaded = bl;
    }

    public static final /* synthetic */ void access$injectTheme(WebViewInstance $this) {
        $this.injectTheme();
    }
}

