/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.webview;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.webview.WebViewInstance;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0016\u0010\u001c\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/sina/weibo/agent/webview/DragDropHandler;", "", "webViewInstance", "Lcom/sina/weibo/agent/webview/WebViewInstance;", "targetComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/sina/weibo/agent/webview/WebViewInstance;Ljavax/swing/JComponent;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "setupDragAndDrop", "", "isShiftKeyPressed", "", "dtde", "Ljava/awt/dnd/DropTargetDragEvent;", "notifyDragState", "isDragging", "handleFileDrop", "Ljava/awt/dnd/DropTargetDropEvent;", "insertFilePathsIntoTextarea", "files", "", "Ljava/io/File;", "convertImageToDataUrl", "", "file", "insertFilePathsAsMentions", "hasFileList", "detectMimeType", "fileName", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nDragDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragDropHandler.kt\ncom/sina/weibo/agent/webview/DragDropHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1563#2:266\n1634#2,3:267\n1869#2,2:270\n1617#2,9:272\n1869#2:281\n1870#2:283\n1626#2:284\n1#3:282\n*S KotlinDebug\n*F\n+ 1 DragDropHandler.kt\ncom/sina/weibo/agent/webview/DragDropHandler\n*L\n130#1:266\n130#1:267,3\n161#1:270,2\n173#1:272,9\n173#1:281\n173#1:283\n173#1:284\n173#1:282\n*E\n"})
public final class DragDropHandler {
    @NotNull
    private final WebViewInstance webViewInstance;
    @NotNull
    private final JComponent targetComponent;
    @NotNull
    private final Logger logger;

    public DragDropHandler(@NotNull WebViewInstance webViewInstance, @NotNull JComponent targetComponent) {
        Intrinsics.checkNotNullParameter((Object)webViewInstance, (String)"webViewInstance");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        this.webViewInstance = webViewInstance;
        this.targetComponent = targetComponent;
        Logger logger = Logger.getInstance(DragDropHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public final void setupDragAndDrop() {
        this.logger.info("Setting up drag and drop support for WebView (VSCode-compatible)");
        DropTarget dropTarget2 = new DropTarget(this.targetComponent, new DropTargetAdapter(this){
            final /* synthetic */ DragDropHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragDropHandler.access$getLogger$p(this.this$0).info("Drag enter detected");
                if (DragDropHandler.access$isShiftKeyPressed(this.this$0, dtde) && DragDropHandler.access$hasFileList(this.this$0, dtde)) {
                    dtde.acceptDrag(1);
                    DragDropHandler.access$notifyDragState(this.this$0, true);
                    DragDropHandler.access$getLogger$p(this.this$0).info("Drag accepted - Shift key pressed and files detected");
                } else {
                    dtde.rejectDrag();
                    DragDropHandler.access$getLogger$p(this.this$0).info("Drag rejected - " + (!DragDropHandler.access$isShiftKeyPressed(this.this$0, dtde) ? "Shift key not pressed" : "no files detected"));
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                if (DragDropHandler.access$isShiftKeyPressed(this.this$0, dtde) && DragDropHandler.access$hasFileList(this.this$0, dtde)) {
                    dtde.acceptDrag(1);
                } else {
                    dtde.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent dte) {
                Intrinsics.checkNotNullParameter((Object)dte, (String)"dte");
                DragDropHandler.access$getLogger$p(this.this$0).info("Drag exit detected");
                DragDropHandler.access$notifyDragState(this.this$0, false);
            }

            public void drop(DropTargetDropEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragDropHandler.access$getLogger$p(this.this$0).info("Drop event detected");
                DragDropHandler.access$handleFileDrop(this.this$0, dtde);
            }
        });
        this.logger.info("Drag and drop setup completed");
    }

    private final boolean isShiftKeyPressed(DropTargetDragEvent dtde) {
        return true;
    }

    private final void notifyDragState(boolean isDragging) {
        try {
            String jsCode = StringsKt.trimIndent((String)("\n                (function() {\n                    console.log('Setting drag state:', " + isDragging + ");\n                    const textareas = document.querySelectorAll('textarea, [contenteditable=\"true\"]');\n                    if (" + isDragging + ") {\n                        textareas.forEach(textarea => {\n                            textarea.style.border = '2px dashed #007acc';\n                            textarea.style.backgroundColor = 'rgba(0, 122, 204, 0.1)';\n                            textarea.setAttribute('data-dragging', 'true');\n                        });\n                    } else {\n                        textareas.forEach(textarea => {\n                            textarea.style.border = '';\n                            textarea.style.backgroundColor = '';\n                            textarea.removeAttribute('data-dragging');\n                        });\n                    }\n                })();\n            "));
            this.webViewInstance.executeJavaScript(jsCode);
        }
        catch (Exception e) {
            this.logger.error("Failed to notify drag state", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFileDrop(DropTargetDropEvent dtde) {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.logger.info("Processing drop event");
            if (!this.hasFileList(dtde)) {
                this.logger.info("Drop rejected: No file list in transferable");
                dtde.rejectDrop();
                this.notifyDragState(false);
                return;
            }
            dtde.acceptDrop(1);
            Transferable transferable = dtde.getTransferable();
            Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
            List fileList = (List)object;
            Iterable iterable = fileList;
            Logger logger = this.logger;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            logger.info("Files dropped: " + (List)destination$iv$iv);
            if (!((Collection)fileList).isEmpty()) {
                this.insertFilePathsIntoTextarea(fileList);
                dtde.dropComplete(true);
            } else {
                this.logger.warn("No valid files found in drop event");
                dtde.dropComplete(false);
            }
            this.notifyDragState(false);
        }
        catch (Exception e) {
            this.logger.error("Error handling file drop", (Throwable)e);
            dtde.dropComplete(false);
            this.notifyDragState(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void insertFilePathsIntoTextarea(List<? extends File> files) {
        try {
            this.logger.info("Processing " + files.size() + " dropped files");
            List imageFiles = new ArrayList();
            List otherFiles = new ArrayList();
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String mimeType = this.detectMimeType(string);
                boolean bl2 = StringsKt.startsWith$default((String)mimeType, (String)"image/", (boolean)false, (int)2, null) ? imageFiles.add(file) : otherFiles.add(file);
            }
            if (!((Collection)imageFiles).isEmpty()) {
                void $this$mapNotNullTo$iv$iv;
                Object element$iv;
                this.logger.info("Found " + imageFiles.size() + " image files, converting to dataURLs");
                Iterable $this$mapNotNull$iv = imageFiles;
                boolean $i$f$mapNotNull = false;
                element$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    File file = (File)element$iv$iv;
                    boolean bl3 = false;
                    try {
                        string = this.convertImageToDataUrl(file);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to convert image to dataURL: " + file.getName(), (Throwable)e);
                        string = null;
                    }
                    if (string == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List dataUrls = (List)destination$iv$iv;
                if (!((Collection)dataUrls).isEmpty()) {
                    String imagesJson = CollectionsKt.joinToString$default((Iterable)dataUrls, (CharSequence)",", null, null, (int)0, null, DragDropHandler::insertFilePathsIntoTextarea$lambda$3, (int)30, null);
                    String message = "{\"type\":\"selectedImages\",\"images\":[" + imagesJson + "],\"context\":\"chat\"}";
                    this.logger.info("Sending selectedImages message with " + dataUrls.size() + " images");
                    this.webViewInstance.postMessageToWebView(message);
                }
            }
            if (!((Collection)otherFiles).isEmpty()) {
                this.logger.info("Found " + otherFiles.size() + " non-image files, inserting as mentions");
                this.insertFilePathsAsMentions(otherFiles);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to process dropped files", (Throwable)e);
        }
    }

    private final String convertImageToDataUrl(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String mimeType = this.detectMimeType(string);
        byte[] bytes = FilesKt.readBytes((File)file);
        String base64 = Base64.getEncoder().encodeToString(bytes);
        return "data:" + mimeType + ";base64," + base64;
    }

    private final void insertFilePathsAsMentions(List<? extends File> files) {
        try {
            String filePaths = CollectionsKt.joinToString$default((Iterable)files, (CharSequence)"\n", null, null, (int)0, null, DragDropHandler::insertFilePathsAsMentions$lambda$4, (int)30, null);
            String escapedPaths = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)filePaths, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
            String message = "{\"type\":\"invoke\",\"invoke\":\"setChatBoxMessage\",\"text\":\"" + escapedPaths + "\"}";
            this.logger.info("Appending " + files.size() + " file paths using setChatBoxMessage");
            this.webViewInstance.postMessageToWebView(message);
        }
        catch (Exception e) {
            this.logger.error("Failed to insert file paths as mentions", (Throwable)e);
        }
    }

    private final boolean hasFileList(DropTargetDragEvent dtde) {
        return dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    private final boolean hasFileList(DropTargetDropEvent dtde) {
        return dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    private final String detectMimeType(String fileName) {
        String extension;
        String string = StringsKt.substringAfterLast((String)fileName, (char)'.', (String)"").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (extension = string) {
            case "png" -> "image/png";
            case "jpg", "jpeg" -> "image/jpeg";
            case "webp" -> "image/webp";
            case "gif" -> "image/gif";
            case "bmp" -> "image/bmp";
            case "svg" -> "image/svg+xml";
            default -> "";
        };
    }

    private static final CharSequence insertFilePathsIntoTextarea$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    private static final CharSequence insertFilePathsAsMentions$lambda$4(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DragDropHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$isShiftKeyPressed(DragDropHandler $this, DropTargetDragEvent dtde) {
        return $this.isShiftKeyPressed(dtde);
    }

    public static final /* synthetic */ boolean access$hasFileList(DragDropHandler $this, DropTargetDragEvent dtde) {
        return $this.hasFileList(dtde);
    }

    public static final /* synthetic */ void access$notifyDragState(DragDropHandler $this, boolean isDragging) {
        $this.notifyDragState(isDragging);
    }

    public static final /* synthetic */ void access$handleFileDrop(DragDropHandler $this, DropTargetDropEvent dtde) {
        $this.handleFileDrop(dtde);
    }
}

