/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.HttpConfigurable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000fJ\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/sina/weibo/agent/util/ProxyConfigUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getProxyConfig", "Lcom/sina/weibo/agent/util/ProxyConfigUtil$ProxyConfig;", "getIDEProxyConfig", "getEnvironmentProxyConfig", "normalizeProxyUrl", "", "url", "getHttpProxyConfigForInitialization", "", "getProxyEnvVarsForProcessStart", "ProxyConfig", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nProxyConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyConfigUtil.kt\ncom/sina/weibo/agent/util/ProxyConfigUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1563#2:197\n1634#2,3:198\n774#2:201\n865#2,2:202\n*S KotlinDebug\n*F\n+ 1 ProxyConfigUtil.kt\ncom/sina/weibo/agent/util/ProxyConfigUtil\n*L\n157#1:197\n157#1:198,3\n158#1:201\n158#1:202,2\n*E\n"})
public final class ProxyConfigUtil {
    @NotNull
    public static final ProxyConfigUtil INSTANCE = new ProxyConfigUtil();
    @NotNull
    private static final Logger logger;

    private ProxyConfigUtil() {
    }

    @NotNull
    public final ProxyConfig getProxyConfig() {
        ProxyConfig ideProxyConfig = this.getIDEProxyConfig();
        if (ideProxyConfig.getHasProxy()) {
            String string = ideProxyConfig.getProxyUrl();
            if (string == null) {
                string = ideProxyConfig.getPacUrl();
            }
            logger.info("Using IDE proxy configuration: " + string);
            return ideProxyConfig;
        }
        ProxyConfig envProxyConfig = this.getEnvironmentProxyConfig();
        if (envProxyConfig.getHasProxy()) {
            logger.info("Using environment variable proxy configuration: " + envProxyConfig.getProxyUrl());
            return envProxyConfig;
        }
        logger.info("No proxy configuration found");
        return new ProxyConfig(null, null, null, "none");
    }

    private final ProxyConfig getIDEProxyConfig() {
        ProxyConfig proxyConfig;
        try {
            String pacUrl;
            CharSequence charSequence;
            HttpConfigurable proxyConfig2 = HttpConfigurable.getInstance();
            if (proxyConfig2.USE_PROXY_PAC && !((charSequence = (CharSequence)(pacUrl = proxyConfig2.PAC_URL)) == null || charSequence.length() == 0)) {
                return new ProxyConfig(null, null, pacUrl, "ide-pac");
            }
            if (proxyConfig2.USE_HTTP_PROXY) {
                String proxyHost = proxyConfig2.PROXY_HOST;
                int proxyPort = proxyConfig2.PROXY_PORT;
                CharSequence charSequence2 = proxyHost;
                if (!(charSequence2 == null || charSequence2.length() == 0) && proxyPort > 0) {
                    String proxyUrl = "http://" + proxyHost + ":" + proxyPort;
                    String proxyExceptions = proxyConfig2.PROXY_EXCEPTIONS;
                    return new ProxyConfig(proxyUrl, proxyExceptions, null, "ide-http");
                }
            }
            proxyConfig = new ProxyConfig(null, null, null, "ide-none");
        }
        catch (Exception e) {
            logger.warn("Failed to get IDE proxy configuration", (Throwable)e);
            proxyConfig = new ProxyConfig(null, null, null, "ide-error");
        }
        return proxyConfig;
    }

    private final ProxyConfig getEnvironmentProxyConfig() {
        ProxyConfig proxyConfig;
        try {
            String string;
            String httpsProxy;
            String string2;
            String httpProxy;
            String string3 = System.getenv("HTTP_PROXY");
            if (string3 == null) {
                string3 = httpProxy = System.getenv("http_proxy");
            }
            if ((string2 = System.getenv("HTTPS_PROXY")) == null) {
                string2 = httpsProxy = System.getenv("https_proxy");
            }
            if ((string = System.getenv("NO_PROXY")) == null) {
                string = System.getenv("no_proxy");
            }
            String noProxy = string;
            CharSequence charSequence = httpsProxy;
            String proxyUrl = !(charSequence == null || charSequence.length() == 0) ? this.normalizeProxyUrl(httpsProxy) : (!((charSequence = (CharSequence)httpProxy) == null || charSequence.length() == 0) ? this.normalizeProxyUrl(httpProxy) : null);
            proxyConfig = new ProxyConfig(proxyUrl, noProxy, null, "env");
        }
        catch (Exception e) {
            logger.warn("Failed to get environment proxy configuration", (Throwable)e);
            proxyConfig = new ProxyConfig(null, null, null, "env-error");
        }
        return proxyConfig;
    }

    private final String normalizeProxyUrl(String url) {
        String string;
        try {
            URI uri = new URI(url);
            CharSequence charSequence = uri.getScheme();
            string = charSequence == null || charSequence.length() == 0 ? "http://" + url : (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)uri.getScheme(), (Object)"https") ? url : "http://" + url);
        }
        catch (URISyntaxException e) {
            string = "http://" + url;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<String, Object> getHttpProxyConfigForInitialization() {
        ProxyConfig proxyConfig = this.getProxyConfig();
        if (!proxyConfig.getHasProxy()) {
            return null;
        }
        Map configMap = new LinkedHashMap();
        CharSequence charSequence = proxyConfig.getPacUrl();
        if (!(charSequence == null || charSequence.length() == 0)) {
            configMap.put("proxy", proxyConfig.getPacUrl());
            configMap.put("proxySupport", "on");
        } else {
            charSequence = proxyConfig.getProxyUrl();
            if (!(charSequence == null || charSequence.length() == 0)) {
                configMap.put("proxy", proxyConfig.getProxyUrl());
                configMap.put("proxySupport", "on");
            }
        }
        charSequence = proxyConfig.getProxyExceptions();
        if (!(charSequence == null || charSequence.length() == 0)) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)proxyConfig.getProxyExceptions(), (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List noProxyList = (List)destination$iv$iv;
            if (!((Collection)noProxyList).isEmpty()) {
                configMap.put("noProxy", noProxyList);
            }
        }
        return !configMap.isEmpty() ? configMap : null;
    }

    @NotNull
    public final Map<String, String> getProxyEnvVarsForProcessStart() {
        ProxyConfig proxyConfig = this.getProxyConfig();
        Map envVars = new LinkedHashMap();
        if (!proxyConfig.getHasProxy()) {
            return MapsKt.emptyMap();
        }
        CharSequence charSequence = proxyConfig.getPacUrl();
        if (!(charSequence == null || charSequence.length() == 0)) {
            envVars.put("PROXY_PAC_URL", proxyConfig.getPacUrl());
        } else {
            charSequence = proxyConfig.getProxyUrl();
            if (!(charSequence == null || charSequence.length() == 0)) {
                envVars.put("HTTP_PROXY", proxyConfig.getProxyUrl());
                envVars.put("HTTPS_PROXY", proxyConfig.getProxyUrl());
            }
        }
        charSequence = proxyConfig.getProxyExceptions();
        if (!(charSequence == null || charSequence.length() == 0)) {
            envVars.put("NO_PROXY", proxyConfig.getProxyExceptions());
        }
        return envVars;
    }

    static {
        Logger logger = Logger.getInstance(ProxyConfigUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProxyConfigUtil.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/sina/weibo/agent/util/ProxyConfigUtil$ProxyConfig;", "", "proxyUrl", "", "proxyExceptions", "pacUrl", "source", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getProxyUrl", "()Ljava/lang/String;", "getProxyExceptions", "getPacUrl", "getSource", "hasProxy", "", "getHasProxy", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    public static final class ProxyConfig {
        @Nullable
        private final String proxyUrl;
        @Nullable
        private final String proxyExceptions;
        @Nullable
        private final String pacUrl;
        @NotNull
        private final String source;

        public ProxyConfig(@Nullable String proxyUrl, @Nullable String proxyExceptions, @Nullable String pacUrl, @NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.proxyUrl = proxyUrl;
            this.proxyExceptions = proxyExceptions;
            this.pacUrl = pacUrl;
            this.source = source;
        }

        @Nullable
        public final String getProxyUrl() {
            return this.proxyUrl;
        }

        @Nullable
        public final String getProxyExceptions() {
            return this.proxyExceptions;
        }

        @Nullable
        public final String getPacUrl() {
            return this.pacUrl;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        public final boolean getHasProxy() {
            CharSequence charSequence = this.proxyUrl;
            return !(charSequence == null || charSequence.length() == 0) || !((charSequence = (CharSequence)this.pacUrl) == null || charSequence.length() == 0);
        }

        @Nullable
        public final String component1() {
            return this.proxyUrl;
        }

        @Nullable
        public final String component2() {
            return this.proxyExceptions;
        }

        @Nullable
        public final String component3() {
            return this.pacUrl;
        }

        @NotNull
        public final String component4() {
            return this.source;
        }

        @NotNull
        public final ProxyConfig copy(@Nullable String proxyUrl, @Nullable String proxyExceptions, @Nullable String pacUrl, @NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new ProxyConfig(proxyUrl, proxyExceptions, pacUrl, source);
        }

        public static /* synthetic */ ProxyConfig copy$default(ProxyConfig proxyConfig, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = proxyConfig.proxyUrl;
            }
            if ((n & 2) != 0) {
                string2 = proxyConfig.proxyExceptions;
            }
            if ((n & 4) != 0) {
                string3 = proxyConfig.pacUrl;
            }
            if ((n & 8) != 0) {
                string4 = proxyConfig.source;
            }
            return proxyConfig.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ProxyConfig(proxyUrl=" + this.proxyUrl + ", proxyExceptions=" + this.proxyExceptions + ", pacUrl=" + this.pacUrl + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.proxyUrl == null ? 0 : this.proxyUrl.hashCode();
            result2 = result2 * 31 + (this.proxyExceptions == null ? 0 : this.proxyExceptions.hashCode());
            result2 = result2 * 31 + (this.pacUrl == null ? 0 : this.pacUrl.hashCode());
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProxyConfig)) {
                return false;
            }
            ProxyConfig proxyConfig = (ProxyConfig)other;
            if (!Intrinsics.areEqual((Object)this.proxyUrl, (Object)proxyConfig.proxyUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.proxyExceptions, (Object)proxyConfig.proxyExceptions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pacUrl, (Object)proxyConfig.pacUrl)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)proxyConfig.source);
        }
    }
}

