/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.theme;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.sina.weibo.agent.theme.ThemeChangeListener;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0017H\u0002J\b\u0010&\u001a\u00020\u0017H\u0002J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0013J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0013J\u0006\u0010*\u001a\u00020\u0017J\u0006\u0010\t\u001a\u00020\nJ\b\u0010+\u001a\u0004\u0018\u00010\fJ\b\u0010,\u001a\u00020\u0017H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/sina/weibo/agent/theme/ThemeManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "themeResourceDir", "Ljava/nio/file/Path;", "isDarkTheme", "", "currentThemeConfig", "Lcom/google/gson/JsonObject;", "themeStyleContent", "", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "themeChangeListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/sina/weibo/agent/theme/ThemeChangeListener;", "gson", "Lcom/google/gson/Gson;", "initialize", "", "resourceRoot", "isDarkThemeForce", "updateCurrentThemeStatus", "parseThemeString", "themeString", "mergeJsonObjects", "first", "second", "convertTheme", "theme", "loadVscodeThemeStyle", "vscodeThemeFile", "Ljava/io/File;", "loadThemeConfig", "notifyThemeChangeListeners", "addThemeChangeListener", "listener", "removeThemeChangeListener", "reloadThemeConfig", "getCurrentThemeConfig", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nThemeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeManager.kt\ncom/sina/weibo/agent/theme/ThemeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,607:1\n774#2:608\n865#2,2:609\n1869#2,2:611\n1869#2,2:613\n1869#2,2:616\n1#3:615\n*S KotlinDebug\n*F\n+ 1 ThemeManager.kt\ncom/sina/weibo/agent/theme/ThemeManager\n*L\n149#1:608\n149#1:609,2\n179#1:611,2\n194#1:613,2\n474#1:616,2\n*E\n"})
public final class ThemeManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @Nullable
    private Path themeResourceDir;
    private boolean isDarkTheme;
    @Nullable
    private JsonObject currentThemeConfig;
    @Nullable
    private String themeStyleContent;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @NotNull
    private final CopyOnWriteArrayList<ThemeChangeListener> themeChangeListeners;
    @NotNull
    private final Gson gson;
    @Nullable
    private static volatile ThemeManager instance;

    public ThemeManager() {
        Logger logger = Logger.getInstance(ThemeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.isDarkTheme = true;
        this.themeChangeListeners = new CopyOnWriteArrayList();
        this.gson = new Gson();
    }

    public final void initialize(@NotNull String resourceRoot) {
        Intrinsics.checkNotNullParameter((Object)resourceRoot, (String)"resourceRoot");
        this.logger.info("Initializing theme manager, resource root: " + resourceRoot);
        this.themeResourceDir = Companion.getThemeResourceDir(resourceRoot);
        if (this.themeResourceDir == null) {
            this.logger.warn("Theme resource directory does not exist for resource root: " + resourceRoot);
            return;
        }
        this.logger.info("Theme resource directory set: " + this.themeResourceDir);
        this.updateCurrentThemeStatus();
        this.loadThemeConfig();
        MessageBusConnection messageBusConnection = this.messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        if (messageBusConnection != null) {
            Topic topic = LafManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, arg_0 -> ThemeManager.initialize$lambda$0(this, arg_0));
        }
        this.logger.info("Theme manager initialization completed, current theme: " + (this.isDarkTheme ? "dark" : "light"));
    }

    public final boolean isDarkThemeForce() {
        this.updateCurrentThemeStatus();
        return this.isDarkTheme();
    }

    private final void updateCurrentThemeStatus() {
        try {
            Color background = UIManager.getColor("Panel.background");
            if (background != null) {
                double brightness = (0.299 * (double)background.getRed() + 0.587 * (double)background.getGreen() + 0.114 * (double)background.getBlue()) / 255.0;
                this.isDarkTheme = brightness < 0.5;
                this.logger.info("Detected " + (this.isDarkTheme ? "dark" : "light") + " theme: brightness is " + brightness);
            } else {
                this.isDarkTheme = true;
                this.logger.warn("Cannot detect theme brightness, defaulting to dark theme");
            }
        }
        catch (Exception e) {
            this.logger.error("Error updating theme status", (Throwable)e);
            this.isDarkTheme = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject parseThemeString(String themeString) {
        try {
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{"\n"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)themeString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"//", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String cleanedContent = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            JsonObject jsonObject2 = JsonParser.parseString((String)cleanedContent).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
            return jsonObject2;
        }
        catch (Exception e) {
            this.logger.error("Error parsing theme string", (Throwable)e);
            throw e;
        }
    }

    private final JsonObject mergeJsonObjects(JsonObject first, JsonObject second) {
        try {
            JsonObject result2 = (JsonObject)this.gson.fromJson(this.gson.toJson((JsonElement)first), JsonObject.class);
            for (String key : second.keySet()) {
                if (!first.has(key)) {
                    result2.add(key, second.get(key));
                    continue;
                }
                JsonElement firstValue = first.get(key);
                JsonElement secondValue = second.get(key);
                if (firstValue.isJsonArray() && secondValue.isJsonArray()) {
                    JsonArray resultArray = firstValue.getAsJsonArray();
                    JsonArray jsonArray = secondValue.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                    Iterable $this$forEach$iv = (Iterable)jsonArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        JsonElement it = (JsonElement)element$iv;
                        boolean bl = false;
                        resultArray.add(it);
                    }
                    continue;
                }
                if (firstValue.isJsonObject() && secondValue.isJsonObject()) {
                    JsonObject jsonObject2 = firstValue.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
                    JsonObject jsonObject3 = secondValue.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"getAsJsonObject(...)");
                    result2.add(key, (JsonElement)this.mergeJsonObjects(jsonObject2, jsonObject3));
                    continue;
                }
                result2.add(key, secondValue);
            }
            Intrinsics.checkNotNull((Object)result2);
            return result2;
        }
        catch (Exception e) {
            this.logger.error("Error merging JSON objects", (Throwable)e);
            JsonObject result3 = (JsonObject)this.gson.fromJson(this.gson.toJson((JsonElement)first), JsonObject.class);
            Set set2 = second.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"entrySet(...)");
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                result3.add((String)it.getKey(), (JsonElement)it.getValue());
            }
            Intrinsics.checkNotNull((Object)result3);
            return result3;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final JsonObject convertTheme(JsonObject theme) {
        try {
            block35: {
                block32: {
                    block34: {
                        block33: {
                            result = new JsonObject();
                            result.addProperty("inherit", Boolean.valueOf(false));
                            base = "vs-dark";
                            if (!theme.has("type")) break block32;
                            var4_5 = theme.get("type").getAsString();
                            if (var4_5 == null) break block33;
                            switch (var4_5.hashCode()) {
                                case 556658381: {
                                    if (var4_5.equals("high-contrast")) break;
                                    ** break;
                                }
                                case -76517948: {
                                    if (var4_5.equals("hc-light")) break;
                                    ** break;
                                }
                                case 102970646: {
                                    if (!var4_5.equals("light")) {
                                        ** break;
                                    }
                                    ** GOTO lbl28
                                }
                                case -2050086378: {
                                    if (var4_5.equals("high-contrast-light")) break;
                                    ** break;
                                }
                                case 3323: {
                                    if (var4_5.equals("hc")) break;
                                    ** break;
                                }
                                case 3773: {
                                    if (!var4_5.equals("vs")) ** break;
lbl28:
                                    // 2 sources

                                    v0 = "vs";
                                    break block34;
                                }
                            }
                            v0 = "hc-black";
                            break block34;
                        }
                        v0 = "vs-dark";
                    }
                    base = v0;
                    break block35;
                }
                base = this.isDarkTheme != false ? "vs-dark" : "vs";
            }
            result.addProperty("base", base);
            if (theme.has("colors")) {
                result.add("colors", theme.get("colors"));
            } else {
                result.add("colors", (JsonElement)new JsonObject());
            }
            monacoThemeRules = JsonParser.parseString((String)"[]").getAsJsonArray();
            result.add("rules", (JsonElement)monacoThemeRules);
            result.add("encodedTokensColors", (JsonElement)JsonParser.parseString((String)"[]").getAsJsonArray());
            if (theme.has("tokenColors") && theme.get("tokenColors").isJsonArray()) {
                tokenColors = theme.getAsJsonArray("tokenColors");
                var7_10 = tokenColors.size();
                for (i = 0; i < var7_10; ++i) {
                    colorElement = tokenColors.get(i);
                    if (!colorElement.isJsonObject() || !(colorObj = colorElement.getAsJsonObject()).has("scope") || !colorObj.has("settings")) continue;
                    scope = colorObj.get("scope");
                    settings = colorObj.get("settings");
                    if (scope.isJsonPrimitive() && scope.getAsJsonPrimitive().isString()) {
                        scopeStr = scope.getAsString();
                        Intrinsics.checkNotNull((Object)scopeStr);
                        var14_25 = new String[]{","};
                        scopes = StringsKt.split$default((CharSequence)scopeStr, (String[])var14_25, (boolean)false, (int)0, (int)6, null);
                        if (scopes.size() > 1) {
                            for (JsonElement scopeItem : scopes) {
                                rule = new JsonObject();
                                if (settings.isJsonObject()) {
                                    settingsObj = settings.getAsJsonObject();
                                    for (Map.Entry entry : settingsObj.entrySet()) {
                                        rule.add((String)entry.getKey(), (JsonElement)entry.getValue());
                                    }
                                }
                                rule.addProperty("token", StringsKt.trim((CharSequence)((CharSequence)scopeItem /* !! */ )).toString());
                                monacoThemeRules.add((JsonElement)rule);
                            }
                            continue;
                        }
                        rule = new JsonObject();
                        if (settings.isJsonObject()) {
                            settingsObj = settings.getAsJsonObject();
                            for (Map.Entry entry : settingsObj.entrySet()) {
                                rule.add((String)entry.getKey(), (JsonElement)entry.getValue());
                            }
                        }
                        rule.addProperty("token", StringsKt.trim((CharSequence)scopeStr).toString());
                        monacoThemeRules.add((JsonElement)rule);
                        continue;
                    }
                    if (!scope.isJsonArray()) continue;
                    scopeArray = scope.getAsJsonArray();
                    rule = scopeArray.size();
                    for (j = 0; j < rule; ++j) {
                        scopeItem /* !! */  = scopeArray.get(j);
                        if (!scopeItem /* !! */ .isJsonPrimitive() || !scopeItem /* !! */ .getAsJsonPrimitive().isString()) continue;
                        rule = new JsonObject();
                        if (settings.isJsonObject()) {
                            settingsObj = settings.getAsJsonObject();
                            for (Map.Entry entry : settingsObj.entrySet()) {
                                rule.add((String)entry.getKey(), (JsonElement)entry.getValue());
                            }
                        }
                        v1 = scopeItem /* !! */ .getAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getAsString(...)");
                        rule.addProperty("token", StringsKt.trim((CharSequence)v1).toString());
                        monacoThemeRules.add((JsonElement)rule);
                    }
                }
            } else if (theme.has("settings") && theme.get("settings").isJsonArray()) {
                settings = theme.getAsJsonArray("settings");
                var7_11 = settings.size();
                for (i = 0; i < var7_11; ++i) {
                    settingElement = settings.get(i);
                    if (!settingElement.isJsonObject() || !(settingObj = settingElement.getAsJsonObject()).has("scope") || !settingObj.has("settings")) continue;
                    scope = settingObj.get("scope");
                    settingsObj = settingObj.getAsJsonObject("settings");
                    if (!scope.isJsonPrimitive() || !scope.getAsJsonPrimitive().isString()) continue;
                    scopeStr = scope.getAsString();
                    Intrinsics.checkNotNull((Object)scopeStr);
                    rule = new String[]{","};
                    scopes = StringsKt.split$default((CharSequence)scopeStr, (String[])rule, (boolean)false, (int)0, (int)6, null);
                    if (scopes.size() > 1) {
                        for (String scopeItem : scopes) {
                            rule = new JsonObject();
                            for (Map.Entry entry : settingsObj.entrySet()) {
                                rule.add((String)entry.getKey(), (JsonElement)entry.getValue());
                            }
                            rule.addProperty("token", StringsKt.trim((CharSequence)scopeItem).toString());
                            monacoThemeRules.add((JsonElement)rule);
                        }
                        continue;
                    }
                    rule = new JsonObject();
                    for (Map.Entry entry : settingsObj.entrySet()) {
                        rule.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                    rule.addProperty("token", StringsKt.trim((CharSequence)scopeStr).toString());
                    monacoThemeRules.add((JsonElement)rule);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("Error converting theme format", (Throwable)e);
            throw e;
        }
    }

    private final String loadVscodeThemeStyle(File vscodeThemeFile) {
        try {
            this.logger.info("Attempting to load VSCode theme style file: " + vscodeThemeFile.getAbsolutePath());
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            String content2 = FilesKt.readText((File)vscodeThemeFile, (Charset)charset);
            this.logger.info("Successfully loaded VSCode theme style, size: " + content2.length() + " bytes");
            return content2;
        }
        catch (Exception e) {
            this.logger.error("Failed to read VSCode theme style file: " + vscodeThemeFile.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadThemeConfig() {
        boolean bl;
        Path path = this.themeResourceDir;
        if (path != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        if (bl) {
            this.logger.warn("Cannot load theme configuration: resource directory does not exist");
            return;
        }
        try {
            JsonObject parsed;
            boolean cssExists;
            File vscodeThemeFile;
            String themeFileName = this.isDarkTheme ? "dark_modern.json" : "light_modern.json";
            String vscodeThemeName = this.isDarkTheme ? "vscode-theme-dark.css" : "vscode-theme-light.css";
            Path path2 = this.themeResourceDir;
            File themeFile = path2 != null && (path2 = path2.resolve(themeFileName)) != null ? path2.toFile() : null;
            Path path3 = this.themeResourceDir;
            File file = vscodeThemeFile = path3 != null && (path3 = path3.resolve(vscodeThemeName)) != null ? path3.toFile() : null;
            boolean bl2 = file != null ? file.exists() : (cssExists = false);
            if (!cssExists) {
                this.logger.warn("VSCode theme style file does not exist: " + vscodeThemeName);
                return;
            }
            File file2 = themeFile;
            String themeContent = (file2 != null ? file2.exists() : false) ? FilesKt.readText$default((File)themeFile, null, (int)1, null) : "";
            JsonObject finalTheme = parsed = !StringsKt.isBlank((CharSequence)themeContent) ? this.parseThemeString(themeContent) : new JsonObject();
            if (parsed.has("include")) {
                Path includePath;
                String includeFileName = parsed.get("include").getAsString();
                Path path4 = this.themeResourceDir;
                Path path5 = includePath = path4 != null ? path4.resolve(includeFileName) : null;
                if (includePath != null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(includePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        try {
                            File file3 = includePath.toFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                            String includeContent = FilesKt.readText$default((File)file3, null, (int)1, null);
                            JsonObject includeTheme = this.parseThemeString(includeContent);
                            finalTheme = this.mergeJsonObjects(finalTheme, includeTheme);
                        }
                        catch (Exception e) {
                            this.logger.error("Error processing include theme: " + includeFileName, (Throwable)e);
                        }
                    }
                }
            }
            JsonObject converted = this.convertTheme(finalTheme);
            ThemeManager themeManager = this;
            File file4 = vscodeThemeFile;
            if (file4 != null) {
                void it;
                File e = file4;
                ThemeManager themeManager2 = themeManager;
                boolean bl3 = false;
                v14 = this.loadVscodeThemeStyle((File)it);
                themeManager = themeManager2;
            } else {
                v14 = themeManager.themeStyleContent = null;
            }
            if (this.themeStyleContent != null) {
                converted.addProperty("cssContent", this.themeStyleContent);
            }
            JsonObject oldConfig = this.currentThemeConfig;
            this.currentThemeConfig = converted;
            File file5 = themeFile;
            this.logger.info("Loaded and converted theme configuration: " + themeFileName + " (theme exists: " + (file5 != null ? file5.exists() : false) + ", css exists: " + cssExists + ")");
            JsonObject jsonObject2 = oldConfig;
            if (!Intrinsics.areEqual((Object)(jsonObject2 != null ? jsonObject2.toString() : null), (Object)converted.toString())) {
                this.notifyThemeChangeListeners();
            }
        }
        catch (IOException e) {
            this.logger.error("Error reading theme configuration", (Throwable)e);
        }
        catch (JsonIOException e) {
            this.logger.error("Error processing theme JSON", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Unknown error occurred during theme configuration loading", (Throwable)e);
        }
    }

    private final void notifyThemeChangeListeners() {
        JsonObject jsonObject2 = this.currentThemeConfig;
        if (jsonObject2 == null) {
            return;
        }
        JsonObject config2 = jsonObject2;
        this.logger.info("Notifying " + this.themeChangeListeners.size() + " theme change listeners");
        Iterable $this$forEach$iv = this.themeChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThemeChangeListener listener2 = (ThemeChangeListener)element$iv;
            boolean bl = false;
            try {
                listener2.onThemeChanged(config2, this.isDarkTheme);
            }
            catch (Exception e) {
                this.logger.error("Error notifying theme change listener", (Throwable)e);
            }
        }
    }

    public final void addThemeChangeListener(@NotNull ThemeChangeListener listener2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.themeChangeListeners.add(listener2);
            this.logger.info("Added theme change listener, current listener count: " + this.themeChangeListeners.size());
            JsonObject jsonObject2 = this.currentThemeConfig;
            if (jsonObject2 == null) break block2;
            JsonObject it = jsonObject2;
            boolean bl = false;
            try {
                listener2.onThemeChanged(it, this.isDarkTheme);
                this.logger.info("Notified newly added listener of current theme configuration");
            }
            catch (Exception e) {
                this.logger.error("Error notifying new listener of current theme configuration", (Throwable)e);
            }
        }
    }

    public final void removeThemeChangeListener(@NotNull ThemeChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.themeChangeListeners.remove(listener2);
        this.logger.info("Removed theme change listener, remaining listener count: " + this.themeChangeListeners.size());
    }

    public final void reloadThemeConfig() {
        this.logger.info("Manually reloading theme configuration");
        this.loadThemeConfig();
    }

    public final boolean isDarkTheme() {
        return this.isDarkTheme;
    }

    @Nullable
    public final JsonObject getCurrentThemeConfig() {
        return this.currentThemeConfig;
    }

    public void dispose() {
        this.logger.info("Releasing theme manager resources");
        this.themeChangeListeners.clear();
        try {
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection != null) {
                messageBusConnection.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.error("Error disconnecting message bus connection", (Throwable)e);
        }
        this.messageBusConnection = null;
        this.themeResourceDir = null;
        this.currentThemeConfig = null;
        this.themeStyleContent = null;
        ThemeManager.Companion.resetInstance();
        this.logger.info("Theme manager resources released");
    }

    private static final void initialize$lambda$0(ThemeManager this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.info("Detected IDE theme change");
        boolean oldIsDarkTheme = this$0.isDarkTheme;
        JsonObject oldConfig = this$0.currentThemeConfig;
        this$0.updateCurrentThemeStatus();
        if (oldIsDarkTheme != this$0.isDarkTheme || oldConfig == null) {
            this$0.loadThemeConfig();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\u0005J\b\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/sina/weibo/agent/theme/ThemeManager$Companion;", "", "<init>", "()V", "instance", "Lcom/sina/weibo/agent/theme/ThemeManager;", "getThemeResourceDir", "Ljava/nio/file/Path;", "resourceRoot", "", "getDefaultThemeResourceDir", "getInstance", "resetInstance", "", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nThemeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeManager.kt\ncom/sina/weibo/agent/theme/ThemeManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,607:1\n1#2:608\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path getThemeResourceDir(@NotNull String resourceRoot) {
            Intrinsics.checkNotNullParameter((Object)resourceRoot, (String)"resourceRoot");
            Object object = new String[]{"src", "integrations", "theme", "default-themes"};
            Path themeDir = Paths.get(resourceRoot, object);
            object = themeDir;
            Intrinsics.checkNotNull((Object)object);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                themeDir = this.getDefaultThemeResourceDir(resourceRoot);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.notExists(themeDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    return null;
                }
            }
            return themeDir;
        }

        @NotNull
        public final Path getDefaultThemeResourceDir(@NotNull String resourceRoot) {
            Intrinsics.checkNotNullParameter((Object)resourceRoot, (String)"resourceRoot");
            String[] stringArray = new String[]{"integrations", "theme", "default-themes"};
            Path path = Paths.get(resourceRoot, stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ThemeManager getInstance() {
            ThemeManager themeManager = instance;
            if (themeManager == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    ThemeManager themeManager2 = instance;
                    if (themeManager2 == null) {
                        ThemeManager themeManager3;
                        ThemeManager it = themeManager3 = new ThemeManager();
                        boolean bl2 = false;
                        instance = it;
                        themeManager2 = themeManager3;
                    }
                    ThemeManager themeManager4 = themeManager2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                    themeManager = themeManager4;
                }
            }
            return themeManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void resetInstance() {
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                instance = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

