/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.terminal.TerminalInstance;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\fJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\fJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u001eJ\b\u0010 \u001a\u00020\u0011H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/sina/weibo/agent/terminal/TerminalInstanceManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "terminals", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/sina/weibo/agent/terminal/TerminalInstance;", "terminalsByNumericId", "", "nextNumericId", "Ljava/util/concurrent/atomic/AtomicInteger;", "allocateNumericId", "registerTerminal", "", "extHostTerminalId", "terminalInstance", "unregisterTerminal", "getTerminalInstance", "id", "numericId", "getAllTerminals", "", "containsTerminal", "", "getTerminalCount", "getAllTerminalIds", "", "getAllNumericIds", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTerminalInstanceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalInstanceManager.kt\ncom/sina/weibo/agent/terminal/TerminalInstanceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1869#2,2:141\n*S KotlinDebug\n*F\n+ 1 TerminalInstanceManager.kt\ncom/sina/weibo/agent/terminal/TerminalInstanceManager\n*L\n126#1:141,2\n*E\n"})
public final class TerminalInstanceManager
implements Disposable {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, TerminalInstance> terminals;
    @NotNull
    private final ConcurrentHashMap<Integer, TerminalInstance> terminalsByNumericId;
    @NotNull
    private final AtomicInteger nextNumericId;

    public TerminalInstanceManager() {
        Logger logger = Logger.getInstance(TerminalInstanceManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.terminals = new ConcurrentHashMap();
        this.terminalsByNumericId = new ConcurrentHashMap();
        this.nextNumericId = new AtomicInteger(1);
    }

    public final int allocateNumericId() {
        return this.nextNumericId.getAndIncrement();
    }

    public final void registerTerminal(@NotNull String extHostTerminalId, @NotNull TerminalInstance terminalInstance) {
        Intrinsics.checkNotNullParameter((Object)extHostTerminalId, (String)"extHostTerminalId");
        Intrinsics.checkNotNullParameter((Object)terminalInstance, (String)"terminalInstance");
        ((Map)this.terminals).put(extHostTerminalId, terminalInstance);
        ((Map)this.terminalsByNumericId).put(terminalInstance.getNumericId(), terminalInstance);
        terminalInstance.addTerminalCloseCallback((Function0<Unit>)((Function0)() -> TerminalInstanceManager.registerTerminal$lambda$0(this, extHostTerminalId)));
        this.logger.info("\ud83d\udcdd Registered terminal instance: " + extHostTerminalId + " (numericId: " + terminalInstance.getNumericId() + ")");
    }

    @Nullable
    public final TerminalInstance unregisterTerminal(@NotNull String extHostTerminalId) {
        Intrinsics.checkNotNullParameter((Object)extHostTerminalId, (String)"extHostTerminalId");
        TerminalInstance terminalInstance = this.terminals.remove(extHostTerminalId);
        if (terminalInstance != null) {
            this.terminalsByNumericId.remove(terminalInstance.getNumericId());
            this.logger.info("\ud83d\uddd1\ufe0f Unregistered terminal instance: " + extHostTerminalId + " (numericId: " + terminalInstance.getNumericId() + ")");
        }
        return terminalInstance;
    }

    @Nullable
    public final TerminalInstance getTerminalInstance(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.terminals.get(id);
    }

    @Nullable
    public final TerminalInstance getTerminalInstance(int numericId) {
        return this.terminalsByNumericId.get(numericId);
    }

    @NotNull
    public final Collection<TerminalInstance> getAllTerminals() {
        Collection<TerminalInstance> collection = this.terminals.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final boolean containsTerminal(@NotNull String extHostTerminalId) {
        Intrinsics.checkNotNullParameter((Object)extHostTerminalId, (String)"extHostTerminalId");
        return this.terminals.containsKey(extHostTerminalId);
    }

    public final int getTerminalCount() {
        return this.terminals.size();
    }

    @NotNull
    public final Set<String> getAllTerminalIds() {
        Set set2 = this.terminals.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        return CollectionsKt.toSet((Iterable)set2);
    }

    @NotNull
    public final Set<Integer> getAllNumericIds() {
        Set set2 = this.terminalsByNumericId.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        return CollectionsKt.toSet((Iterable)set2);
    }

    public void dispose() {
        this.logger.info("\ud83e\uddf9 Disposing terminal instance manager");
        try {
            Collection<TerminalInstance> collection = this.terminals.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            List terminalList = CollectionsKt.toList((Iterable)collection);
            this.terminals.clear();
            this.terminalsByNumericId.clear();
            Iterable $this$forEach$iv = terminalList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalInstance terminal = (TerminalInstance)element$iv;
                boolean bl = false;
                try {
                    terminal.dispose();
                }
                catch (Exception e) {
                    this.logger.error("Failed to dispose terminal instance: " + terminal.getExtHostTerminalId(), (Throwable)e);
                }
            }
            this.logger.info("\u2705 Terminal instance manager disposed");
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to dispose terminal instance manager", (Throwable)e);
        }
    }

    private static final Unit registerTerminal$lambda$0(TerminalInstanceManager this$0, String $extHostTerminalId) {
        this$0.logger.info("\ud83d\udd14 Received terminal close event callback: " + $extHostTerminalId);
        this$0.unregisterTerminal($extHostTerminalId);
        return Unit.INSTANCE;
    }
}

