/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.terminal.ShellEvent;
import com.sina.weibo.agent.terminal.ShellEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\tJ\u000e\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\tJ\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\u000eH\u0002J\b\u00100\u001a\u00020(H\u0002J\u0006\u00101\u001a\u00020(J\u0006\u00102\u001a\u00020(J\u000e\u00103\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u000eJ\u000e\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000eJ\u0006\u00106\u001a\u00020(R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R$\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0012\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/sina/weibo/agent/terminal/ShellIntegrationOutputState;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "listeners", "", "Lcom/sina/weibo/agent/terminal/ShellEventListener;", "value", "", "isCommandRunning", "()Z", "", "currentCommand", "getCurrentCommand", "()Ljava/lang/String;", "currentNonce", "getCurrentNonce", "", "commandStatus", "getCommandStatus", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "currentDirectory", "getCurrentDirectory", "output", "getOutput", "pendingOutput", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pendingOutputLock", "lastAppendTime", "Ljava/util/concurrent/atomic/AtomicLong;", "isFlushScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "addListener", "", "listener", "removeListener", "notifyListeners", "event", "Lcom/sina/weibo/agent/terminal/ShellEvent;", "appendOutput", "text", "flushPendingOutput", "clearOutput", "terminate", "appendRawOutput", "getCleanOutput", "rawOutput", "dispose", "MarkerType", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nShellIntegrationOutputState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellIntegrationOutputState.kt\ncom/sina/weibo/agent/terminal/ShellIntegrationOutputState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,394:1\n1869#2,2:395\n*S KotlinDebug\n*F\n+ 1 ShellIntegrationOutputState.kt\ncom/sina/weibo/agent/terminal/ShellIntegrationOutputState\n*L\n101#1:395,2\n*E\n"})
public final class ShellIntegrationOutputState {
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<ShellEventListener> listeners;
    private volatile boolean isCommandRunning;
    @NotNull
    private volatile String currentCommand;
    @NotNull
    private volatile String currentNonce;
    @Nullable
    private volatile Integer commandStatus;
    @NotNull
    private volatile String currentDirectory;
    @NotNull
    private volatile String output;
    @NotNull
    private final StringBuilder pendingOutput;
    @NotNull
    private final Object pendingOutputLock;
    @NotNull
    private final AtomicLong lastAppendTime;
    @NotNull
    private final AtomicBoolean isFlushScheduled;
    @NotNull
    private final CoroutineScope scope;

    public ShellIntegrationOutputState() {
        Logger logger = Logger.getInstance(ShellIntegrationOutputState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.listeners = new ArrayList();
        this.currentCommand = "";
        this.currentNonce = "";
        this.currentDirectory = "";
        this.output = "";
        this.pendingOutput = new StringBuilder();
        this.pendingOutputLock = new Object();
        this.lastAppendTime = new AtomicLong(0L);
        this.isFlushScheduled = new AtomicBoolean(false);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }

    public final boolean isCommandRunning() {
        return this.isCommandRunning;
    }

    @NotNull
    public final String getCurrentCommand() {
        return this.currentCommand;
    }

    @NotNull
    public final String getCurrentNonce() {
        return this.currentNonce;
    }

    @Nullable
    public final Integer getCommandStatus() {
        return this.commandStatus;
    }

    @NotNull
    public final String getCurrentDirectory() {
        return this.currentDirectory;
    }

    @NotNull
    public final String getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(@NotNull ShellEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        List<ShellEventListener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.listeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(@NotNull ShellEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        List<ShellEventListener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.listeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners(ShellEvent event2) {
        List<ShellEventListener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShellEventListener listener2 = (ShellEventListener)element$iv;
                boolean bl2 = false;
                try {
                    ShellEvent shellEvent = event2;
                    if (shellEvent instanceof ShellEvent.ShellExecutionStart) {
                        listener2.onShellExecutionStart(((ShellEvent.ShellExecutionStart)event2).getCommandLine(), ((ShellEvent.ShellExecutionStart)event2).getCwd());
                        continue;
                    }
                    if (shellEvent instanceof ShellEvent.ShellExecutionEnd) {
                        listener2.onShellExecutionEnd(((ShellEvent.ShellExecutionEnd)event2).getCommandLine(), ((ShellEvent.ShellExecutionEnd)event2).getExitCode());
                        continue;
                    }
                    if (shellEvent instanceof ShellEvent.ShellExecutionData) {
                        listener2.onShellExecutionData(((ShellEvent.ShellExecutionData)event2).getData());
                        continue;
                    }
                    if (shellEvent instanceof ShellEvent.CwdChange) {
                        listener2.onCwdChange(((ShellEvent.CwdChange)event2).getCwd());
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                catch (Exception e) {
                    this.logger.warn("Failed to notify Shell event listener", (Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void appendOutput(String text) {
        this.logger.debug("\ud83d\udcdd appendOutput called: '" + text + "', length=" + text.length());
        Object object = this.pendingOutputLock;
        synchronized (object) {
            boolean bl = false;
            this.pendingOutput.append(text);
            this.logger.debug("\ud83d\udcdd pendingOutput updated length: " + this.pendingOutput.length());
            Unit unit = Unit.INSTANCE;
        }
        long currentTime = System.currentTimeMillis();
        this.lastAppendTime.set(currentTime);
        if (this.isFlushScheduled.compareAndSet(false, true)) {
            this.logger.debug("\ud83d\udcdd Scheduling flush task, will execute after 50ms");
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ShellIntegrationOutputState this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)50L, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            ShellIntegrationOutputState.access$flushPendingOutput(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.logger.debug("\ud83d\udcdd Flush task already scheduled, skipping");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushPendingOutput() {
        block5: {
            String $i$a$-synchronized-ShellIntegrationOutputState$flushPendingOutput$textToFlush$22;
            this.logger.debug("\ud83d\ude80 flushPendingOutput called");
            Object object = this.pendingOutputLock;
            synchronized (object) {
                String string;
                boolean $i$a$-synchronized-ShellIntegrationOutputState$flushPendingOutput$textToFlush$22 = false;
                if (((CharSequence)this.pendingOutput).length() > 0) {
                    String string2 = this.pendingOutput.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String text = string2;
                    StringsKt.clear((StringBuilder)this.pendingOutput);
                    this.logger.debug("\ud83d\ude80 Ready to flush text: '" + text + "', length=" + text.length());
                    string = text;
                } else {
                    this.logger.debug("\ud83d\ude80 pendingOutput is empty, no need to flush");
                    string = null;
                }
                $i$a$-synchronized-ShellIntegrationOutputState$flushPendingOutput$textToFlush$22 = string;
            }
            String textToFlush = $i$a$-synchronized-ShellIntegrationOutputState$flushPendingOutput$textToFlush$22;
            this.isFlushScheduled.set(false);
            String string = textToFlush;
            if (string == null) break block5;
            String text = string;
            boolean bl = false;
            this.output = this.output + text;
            this.logger.info("\ud83d\ude80 Sending ShellExecutionData event: '" + text + "', length=" + text.length());
            this.notifyListeners(new ShellEvent.ShellExecutionData(text));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearOutput() {
        Object object = this.pendingOutputLock;
        synchronized (object) {
            boolean bl = false;
            this.output = "";
            StringsKt.clear((StringBuilder)this.pendingOutput);
            this.currentNonce = "";
            Unit unit = Unit.INSTANCE;
        }
        this.isFlushScheduled.set(false);
    }

    public final void terminate() {
        this.isCommandRunning = false;
        this.flushPendingOutput();
    }

    public final void appendRawOutput(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.logger.debug("\ud83d\udce5 Processing raw output: " + output.length() + " chars, isCommandRunning=" + this.isCommandRunning);
        this.logger.debug("\ud83d\udce5 Raw output content: '" + StringsKt.replace$default((String)StringsKt.replace$default((String)output, (String)"\u001b", (String)"\\u001b", (boolean)false, (int)4, null), (String)"\u0007", (String)"\\u0007", (boolean)false, (int)4, null) + "'");
        int currentIndex = 0;
        boolean hasShellIntegrationMarkers = false;
        while (currentIndex < output.length()) {
            List list;
            String params;
            int markerIndex = StringsKt.indexOf$default((CharSequence)output, (String)"\u001b]633;", (int)currentIndex, (boolean)false, (int)4, null);
            if (markerIndex == -1) {
                String string = output.substring(currentIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String remainingContent = string;
                this.logger.debug("\ud83d\udce4 No Shell Integration marker found, remaining content: '" + remainingContent + "', isCommandRunning=" + this.isCommandRunning);
                if (!hasShellIntegrationMarkers && ((CharSequence)remainingContent).length() > 0) {
                    this.logger.debug("\ud83d\udce4 No Shell Integration marker, treat all content as command output");
                    this.appendOutput(remainingContent);
                    break;
                }
                if (this.isCommandRunning && currentIndex < output.length()) {
                    this.logger.debug("\ud83d\udce4 Append remaining content to output: '" + remainingContent + "'");
                    this.appendOutput(remainingContent);
                    break;
                }
                if (this.isCommandRunning) break;
                this.logger.debug("\u26a0\ufe0f Command not running, ignore output: '" + remainingContent + "'");
                break;
            }
            hasShellIntegrationMarkers = true;
            if (this.isCommandRunning && currentIndex < markerIndex) {
                String beforeMarker;
                Intrinsics.checkNotNullExpressionValue((Object)output.substring(currentIndex, markerIndex), (String)"substring(...)");
                this.logger.debug("\ud83d\udce4 Append content before marker: '" + beforeMarker + "'");
                this.appendOutput(beforeMarker);
            } else if (!this.isCommandRunning && currentIndex < markerIndex) {
                String beforeMarker;
                Intrinsics.checkNotNullExpressionValue((Object)output.substring(currentIndex, markerIndex), (String)"substring(...)");
                this.logger.debug("\u26a0\ufe0f Command not running, ignore content before marker: '" + beforeMarker + "'");
            }
            int typeStart = markerIndex + 6;
            if (typeStart >= output.length()) {
                if (!this.isCommandRunning || currentIndex >= output.length()) break;
                String string = output.substring(currentIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.appendOutput(string);
                break;
            }
            MarkerType type2 = MarkerType.Companion.fromChar(output.charAt(typeStart));
            int paramStart = typeStart + 1;
            int paramEnd = StringsKt.indexOf$default((CharSequence)output, (char)'\u0007', (int)paramStart, (boolean)false, (int)4, null);
            if (paramEnd == -1) {
                this.logger.debug("\u26a0\ufe0f Marker end not found, skip");
                currentIndex = typeStart;
                continue;
            }
            if (paramStart < paramEnd) {
                String string = output.substring(paramStart, paramEnd);
                v3 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                v3 = params = "";
            }
            if (StringsKt.startsWith$default((String)params, (String)";", (boolean)false, (int)2, null)) {
                String string = params.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String[] stringArray = new String[]{";"};
                list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list = CollectionsKt.listOf((Object)params);
            }
            List components = list;
            this.logger.debug("\ud83d\udd0d Parse Shell Integration marker: type=" + type2 + ", params='" + params + "', components=" + components);
            switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    this.logger.info("\ud83c\udfaf Shell Integration - Detected command line marker");
                    if (!(!((Collection)components).isEmpty()) || !(((CharSequence)components.get(0)).length() > 0)) break;
                    this.currentCommand = (String)components.get(0);
                    this.currentNonce = components.size() >= 2 ? (String)components.get(1) : "";
                    this.logger.info("\ud83c\udfaf Shell Integration - Command line: '" + this.currentCommand + "'");
                    break;
                }
                case 2: {
                    this.logger.info("\ud83d\ude80 Shell Integration - Detected command executed marker");
                    this.isCommandRunning = true;
                    if (!(((CharSequence)this.currentCommand).length() > 0)) break;
                    this.logger.info("\ud83d\ude80 Shell Integration - Command started: '" + this.currentCommand + "', isCommandRunning=" + this.isCommandRunning);
                    this.notifyListeners(new ShellEvent.ShellExecutionStart(this.currentCommand, this.currentDirectory));
                    String string = output.substring(markerIndex, paramEnd + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    this.appendOutput(string);
                    break;
                }
                case 3: {
                    this.logger.info("\ud83c\udfc1 Shell Integration - Detected command finished marker");
                    if (((CharSequence)this.currentCommand).length() > 0) {
                        String string = output.substring(markerIndex, paramEnd + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        this.appendOutput(string);
                        this.flushPendingOutput();
                        String string2 = (String)CollectionsKt.firstOrNull((List)components);
                        this.commandStatus = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
                        this.logger.info("\ud83c\udfc1 Shell Integration - Command finished: '" + this.currentCommand + "' (exit code: " + this.commandStatus + ")");
                        this.notifyListeners(new ShellEvent.ShellExecutionEnd(this.currentCommand, this.commandStatus));
                        this.currentCommand = "";
                    }
                    this.isCommandRunning = false;
                    break;
                }
                case 4: {
                    String cwdValue;
                    String property;
                    this.logger.debug("\ud83d\udccb Shell Integration - Detected property marker");
                    if (!(!((Collection)components).isEmpty()) || !StringsKt.startsWith$default((String)(property = (String)components.get(0)), (String)"Cwd=", (boolean)false, (int)2, null)) break;
                    Intrinsics.checkNotNullExpressionValue((Object)property.substring(4), (String)"substring(...)");
                    if (Intrinsics.areEqual((Object)cwdValue, (Object)this.currentDirectory)) break;
                    this.currentDirectory = cwdValue;
                    this.logger.info("\ud83d\udcc1 Shell Integration - Directory changed: '" + cwdValue + "'");
                    this.notifyListeners(new ShellEvent.CwdChange(cwdValue));
                    break;
                }
                case 5: {
                    this.logger.debug("\ud83c\udfaf Shell Integration - Prompt start");
                    break;
                }
                case 6: {
                    this.logger.debug("\ud83c\udfaf Shell Integration - Command input start");
                    break;
                }
                default: {
                    this.logger.debug("\ud83d\udd0d Shell Integration - Unhandled marker type: " + type2);
                }
            }
            currentIndex = paramEnd + 1;
        }
    }

    @NotNull
    public final String getCleanOutput(@NotNull String rawOutput) {
        Intrinsics.checkNotNullParameter((Object)rawOutput, (String)"rawOutput");
        String result2 = rawOutput;
        Regex markerPattern = new Regex("\u001b\\]633;[^\\u0007]*\\u0007");
        result2 = markerPattern.replace((CharSequence)result2, "");
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        List<ShellEventListener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            this.listeners.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ void access$flushPendingOutput(ShellIntegrationOutputState $this) {
        $this.flushPendingOutput();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\u0011\b\u0082\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lcom/sina/weibo/agent/terminal/ShellIntegrationOutputState$MarkerType;", "", "char", "", "<init>", "(Ljava/lang/String;IC)V", "getChar", "()C", "COMMAND_LINE", "COMMAND_FINISHED", "COMMAND_EXECUTED", "PROPERTY", "PROMPT_START", "COMMAND_START", "CONTINUATION_START", "CONTINUATION_END", "RIGHT_PROMPT_START", "RIGHT_PROMPT_END", "UNKNOWN", "Companion", "coderider-kilo-jetbrains"})
    private static final class MarkerType
    extends Enum<MarkerType> {
        @NotNull
        public static final Companion Companion;
        private final char char;
        public static final /* enum */ MarkerType COMMAND_LINE;
        public static final /* enum */ MarkerType COMMAND_FINISHED;
        public static final /* enum */ MarkerType COMMAND_EXECUTED;
        public static final /* enum */ MarkerType PROPERTY;
        public static final /* enum */ MarkerType PROMPT_START;
        public static final /* enum */ MarkerType COMMAND_START;
        public static final /* enum */ MarkerType CONTINUATION_START;
        public static final /* enum */ MarkerType CONTINUATION_END;
        public static final /* enum */ MarkerType RIGHT_PROMPT_START;
        public static final /* enum */ MarkerType RIGHT_PROMPT_END;
        public static final /* enum */ MarkerType UNKNOWN;
        private static final /* synthetic */ MarkerType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MarkerType(char c) {
            this.char = c;
        }

        public final char getChar() {
            return this.char;
        }

        public static MarkerType[] values() {
            return (MarkerType[])$VALUES.clone();
        }

        public static MarkerType valueOf(String value) {
            return Enum.valueOf(MarkerType.class, value);
        }

        @NotNull
        public static EnumEntries<MarkerType> getEntries() {
            return $ENTRIES;
        }

        static {
            COMMAND_LINE = new MarkerType('E');
            COMMAND_FINISHED = new MarkerType('D');
            COMMAND_EXECUTED = new MarkerType('C');
            PROPERTY = new MarkerType('P');
            PROMPT_START = new MarkerType('A');
            COMMAND_START = new MarkerType('B');
            CONTINUATION_START = new MarkerType('F');
            CONTINUATION_END = new MarkerType('G');
            RIGHT_PROMPT_START = new MarkerType('H');
            RIGHT_PROMPT_END = new MarkerType('I');
            UNKNOWN = new MarkerType('?');
            $VALUES = markerTypeArray = new MarkerType[]{MarkerType.COMMAND_LINE, MarkerType.COMMAND_FINISHED, MarkerType.COMMAND_EXECUTED, MarkerType.PROPERTY, MarkerType.PROMPT_START, MarkerType.COMMAND_START, MarkerType.CONTINUATION_START, MarkerType.CONTINUATION_END, MarkerType.RIGHT_PROMPT_START, MarkerType.RIGHT_PROMPT_END, MarkerType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/sina/weibo/agent/terminal/ShellIntegrationOutputState$MarkerType$Companion;", "", "<init>", "()V", "fromChar", "Lcom/sina/weibo/agent/terminal/ShellIntegrationOutputState$MarkerType;", "char", "", "coderider-kilo-jetbrains"})
        @SourceDebugExtension(value={"SMAP\nShellIntegrationOutputState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellIntegrationOutputState.kt\ncom/sina/weibo/agent/terminal/ShellIntegrationOutputState$MarkerType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MarkerType fromChar(char c) {
                MarkerType markerType;
                MarkerType markerType2;
                block2: {
                    MarkerType[] markerTypeArray = MarkerType.values();
                    int n = markerTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        MarkerType markerType3;
                        MarkerType it = markerType3 = markerTypeArray[i];
                        boolean bl = false;
                        if (!(it.getChar() == c)) continue;
                        markerType2 = markerType3;
                        break block2;
                    }
                    markerType2 = markerType = null;
                }
                if (markerType2 == null) {
                    markerType = UNKNOWN;
                }
                return markerType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MarkerType.values().length];
            try {
                nArray[MarkerType.COMMAND_LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkerType.COMMAND_EXECUTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkerType.COMMAND_FINISHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkerType.PROPERTY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkerType.PROMPT_START.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkerType.COMMAND_START.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

