/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.terminal;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.sina.weibo.agent.terminal.ProxyInputStream;
import com.sina.weibo.agent.terminal.ProxyPtyProcessCallback;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020!H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0(H\u0016J\b\u0010)\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/sina/weibo/agent/terminal/ProxyPtyProcess;", "Lcom/pty4j/PtyProcess;", "originalProcess", "callback", "Lcom/sina/weibo/agent/terminal/ProxyPtyProcessCallback;", "<init>", "(Lcom/pty4j/PtyProcess;Lcom/sina/weibo/agent/terminal/ProxyPtyProcessCallback;)V", "proxyInputStream", "Lcom/sina/weibo/agent/terminal/ProxyInputStream;", "proxyErrorStream", "getInputStream", "Ljava/io/InputStream;", "getErrorStream", "getOutputStream", "Ljava/io/OutputStream;", "isAlive", "", "pid", "", "exitValue", "", "waitFor", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "destroy", "", "destroyForcibly", "Ljava/lang/Process;", "info", "Ljava/lang/ProcessHandle$Info;", "children", "Ljava/util/stream/Stream;", "Ljava/lang/ProcessHandle;", "descendants", "setWinSize", "winSize", "Lcom/pty4j/WinSize;", "toHandle", "onExit", "Ljava/util/concurrent/CompletableFuture;", "getWinSize", "isConsoleMode", "coderider-kilo-jetbrains"})
public final class ProxyPtyProcess
extends PtyProcess {
    @NotNull
    private final PtyProcess originalProcess;
    @Nullable
    private final ProxyPtyProcessCallback callback;
    @NotNull
    private final ProxyInputStream proxyInputStream;
    @NotNull
    private final ProxyInputStream proxyErrorStream;

    public ProxyPtyProcess(@NotNull PtyProcess originalProcess, @Nullable ProxyPtyProcessCallback callback) {
        Intrinsics.checkNotNullParameter((Object)originalProcess, (String)"originalProcess");
        this.originalProcess = originalProcess;
        this.callback = callback;
        InputStream inputStream = this.originalProcess.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        this.proxyInputStream = new ProxyInputStream(inputStream, "STDOUT", this.callback);
        InputStream inputStream2 = this.originalProcess.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        this.proxyErrorStream = new ProxyInputStream(inputStream2, "STDERR", this.callback);
    }

    public /* synthetic */ ProxyPtyProcess(PtyProcess ptyProcess, ProxyPtyProcessCallback proxyPtyProcessCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            proxyPtyProcessCallback = null;
        }
        this(ptyProcess, proxyPtyProcessCallback);
    }

    @NotNull
    public InputStream getInputStream() {
        return this.proxyInputStream;
    }

    @NotNull
    public InputStream getErrorStream() {
        return this.proxyErrorStream;
    }

    @NotNull
    public OutputStream getOutputStream() {
        OutputStream outputStream = this.originalProcess.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        return outputStream;
    }

    public boolean isAlive() {
        return this.originalProcess.isAlive();
    }

    public long pid() {
        return this.originalProcess.pid();
    }

    public int exitValue() {
        return this.originalProcess.exitValue();
    }

    public int waitFor() {
        return this.originalProcess.waitFor();
    }

    public boolean waitFor(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.originalProcess.waitFor(timeout, unit);
    }

    public void destroy() {
        this.originalProcess.destroy();
    }

    @NotNull
    public Process destroyForcibly() {
        Process process2 = this.originalProcess.destroyForcibly();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"destroyForcibly(...)");
        return process2;
    }

    @NotNull
    public ProcessHandle.Info info() {
        ProcessHandle.Info info2 = this.originalProcess.info();
        Intrinsics.checkNotNullExpressionValue((Object)info2, (String)"info(...)");
        return info2;
    }

    @NotNull
    public Stream<ProcessHandle> children() {
        Stream stream = this.originalProcess.children();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"children(...)");
        return stream;
    }

    @NotNull
    public Stream<ProcessHandle> descendants() {
        Stream stream = this.originalProcess.descendants();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"descendants(...)");
        return stream;
    }

    public void setWinSize(@NotNull WinSize winSize) {
        Intrinsics.checkNotNullParameter((Object)winSize, (String)"winSize");
        this.originalProcess.setWinSize(winSize);
    }

    @NotNull
    public ProcessHandle toHandle() {
        ProcessHandle processHandle = this.originalProcess.toHandle();
        Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
        return processHandle;
    }

    @NotNull
    public CompletableFuture<Process> onExit() {
        CompletableFuture completableFuture = this.originalProcess.onExit();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"onExit(...)");
        return completableFuture;
    }

    @NotNull
    public WinSize getWinSize() {
        WinSize winSize = this.originalProcess.getWinSize();
        Intrinsics.checkNotNullExpressionValue((Object)winSize, (String)"getWinSize(...)");
        return winSize;
    }

    public boolean isConsoleMode() {
        return this.originalProcess.isConsoleMode();
    }
}

