/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.plugin;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.sina.weibo.agent.core.ExtensionProcessManager;
import com.sina.weibo.agent.core.ExtensionSocketServer;
import com.sina.weibo.agent.core.ExtensionUnixDomainSocketServer;
import com.sina.weibo.agent.core.ISocketServer;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.extensions.core.ExtensionConfigurationManager;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.plugin.DEBUG_MODE;
import com.sina.weibo.agent.plugin.SystemObjectProvider;
import com.sina.weibo.agent.util.ExtensionUtils;
import com.sina.weibo.agent.util.PluginResourceUtil;
import com.sina.weibo.agent.webview.WebViewManager;
import com.sina.weibo.agent.workspace.WorkspaceFileChangeManager;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\u0010J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0014J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\b\u0010 \u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sina/weibo/agent/plugin/WecoderPluginService;", "Lcom/intellij/openapi/Disposable;", "currentProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isInitialized", "", "initializationComplete", "Ljava/util/concurrent/CompletableFuture;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "socketServer", "Lcom/sina/weibo/agent/core/ExtensionSocketServer;", "udsSocketServer", "Lcom/sina/weibo/agent/core/ExtensionUnixDomainSocketServer;", "processManager", "Lcom/sina/weibo/agent/core/ExtensionProcessManager;", "initialize", "", "project", "initPlatformFiles", "waitForInitialization", "cleanup", "getSocketServer", "getUdsServer", "getProcessManager", "reset", "getCurrentProject", "dispose", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nWecoderPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WecoderPlugin.kt\ncom/sina/weibo/agent/plugin/WecoderPluginService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,665:1\n774#2:666\n865#2,2:667\n1869#2,2:669\n*S KotlinDebug\n*F\n+ 1 WecoderPlugin.kt\ncom/sina/weibo/agent/plugin/WecoderPluginService\n*L\n469#1:666\n469#1:667,2\n470#1:669,2\n*E\n"})
public final class WecoderPluginService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Project currentProject;
    @NotNull
    private final Logger LOG;
    private volatile boolean isInitialized;
    @NotNull
    private final CompletableFuture<Boolean> initializationComplete;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ExtensionSocketServer socketServer;
    @NotNull
    private final ExtensionUnixDomainSocketServer udsSocketServer;
    @NotNull
    private final ExtensionProcessManager processManager;
    @NotNull
    private static volatile DEBUG_MODE DEBUG_TYPE = DEBUG_MODE.NONE;
    @Nullable
    private static volatile String DEBUG_RESOURCE;
    @NotNull
    private static final String DEBUG_HOST = "127.0.0.1";
    private static final int DEBUG_PORT = 51234;

    public WecoderPluginService(@NotNull Project currentProject) {
        Intrinsics.checkNotNullParameter((Object)currentProject, (String)"currentProject");
        this.currentProject = currentProject;
        Logger logger = Logger.getInstance(WecoderPluginService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.initializationComplete = new CompletableFuture();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.socketServer = new ExtensionSocketServer();
        this.udsSocketServer = new ExtensionUnixDomainSocketServer();
        this.processManager = new ExtensionProcessManager();
    }

    public final void initialize(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.isInitialized) {
            this.LOG.info("WecoderPluginService already initialized");
            return;
        }
        ExtensionConfigurationManager configManager = ExtensionConfigurationManager.Companion.getInstance(project);
        if (!configManager.isConfigurationValid()) {
            this.LOG.warn("Plugin service initialization skipped: Invalid configuration");
            this.initializationComplete.complete(false);
            return;
        }
        ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(project);
        if (!extensionManager.isProperlyInitialized()) {
            this.LOG.warn("Plugin service initialization skipped: Extension manager not properly initialized");
            this.initializationComplete.complete(false);
            return;
        }
        this.LOG.info("Initializing WecoderPluginService, debug mode: " + DEBUG_TYPE);
        SystemObjectProvider.INSTANCE.initialize(project);
        this.currentProject = project;
        this.socketServer.setProject(project);
        this.udsSocketServer.setProject(project);
        SystemObjectProvider.INSTANCE.register("pluginService", this);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WecoderPluginService this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            WecoderPluginService.access$initPlatformFiles(this.this$0);
                            String string = this.$project.getBasePath();
                            if (string == null) {
                                string = "";
                            }
                            String projectPath = string;
                            ((ServiceProxyRegistry)this.$project.getService(ServiceProxyRegistry.class)).initialize();
                            if (WecoderPluginService.access$getDEBUG_TYPE$cp() == DEBUG_MODE.ALL) {
                                WecoderPluginService.access$getLOG$p(this.this$0).info("Running in debug mode: " + WecoderPluginService.access$getDEBUG_TYPE$cp() + ", will directly connect to 127.0.0.1:51234");
                                WecoderPluginService.access$getSocketServer$p(this.this$0).connectToDebugHost("127.0.0.1", 51234);
                                WecoderPluginService.access$setInitialized$p(this.this$0, true);
                                WecoderPluginService.access$getInitializationComplete$p(this.this$0).complete(Boxing.boxBoolean((boolean)true));
                                WecoderPluginService.access$getLOG$p(this.this$0).info("Debug mode connection successful, WecoderPluginService initialized");
                            } else {
                                PluginContext traceCtx = PluginContext.Companion.getInstance(this.$project);
                                String string2 = traceCtx.getTraceId();
                                if (string2 == null) {
                                    boolean bl = false;
                                    String string3 = UUID.randomUUID().toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                                    String string4 = string3;
                                    int n = 0;
                                    int n2 = 8;
                                    String string5 = string4.substring(n, n2);
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                                    String id = string5;
                                    traceCtx.startTraceSession(id, System.nanoTime());
                                    string2 = id;
                                }
                                String traceId = string2;
                                WecoderPluginService.access$getLOG$p(this.this$0).info("[Perf][traceId=" + traceId + "] Normal mode initialization begin");
                                long tNormalStart = System.nanoTime();
                                ISocketServer server = SystemInfo.isWindows ? (ISocketServer)WecoderPluginService.access$getSocketServer$p(this.this$0) : (ISocketServer)WecoderPluginService.access$getUdsSocketServer$p(this.this$0);
                                long tServerStart = System.nanoTime();
                                Object portOrPath = server.start(projectPath);
                                long serverStartElapsedMs = (System.nanoTime() - tServerStart) / (long)1000000;
                                if (!ExtensionUtils.isValidPortOrPath(portOrPath)) {
                                    WecoderPluginService.access$getLOG$p(this.this$0).info("Failed to start socket server");
                                    WecoderPluginService.access$getLOG$p(this.this$0).info("[Timing] Socket server start took " + serverStartElapsedMs + " ms (failed)");
                                    WecoderPluginService.access$getInitializationComplete$p(this.this$0).complete(Boxing.boxBoolean((boolean)false));
                                    return Unit.INSTANCE;
                                }
                                WecoderPluginService.access$getLOG$p(this.this$0).info("Socket server started on: " + portOrPath);
                                WecoderPluginService.access$getLOG$p(this.this$0).info("[Timing] Socket server start completed in " + serverStartElapsedMs + " ms");
                                long tProcStart = System.nanoTime();
                                if (!WecoderPluginService.access$getProcessManager$p(this.this$0).start(portOrPath, traceId)) {
                                    WecoderPluginService.access$getLOG$p(this.this$0).info("[Timing] Extension process start took " + (System.nanoTime() - tProcStart) / (long)1000000 + " ms (failed)");
                                    WecoderPluginService.access$getLOG$p(this.this$0).info("Failed to start extension process");
                                    server.stop();
                                    WecoderPluginService.access$getInitializationComplete$p(this.this$0).complete(Boxing.boxBoolean((boolean)false));
                                    return Unit.INSTANCE;
                                }
                                WecoderPluginService.access$getLOG$p(this.this$0).info("[Timing] Extension process start completed in " + (System.nanoTime() - tProcStart) / (long)1000000 + " ms");
                                WecoderPluginService.access$getLOG$p(this.this$0).info("[Perf][traceId=" + traceId + "] Extension process start request sent");
                                WecoderPluginService.access$setInitialized$p(this.this$0, true);
                                WecoderPluginService.access$getInitializationComplete$p(this.this$0).complete(Boxing.boxBoolean((boolean)true));
                                WecoderPluginService.access$getLOG$p(this.this$0).info("WecoderPluginService initialization completed");
                                WecoderPluginService.access$getLOG$p(this.this$0).info("[Timing] Normal mode initialization completed in " + (System.nanoTime() - tNormalStart) / (long)1000000 + " ms");
                            }
                        }
                        catch (Exception e) {
                            WecoderPluginService.access$getLOG$p(this.this$0).info("Error during WecoderPluginService initialization", (Throwable)e);
                            WecoderPluginService.access$cleanup(this.this$0);
                            WecoderPluginService.access$getInitializationComplete$p(this.this$0).complete(Boxing.boxBoolean((boolean)false));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void initPlatformFiles() {
        String platformSuffix;
        String string;
        String string2 = SystemInfo.isWindows ? "windows-x64" : (SystemInfo.isMac ? (Intrinsics.areEqual((Object)(string = System.getProperty("os.arch")), (Object)"x86_64") ? "darwin-x64" : (Intrinsics.areEqual((Object)string, (Object)"aarch64") ? "darwin-arm64" : "")) : (platformSuffix = SystemInfo.isLinux ? "linux-x64" : ""));
        if (((CharSequence)platformSuffix).length() > 0) {
            String string3 = PluginResourceUtil.INSTANCE.getResourcePath("com.gitlab.coderider-kilo", "");
            if (string3 == null) {
                throw new IllegalStateException("Cannot get plugin directory");
            }
            String pluginDir = string3;
            File platformFile = new File(pluginDir, "platform.txt");
            if (platformFile.exists()) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = FilesKt.readLines$default((File)platformFile, null, (int)1, null);
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!StringsKt.isBlank((CharSequence)it) && !StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String originalPath = (String)element$iv;
                    boolean bl = false;
                    String suffixedPath = originalPath + platformSuffix;
                    File originalFile = new File(pluginDir, "node_modules/" + originalPath);
                    File suffixedFile = new File(pluginDir, "node_modules/" + suffixedPath);
                    if (!suffixedFile.exists()) continue;
                    if (originalFile.exists()) {
                        originalFile.delete();
                    }
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.move(suffixedFile.toPath(), originalFile.toPath(), copyOptionArray);
                    originalFile.setExecutable(true);
                }
            }
            platformFile.delete();
        }
    }

    public final boolean waitForInitialization() {
        Boolean bl = this.initializationComplete.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        return bl;
    }

    private final void cleanup() {
        try {
            if (DEBUG_TYPE == DEBUG_MODE.NONE) {
                this.processManager.stop();
            }
        }
        catch (Exception e) {
            this.LOG.info("Error stopping process manager", (Throwable)e);
        }
        try {
            this.socketServer.stop();
            this.udsSocketServer.stop();
        }
        catch (Exception e) {
            this.LOG.info("Error stopping socket server", (Throwable)e);
        }
        ((WorkspaceFileChangeManager)this.currentProject.getService(WorkspaceFileChangeManager.class)).dispose();
        this.isInitialized = false;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    public final ExtensionSocketServer getSocketServer() {
        return this.socketServer;
    }

    @NotNull
    public final ExtensionUnixDomainSocketServer getUdsServer() {
        return this.udsSocketServer;
    }

    @NotNull
    public final ExtensionProcessManager getProcessManager() {
        return this.processManager;
    }

    @NotNull
    public final CompletableFuture<Boolean> reset() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, future, null){
            int label;
            final /* synthetic */ WecoderPluginService this$0;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.this$0 = $receiver;
                this.$future = $future;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            boolean bl;
                            Object object2;
                            WecoderPluginService.access$getLOG$p(this.this$0).info("Resetting extension host and reloading WebView...");
                            try {
                                WecoderPluginService.access$getProcessManager$p(this.this$0).stop();
                            }
                            catch (Exception e) {
                                WecoderPluginService.access$getLOG$p(this.this$0).warn("Error stopping extension process during reset", (Throwable)e);
                            }
                            try {
                                if (SystemInfo.isWindows) {
                                    WecoderPluginService.access$getSocketServer$p(this.this$0).stop();
                                } else {
                                    WecoderPluginService.access$getUdsSocketServer$p(this.this$0).stop();
                                }
                            }
                            catch (Exception e) {
                                WecoderPluginService.access$getLOG$p(this.this$0).warn("Error stopping socket server during reset", (Throwable)e);
                            }
                            try {
                                Object object3;
                                if (SystemInfo.isWindows) {
                                    ExtensionSocketServer extensionSocketServer = WecoderPluginService.access$getSocketServer$p(this.this$0);
                                    String string = WecoderPluginService.access$getCurrentProject$p(this.this$0).getBasePath();
                                    if (string == null) {
                                        string = "";
                                    }
                                    object3 = extensionSocketServer.start(string);
                                } else {
                                    ExtensionUnixDomainSocketServer extensionUnixDomainSocketServer = WecoderPluginService.access$getUdsSocketServer$p(this.this$0);
                                    String string = WecoderPluginService.access$getCurrentProject$p(this.this$0).getBasePath();
                                    if (string == null) {
                                        string = "";
                                    }
                                    object3 = extensionUnixDomainSocketServer.start(string);
                                }
                                object2 = object3;
                            }
                            catch (Exception e) {
                                WecoderPluginService.access$getLOG$p(this.this$0).info("Failed to start socket server during reset", (Throwable)e);
                                this.$future.complete(Boxing.boxBoolean((boolean)false));
                                return Unit.INSTANCE;
                            }
                            Object portOrPath = object2;
                            if (!ExtensionUtils.isValidPortOrPath(portOrPath)) {
                                WecoderPluginService.access$getLOG$p(this.this$0).info("Invalid socket info when restarting during reset: " + portOrPath);
                                this.$future.complete(Boxing.boxBoolean((boolean)false));
                                return Unit.INSTANCE;
                            }
                            String string = PluginContext.Companion.getInstance(WecoderPluginService.access$getCurrentProject$p(this.this$0)).getTraceId();
                            if (string == null) {
                                String string2 = UUID.randomUUID().toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                                String string3 = string2;
                                int n = 0;
                                int n2 = 8;
                                String string4 = string3.substring(n, n2);
                                string = string4;
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                            }
                            String traceId = string;
                            try {
                                bl = WecoderPluginService.access$getProcessManager$p(this.this$0).start(portOrPath, traceId);
                            }
                            catch (Exception e) {
                                WecoderPluginService.access$getLOG$p(this.this$0).info("Failed to start extension process during reset", (Throwable)e);
                                bl = false;
                            }
                            boolean started = bl;
                            if (!started) {
                                this.$future.complete(Boxing.boxBoolean((boolean)false));
                                return Unit.INSTANCE;
                            }
                            try {
                                WebViewManager webViewManager = (WebViewManager)WecoderPluginService.access$getCurrentProject$p(this.this$0).getService(WebViewManager.class);
                                if (webViewManager != null) {
                                    webViewManager.disposeWebView();
                                }
                            }
                            catch (Exception e) {
                                WecoderPluginService.access$getLOG$p(this.this$0).warn("Failed to refresh WebView after reset", (Throwable)e);
                            }
                            WecoderPluginService.access$getLOG$p(this.this$0).info("Reset completed successfully");
                            this.$future.complete(Boxing.boxBoolean((boolean)true));
                        }
                        catch (Exception e) {
                            WecoderPluginService.access$getLOG$p(this.this$0).info("Unexpected error during reset", (Throwable)e);
                            this.$future.complete(Boxing.boxBoolean((boolean)false));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return future;
    }

    @Nullable
    public final Project getCurrentProject() {
        return this.currentProject;
    }

    public void dispose() {
        if (!this.isInitialized) {
            return;
        }
        this.LOG.info("Disposing WecoderPluginService");
        WebViewManager webViewManager = (WebViewManager)this.currentProject.getService(WebViewManager.class);
        if (webViewManager != null) {
            webViewManager.dispose();
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.cleanup();
        this.LOG.info("WecoderPluginService disposed");
    }

    @JvmStatic
    @NotNull
    public static final DEBUG_MODE getDebugMode() {
        return Companion.getDebugMode();
    }

    @JvmStatic
    @Nullable
    public static final String getDebugResource() {
        return Companion.getDebugResource();
    }

    public static final /* synthetic */ void access$initPlatformFiles(WecoderPluginService $this) {
        $this.initPlatformFiles();
    }

    public static final /* synthetic */ Logger access$getLOG$p(WecoderPluginService $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ ExtensionSocketServer access$getSocketServer$p(WecoderPluginService $this) {
        return $this.socketServer;
    }

    public static final /* synthetic */ void access$setInitialized$p(WecoderPluginService $this, boolean bl) {
        $this.isInitialized = bl;
    }

    public static final /* synthetic */ CompletableFuture access$getInitializationComplete$p(WecoderPluginService $this) {
        return $this.initializationComplete;
    }

    public static final /* synthetic */ ExtensionUnixDomainSocketServer access$getUdsSocketServer$p(WecoderPluginService $this) {
        return $this.udsSocketServer;
    }

    public static final /* synthetic */ ExtensionProcessManager access$getProcessManager$p(WecoderPluginService $this) {
        return $this.processManager;
    }

    public static final /* synthetic */ void access$cleanup(WecoderPluginService $this) {
        $this.cleanup();
    }

    public static final /* synthetic */ Project access$getCurrentProject$p(WecoderPluginService $this) {
        return $this.currentProject;
    }

    static {
        try {
            Properties properties = new Properties();
            InputStream configStream = WecoderPluginService.class.getResourceAsStream("/com/sina/weibo/agent/plugin/config/plugin.properties");
            if (configStream != null) {
                properties.load(configStream);
                configStream.close();
                String string = properties.getProperty("debug.mode", "none");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String debugModeStr = string2;
                DEBUG_TYPE = DEBUG_MODE.Companion.fromString(debugModeStr);
                DEBUG_RESOURCE = properties.getProperty("debug.resource", null);
                Logger.getInstance(WecoderPluginService.class).info("Read debug mode from config file: " + DEBUG_MODE.Companion);
            } else {
                Logger.getInstance(WecoderPluginService.class).warn("Cannot load config file, use default debug mode: " + DEBUG_MODE.Companion);
            }
        }
        catch (Exception e) {
            Logger.getInstance(WecoderPluginService.class).warn("Error reading config file, use default debug mode: " + DEBUG_MODE.Companion, (Throwable)e);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/sina/weibo/agent/plugin/WecoderPluginService$Companion;", "", "<init>", "()V", "DEBUG_TYPE", "Lcom/sina/weibo/agent/plugin/DEBUG_MODE;", "DEBUG_RESOURCE", "", "DEBUG_HOST", "DEBUG_PORT", "", "getDebugMode", "getDebugResource", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DEBUG_MODE getDebugMode() {
            return DEBUG_TYPE;
        }

        @JvmStatic
        @Nullable
        public final String getDebugResource() {
            return DEBUG_RESOURCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

