/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.plugin;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0001J\u001b\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/sina/weibo/agent/plugin/SystemObjectProvider;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "systemObjects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "initialize", "", "project", "Lcom/intellij/openapi/project/Project;", "register", "key", "obj", "get", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "dispose", "Keys", "coderider-kilo-jetbrains"})
public final class SystemObjectProvider {
    @NotNull
    public static final SystemObjectProvider INSTANCE = new SystemObjectProvider();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ConcurrentHashMap<String, Object> systemObjects;

    private SystemObjectProvider() {
    }

    public final void initialize(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        logger.info("Initializing SystemObjectProvider with project: " + project.getName());
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        this.register("application", application);
    }

    public final void register(@NotNull String key, @NotNull Object obj2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        ((Map)systemObjects).put(key, obj2);
        logger.debug("Registered system object: " + key);
    }

    @Nullable
    public final <T> T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = systemObjects.get(key);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    public final void dispose() {
        logger.info("Disposing SystemObjectProvider");
        systemObjects.clear();
    }

    static {
        Logger logger = Logger.getInstance(SystemObjectProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SystemObjectProvider.logger = logger;
        systemObjects = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/sina/weibo/agent/plugin/SystemObjectProvider$Keys;", "", "<init>", "()V", "APPLICATION", "", "coderider-kilo-jetbrains"})
    public static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        public static final String APPLICATION = "application";

        private Keys() {
        }
    }
}

