/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc.proxy;

import com.sina.weibo.agent.ipc.proxy.ArgType;
import com.sina.weibo.agent.ipc.proxy.MessageBufferKt;
import com.sina.weibo.agent.ipc.proxy.MessageType;
import com.sina.weibo.agent.ipc.proxy.MixedArg;
import com.sina.weibo.agent.ipc.proxy.SerializableObjectWithBuffers;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001d\u001a\u00020\u0007J\u0014\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/sina/weibo/agent/ipc/proxy/MessageBuffer;", "", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "bytes", "", "getBytes", "()[B", "byteLength", "", "getByteLength", "()I", "writeUInt8", "", "n", "readUInt8", "writeUInt32", "readUInt32", "writeShortString", "str", "readShortString", "", "writeLongString", "readLongString", "writeBuffer", "buff", "writeVSBuffer", "readVSBuffer", "writeMixedArray", "arr", "", "Lcom/sina/weibo/agent/ipc/proxy/MixedArg;", "readMixedArray", "Companion", "coderider-kilo-jetbrains"})
public final class MessageBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    public static final int sizeUInt8 = 1;
    public static final int sizeUInt32 = 4;

    private MessageBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @NotNull
    public final byte[] getBytes() {
        byte[] byArray = this.buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    public final int getByteLength() {
        return this.buffer.array().length;
    }

    public final void writeUInt8(int n) {
        this.buffer.put((byte)n);
    }

    public final int readUInt8() {
        return this.buffer.get() & 0xFF;
    }

    public final void writeUInt32(int n) {
        this.buffer.putInt(n);
    }

    public final int readUInt32() {
        return this.buffer.getInt();
    }

    public final void writeShortString(@NotNull byte[] str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.buffer.put((byte)str.length);
        this.buffer.put(str);
    }

    @NotNull
    public final String readShortString() {
        int strByteLength = this.buffer.get() & 0xFF;
        byte[] strBuff = new byte[strByteLength];
        this.buffer.get(strBuff);
        return new String(strBuff, Charsets.UTF_8);
    }

    public final void writeLongString(@NotNull byte[] str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.buffer.putInt(str.length);
        this.buffer.put(str);
    }

    @NotNull
    public final String readLongString() {
        int strByteLength = this.buffer.getInt();
        byte[] strBuff = new byte[strByteLength];
        this.buffer.get(strBuff);
        return new String(strBuff, Charsets.UTF_8);
    }

    public final void writeBuffer(@NotNull byte[] buff) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        this.buffer.putInt(buff.length);
        this.buffer.put(buff);
    }

    public final void writeVSBuffer(@NotNull byte[] buff) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        this.buffer.putInt(buff.length);
        this.buffer.put(buff);
    }

    @NotNull
    public final byte[] readVSBuffer() {
        int buffLength = this.buffer.getInt();
        byte[] buff = new byte[buffLength];
        this.buffer.get(buff);
        return buff;
    }

    public final void writeMixedArray(@NotNull List<? extends MixedArg> arr) {
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        this.buffer.put((byte)arr.size());
        for (MixedArg mixedArg : arr) {
            MixedArg mixedArg2 = mixedArg;
            if (mixedArg2 instanceof MixedArg.StringArg) {
                this.writeUInt8(ArgType.String.getValue());
                this.writeLongString(((MixedArg.StringArg)mixedArg).getValue());
                continue;
            }
            if (mixedArg2 instanceof MixedArg.VSBufferArg) {
                this.writeUInt8(ArgType.VSBuffer.getValue());
                this.writeVSBuffer(((MixedArg.VSBufferArg)mixedArg).getValue());
                continue;
            }
            if (mixedArg2 instanceof MixedArg.SerializedObjectWithBuffersArg) {
                this.writeUInt8(ArgType.SerializedObjectWithBuffers.getValue());
                this.writeUInt32(((MixedArg.SerializedObjectWithBuffersArg)mixedArg).getBuffers().size());
                this.writeLongString(((MixedArg.SerializedObjectWithBuffersArg)mixedArg).getValue());
                for (byte[] buffer : ((MixedArg.SerializedObjectWithBuffersArg)mixedArg).getBuffers()) {
                    this.writeBuffer(buffer);
                }
                continue;
            }
            if (mixedArg2 instanceof MixedArg.UndefinedArg) {
                this.writeUInt8(ArgType.Undefined.getValue());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final List<Object> readMixedArray() {
        int arrLen = this.readUInt8();
        ArrayList<Object> arr = new ArrayList<Object>(arrLen);
        block6: for (int i = 0; i < arrLen; ++i) {
            ArgType argType = ArgType.Companion.fromValue(this.readUInt8());
            if (argType == null) {
                argType = ArgType.Undefined;
            }
            ArgType argType2 = argType;
            switch (WhenMappings.$EnumSwitchMapping$0[argType2.ordinal()]) {
                case 1: {
                    boolean bl = arr.add(this.readLongString());
                    continue block6;
                }
                case 2: {
                    boolean bl = arr.add(this.readVSBuffer());
                    continue block6;
                }
                case 3: {
                    int bufferCount = this.readUInt32();
                    String jsonString = this.readLongString();
                    ArrayList<byte[]> buffers = new ArrayList<byte[]>(bufferCount);
                    for (int j = 0; j < bufferCount; ++j) {
                        buffers.add(this.readVSBuffer());
                    }
                    boolean bl = arr.add(new SerializableObjectWithBuffers<Object>(MessageBufferKt.parseJsonAndRestoreBufferRefs(jsonString, (List<byte[]>)buffers, null)));
                    continue block6;
                }
                case 4: {
                    boolean bl = arr.add(null);
                    continue block6;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return arr;
    }

    public /* synthetic */ MessageBuffer(ByteBuffer buffer, DefaultConstructorMarker $constructor_marker) {
        this(buffer);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/sina/weibo/agent/ipc/proxy/MessageBuffer$Companion;", "", "<init>", "()V", "alloc", "Lcom/sina/weibo/agent/ipc/proxy/MessageBuffer;", "type", "Lcom/sina/weibo/agent/ipc/proxy/MessageType;", "req", "", "messageSize", "read", "buff", "", "offset", "sizeUInt8", "sizeUInt32", "sizeShortString", "str", "sizeLongString", "sizeVSBuffer", "sizeMixedArray", "arr", "", "Lcom/sina/weibo/agent/ipc/proxy/MixedArg;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MessageBuffer alloc(@NotNull MessageType type2, int req, int messageSize) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            int totalSize = messageSize + 1 + 4;
            ByteBuffer buffer = ByteBuffer.allocate(totalSize).order(ByteOrder.BIG_ENDIAN);
            Intrinsics.checkNotNull((Object)buffer);
            MessageBuffer result2 = new MessageBuffer(buffer, null);
            result2.writeUInt8(type2.getValue());
            result2.writeUInt32(req);
            return result2;
        }

        @NotNull
        public final MessageBuffer read(@NotNull byte[] buff, int offset) {
            Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
            ByteBuffer buffer = ByteBuffer.wrap(buff).order(ByteOrder.BIG_ENDIAN);
            buffer.position(offset);
            Intrinsics.checkNotNull((Object)buffer);
            return new MessageBuffer(buffer, null);
        }

        public final int sizeShortString(@NotNull byte[] str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return 1 + str.length;
        }

        public final int sizeLongString(@NotNull byte[] str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return 4 + str.length;
        }

        public final int sizeVSBuffer(@NotNull byte[] buff) {
            Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
            return 4 + buff.length;
        }

        public final int sizeMixedArray(@NotNull List<? extends MixedArg> arr) {
            Intrinsics.checkNotNullParameter(arr, (String)"arr");
            int size = 0;
            ++size;
            for (MixedArg mixedArg : arr) {
                ++size;
                MixedArg mixedArg2 = mixedArg;
                if (mixedArg2 instanceof MixedArg.StringArg) {
                    size += this.sizeLongString(((MixedArg.StringArg)mixedArg).getValue());
                    continue;
                }
                if (mixedArg2 instanceof MixedArg.VSBufferArg) {
                    size += this.sizeVSBuffer(((MixedArg.VSBufferArg)mixedArg).getValue());
                    continue;
                }
                if (mixedArg2 instanceof MixedArg.SerializedObjectWithBuffersArg) {
                    size += 4;
                    size += this.sizeLongString(((MixedArg.SerializedObjectWithBuffersArg)mixedArg).getValue());
                    for (byte[] buffer : ((MixedArg.SerializedObjectWithBuffersArg)mixedArg).getBuffers()) {
                        size += this.sizeVSBuffer(buffer);
                    }
                    continue;
                }
                if (mixedArg2 instanceof MixedArg.UndefinedArg) continue;
                throw new NoWhenBranchMatchedException();
            }
            return size;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArgType.values().length];
            try {
                nArray[ArgType.String.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgType.VSBuffer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgType.SerializedObjectWithBuffers.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgType.Undefined.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

