/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.ipc.ChunkStream;
import com.sina.weibo.agent.ipc.ISocket;
import com.sina.weibo.agent.ipc.ProtocolMessage;
import com.sina.weibo.agent.ipc.ProtocolMessageType;
import com.sina.weibo.agent.ipc.SocketDiagnosticsEventType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001b\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0013\u001a\u00020\u00012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u000bJ\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/sina/weibo/agent/ipc/ProtocolReader;", "Lcom/intellij/openapi/Disposable;", "socket", "Lcom/sina/weibo/agent/ipc/ISocket;", "<init>", "(Lcom/sina/weibo/agent/ipc/ISocket;)V", "isDisposed", "", "incomingData", "Lcom/sina/weibo/agent/ipc/ChunkStream;", "lastReadTime", "", "messageListeners", "", "Lkotlin/Function1;", "Lcom/sina/weibo/agent/ipc/ProtocolMessage;", "", "state", "Lcom/sina/weibo/agent/ipc/ProtocolReader$State;", "onMessage", "listener", "acceptChunk", "data", "", "readEntireBuffer", "getLastReadTime", "dispose", "Companion", "State", "HeaderReadInfo", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nProtocolReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolReader.kt\ncom/sina/weibo/agent/ipc/ProtocolReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1869#2,2:168\n*S KotlinDebug\n*F\n+ 1 ProtocolReader.kt\ncom/sina/weibo/agent/ipc/ProtocolReader\n*L\n105#1:168,2\n*E\n"})
public final class ProtocolReader
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ISocket socket;
    private boolean isDisposed;
    @NotNull
    private final ChunkStream incomingData;
    private long lastReadTime;
    @NotNull
    private final List<Function1<ProtocolMessage, Unit>> messageListeners;
    @NotNull
    private final State state;
    @NotNull
    private static final Logger LOG;

    public ProtocolReader(@NotNull ISocket socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.socket = socket;
        this.incomingData = new ChunkStream();
        this.lastReadTime = System.currentTimeMillis();
        this.messageListeners = new ArrayList();
        this.state = new State();
        this.socket.onData(new ISocket.DataListener(){

            @Override
            public final void onData(byte[] p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ProtocolReader.this.acceptChunk(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)ProtocolReader.this, ProtocolReader.class, "acceptChunk", "acceptChunk([B)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ISocket.DataListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    @NotNull
    public final Disposable onMessage(@NotNull Function1<? super ProtocolMessage, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.messageListeners.add(listener2);
        return () -> ProtocolReader.onMessage$lambda$0(this, listener2);
    }

    public final void acceptChunk(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length == 0) {
            return;
        }
        this.lastReadTime = System.currentTimeMillis();
        this.incomingData.acceptChunk(data);
        while (this.incomingData.getByteLength() >= this.state.getReadLen()) {
            byte[] buff = this.incomingData.read(this.state.getReadLen());
            if (this.state.getReadHead()) {
                ByteBuffer buffer = ByteBuffer.wrap(buff);
                byte messageTypeByte = buffer.get(0);
                int id = buffer.getInt(1);
                int ack = buffer.getInt(5);
                int messageSize = buffer.getInt(9);
                ProtocolMessageType messageType = ProtocolMessageType.Companion.fromValue(messageTypeByte);
                this.state.setReadHead(false);
                this.state.setReadLen(messageSize);
                this.state.setMessageType(messageType);
                this.state.setId(id);
                this.state.setAck(ack);
                this.socket.traceSocketEvent(SocketDiagnosticsEventType.PROTOCOL_HEADER_READ, new HeaderReadInfo(messageType.toTypeString(), id, ack, messageSize));
                continue;
            }
            ProtocolMessageType messageType = this.state.getMessageType();
            int id = this.state.getId();
            int ack = this.state.getAck();
            this.state.setReadHead(true);
            this.state.setReadLen(13);
            this.state.setMessageType(ProtocolMessageType.NONE);
            this.state.setId(0);
            this.state.setAck(0);
            this.socket.traceSocketEvent(SocketDiagnosticsEventType.PROTOCOL_MESSAGE_READ, buff);
            ProtocolMessage message = new ProtocolMessage(messageType, id, ack, buff);
            Iterable $this$forEach$iv = new ArrayList(this.messageListeners);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 listener2 = (Function1)element$iv;
                boolean bl = false;
                try {
                    listener2.invoke((Object)message);
                }
                catch (Exception e) {
                    LOG.warn("Error in message listener: " + e.getMessage(), (Throwable)e);
                }
            }
            if (!this.isDisposed) continue;
            break;
        }
    }

    @NotNull
    public final byte[] readEntireBuffer() {
        return this.incomingData.read(this.incomingData.getByteLength());
    }

    public final long getLastReadTime() {
        return this.lastReadTime;
    }

    public void dispose() {
        this.isDisposed = true;
        this.messageListeners.clear();
    }

    private static final void onMessage$lambda$0(ProtocolReader this$0, Function1 $listener) {
        this$0.messageListeners.remove($listener);
    }

    static {
        Logger logger = Logger.getInstance(ProtocolReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/sina/weibo/agent/ipc/ProtocolReader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/sina/weibo/agent/ipc/ProtocolReader$HeaderReadInfo;", "", "messageType", "", "id", "", "ack", "messageSize", "<init>", "(Ljava/lang/String;III)V", "getMessageType", "()Ljava/lang/String;", "getId", "()I", "getAck", "getMessageSize", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "coderider-kilo-jetbrains"})
    private static final class HeaderReadInfo {
        @NotNull
        private final String messageType;
        private final int id;
        private final int ack;
        private final int messageSize;

        public HeaderReadInfo(@NotNull String messageType, int id, int ack, int messageSize) {
            Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
            this.messageType = messageType;
            this.id = id;
            this.ack = ack;
            this.messageSize = messageSize;
        }

        @NotNull
        public final String getMessageType() {
            return this.messageType;
        }

        public final int getId() {
            return this.id;
        }

        public final int getAck() {
            return this.ack;
        }

        public final int getMessageSize() {
            return this.messageSize;
        }

        @NotNull
        public String toString() {
            return "HeaderReadInfo{messageType='" + this.messageType + "', id=" + this.id + ", ack=" + this.ack + ", messageSize=" + this.messageSize + "}";
        }

        @NotNull
        public final String component1() {
            return this.messageType;
        }

        public final int component2() {
            return this.id;
        }

        public final int component3() {
            return this.ack;
        }

        public final int component4() {
            return this.messageSize;
        }

        @NotNull
        public final HeaderReadInfo copy(@NotNull String messageType, int id, int ack, int messageSize) {
            Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
            return new HeaderReadInfo(messageType, id, ack, messageSize);
        }

        public static /* synthetic */ HeaderReadInfo copy$default(HeaderReadInfo headerReadInfo, String string, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                string = headerReadInfo.messageType;
            }
            if ((n4 & 2) != 0) {
                n = headerReadInfo.id;
            }
            if ((n4 & 4) != 0) {
                n2 = headerReadInfo.ack;
            }
            if ((n4 & 8) != 0) {
                n3 = headerReadInfo.messageSize;
            }
            return headerReadInfo.copy(string, n, n2, n3);
        }

        public int hashCode() {
            int result2 = this.messageType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.id);
            result2 = result2 * 31 + Integer.hashCode(this.ack);
            result2 = result2 * 31 + Integer.hashCode(this.messageSize);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeaderReadInfo)) {
                return false;
            }
            HeaderReadInfo headerReadInfo = (HeaderReadInfo)other;
            if (!Intrinsics.areEqual((Object)this.messageType, (Object)headerReadInfo.messageType)) {
                return false;
            }
            if (this.id != headerReadInfo.id) {
                return false;
            }
            if (this.ack != headerReadInfo.ack) {
                return false;
            }
            return this.messageSize == headerReadInfo.messageSize;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/sina/weibo/agent/ipc/ProtocolReader$State;", "", "<init>", "()V", "readHead", "", "getReadHead", "()Z", "setReadHead", "(Z)V", "readLen", "", "getReadLen", "()I", "setReadLen", "(I)V", "messageType", "Lcom/sina/weibo/agent/ipc/ProtocolMessageType;", "getMessageType", "()Lcom/sina/weibo/agent/ipc/ProtocolMessageType;", "setMessageType", "(Lcom/sina/weibo/agent/ipc/ProtocolMessageType;)V", "id", "getId", "setId", "ack", "getAck", "setAck", "coderider-kilo-jetbrains"})
    private static final class State {
        private boolean readHead = true;
        private int readLen = 13;
        @NotNull
        private ProtocolMessageType messageType = ProtocolMessageType.NONE;
        private int id;
        private int ack;

        public final boolean getReadHead() {
            return this.readHead;
        }

        public final void setReadHead(boolean bl) {
            this.readHead = bl;
        }

        public final int getReadLen() {
            return this.readLen;
        }

        public final void setReadLen(int n) {
            this.readLen = n;
        }

        @NotNull
        public final ProtocolMessageType getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(@NotNull ProtocolMessageType protocolMessageType) {
            Intrinsics.checkNotNullParameter((Object)((Object)protocolMessageType), (String)"<set-?>");
            this.messageType = protocolMessageType;
        }

        public final int getId() {
            return this.id;
        }

        public final void setId(int n) {
            this.id = n;
        }

        public final int getAck() {
            return this.ack;
        }

        public final void setAck(int n) {
            this.ack = n;
        }
    }
}

