/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.ipc.ISocket;
import com.sina.weibo.agent.ipc.SocketCloseEvent;
import com.sina.weibo.agent.ipc.SocketDiagnosticsEventType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010(\u001a\u00020\u0011H\u0016J\b\u0010)\u001a\u00020\u0011H\u0002J\u0014\u0010*\u001a\u00020\u00112\n\u0010+\u001a\u00060,j\u0002`-H\u0002J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020$H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0010H\u0016J\u0010\u00103\u001a\u0002012\u0006\u00102\u001a\u00020\u0013H\u0016J\u0016\u00104\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\u0010\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u00020'H\u0016J\b\u00107\u001a\u00020\u0011H\u0016J\u000e\u00108\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u00109J\u001a\u0010:\u001a\u00020\u00112\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\b\u0010?\u001a\u00020\u0011H\u0016J\u0006\u0010@\u001a\u00020$J\u0006\u0010A\u001a\u00020$J\u0006\u0010B\u001a\u00020$J\u0006\u0010\u001a\u001a\u00020$R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0015\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00110&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/sina/weibo/agent/ipc/NodeSocket;", "Lcom/sina/weibo/agent/ipc/ISocket;", "socket", "Ljava/net/Socket;", "debugLabel", "", "<init>", "(Ljava/net/Socket;Ljava/lang/String;)V", "channel", "Ljava/nio/channels/SocketChannel;", "(Ljava/nio/channels/SocketChannel;Ljava/lang/String;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "dataListeners", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/sina/weibo/agent/ipc/ISocket$DataListener;", "", "closeListeners", "Lcom/sina/weibo/agent/ipc/ISocket$CloseListener;", "endListeners", "Lkotlin/Function0;", "canWrite", "Ljava/util/concurrent/atomic/AtomicBoolean;", "receiveThread", "Ljava/lang/Thread;", "isDisposed", "endTimeoutHandle", "socketEndTimeoutMs", "", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "closeAction", "isSocket", "", "writeAction", "Lkotlin/Function1;", "", "startReceiving", "onEndReceived", "handleSocketError", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "closeSocket", "hadError", "onData", "Lcom/intellij/openapi/Disposable;", "listener", "onClose", "onEnd", "write", "buffer", "end", "drain", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "traceSocketEvent", "type", "Lcom/sina/weibo/agent/ipc/SocketDiagnosticsEventType;", "data", "", "dispose", "isClosed", "isInputClosed", "isOutputClosed", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nNodeSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeSocket.kt\ncom/sina/weibo/agent/ipc/NodeSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n1869#2,2:358\n1869#2,2:360\n1869#2,2:362\n*S KotlinDebug\n*F\n+ 1 NodeSocket.kt\ncom/sina/weibo/agent/ipc/NodeSocket\n*L\n128#1:358,2\n198#1:360,2\n93#1:362,2\n*E\n"})
public final class NodeSocket
implements ISocket {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<ISocket.DataListener, Unit> dataListeners;
    @NotNull
    private final ConcurrentHashMap<ISocket.CloseListener, Unit> closeListeners;
    @NotNull
    private final ConcurrentHashMap<Function0<Unit>, Unit> endListeners;
    @NotNull
    private final AtomicBoolean canWrite;
    @Nullable
    private Thread receiveThread;
    @NotNull
    private final AtomicBoolean isDisposed;
    @Nullable
    private Thread endTimeoutHandle;
    private final long socketEndTimeoutMs;
    @NotNull
    private final String debugLabel;
    @NotNull
    private final InputStream input;
    @NotNull
    private final OutputStream output;
    @NotNull
    private final Function0<Unit> closeAction;
    private final boolean isSocket;
    @Nullable
    private final Socket socket;
    @Nullable
    private final SocketChannel channel;
    @NotNull
    private final Function1<byte[], Unit> writeAction;

    public NodeSocket(@NotNull Socket socket, @NotNull String debugLabel) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)debugLabel, (String)"debugLabel");
        Logger logger = Logger.getInstance(NodeSocket.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.dataListeners = new ConcurrentHashMap();
        this.closeListeners = new ConcurrentHashMap();
        this.endListeners = new ConcurrentHashMap();
        this.canWrite = new AtomicBoolean(true);
        this.isDisposed = new AtomicBoolean(false);
        this.socketEndTimeoutMs = 30000L;
        InputStream inputStream = socket.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        this.input = inputStream;
        OutputStream outputStream = socket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        this.output = outputStream;
        this.closeAction = () -> NodeSocket._init_$lambda$0(socket);
        this.debugLabel = debugLabel;
        this.isSocket = true;
        this.socket = socket;
        this.channel = null;
        this.writeAction = arg_0 -> NodeSocket._init_$lambda$1(this, arg_0);
        this.traceSocketEvent(SocketDiagnosticsEventType.CREATED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"NodeSocket-TCP")));
    }

    public /* synthetic */ NodeSocket(Socket socket, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(socket, string);
    }

    public NodeSocket(@NotNull SocketChannel channel, @NotNull String debugLabel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)debugLabel, (String)"debugLabel");
        Logger logger = Logger.getInstance(NodeSocket.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.dataListeners = new ConcurrentHashMap();
        this.closeListeners = new ConcurrentHashMap();
        this.endListeners = new ConcurrentHashMap();
        this.canWrite = new AtomicBoolean(true);
        this.isDisposed = new AtomicBoolean(false);
        this.socketEndTimeoutMs = 30000L;
        InputStream inputStream = Channels.newInputStream(channel);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        this.input = inputStream;
        OutputStream outputStream = Channels.newOutputStream(channel);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        this.output = outputStream;
        this.closeAction = () -> NodeSocket._init_$lambda$2(channel);
        this.debugLabel = debugLabel;
        this.isSocket = false;
        this.socket = null;
        this.channel = channel;
        this.writeAction = arg_0 -> NodeSocket._init_$lambda$3(channel, arg_0);
        this.traceSocketEvent(SocketDiagnosticsEventType.CREATED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"NodeSocket-UDS")));
    }

    public /* synthetic */ NodeSocket(SocketChannel socketChannel, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(socketChannel, string);
    }

    @Override
    public void startReceiving() {
        if (this.receiveThread != null) {
            return;
        }
        this.receiveThread = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)("NodeSocket-Receiver-" + this.debugLabel), (int)0, () -> NodeSocket.startReceiving$lambda$5(this), (int)22, null);
    }

    private final void onEndReceived() {
        ISocket.DefaultImpls.traceSocketEvent$default(this, SocketDiagnosticsEventType.NODE_END_RECEIVED, null, 2, null);
        this.logger.info("Socket[" + this.debugLabel + "] Received END event, disabling write operations");
        this.canWrite.set(false);
        Set set2 = this.endListeners.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 listener2 = (Function0)element$iv;
            boolean bl = false;
            try {
                listener2.invoke();
            }
            catch (Exception e) {
                this.logger.error("Socket[" + this.debugLabel + "] END event listener processing exception", (Throwable)e);
            }
        }
        this.logger.info("Socket[" + this.debugLabel + "] Will execute delayed close after " + this.socketEndTimeoutMs + "ms");
        this.endTimeoutHandle = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)("NodeSocket-EndTimeout-" + this.debugLabel), (int)0, () -> NodeSocket.onEndReceived$lambda$7(this), (int)22, null);
    }

    private final void handleSocketError(Exception error2) {
        String string;
        String string2 = error2.getMessage();
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Broken pipe", (boolean)false, (int)2, null) : false;
        if (bl) {
            string = "EPIPE";
        } else {
            String string3 = error2.getMessage();
            string = (string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"Connection reset", (boolean)false, (int)2, null) : false) ? "ECONNRESET" : null;
        }
        String errorCode = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"code", (Object)errorCode), TuplesKt.to((Object)"message", (Object)error2.getMessage())};
        this.traceSocketEvent(SocketDiagnosticsEventType.ERROR, MapsKt.mapOf((Pair[])pairArray));
        if (!Intrinsics.areEqual((Object)errorCode, (Object)"EPIPE")) {
            this.logger.warn("Socket[" + this.debugLabel + "] Error: " + error2.getMessage(), (Throwable)error2);
        }
        this.closeSocket(true);
    }

    private final void closeSocket(boolean hadError) {
        if (this.isDisposed.get()) {
            return;
        }
        this.logger.info("Socket[" + this.debugLabel + "] Closing connection, hadError=" + hadError);
        try {
            if (!this.isClosed()) {
                this.logger.info("Socket[" + this.debugLabel + "] Closing connection");
                this.closeAction.invoke();
            }
        }
        catch (Exception e) {
            this.logger.warn("Socket[" + this.debugLabel + "] Exception occurred while closing connection", (Throwable)e);
        }
        Thread thread = this.endTimeoutHandle;
        if (thread != null) {
            thread.interrupt();
        }
        this.endTimeoutHandle = null;
        this.canWrite.set(false);
        this.traceSocketEvent(SocketDiagnosticsEventType.CLOSE, MapsKt.mapOf((Pair)TuplesKt.to((Object)"hadError", (Object)hadError)));
        SocketCloseEvent.NodeSocketCloseEvent closeEvent = new SocketCloseEvent.NodeSocketCloseEvent(hadError, null);
        Set set2 = this.closeListeners.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ISocket.CloseListener listener2 = (ISocket.CloseListener)element$iv;
            boolean bl = false;
            try {
                listener2.onClose(closeEvent);
            }
            catch (Exception e) {
                this.logger.error("Socket[" + this.debugLabel + "] Close listener processing exception", (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public Disposable onData(@NotNull ISocket.DataListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ((Map)this.dataListeners).put(listener2, Unit.INSTANCE);
        return () -> NodeSocket.onData$lambda$9(this, listener2);
    }

    @Override
    @NotNull
    public Disposable onClose(@NotNull ISocket.CloseListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ((Map)this.closeListeners).put(listener2, Unit.INSTANCE);
        return () -> NodeSocket.onClose$lambda$10(this, listener2);
    }

    @Override
    @NotNull
    public Disposable onEnd(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ((Map)this.endListeners).put(listener2, Unit.INSTANCE);
        return () -> NodeSocket.onEnd$lambda$11(this, listener2);
    }

    @Override
    public void write(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.isDisposed.get()) {
            this.logger.debug("Socket[" + this.debugLabel + "] Write ignored: Socket disposed");
            return;
        }
        if (this.isClosed()) {
            this.logger.info("Socket[" + this.debugLabel + "] Write ignored: Socket closed");
            return;
        }
        if (!this.canWrite.get()) {
            this.logger.info("Socket[" + this.debugLabel + "] Write ignored: canWrite=false");
            return;
        }
        try {
            this.traceSocketEvent(SocketDiagnosticsEventType.WRITE, buffer);
            this.writeAction.invoke((Object)buffer);
        }
        catch (ClosedChannelException e) {
            this.logger.warn("Socket[" + this.debugLabel + "] ClosedChannelException detected during write, connection closed");
            this.handleSocketError(e);
        }
        catch (IOException e) {
            this.logger.error("Socket[" + this.debugLabel + "] IO exception occurred during write", (Throwable)e);
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Broken pipe", (boolean)false, (int)2, null) : false;
            if (bl) {
                this.logger.warn("Socket[" + this.debugLabel + "] Broken pipe detected during write");
                return;
            }
            this.handleSocketError(e);
        }
        catch (Exception e) {
            this.logger.error("Socket[" + this.debugLabel + "] Unknown exception occurred during write", (Throwable)e);
            this.handleSocketError(e);
        }
    }

    @Override
    public void end() {
        if (this.isDisposed.get() || this.isClosed()) {
            return;
        }
        ISocket.DefaultImpls.traceSocketEvent$default(this, SocketDiagnosticsEventType.NODE_END_SENT, null, 2, null);
        this.logger.info("Socket[" + this.debugLabel + "] Sending END signal");
        try {
            if (this.isSocket && this.socket != null) {
                this.socket.shutdownOutput();
            } else {
                SocketChannel socketChannel = this.channel;
                if (socketChannel != null) {
                    socketChannel.shutdownOutput();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Socket[" + this.debugLabel + "] Exception occurred while sending END signal", (Throwable)e);
            this.handleSocketError(e);
        }
    }

    @Override
    @Nullable
    public Object drain(@NotNull Continuation<? super Unit> $completion) {
        ISocket.DefaultImpls.traceSocketEvent$default(this, SocketDiagnosticsEventType.NODE_DRAIN_BEGIN, null, 2, null);
        try {
            this.writeAction.invoke((Object)new byte[0]);
        }
        catch (Exception e) {
            this.logger.error("Socket[" + this.debugLabel + "] Exception occurred while executing drain", (Throwable)e);
            this.handleSocketError(e);
        }
        ISocket.DefaultImpls.traceSocketEvent$default(this, SocketDiagnosticsEventType.NODE_DRAIN_END, null, 2, null);
        return Unit.INSTANCE;
    }

    @Override
    public void traceSocketEvent(@NotNull SocketDiagnosticsEventType type2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Socket[" + this.debugLabel + "] Event: " + type2 + ", Data: " + data);
        }
    }

    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        ISocket.DefaultImpls.traceSocketEvent$default(this, SocketDiagnosticsEventType.CLOSE, null, 2, null);
        this.logger.info("Socket[" + this.debugLabel + "] Releasing resources");
        this.dataListeners.clear();
        this.closeListeners.clear();
        this.endListeners.clear();
        try {
            if (!this.isClosed()) {
                this.closeAction.invoke();
            }
        }
        catch (Exception e) {
            this.logger.warn("Socket[" + this.debugLabel + "] Exception occurred while closing Socket during resource release", (Throwable)e);
        }
        Thread thread = this.receiveThread;
        if (thread != null) {
            thread.interrupt();
        }
        this.receiveThread = null;
        Thread thread2 = this.endTimeoutHandle;
        if (thread2 != null) {
            thread2.interrupt();
        }
        this.endTimeoutHandle = null;
        this.logger.info("Socket[" + this.debugLabel + "] Resource release completed");
    }

    public final boolean isClosed() {
        return this.socket != null ? this.socket.isClosed() : (this.channel != null ? !this.channel.isOpen() : true);
    }

    public final boolean isInputClosed() {
        return this.socket != null ? this.socket.isClosed() || this.socket.isInputShutdown() : (this.channel != null ? !this.channel.isOpen() : true);
    }

    public final boolean isOutputClosed() {
        return this.socket != null ? this.socket.isClosed() || this.socket.isOutputShutdown() : (this.channel != null ? !this.channel.isOpen() : true);
    }

    public final boolean isDisposed() {
        return this.isDisposed.get();
    }

    private static final Unit _init_$lambda$0(Socket $socket) {
        $socket.close();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(NodeSocket this$0, byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this$0.output.write(buffer);
        this$0.output.flush();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(SocketChannel $channel) {
        $channel.close();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(SocketChannel $channel, byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        while (byteBuffer.hasRemaining()) {
            $channel.write(byteBuffer);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startReceiving$lambda$5(NodeSocket this$0) {
        byte[] buffer = new byte[8192];
        try {
            while (!this$0.isDisposed.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    int bytesRead = this$0.input.read(buffer);
                    if (bytesRead == -1) {
                        this$0.logger.info("Socket[" + this$0.debugLabel + "] Read EOF, triggering onEndReceived()");
                        this$0.onEndReceived();
                        break;
                    }
                    if (bytesRead <= 0) continue;
                    byte[] data = ArraysKt.copyOfRange((byte[])buffer, (int)0, (int)bytesRead);
                    this$0.traceSocketEvent(SocketDiagnosticsEventType.READ, data);
                    Set set2 = this$0.dataListeners.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
                    Iterable $this$forEach$iv = set2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ISocket.DataListener listener2 = (ISocket.DataListener)element$iv;
                        boolean bl = false;
                        try {
                            listener2.onData(data);
                        }
                        catch (Exception e) {
                            this$0.logger.error("Socket[" + this$0.debugLabel + "] Data listener processing exception", (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    if (!this$0.isDisposed.get()) {
                        this$0.logger.error("Socket[" + this$0.debugLabel + "] IO exception occurred while reading data", (Throwable)e);
                        this$0.handleSocketError(e);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            if (!this$0.isDisposed.get()) {
                this$0.logger.error("Socket[" + this$0.debugLabel + "] Unhandled exception in receive thread", (Throwable)e);
                this$0.handleSocketError(e);
            }
        }
        finally {
            this$0.closeSocket(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEndReceived$lambda$7(NodeSocket this$0) {
        try {
            Thread.sleep(this$0.socketEndTimeoutMs);
            if (!this$0.isDisposed.get()) {
                this$0.logger.info("Socket[" + this$0.debugLabel + "] Executing delayed close");
                this$0.closeAction.invoke();
            }
        }
        catch (InterruptedException e) {
            this$0.logger.info("Socket[" + this$0.debugLabel + "] Delayed close thread interrupted");
        }
        catch (Exception e) {
            this$0.logger.error("Socket[" + this$0.debugLabel + "] Delayed close processing exception", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final void onData$lambda$9(NodeSocket this$0, ISocket.DataListener $listener) {
        this$0.dataListeners.remove($listener);
    }

    private static final void onClose$lambda$10(NodeSocket this$0, ISocket.CloseListener $listener) {
        this$0.closeListeners.remove($listener);
    }

    private static final void onEnd$lambda$11(NodeSocket this$0, Function0 $listener) {
        this$0.endListeners.remove($listener);
    }
}

