/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.ipc;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bJ\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/sina/weibo/agent/ipc/ChunkStream;", "", "<init>", "()V", "chunks", "", "", "value", "", "byteLength", "getByteLength", "()I", "acceptChunk", "", "buff", "read", "byteCount", "peek", "_read", "advance", "", "coderider-kilo-jetbrains"})
public final class ChunkStream {
    @NotNull
    private final List<byte[]> chunks = new ArrayList();
    private int byteLength;

    public final int getByteLength() {
        return this.byteLength;
    }

    public final void acceptChunk(@NotNull byte[] buff) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        if (buff.length == 0) {
            return;
        }
        this.chunks.add(buff);
        this.byteLength += buff.length;
    }

    @NotNull
    public final byte[] read(int byteCount) {
        return this._read(byteCount, true);
    }

    @NotNull
    public final byte[] peek(int byteCount) {
        return this._read(byteCount, false);
    }

    private final byte[] _read(int byteCount, boolean advance) {
        if (byteCount == 0) {
            return new byte[0];
        }
        if (byteCount > this.byteLength) {
            throw new IllegalArgumentException("Cannot read so many bytes!");
        }
        if (this.chunks.get(0).length == byteCount) {
            byte[] result2 = this.chunks.get(0);
            if (advance) {
                this.chunks.remove(0);
                this.byteLength -= byteCount;
            }
            return result2;
        }
        if (this.chunks.get(0).length > byteCount) {
            byte[] firstChunk = this.chunks.get(0);
            byte[] result3 = new byte[byteCount];
            System.arraycopy(firstChunk, 0, result3, 0, byteCount);
            if (advance) {
                byte[] remaining = new byte[firstChunk.length - byteCount];
                System.arraycopy(firstChunk, byteCount, remaining, 0, remaining.length);
                this.chunks.set(0, remaining);
                this.byteLength -= byteCount;
            }
            return result3;
        }
        byte[] result4 = new byte[byteCount];
        int resultOffset = 0;
        int chunkIndex = 0;
        int remainingBytes = byteCount;
        while (remainingBytes > 0) {
            byte[] chunk = this.chunks.get(chunkIndex);
            if (chunk.length > remainingBytes) {
                System.arraycopy(chunk, 0, result4, resultOffset, remainingBytes);
                if (advance) {
                    byte[] remaining = new byte[chunk.length - remainingBytes];
                    System.arraycopy(chunk, remainingBytes, remaining, 0, remaining.length);
                    this.chunks.set(chunkIndex, remaining);
                    this.byteLength -= remainingBytes;
                }
                resultOffset += remainingBytes;
                remainingBytes = 0;
                continue;
            }
            System.arraycopy(chunk, 0, result4, resultOffset, chunk.length);
            resultOffset += chunk.length;
            remainingBytes -= chunk.length;
            if (advance) {
                this.chunks.remove(chunkIndex);
                this.byteLength -= chunk.length;
                continue;
            }
            ++chunkIndex;
        }
        return result4;
    }
}

