/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.extensions.core.ExtensionSwitcher;
import com.sina.weibo.agent.extensions.ui.ExtensionSwitcherDialog;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/sina/weibo/agent/extensions/ui/actions/ExtensionSwitcherAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "coderider-kilo-jetbrains"})
public final class ExtensionSwitcherAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ExtensionSwitcher extensionSwitcher = ExtensionSwitcher.Companion.getInstance(project2);
        if (extensionSwitcher.isSwitching()) {
            Messages.showInfoMessage((String)"Extension switching is already in progress. Please wait for it to complete.", (String)"Switch in Progress");
            return;
        }
        ExtensionSwitcherDialog dialog = new ExtensionSwitcherDialog(project2);
        dialog.show();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (project == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(project);
        List<ExtensionProvider> availableProviders = extensionManager.getAvailableProviders();
        if (availableProviders.isEmpty()) {
            presentation2.setEnabledAndVisible(false);
            presentation2.setText("No Extensions Available");
            return;
        }
        ExtensionProvider currentProvider = extensionManager.getCurrentProvider();
        Object object = currentProvider;
        if (object == null || (object = object.getDisplayName()) == null) {
            object = "Unknown";
        }
        Object currentExtensionName = object;
        switch (e.getPlace()) {
            case "toolbar": {
                presentation2.setText("Switch (" + (String)currentExtensionName + ")");
                presentation2.setDescription("Switch to a different extension provider or upload VSIX");
                break;
            }
            case "MainMenu": {
                presentation2.setText("Switch Extension Provider");
                presentation2.setDescription("Switch to a different extension provider or upload VSIX");
                break;
            }
            default: {
                presentation2.setText("Switch Extension (" + (String)currentExtensionName + ")");
                presentation2.setDescription("Switch to a different extension provider or upload VSIX");
            }
        }
        presentation2.setEnabledAndVisible(true);
        ExtensionSwitcher extensionSwitcher = ExtensionSwitcher.Companion.getInstance(project);
        if (extensionSwitcher.isSwitching()) {
            presentation2.setText("Switching...");
            presentation2.setDescription("Extension switching in progress...");
            presentation2.setEnabled(false);
        }
    }
}

