/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.extensions.core;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.theme.ThemeManager;
import com.sina.weibo.agent.util.PluginConstants;
import com.sina.weibo.agent.util.PluginResourceUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\tH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t\u00a8\u0006\u001f"}, d2={"Lcom/sina/weibo/agent/extensions/core/VsixManager;", "", "<init>", "()V", "installVsix", "", "vsixFile", "Ljava/io/File;", "extensionId", "", "getExtensionDirectory", "hasVsixInstallation", "getVsixInstallationPath", "uninstallVsix", "listInstalledExtensions", "", "extractVsixFile", "targetDir", "moveDirectory", "", "source", "target", "copyThemesToIntegrations", "extensionDir", "getPluginThemesDirectory", "deleteDirectory", "dir", "getExtensionResourcePath", "codeDir", "projectPath", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nVsixManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VsixManager.kt\ncom/sina/weibo/agent/extensions/core/VsixManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n3829#2:413\n4344#2,2:414\n13472#2,2:420\n1563#3:416\n1634#3,3:417\n*S KotlinDebug\n*F\n+ 1 VsixManager.kt\ncom/sina/weibo/agent/extensions/core/VsixManager\n*L\n137#1:413\n137#1:414,2\n351#1:420,2\n138#1:416\n138#1:417,3\n*E\n"})
public final class VsixManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public final boolean installVsix(@NotNull File vsixFile, @NotNull String extensionId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)vsixFile, (String)"vsixFile");
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            String targetDir = this.getExtensionDirectory(extensionId);
            LOG.info("Installing VSIX for extension " + extensionId + " to " + targetDir);
            boolean existingInstallation = this.hasVsixInstallation(extensionId);
            if (existingInstallation) {
                LOG.info("Extension " + extensionId + " already exists, will overwrite existing installation");
            }
            Path targetPath = Paths.get(targetDir, new String[0]);
            Files.createDirectories(targetPath, new FileAttribute[0]);
            boolean success = this.extractVsixFile(vsixFile, targetDir);
            if (success) {
                if (existingInstallation) {
                    LOG.info("VSIX installation updated successfully for extension " + extensionId);
                } else {
                    LOG.info("VSIX installation completed successfully for extension " + extensionId);
                }
            } else {
                LOG.info("VSIX extraction failed for extension " + extensionId);
            }
            bl = success;
        }
        catch (Exception e) {
            LOG.info("Failed to install VSIX for extension " + extensionId, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String getExtensionDirectory(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        return Companion.getBaseDirectory() + "/" + extensionId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasVsixInstallation(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        String extensionDir = this.getExtensionDirectory(extensionId);
        File dir = new File(extensionDir);
        if (!dir.exists()) return false;
        if (!dir.isDirectory()) return false;
        File[] fileArray = dir.listFiles();
        if (fileArray == null) return false;
        if (fileArray.length != 0) return true;
        return false;
    }

    @Nullable
    public final String getVsixInstallationPath(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        return this.hasVsixInstallation(extensionId) ? this.getExtensionDirectory(extensionId) : null;
    }

    public final boolean uninstallVsix(@NotNull String extensionId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        try {
            boolean bl2;
            String extensionDir = this.getExtensionDirectory(extensionId);
            File dir = new File(extensionDir);
            if (dir.exists()) {
                this.deleteDirectory(dir);
                LOG.info("VSIX uninstalled for extension " + extensionId);
                bl2 = true;
            } else {
                LOG.info("No VSIX installation found for extension " + extensionId);
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LOG.info("Failed to uninstall VSIX for extension " + extensionId, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> listInstalledExtensions() {
        block6: {
            block5: {
                baseDir = new File(VsixManager.Companion.getBaseDirectory());
                if (!baseDir.exists() || !baseDir.isDirectory()) {
                    return CollectionsKt.emptyList();
                }
                var2_2 = baseDir.listFiles();
                if (var2_2 == null) break block5;
                $this$filter$iv = var2_2;
                $i$f$filter = false;
                var5_6 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    it = element$iv$iv;
                    $i$a$-filter-VsixManager$listInstalledExtensions$1 = false;
                    if (!it.isDirectory()) ** GOTO lbl-1000
                    v0 = it.listFiles();
                    v1 = v0 != null ? v0.length == 0 == false : false;
                    if (v1) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $i$f$filter = (List)destination$iv$iv;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (File)item$iv$iv;
                    var13_17 = destination$iv$iv;
                    $i$a$-map-VsixManager$listInstalledExtensions$2 = false;
                    var13_17.add(it.getName());
                }
                v3 = (List)destination$iv$iv;
                break block6;
            }
            v3 = CollectionsKt.emptyList();
        }
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean extractVsixFile(File vsixFile, String targetDir) {
        Object temp;
        File tempDir;
        block34: {
            Object[] extensionFiles;
            Path targetPath;
            block33: {
                File extensionDir;
                boolean bl2222222;
                block32: {
                    tempDir = null;
                    tempDir = Files.createTempDirectory("vsix-extract-", new FileAttribute[0]).toFile();
                    LOG.debug("Created temporary directory: " + tempDir.getAbsolutePath());
                    Closeable closeable = new ZipInputStream(new BufferedInputStream(new FileInputStream(vsixFile)));
                    Throwable throwable = null;
                    try {
                        ZipInputStream zis = (ZipInputStream)closeable;
                        bl2222222 = false;
                        ZipEntry entry = zis.getNextEntry();
                        int extractedCount = 0;
                        while (entry != null) {
                            if (!entry.isDirectory()) {
                                File file = tempDir;
                                Intrinsics.checkNotNull((Object)file);
                                Path entryPath = file.toPath().resolve(entry.getName());
                                Path parentDir = entryPath.getParent();
                                if (parentDir != null) {
                                    Files.createDirectories(parentDir, new FileAttribute[0]);
                                }
                                Files.copy(zis, entryPath, new CopyOption[0]);
                                ++extractedCount;
                            }
                            entry = zis.getNextEntry();
                        }
                        LOG.debug("Extracted " + extractedCount + " files to temporary directory");
                        zis = Unit.INSTANCE;
                    }
                    catch (Throwable bl2222222) {
                        throwable = bl2222222;
                        throw bl2222222;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    extensionDir = new File(tempDir, "extension");
                    if (extensionDir.exists() && extensionDir.isDirectory()) break block32;
                    LOG.info("Extension directory not found in VSIX file");
                    boolean bl3 = false;
                    File file = tempDir;
                    if (file == null) return bl3;
                    temp = file;
                    boolean bl4 = false;
                    try {
                        this.deleteDirectory((File)temp);
                        LOG.debug("Cleaned up temporary directory: " + ((File)temp).getAbsolutePath());
                        return bl3;
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to clean up temporary directory", (Throwable)e);
                    }
                    return bl3;
                }
                targetPath = Paths.get(targetDir, new String[0]);
                if (Files.exists(targetPath, new LinkOption[0])) {
                    File file = targetPath.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    this.deleteDirectory(file);
                }
                Files.createDirectories(targetPath, new FileAttribute[0]);
                extensionFiles = extensionDir.listFiles();
                if (extensionFiles != null && !(extensionFiles.length == 0)) break block33;
                LOG.warn("Extension directory is empty");
                bl2222222 = false;
                File file = tempDir;
                if (file == null) return bl2222222;
                File temp2 = file;
                boolean bl5 = false;
                try {
                    this.deleteDirectory(temp2);
                    LOG.debug("Cleaned up temporary directory: " + temp2.getAbsolutePath());
                    return bl2222222;
                }
                catch (Exception e) {
                    LOG.warn("Failed to clean up temporary directory", (Throwable)e);
                }
                return bl2222222;
            }
            int movedCount = 0;
            temp = ArrayIteratorKt.iterator((Object[])extensionFiles);
            while (temp.hasNext()) {
                File file = (File)temp.next();
                File targetFile = targetPath.resolve(file.getName()).toFile();
                if (file.isDirectory()) {
                    Intrinsics.checkNotNull((Object)file);
                    Intrinsics.checkNotNull((Object)targetFile);
                    this.moveDirectory(file, targetFile);
                } else {
                    Files.move(file.toPath(), targetFile.toPath(), new CopyOption[0]);
                }
                ++movedCount;
            }
            LOG.info("VSIX extraction completed. Moved " + movedCount + " items from extension directory to: " + targetDir);
            this.copyThemesToIntegrations(targetDir);
            File[] targetFiles = targetPath.toFile().listFiles();
            if (targetFiles != null && !(targetFiles.length == 0)) break block34;
            LOG.warn("No files were moved to target directory");
            boolean file = false;
            File file2 = tempDir;
            if (file2 == null) return file;
            File temp3 = file2;
            boolean bl = false;
            try {
                this.deleteDirectory(temp3);
                LOG.debug("Cleaned up temporary directory: " + temp3.getAbsolutePath());
                return file;
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up temporary directory", (Throwable)e);
            }
            return file;
        }
        boolean bl = true;
        File file = tempDir;
        if (file == null) return bl;
        File temp4 = file;
        boolean bl6 = false;
        try {
            this.deleteDirectory(temp4);
            LOG.debug("Cleaned up temporary directory: " + temp4.getAbsolutePath());
            return bl;
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up temporary directory", (Throwable)e);
        }
        return bl;
        catch (Exception e) {
            File file3;
            try {
                LOG.info("Failed to extract VSIX file", (Throwable)e);
                bl = false;
                file3 = tempDir;
            }
            catch (Throwable throwable) {
                File file4 = tempDir;
                if (file4 == null) throw throwable;
                temp = file4;
                bl4 = false;
                try {
                    this.deleteDirectory((File)temp);
                    LOG.debug("Cleaned up temporary directory: " + ((File)temp).getAbsolutePath());
                    throw throwable;
                }
                catch (Exception e2) {
                    LOG.warn("Failed to clean up temporary directory", (Throwable)e2);
                }
                throw throwable;
            }
            if (file3 == null) return bl;
            temp2 = file3;
            bl2 = false;
            try {
                this.deleteDirectory(temp2);
                LOG.debug("Cleaned up temporary directory: " + temp2.getAbsolutePath());
                return bl;
            }
            catch (Exception e3) {
                LOG.warn("Failed to clean up temporary directory", (Throwable)e3);
            }
            return bl;
        }
    }

    private final void moveDirectory(File source, File target) {
        Object[] sourceFiles;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((sourceFiles = source.listFiles()) != null) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])sourceFiles);
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                File targetFile = new File(target, file.getName());
                if (file.isDirectory()) {
                    Intrinsics.checkNotNull((Object)file);
                    this.moveDirectory(file, targetFile);
                    continue;
                }
                Files.move(file.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
        }
        source.delete();
    }

    private final void copyThemesToIntegrations(String extensionDir) {
        try {
            File pluginThemesDir = this.getPluginThemesDirectory();
            if (pluginThemesDir == null) {
                LOG.warn("Plugin themes directory not found, skipping themes copy");
                return;
            }
            Path integrationsThemeDir = ThemeManager.Companion.getThemeResourceDir(extensionDir);
            if (integrationsThemeDir == null) {
                integrationsThemeDir = ThemeManager.Companion.getDefaultThemeResourceDir(extensionDir);
                LOG.warn("Plugin themes directory not found, mkdir");
            }
            Files.createDirectories(integrationsThemeDir, new FileAttribute[0]);
            Object[] themeFiles = pluginThemesDir.listFiles(VsixManager::copyThemesToIntegrations$lambda$4);
            if (themeFiles != null) {
                int copiedCount = 0;
                Iterator iterator = ArrayIteratorKt.iterator((Object[])themeFiles);
                while (iterator.hasNext()) {
                    File themeFile = (File)iterator.next();
                    File targetFile = integrationsThemeDir.resolve(themeFile.getName()).toFile();
                    Files.copy(themeFile.toPath(), targetFile.toPath(), new CopyOption[0]);
                    ++copiedCount;
                    LOG.debug("Copied theme file: " + themeFile.getName() + " to integrations directory");
                }
                LOG.info("Copied " + copiedCount + " theme files to integrations/theme/default-themes");
            } else {
                LOG.warn("No theme files found in plugin themes directory");
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to copy themes to integrations directory", (Throwable)e);
        }
    }

    private final File getPluginThemesDirectory() {
        Object var1_1;
        try {
            File currentDir;
            File themesDir;
            File themesDir2;
            String pluginThemesPath = PluginResourceUtil.INSTANCE.getResourcePath("com.gitlab.coderider-kilo", "themes");
            if (pluginThemesPath != null && (themesDir2 = new File(pluginThemesPath)).exists() && themesDir2.isDirectory()) {
                return themesDir2;
            }
            String string = System.getProperty("user.dir");
            if (string == null) {
                string = "";
            }
            if ((themesDir = new File(currentDir = new File(string), "src/main/resources/themes")).exists() && themesDir.isDirectory()) {
                return themesDir;
            }
            LOG.warn("Plugin themes directory not found");
            var1_1 = null;
        }
        catch (Exception e) {
            LOG.warn("Failed to get plugin themes directory", (Throwable)e);
            var1_1 = null;
        }
        return var1_1;
    }

    private final void deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)file);
                    this.deleteDirectory(file);
                }
            }
        }
        dir.delete();
    }

    @Nullable
    public final String getExtensionResourcePath(@NotNull String extensionId, @NotNull String codeDir, @Nullable String projectPath) {
        String vsixPath;
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Intrinsics.checkNotNullParameter((Object)codeDir, (String)"codeDir");
        if (projectPath != null) {
            String[] stringArray = new String[]{projectPath + "/" + codeDir, projectPath + "/../" + codeDir, projectPath + "/../../" + codeDir};
            List possiblePaths = CollectionsKt.listOf((Object[])stringArray);
            for (String path : possiblePaths) {
                if (!new File(path).exists()) continue;
                LOG.debug("Found extension resources in project path: " + path);
                return path;
            }
        }
        if ((vsixPath = this.getVsixInstallationPath(extensionId)) != null && new File(vsixPath).exists()) {
            LOG.debug("Found extension resources in VSIX installation: " + vsixPath);
            return vsixPath;
        }
        try {
            String pluginPath = PluginResourceUtil.INSTANCE.getResourcePath("com.gitlab.coderider-kilo", codeDir);
            if (pluginPath != null && new File(pluginPath).exists()) {
                LOG.debug("Found extension resources in plugin: " + pluginPath);
                return pluginPath;
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to get plugin resource path for extension: " + extensionId, (Throwable)e);
        }
        LOG.debug("No extension resources found for extension: " + extensionId);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean copyThemesToIntegrations$lambda$4(File file) {
        String string;
        if (!file.isFile()) return false;
        Intrinsics.checkNotNull((Object)file);
        String string2 = FilesKt.getExtension((File)file);
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"css")) return false;
        return true;
    }

    static {
        Logger logger = Logger.getInstance(VsixManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/sina/weibo/agent/extensions/core/VsixManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/sina/weibo/agent/extensions/core/VsixManager;", "getBaseDirectory", "", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VsixManager getInstance() {
            return new VsixManager();
        }

        @NotNull
        public final String getBaseDirectory() {
            return PluginConstants.ConfigFiles.INSTANCE.getUserConfigDir() + "/plugins";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

