/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.sina.weibo.agent.model.StaticWorkspaceData;
import com.sina.weibo.agent.model.WorkspaceData;
import com.sina.weibo.agent.model.WorkspaceFolder;
import com.sina.weibo.agent.util.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/sina/weibo/agent/core/WorkspaceManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCurrentWorkspaceData", "Lcom/sina/weibo/agent/model/WorkspaceData;", "getProjectWorkspaceData", "getWorkspaceId", "", "getWorkspaceFolders", "", "Lcom/sina/weibo/agent/model/WorkspaceFolder;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nWorkspaceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceManager.kt\ncom/sina/weibo/agent/core/WorkspaceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class WorkspaceManager {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public WorkspaceManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(WorkspaceManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final WorkspaceData getCurrentWorkspaceData() {
        return this.getProjectWorkspaceData(this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final WorkspaceData getProjectWorkspaceData(@NotNull Project project) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String workspaceId = this.getWorkspaceId(project);
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String workspaceName = string;
        String string2 = workspaceId;
        String string3 = workspaceName;
        Boolean bl = false;
        String string4 = project.getBasePath();
        if (string4 != null) {
            void it;
            String string5 = string4;
            Boolean bl2 = bl;
            String string6 = string3;
            String string7 = string2;
            boolean bl3 = false;
            URI uRI2 = URI.Companion.file((String)it + "/.idea");
            string2 = string7;
            string3 = string6;
            bl = bl2;
            uRI = uRI2;
        } else {
            uRI = null;
        }
        Boolean bl4 = false;
        URI uRI3 = uRI;
        Boolean bl5 = bl;
        String string8 = string3;
        String string9 = string2;
        StaticWorkspaceData staticWorkspaceData = new StaticWorkspaceData(string9, string8, bl5, uRI3, bl4);
        List<WorkspaceFolder> workspaceFolders = this.getWorkspaceFolders(project);
        return new WorkspaceData(staticWorkspaceData, workspaceFolders);
    }

    private final String getWorkspaceId(Project project) {
        String string = project.getBasePath();
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        String basePath = string;
        return String.valueOf(basePath.hashCode());
    }

    private final List<WorkspaceFolder> getWorkspaceFolders(Project project) {
        List folders = new ArrayList();
        String string = project.getBasePath();
        if (string == null) {
            return folders;
        }
        String basePath = string;
        URI uRI = URI.Companion.file(basePath);
        String string2 = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        folders.add(new WorkspaceFolder(uRI, string2, 0));
        VirtualFile projectDir = (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> WorkspaceManager.getWorkspaceFolders$lambda$1(basePath));
        if (projectDir == null || !projectDir.isDirectory()) {
            return folders;
        }
        return folders;
    }

    private static final VirtualFile getWorkspaceFolders$lambda$1(String $basePath) {
        return LocalFileSystem.getInstance().findFileByPath($basePath);
    }
}

