/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.actors.MainThreadBulkEdits;
import com.sina.weibo.agent.actors.MainThreadClipboard;
import com.sina.weibo.agent.actors.MainThreadCommands;
import com.sina.weibo.agent.actors.MainThreadConfiguration;
import com.sina.weibo.agent.actors.MainThreadConsole;
import com.sina.weibo.agent.actors.MainThreadDebugService;
import com.sina.weibo.agent.actors.MainThreadDiaglogs;
import com.sina.weibo.agent.actors.MainThreadDocumentContentProviders;
import com.sina.weibo.agent.actors.MainThreadDocuments;
import com.sina.weibo.agent.actors.MainThreadEditorTabs;
import com.sina.weibo.agent.actors.MainThreadErrors;
import com.sina.weibo.agent.actors.MainThreadExtensionService;
import com.sina.weibo.agent.actors.MainThreadFileSystem;
import com.sina.weibo.agent.actors.MainThreadFileSystemEventService;
import com.sina.weibo.agent.actors.MainThreadLanguageFeatures;
import com.sina.weibo.agent.actors.MainThreadLanguageModelTools;
import com.sina.weibo.agent.actors.MainThreadLogger;
import com.sina.weibo.agent.actors.MainThreadMessageService;
import com.sina.weibo.agent.actors.MainThreadOutputService;
import com.sina.weibo.agent.actors.MainThreadSearch;
import com.sina.weibo.agent.actors.MainThreadSecretState;
import com.sina.weibo.agent.actors.MainThreadStatusBar;
import com.sina.weibo.agent.actors.MainThreadStorage;
import com.sina.weibo.agent.actors.MainThreadTask;
import com.sina.weibo.agent.actors.MainThreadTelemetry;
import com.sina.weibo.agent.actors.MainThreadTerminalService;
import com.sina.weibo.agent.actors.MainThreadTerminalShellIntegration;
import com.sina.weibo.agent.actors.MainThreadTextEditors;
import com.sina.weibo.agent.actors.MainThreadUrls;
import com.sina.weibo.agent.actors.MainThreadWebviewViews;
import com.sina.weibo.agent.actors.MainThreadWebviews;
import com.sina.weibo.agent.actors.MainThreadWindow;
import com.sina.weibo.agent.core.ExtensionManager;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.core.WorkspaceManager;
import com.sina.weibo.agent.ipc.IMessagePassingProtocol;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.RPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostConfigurationProxy;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostWorkspaceProxy;
import com.sina.weibo.agent.ipc.proxy.logger.FileRPCProtocolLogger;
import com.sina.weibo.agent.ipc.proxy.uri.IURITransformer;
import com.sina.weibo.agent.model.WorkspaceData;
import com.sina.weibo.agent.theme.ThemeManager;
import com.sina.weibo.agent.util.ProxyConfigUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0006\u0010\u0019\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/sina/weibo/agent/core/RPCManager;", "", "protocol", "Lcom/sina/weibo/agent/ipc/IMessagePassingProtocol;", "extensionManager", "Lcom/sina/weibo/agent/core/ExtensionManager;", "uriTransformer", "Lcom/sina/weibo/agent/ipc/proxy/uri/IURITransformer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/sina/weibo/agent/ipc/IMessagePassingProtocol;Lcom/sina/weibo/agent/core/ExtensionManager;Lcom/sina/weibo/agent/ipc/proxy/uri/IURITransformer;Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "rpcProtocol", "Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;", "startInitialize", "", "setupDefaultProtocols", "setupExtensionRequiredProtocols", "setupWeCodeRequiredProtocols", "setupRooCodeFuncitonProtocols", "setupKiloCodeFunctionProtocols", "setupWebviewProtocols", "getRPCProtocol", "coderider-kilo-jetbrains"})
public final class RPCManager {
    @NotNull
    private final IMessagePassingProtocol protocol;
    @NotNull
    private final ExtensionManager extensionManager;
    @Nullable
    private final IURITransformer uriTransformer;
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final IRPCProtocol rpcProtocol;

    public RPCManager(@NotNull IMessagePassingProtocol protocol, @NotNull ExtensionManager extensionManager, @Nullable IURITransformer uriTransformer, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)extensionManager, (String)"extensionManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.protocol = protocol;
        this.extensionManager = extensionManager;
        this.uriTransformer = uriTransformer;
        this.project = project;
        Logger logger = Logger.getInstance(RPCManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.rpcProtocol = new RPCProtocol(this.protocol, new FileRPCProtocolLogger(), this.uriTransformer);
        this.setupDefaultProtocols();
        this.setupExtensionRequiredProtocols();
        this.setupWeCodeRequiredProtocols();
        this.setupRooCodeFuncitonProtocols();
        this.setupKiloCodeFunctionProtocols();
        this.setupWebviewProtocols();
    }

    public /* synthetic */ RPCManager(IMessagePassingProtocol iMessagePassingProtocol, ExtensionManager extensionManager, IURITransformer iURITransformer, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            iURITransformer = null;
        }
        this(iMessagePassingProtocol, extensionManager, iURITransformer, project);
    }

    public final void startInitialize() {
        try {
            this.logger.info("Starting to initialize plugin environment");
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ RPCManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object it;
                            Pair[] pairArray;
                            ResultKt.throwOnFailure((Object)object);
                            ExtHostConfigurationProxy extHostConfiguration = RPCManager.access$getRpcProtocol$p(this.this$0).getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostConfiguration());
                            RPCManager.access$getLogger$p(this.this$0).info("Sending configuration information to extension process");
                            String themeName = ThemeManager.Companion.getInstance().isDarkThemeForce() ? "Visual Studio 2017 Dark - C++" : "Visual Studio 2017 Light - C++";
                            Map<String, Object> httpProxyConfig = ProxyConfigUtil.INSTANCE.getHttpProxyConfigForInitialization();
                            Object object2 = new Pair[]{TuplesKt.to((Object)"workbench.colorTheme", (Object)themeName)};
                            Map contentsBuilder = MapsKt.mutableMapOf((Pair[])object2);
                            Map<String, Object> map = httpProxyConfig;
                            if (map != null) {
                                object2 = map;
                                pairArray = this.this$0;
                                it = object2;
                                boolean bl = false;
                                contentsBuilder.put("http", it);
                                RPCManager.access$getLogger$p((RPCManager)pairArray).info("Using proxy configuration for initialization: " + (Map)it);
                            }
                            pairArray = new Pair[]{TuplesKt.to((Object)"contents", (Object)MapsKt.emptyMap()), TuplesKt.to((Object)"keys", (Object)CollectionsKt.emptyList()), TuplesKt.to((Object)"overrides", (Object)CollectionsKt.emptyList())};
                            Map emptyMap = MapsKt.mapOf((Pair[])pairArray);
                            it = new Pair[8];
                            Pair[] bl = new Pair[]{TuplesKt.to((Object)"contents", (Object)contentsBuilder), TuplesKt.to((Object)"keys", (Object)CollectionsKt.emptyList()), TuplesKt.to((Object)"overrides", (Object)CollectionsKt.emptyList())};
                            it[0] = TuplesKt.to((Object)"defaults", (Object)MapsKt.mapOf((Pair[])bl));
                            it[1] = TuplesKt.to((Object)"policy", (Object)emptyMap);
                            it[2] = TuplesKt.to((Object)"application", (Object)emptyMap);
                            it[3] = TuplesKt.to((Object)"userLocal", (Object)emptyMap);
                            it[4] = TuplesKt.to((Object)"userRemote", (Object)emptyMap);
                            it[5] = TuplesKt.to((Object)"workspace", (Object)emptyMap);
                            it[6] = TuplesKt.to((Object)"folders", (Object)CollectionsKt.emptyList());
                            it[7] = TuplesKt.to((Object)"configurationScopes", (Object)CollectionsKt.emptyList());
                            Map emptyConfigModel = MapsKt.mapOf((Pair[])it);
                            extHostConfiguration.initializeConfiguration(emptyConfigModel);
                            ExtHostWorkspaceProxy extHostWorkspace = RPCManager.access$getRpcProtocol$p(this.this$0).getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostWorkspace());
                            RPCManager.access$getLogger$p(this.this$0).info("Getting current workspace data");
                            WorkspaceData workspaceData = ((WorkspaceManager)RPCManager.access$getProject$p(this.this$0).getService(WorkspaceManager.class)).getCurrentWorkspaceData();
                            if (workspaceData != null) {
                                RPCManager.access$getLogger$p(this.this$0).info("Sending workspace data to extension process: " + workspaceData.getName() + ", folders: " + workspaceData.getFolders().size());
                                extHostWorkspace.initializeWorkspace(workspaceData, true);
                            } else {
                                RPCManager.access$getLogger$p(this.this$0).info("No available workspace data, sending null to extension process");
                                extHostWorkspace.initializeWorkspace(null, true);
                            }
                            RPCManager.access$getLogger$p(this.this$0).info("Workspace initialization completed");
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize plugin environment: " + e.getMessage(), (Throwable)e);
        }
    }

    private final void setupDefaultProtocols() {
        this.logger.info("Setting up default protocol handlers");
        PluginContext.Companion.getInstance(this.project).setRPCProtocol(this.rpcProtocol);
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadErrors(), new MainThreadErrors());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadConsole(), new MainThreadConsole());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadLogger(), new MainThreadLogger());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadCommands(), new MainThreadCommands(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadDebugService(), new MainThreadDebugService());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadConfiguration(), new MainThreadConfiguration());
    }

    private final void setupExtensionRequiredProtocols() {
        this.logger.info("Setting up required protocol handlers for plugins");
        MainThreadExtensionService mainThreadExtensionService = new MainThreadExtensionService(this.extensionManager, this.rpcProtocol);
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadExtensionService(), mainThreadExtensionService);
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadTelemetry(), new MainThreadTelemetry());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadTerminalShellIntegration(), new MainThreadTerminalShellIntegration(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadTerminalService(), new MainThreadTerminalService(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadTask(), new MainThreadTask());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadSearch(), new MainThreadSearch());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadWindow(), new MainThreadWindow(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadDialogs(), new MainThreadDiaglogs());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadLanguageModelTools(), new MainThreadLanguageModelTools());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadClipboard(), new MainThreadClipboard());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadBulkEdits(), new MainThreadBulkEdits(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadEditorTabs(), new MainThreadEditorTabs(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadDocuments(), new MainThreadDocuments(this.project));
    }

    private final void setupWeCodeRequiredProtocols() {
        this.logger.info("Setting up required protocol handlers for WeCode");
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadTextEditors(), new MainThreadTextEditors(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadStorage(), new MainThreadStorage());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadOutputService(), new MainThreadOutputService());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadWebviewViews(), new MainThreadWebviewViews(this.project));
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadDocumentContentProviders(), new MainThreadDocumentContentProviders());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadUrls(), new MainThreadUrls());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadLanguageFeatures(), new MainThreadLanguageFeatures());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadFileSystem(), new MainThreadFileSystem());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadMessageService(), new MainThreadMessageService());
    }

    private final void setupRooCodeFuncitonProtocols() {
        this.logger.info("Setting up protocol handlers required for RooCode specific functionality");
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadFileSystemEventService(), new MainThreadFileSystemEventService());
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadSecretState(), new MainThreadSecretState());
    }

    private final void setupKiloCodeFunctionProtocols() {
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadStatusBar(), new MainThreadStatusBar());
    }

    private final void setupWebviewProtocols() {
        this.logger.info("Setting up protocol handlers required for Webview");
        this.rpcProtocol.set(ServiceProxyRegistry.MainContext.INSTANCE.getMainThreadWebviews(), new MainThreadWebviews(this.project));
    }

    @NotNull
    public final IRPCProtocol getRPCProtocol() {
        return this.rpcProtocol;
    }

    public static final /* synthetic */ IRPCProtocol access$getRpcProtocol$p(RPCManager $this) {
        return $this.rpcProtocol;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RPCManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Project access$getProject$p(RPCManager $this) {
        return $this.project;
    }
}

