/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.core;

import com.google.gson.Gson;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.core.Engines;
import com.sina.weibo.agent.core.ExtensionDescription;
import com.sina.weibo.agent.core.ExtensionIdentifier;
import com.sina.weibo.agent.core.PackageJson;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.extensions.config.ExtensionConfig;
import com.sina.weibo.agent.extensions.config.ExtensionMetadata;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.LazyPromise;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostExtensionServiceProxy;
import com.sina.weibo.agent.util.PromiseUtilsKt;
import com.sina.weibo.agent.util.URI;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000fJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/sina/weibo/agent/core/ExtensionManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "extensions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/sina/weibo/agent/core/ExtensionDescription;", "gson", "Lcom/google/gson/Gson;", "parseExtensionDescription", "extensionPath", "extensionConfig", "Lcom/sina/weibo/agent/extensions/config/ExtensionConfig;", "parseExtensionDescriptionFromNewConfig", "Lcom/sina/weibo/agent/extensions/config/ExtensionMetadata;", "getAllExtensionDescriptions", "", "getExtensionDescription", "extensionId", "registerExtension", "activateExtension", "Ljava/util/concurrent/CompletableFuture;", "", "rpcProtocol", "Lcom/sina/weibo/agent/ipc/proxy/IRPCProtocol;", "dispose", "", "Companion", "coderider-kilo-jetbrains"})
public final class ExtensionManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, ExtensionDescription> extensions = new ConcurrentHashMap();
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    private final ExtensionDescription parseExtensionDescription(String extensionPath, ExtensionConfig extensionConfig) {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string;
        URI uRI;
        List<String> list;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        ExtensionIdentifier extensionIdentifier;
        String string8;
        PackageJson packageJson;
        block9: {
            block8: {
                void it;
                LOG.info("Parsing extension: " + extensionPath);
                String[] stringArray = new String[]{"package.json"};
                String packageJsonPath = ((Object)Paths.get(extensionPath, stringArray)).toString();
                String packageJsonContent = FilesKt.readText$default((File)new File(packageJsonPath), null, (int)1, null);
                packageJson = (PackageJson)this.gson.fromJson(packageJsonContent, PackageJson.class);
                String name = extensionConfig.getPublisher() + "." + packageJson.getName();
                ExtensionIdentifier extensionIdentifier2 = new ExtensionIdentifier(name);
                string8 = name;
                extensionIdentifier = extensionIdentifier2;
                string7 = name;
                string6 = extensionConfig.getDisplayName() + ": " + packageJson.getDisplayName();
                string5 = extensionConfig.getDescription() + ": " + packageJson.getDescription();
                string4 = packageJson.getVersion();
                if (string4 == null) {
                    string4 = extensionConfig.getVersion();
                }
                string3 = extensionConfig.getPublisher();
                string2 = packageJson.getMain();
                if (string2 == null) {
                    string2 = extensionConfig.getMainFile();
                }
                if ((list = packageJson.getActivationEvents()) == null) {
                    list = extensionConfig.getActivationEvents();
                }
                uRI = URI.Companion.file(extensionPath);
                string = "universal";
                bl3 = false;
                bl2 = false;
                bl = false;
                object = packageJson.getEngines();
                if (object == null) break block8;
                Engines engines = object;
                boolean bl4 = bl;
                boolean bl5 = bl2;
                boolean bl6 = bl3;
                String string9 = string;
                URI uRI2 = uRI;
                List<String> list2 = list;
                String string10 = string2;
                String string11 = string3;
                String string12 = string4;
                String string13 = string5;
                String string14 = string6;
                String string15 = string7;
                ExtensionIdentifier extensionIdentifier3 = extensionIdentifier;
                String string16 = string8;
                boolean bl7 = false;
                String string17 = it.getVscode();
                if (string17 == null) {
                    string17 = "^1.0.0";
                }
                Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"vscode", (Object)string17));
                string8 = string16;
                extensionIdentifier = extensionIdentifier3;
                string7 = string15;
                string6 = string14;
                string5 = string13;
                string4 = string12;
                string3 = string11;
                string2 = string10;
                list = list2;
                uRI = uRI2;
                string = string9;
                bl3 = bl6;
                bl2 = bl5;
                bl = bl4;
                Map map2 = map;
                object = map2;
                if (map2 != null) break block9;
            }
            object = extensionConfig.getEngines();
        }
        Map<String, Object> map = extensionConfig.getCapabilities();
        List<String> list3 = packageJson.getExtensionDependencies();
        if (list3 == null) {
            list3 = extensionConfig.getExtensionDependencies();
        }
        List<String> list4 = list3;
        Map<String, Object> map3 = map;
        boolean bl8 = false;
        Object object2 = object;
        boolean bl9 = bl;
        boolean bl10 = bl2;
        boolean bl11 = bl3;
        String string18 = string;
        URI uRI3 = uRI;
        List<String> list5 = list;
        String string19 = string2;
        String string20 = string3;
        String string21 = string4;
        String string22 = string5;
        String string23 = string6;
        String string24 = string7;
        ExtensionIdentifier extensionIdentifier4 = extensionIdentifier;
        String string25 = string8;
        return new ExtensionDescription(string25, extensionIdentifier4, string24, string23, string22, string21, string20, string19, list5, uRI3, string18, bl11, bl10, bl9, (Map<String, String>)object2, bl8, map3, list4);
    }

    /*
     * WARNING - void declaration
     */
    private final ExtensionDescription parseExtensionDescriptionFromNewConfig(String extensionPath, ExtensionMetadata extensionConfig) {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string;
        URI uRI;
        List<String> list;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        ExtensionIdentifier extensionIdentifier;
        String string8;
        PackageJson packageJson;
        block9: {
            block8: {
                void it;
                LOG.info("Parsing extension: " + extensionPath);
                String[] stringArray = new String[]{"package.json"};
                String packageJsonPath = ((Object)Paths.get(extensionPath, stringArray)).toString();
                String packageJsonContent = FilesKt.readText$default((File)new File(packageJsonPath), null, (int)1, null);
                packageJson = (PackageJson)this.gson.fromJson(packageJsonContent, PackageJson.class);
                String name = extensionConfig.getPublisher() + "." + packageJson.getName();
                ExtensionIdentifier extensionIdentifier2 = new ExtensionIdentifier(name);
                string8 = name;
                extensionIdentifier = extensionIdentifier2;
                string7 = name;
                string6 = extensionConfig.getCodeDir() + ": " + packageJson.getDisplayName();
                string5 = extensionConfig.getCodeDir() + ": " + packageJson.getDescription();
                string4 = packageJson.getVersion();
                if (string4 == null) {
                    string4 = extensionConfig.getVersion();
                }
                string3 = extensionConfig.getPublisher();
                string2 = packageJson.getMain();
                if (string2 == null) {
                    string2 = extensionConfig.getMainFile();
                }
                if ((list = packageJson.getActivationEvents()) == null) {
                    list = extensionConfig.getActivationEvents();
                }
                uRI = URI.Companion.file(extensionPath);
                string = "universal";
                bl3 = false;
                bl2 = false;
                bl = false;
                object = packageJson.getEngines();
                if (object == null) break block8;
                Engines engines = object;
                boolean bl4 = bl;
                boolean bl5 = bl2;
                boolean bl6 = bl3;
                String string9 = string;
                URI uRI2 = uRI;
                List<String> list2 = list;
                String string10 = string2;
                String string11 = string3;
                String string12 = string4;
                String string13 = string5;
                String string14 = string6;
                String string15 = string7;
                ExtensionIdentifier extensionIdentifier3 = extensionIdentifier;
                String string16 = string8;
                boolean bl7 = false;
                String string17 = it.getVscode();
                if (string17 == null) {
                    string17 = "^1.0.0";
                }
                Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"vscode", (Object)string17));
                string8 = string16;
                extensionIdentifier = extensionIdentifier3;
                string7 = string15;
                string6 = string14;
                string5 = string13;
                string4 = string12;
                string3 = string11;
                string2 = string10;
                list = list2;
                uRI = uRI2;
                string = string9;
                bl3 = bl6;
                bl2 = bl5;
                bl = bl4;
                Map map2 = map;
                object = map2;
                if (map2 != null) break block9;
            }
            object = extensionConfig.getEngines();
        }
        Map<String, Object> map = extensionConfig.getCapabilities();
        List<String> list3 = packageJson.getExtensionDependencies();
        if (list3 == null) {
            list3 = extensionConfig.getExtensionDependencies();
        }
        List<String> list4 = list3;
        Map<String, Object> map3 = map;
        boolean bl8 = false;
        Object object2 = object;
        boolean bl9 = bl;
        boolean bl10 = bl2;
        boolean bl11 = bl3;
        String string18 = string;
        URI uRI3 = uRI;
        List<String> list5 = list;
        String string19 = string2;
        String string20 = string3;
        String string21 = string4;
        String string22 = string5;
        String string23 = string6;
        String string24 = string7;
        ExtensionIdentifier extensionIdentifier4 = extensionIdentifier;
        String string25 = string8;
        return new ExtensionDescription(string25, extensionIdentifier4, string24, string23, string22, string21, string20, string19, list5, uRI3, string18, bl11, bl10, bl9, (Map<String, String>)object2, bl8, map3, list4);
    }

    @NotNull
    public final List<ExtensionDescription> getAllExtensionDescriptions() {
        Collection<ExtensionDescription> collection = this.extensions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Nullable
    public final ExtensionDescription getExtensionDescription(@NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        return this.extensions.get(extensionId);
    }

    @NotNull
    public final ExtensionDescription registerExtension(@NotNull String extensionPath, @NotNull ExtensionConfig extensionConfig) {
        Intrinsics.checkNotNullParameter((Object)extensionPath, (String)"extensionPath");
        Intrinsics.checkNotNullParameter((Object)extensionConfig, (String)"extensionConfig");
        ExtensionDescription extensionDescription = this.parseExtensionDescription(extensionPath, extensionConfig);
        ((Map)this.extensions).put(extensionDescription.getName(), extensionDescription);
        LOG.info("Extension registered: " + extensionDescription.getName());
        return extensionDescription;
    }

    @NotNull
    public final ExtensionDescription registerExtension(@NotNull String extensionPath, @NotNull ExtensionMetadata extensionConfig) {
        Intrinsics.checkNotNullParameter((Object)extensionPath, (String)"extensionPath");
        Intrinsics.checkNotNullParameter((Object)extensionConfig, (String)"extensionConfig");
        ExtensionDescription extensionDescription = this.parseExtensionDescriptionFromNewConfig(extensionPath, extensionConfig);
        ((Map)this.extensions).put(extensionDescription.getName(), extensionDescription);
        LOG.info("Extension registered: " + extensionDescription.getName());
        return extensionDescription;
    }

    @NotNull
    public final CompletableFuture<Boolean> activateExtension(@NotNull String extensionId, @NotNull IRPCProtocol rpcProtocol) {
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Intrinsics.checkNotNullParameter((Object)rpcProtocol, (String)"rpcProtocol");
        LOG.info("Activating extension: " + extensionId);
        try {
            ExtensionDescription extension = this.extensions.get(extensionId);
            if (extension == null) {
                LOG.info("Extension not found: " + extensionId);
                CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
                future.completeExceptionally(new IllegalArgumentException("Extension not found: " + extensionId));
                return future;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"startup", (Object)true), TuplesKt.to((Object)"extensionId", (Object)extension.getIdentifier()), TuplesKt.to((Object)"activationEvent", (Object)"api")};
            Map activationParams = MapsKt.mapOf((Pair[])pairArray);
            ExtHostExtensionServiceProxy extHostService = rpcProtocol.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostExtensionService());
            try {
                LazyPromise lazyPromise = extHostService.activate(extension.getIdentifier().getValue(), activationParams);
                CompletionStage completionStage = ((CompletableFuture)PromiseUtilsKt.toCompletableFuture(lazyPromise).thenApply(arg_0 -> ExtensionManager.activateExtension$lambda$2(extensionId, arg_0))).exceptionally(arg_0 -> ExtensionManager.activateExtension$lambda$3(extensionId, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"exceptionally(...)");
                return completionStage;
            }
            catch (Exception e) {
                LOG.info("Failed to call activate method: " + extensionId, (Throwable)e);
                CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
                future.completeExceptionally(e);
                return future;
            }
        }
        catch (Exception e) {
            LOG.info("Failed to activate extension: " + extensionId, (Throwable)e);
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public void dispose() {
        LOG.info("Releasing ExtensionManager resources");
        this.extensions.clear();
    }

    private static final Boolean activateExtension$lambda$2(String $extensionId, Object result2) {
        boolean boolResult = result2 instanceof Boolean ? (Boolean)result2 : false;
        LOG.info("Extension activation " + (boolResult ? "successful" : "failed") + ": " + $extensionId);
        return boolResult;
    }

    private static final Boolean activateExtension$lambda$3(String $extensionId, Throwable throwable) {
        LOG.info("Failed to activate extension: " + $extensionId, throwable);
        return false;
    }

    static {
        Logger logger = Logger.getInstance(ExtensionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/sina/weibo/agent/core/ExtensionManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

