/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.sina.weibo.agent.actors.MainThreadWindowShape;
import java.awt.Desktop;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016J>\u0010\u000f\u001a\u00020\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00110\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0016JB\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00110\f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00110\f2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0016J \u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002J(\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\r2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadWindow;", "Lcom/sina/weibo/agent/actors/MainThreadWindowShape;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInitialState", "", "", "", "openUri", "uri", "", "uriString", "options", "asExternalUri", "createUriFromComponents", "Ljava/net/URI;", "components", "dispatcher", "methodName", "args", "", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "", "coderider-kilo-jetbrains"})
public final class MainThreadWindow
implements MainThreadWindowShape {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public MainThreadWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(MainThreadWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Map<String, Boolean> getInitialState() {
        try {
            this.logger.info("Getting window initial state");
            if (this.project != null) {
                JFrame frame;
                JFrame jFrame = frame = WindowManager.getInstance().getFrame(this.project);
                boolean isFocused = jFrame != null ? jFrame.isFocused() : false;
                JFrame jFrame2 = frame;
                boolean isActive = jFrame2 != null ? jFrame2.isActive() : false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"isFocused", (Object)isFocused), TuplesKt.to((Object)"isActive", (Object)isActive)};
                return MapsKt.mapOf((Pair[])pairArray);
            }
            this.logger.warn("Cannot get current project, returning default window state");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"isFocused", (Object)false), TuplesKt.to((Object)"isActive", (Object)false)};
            return MapsKt.mapOf((Pair[])pairArray);
        }
        catch (Exception e) {
            this.logger.error("Failed to get window initial state", (Throwable)e);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"isFocused", (Object)false), TuplesKt.to((Object)"isActive", (Object)false)};
            return MapsKt.mapOf((Pair[])pairArray);
        }
    }

    @Override
    public boolean openUri(@NotNull Map<String, ? extends Object> uri, @Nullable String uriString, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(uri, (String)"uri");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        try {
            boolean bl;
            URI actualUri;
            this.logger.info("Opening URI: " + uriString);
            if (uriString != null) {
                URI uRI;
                try {
                    uRI = new URI(uriString);
                }
                catch (Exception e) {
                    uRI = this.createUriFromComponents(uri);
                }
                v0 = uRI;
            } else {
                v0 = actualUri = this.createUriFromComponents(uri);
            }
            if (actualUri != null) {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(actualUri);
                    bl = true;
                } else {
                    this.logger.warn("System does not support opening URI");
                    bl = false;
                }
            } else {
                this.logger.warn("Cannot create valid URI");
                bl = false;
            }
            return bl;
        }
        catch (Exception e) {
            this.logger.error("Failed to open URI", (Throwable)e);
            return false;
        }
    }

    @Override
    @NotNull
    public Map<String, Object> asExternalUri(@NotNull Map<String, ? extends Object> uri, @NotNull Map<String, ? extends Object> options) {
        Map<String, Object> map;
        Intrinsics.checkNotNullParameter(uri, (String)"uri");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        try {
            this.logger.info("Converting to external URI: " + uri);
            map = uri;
        }
        catch (Exception e) {
            this.logger.error("Failed to convert to external URI", (Throwable)e);
            map = uri;
        }
        return map;
    }

    private final URI createUriFromComponents(Map<String, ? extends Object> components) {
        URI uRI;
        try {
            Object object;
            String string;
            String query;
            Object object2;
            String string2;
            String path;
            Object object3;
            String string3;
            String authority;
            Object object4 = components.get("scheme");
            String string4 = object4 instanceof String ? (String)object4 : null;
            if (string4 == null) {
                return null;
            }
            String scheme = string4;
            Object object5 = components.get("authority");
            String string5 = object5 instanceof String ? (String)object5 : null;
            if (string5 == null) {
                string5 = authority = "";
            }
            if ((string3 = (object3 = components.get("path")) instanceof String ? (String)object3 : null) == null) {
                string3 = path = "";
            }
            if ((string2 = (object2 = components.get("query")) instanceof String ? (String)object2 : null) == null) {
                string2 = query = "";
            }
            if ((string = (object = components.get("fragment")) instanceof String ? (String)object : null) == null) {
                string = "";
            }
            String fragment = string;
            uRI = new URI(scheme, authority, path, query, fragment);
        }
        catch (Exception e) {
            this.logger.warn("Failed to create URI from components: " + components, (Throwable)e);
            uRI = null;
        }
        return uRI;
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        return switch (methodName) {
            case "getInitialState" -> this.getInitialState();
            case "openUri" -> {
                Object[] var6_5 = new Class[]{Map.class, String.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])var6_5), args);
                Object v1 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map uri = (Map)v1;
                String uriString = (String)realArgs.get(1);
                Object v2 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map options = (Map)v2;
                yield Boxing.boxBoolean((boolean)this.openUri(uri, uriString, options));
            }
            case "asExternalUri" -> {
                Object uri = new Class[]{Map.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])uri), args);
                Object v3 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                uri = (Map)v3;
                Object v4 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map options = (Map)v4;
                yield this.asExternalUri((Map<String, ? extends Object>)uri, options);
            }
            default -> null;
        };
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadWindow");
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadWindowShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

