/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.actors.MainThreadWebviewsShape;
import com.sina.weibo.agent.events.WebviewHtmlUpdateData;
import com.sina.weibo.agent.extensions.config.ExtensionProvider;
import com.sina.weibo.agent.extensions.core.ExtensionManager;
import com.sina.weibo.agent.webview.WebViewInstance;
import com.sina.weibo.agent.webview.WebViewManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0014\u001a\u00020\rH\u0016J*\u0010\u0015\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\rj\u0002`\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u0013\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0014\u001a\u00020\rH\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\r2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\rj\u0002`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/sina/weibo/agent/actors/MainThreadWebviews;", "Lcom/sina/weibo/agent/actors/MainThreadWebviewsShape;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "webviews", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/sina/weibo/agent/actors/WebviewHandle;", "", "webviewHandle", "setHtml", "", "handle", "value", "setOptions", "options", "", "postMessage", "", "dispatcher", "methodName", "args", "", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coderider-kilo-jetbrains"})
public final class MainThreadWebviews
implements MainThreadWebviewsShape {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, Object> webviews;
    @NotNull
    private String webviewHandle;

    public MainThreadWebviews(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(MainThreadWebviews.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.webviews = new ConcurrentHashMap();
        this.webviewHandle = "";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void setHtml(@NotNull String handle2, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)handle2, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.logger.info("Setting Webview HTML: handle=" + handle2 + ", length=" + value.length());
        this.webviewHandle = handle2;
        try {
            ExtensionManager extensionManager = ExtensionManager.Companion.getInstance(this.project);
            ExtensionProvider currentProvider = extensionManager.getCurrentProvider();
            Object object = currentProvider;
            if (object == null || (object = object.getConfiguration(this.project)) == null || (object = object.getCodeDir()) == null) {
                object = "unknown-extension";
            }
            Object extensionDir = object;
            CharSequence charSequence = value;
            Regex regex = new Regex("vscode-file:/.*?/" + (String)extensionDir + "/");
            String string = "/";
            String modifiedHtml = regex.replace(charSequence, string);
            this.logger.info("Replaced vscode-file protocol path format");
            WebviewHtmlUpdateData data = new WebviewHtmlUpdateData(handle2, modifiedHtml);
            ((WebViewManager)this.project.getService(WebViewManager.class)).updateWebViewHtml(data);
            this.logger.info("Sent HTML content update event: handle=" + handle2);
        }
        catch (Exception e) {
            this.logger.error("Failed to set Webview HTML", (Throwable)e);
        }
    }

    @Override
    public void setOptions(@NotNull String handle2, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)handle2, (String)"handle");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.logger.info("Setting Webview options: handle=" + handle2 + ", options=" + options);
        this.webviewHandle = handle2;
        try {
        }
        catch (Exception e) {
            this.logger.error("Failed to set Webview options: " + e);
        }
    }

    @Override
    public boolean postMessage(@NotNull String handle2, @NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)handle2, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)"theme", (boolean)false, (int)2, null)) {
            this.logger.debug("Sending theme message to Webview");
        }
        try {
            WebViewManager mangler = (WebViewManager)this.project.getService(WebViewManager.class);
            WebViewInstance webViewInstance = mangler.getLatestWebView();
            if (webViewInstance != null) {
                webViewInstance.postMessageToWebView(value);
            }
            bl = true;
        }
        catch (Exception e) {
            this.logger.error("Failed to send message to Webview: " + e);
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        return switch (methodName) {
            case "setHtml" -> {
                Object[] var6_5 = new Class[]{String.class, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])var6_5), args);
                Object v0 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type kotlin.String");
                String handle = (String)v0;
                Object v1 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.String");
                String value = (String)v1;
                this.setHtml(handle, value);
                yield Unit.INSTANCE;
            }
            case "setOptions" -> {
                Object handle = new Class[]{String.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])handle), args);
                Object v3 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.String");
                handle = (String)v3;
                Object v4 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map options = (Map)v4;
                this.setOptions((String)handle, options);
                yield Unit.INSTANCE;
            }
            case "postMessage" -> {
                Object handle = new Class[]{String.class, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])handle), args);
                Object v5 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type kotlin.String");
                handle = (String)v5;
                Object v6 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type kotlin.String");
                String value = (String)v6;
                yield Boxing.boxBoolean((boolean)this.postMessage((String)handle, value));
            }
            default -> null;
        };
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadWebviews resources");
        this.webviews.clear();
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadWebviewsShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

