/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sina.weibo.agent.actors.MainThreadTerminalServiceShape;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.terminal.TerminalConfig;
import com.sina.weibo.agent.terminal.TerminalInstance;
import com.sina.weibo.agent.terminal.TerminalInstanceManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J'\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J1\u0010%\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100'\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016JF\u0010,\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u001b2\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00122\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0016J\b\u00100\u001a\u00020\u000eH\u0016J\b\u00101\u001a\u00020\u000eH\u0016J\b\u00102\u001a\u00020\u000eH\u0016J\b\u00103\u001a\u00020\u000eH\u0016J\b\u00104\u001a\u00020\u000eH\u0016J\b\u00105\u001a\u00020\u000eH\u0016J\u0018\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0010H\u0016J8\u0010:\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\u0006\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020\u00102\u0016\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u0012H\u0016J&\u0010>\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\u0014\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0016J\u001f\u0010@\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\b\u0010A\u001a\u0004\u0018\u000108H\u0016\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010\u0016\u001a\u00020\u0013J\f\u0010E\u001a\b\u0012\u0004\u0012\u00020D0FJ(\u0010G\u001a\u0004\u0018\u00010\u00132\u0006\u0010H\u001a\u00020\u00102\u000e\u0010I\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130JH\u0096@\u00a2\u0006\u0002\u0010KJ\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadTerminalService;", "Lcom/sina/weibo/agent/actors/MainThreadTerminalServiceShape;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "terminalManager", "Lcom/sina/weibo/agent/terminal/TerminalInstanceManager;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "createTerminal", "", "extHostTerminalId", "", "config", "", "", "(Ljava/lang/String;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "id", "hide", "sendText", "text", "shouldExecute", "", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Boolean;)V", "show", "preserveFocus", "(Ljava/lang/Object;Ljava/lang/Boolean;)V", "registerProcessSupport", "isSupported", "registerProfileProvider", "extensionIdentifier", "unregisterProfileProvider", "registerCompletionProvider", "triggerCharacters", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "unregisterCompletionProvider", "registerQuickFixProvider", "unregisterQuickFixProvider", "setEnvironmentVariableCollection", "persistent", "collection", "descriptionMap", "startSendingDataEvents", "stopSendingDataEvents", "startSendingCommandEvents", "stopSendingCommandEvents", "startLinkProvider", "stopLinkProvider", "sendProcessData", "terminalId", "", "data", "sendProcessReady", "pid", "cwd", "windowsPty", "sendProcessProperty", "property", "sendProcessExit", "exitCode", "(ILjava/lang/Integer;)V", "getTerminalInstance", "Lcom/sina/weibo/agent/terminal/TerminalInstance;", "getAllTerminals", "", "dispatcher", "methodName", "args", "", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadTerminalServiceShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadTerminalServiceShape.kt\ncom/sina/weibo/agent/actors/MainThreadTerminalService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,598:1\n31#2,2:599\n*S KotlinDebug\n*F\n+ 1 MainThreadTerminalServiceShape.kt\ncom/sina/weibo/agent/actors/MainThreadTerminalService\n*L\n195#1:599,2\n*E\n"})
public final class MainThreadTerminalService
implements MainThreadTerminalServiceShape {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TerminalInstanceManager terminalManager;
    @NotNull
    private final CoroutineScope scope;

    public MainThreadTerminalService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(MainThreadTerminalService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<TerminalInstanceManager> serviceClass$iv = TerminalInstanceManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.terminalManager = (TerminalInstanceManager)object;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }

    @Override
    @Nullable
    public Object createTerminal(@NotNull String extHostTerminalId, @NotNull Map<String, ? extends Object> config2, @NotNull Continuation<? super Unit> $completion) {
        this.logger.info("\ud83d\ude80 Creating terminal: " + extHostTerminalId + ", config: " + config2);
        try {
            if (this.terminalManager.containsTerminal(extHostTerminalId)) {
                this.logger.warn("Terminal already exists: " + extHostTerminalId);
                return Unit.INSTANCE;
            }
            PluginContext pluginContext = PluginContext.Companion.getInstance(this.project);
            IRPCProtocol rpcProtocol = pluginContext.getRPCProtocol();
            if (rpcProtocol == null) {
                this.logger.error("\u274c Unable to get RPC protocol instance, terminal creation failed: " + extHostTerminalId);
                throw new IllegalStateException("RPC protocol not initialized");
            }
            this.logger.info("\u2705 Got RPC protocol instance: " + rpcProtocol.getClass().getSimpleName());
            int numericId = this.terminalManager.allocateNumericId();
            this.logger.info("\ud83d\udd22 Allocated terminal numeric ID: " + numericId);
            TerminalConfig terminalConfig = TerminalConfig.Companion.fromMap(config2);
            TerminalInstance terminalInstance = new TerminalInstance(extHostTerminalId, numericId, this.project, terminalConfig, rpcProtocol);
            terminalInstance.initialize();
            this.terminalManager.registerTerminal(extHostTerminalId, terminalInstance);
            this.logger.info("\u2705 Terminal created successfully: " + extHostTerminalId + " (numericId: " + numericId + ")");
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to create terminal: " + extHostTerminalId, (Throwable)e);
            this.terminalManager.unregisterTerminal(extHostTerminalId);
            throw e;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void dispose(@NotNull Object id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            this.logger.info("\ud83e\uddf9 Destroying terminal: " + id);
            TerminalInstance terminalInstance = this.terminalManager.unregisterTerminal(id.toString());
            if (terminalInstance != null) {
                terminalInstance.dispose();
                this.logger.info("\u2705 Terminal destroyed: " + id);
            } else {
                this.logger.warn("Terminal does not exist: " + id);
            }
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to destroy terminal: " + id, (Throwable)e);
        }
    }

    @Override
    public void hide(@NotNull Object id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            this.logger.info("\ud83d\ude48 Hiding terminal: " + id);
            TerminalInstance terminalInstance = this.getTerminalInstance(id);
            if (terminalInstance != null) {
                terminalInstance.hide();
                this.logger.info("\u2705 Terminal hidden: " + id);
            } else {
                this.logger.warn("Terminal does not exist: " + id);
            }
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to hide terminal: " + id, (Throwable)e);
        }
    }

    @Override
    public void sendText(@NotNull Object id, @NotNull String text, @Nullable Boolean shouldExecute) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            this.logger.debug("\ud83d\udce4 Sending text to terminal " + id + ": " + text + " (execute: " + shouldExecute + ")");
            TerminalInstance terminalInstance = this.getTerminalInstance(id);
            if (terminalInstance != null) {
                Boolean bl = shouldExecute;
                terminalInstance.sendText(text, bl != null ? bl : false);
                this.logger.debug("\u2705 Text sent to terminal: " + id);
            } else {
                this.logger.warn("Terminal does not exist: " + id);
            }
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to send text to terminal: " + id, (Throwable)e);
        }
    }

    @Override
    public void show(@NotNull Object id, @Nullable Boolean preserveFocus) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            this.logger.info("\ud83d\udc41\ufe0f Showing terminal: " + id + " (preserve focus: " + preserveFocus + ")");
            TerminalInstance terminalInstance = this.getTerminalInstance(id);
            if (terminalInstance != null) {
                Boolean bl = preserveFocus;
                terminalInstance.show(bl != null ? bl : true);
                this.logger.info("\u2705 Terminal shown: " + id);
            } else {
                this.logger.warn("Terminal does not exist: " + id);
            }
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to show terminal: " + id, (Throwable)e);
        }
    }

    @Override
    public void registerProcessSupport(boolean isSupported) {
        this.logger.info("\ud83d\udccb Registering process support: " + isSupported);
    }

    @Override
    public void registerProfileProvider(@NotNull String id, @NotNull String extensionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)extensionIdentifier, (String)"extensionIdentifier");
        this.logger.info("\ud83d\udccb Registering profile provider: " + id + " (extension: " + extensionIdentifier + ")");
    }

    @Override
    public void unregisterProfileProvider(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.logger.info("\ud83d\udccb Unregistering profile provider: " + id);
    }

    @Override
    public void registerCompletionProvider(@NotNull String id, @NotNull String extensionIdentifier, String ... triggerCharacters) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)extensionIdentifier, (String)"extensionIdentifier");
        Intrinsics.checkNotNullParameter((Object)triggerCharacters, (String)"triggerCharacters");
        this.logger.info("\ud83d\udccb Registering completion provider: " + id + " (extension: " + extensionIdentifier + ", trigger characters: " + ArraysKt.joinToString$default((Object[])triggerCharacters, null, null, null, (int)0, null, null, (int)63, null) + ")");
    }

    @Override
    public void unregisterCompletionProvider(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.logger.info("\ud83d\udccb Unregistering completion provider: " + id);
    }

    @Override
    public void registerQuickFixProvider(@NotNull String id, @NotNull String extensionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)extensionIdentifier, (String)"extensionIdentifier");
        this.logger.info("\ud83d\udccb Registering quick fix provider: " + id + " (extension: " + extensionIdentifier + ")");
    }

    @Override
    public void unregisterQuickFixProvider(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.logger.info("\ud83d\udccb Unregistering quick fix provider: " + id);
    }

    @Override
    public void setEnvironmentVariableCollection(@NotNull String extensionIdentifier, boolean persistent, @Nullable Map<String, ? extends Object> collection, @NotNull Map<String, ? extends Object> descriptionMap) {
        Intrinsics.checkNotNullParameter((Object)extensionIdentifier, (String)"extensionIdentifier");
        Intrinsics.checkNotNullParameter(descriptionMap, (String)"descriptionMap");
        this.logger.info("\ud83d\udccb Setting environment variable collection: " + extensionIdentifier + " (persistent: " + persistent + ")");
    }

    @Override
    public void startSendingDataEvents() {
        this.logger.info("\ud83d\udccb Starting to send data events");
    }

    @Override
    public void stopSendingDataEvents() {
        this.logger.info("\ud83d\udccb Stopping data event sending");
    }

    @Override
    public void startSendingCommandEvents() {
        this.logger.info("\ud83d\udccb Starting to send command events");
    }

    @Override
    public void stopSendingCommandEvents() {
        this.logger.info("\ud83d\udccb Stopping command event sending");
    }

    @Override
    public void startLinkProvider() {
        this.logger.info("\ud83d\udccb Starting link provider");
    }

    @Override
    public void stopLinkProvider() {
        this.logger.info("\ud83d\udccb Stopping link provider");
    }

    @Override
    public void sendProcessData(int terminalId, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.logger.debug("Send process data to terminal " + terminalId);
    }

    @Override
    public void sendProcessReady(int terminalId, int pid, @NotNull String cwd, @Nullable Map<String, ? extends Object> windowsPty) {
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        this.logger.info("Send process ready: terminal=" + terminalId + ", pid=" + pid + ", cwd=" + cwd);
    }

    @Override
    public void sendProcessProperty(int terminalId, @NotNull Map<String, ? extends Object> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this.logger.debug("\ud83d\udccb Sending process property: terminal=" + terminalId);
    }

    @Override
    public void sendProcessExit(int terminalId, @Nullable Integer exitCode) {
        this.logger.info("\ud83d\udccb Sending process exit: terminal=" + terminalId + ", exit code=" + exitCode);
    }

    @Nullable
    public final TerminalInstance getTerminalInstance(@NotNull Object id) {
        TerminalInstance terminalInstance;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = id;
        if (object instanceof String) {
            terminalInstance = this.terminalManager.getTerminalInstance((String)id);
        } else if (object instanceof Number) {
            terminalInstance = this.terminalManager.getTerminalInstance(((Number)id).intValue());
        } else {
            this.logger.warn("Unsupported ID type: " + id.getClass().getName() + ", attempting to convert to string");
            terminalInstance = this.terminalManager.getTerminalInstance(id.toString());
        }
        return terminalInstance;
    }

    @NotNull
    public final Collection<TerminalInstance> getAllTerminals() {
        return this.terminalManager.getAllTerminals();
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        Unit unit;
        switch (methodName) {
            case "createTerminal": {
                Object[] objectArray = new Class[]{String.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])objectArray), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String extHostTerminalId = (String)object;
                Object object2 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map config2 = (Map)object2;
                Object object3 = this.createTerminal(extHostTerminalId, config2, $completion);
                if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object3;
                }
                unit = Unit.INSTANCE;
                break;
            }
            case "dispose": {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Object.class), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
                Object id = object;
                this.dispose(id);
                unit = Unit.INSTANCE;
                break;
            }
            case "hide": {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Object.class), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
                Object id = object;
                this.hide(id);
                unit = Unit.INSTANCE;
                break;
            }
            case "sendText": {
                Object id = new Class[]{Object.class, String.class, Boolean.TYPE};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])id), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
                id = object;
                Object object4 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
                String text = (String)object4;
                Boolean shouldExecute = (Boolean)realArgs.get(2);
                this.sendText(id, text, shouldExecute);
                unit = Unit.INSTANCE;
                break;
            }
            case "show": {
                Object id = new Class[]{Object.class, Boolean.TYPE};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])id), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
                id = object;
                Boolean preserveFocus = (Boolean)realArgs.get(1);
                this.show(id, preserveFocus);
                unit = Unit.INSTANCE;
                break;
            }
            case "registerProcessSupport": {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Boolean.TYPE), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean isSupported = (Boolean)object;
                this.registerProcessSupport(isSupported);
                unit = Unit.INSTANCE;
                break;
            }
            case "registerProfileProvider": {
                Object[] isSupported = new Class[]{String.class, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])isSupported), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String id = (String)object;
                Object object5 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.String");
                String extensionIdentifier = (String)object5;
                this.registerProfileProvider(id, extensionIdentifier);
                unit = Unit.INSTANCE;
                break;
            }
            case "unregisterProfileProvider": {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String id = (String)object;
                this.unregisterProfileProvider(id);
                unit = Unit.INSTANCE;
                break;
            }
            case "registerCompletionProvider": {
                Object id = new Class[]{String.class, String.class, String[].class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])id), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                id = (String)object;
                Object object6 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.String");
                String extensionIdentifier = (String)object6;
                Object object7 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                String[] triggerCharacters = (String[])object7;
                this.registerCompletionProvider((String)id, extensionIdentifier, Arrays.copyOf(triggerCharacters, triggerCharacters.length));
                unit = Unit.INSTANCE;
                break;
            }
            case "unregisterCompletionProvider": {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String id = (String)object;
                this.unregisterCompletionProvider(id);
                unit = Unit.INSTANCE;
                break;
            }
            case "registerQuickFixProvider": {
                Object id = new Class[]{String.class, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])id), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                id = (String)object;
                Object object8 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.String");
                String extensionIdentifier = (String)object8;
                this.registerQuickFixProvider((String)id, extensionIdentifier);
                unit = Unit.INSTANCE;
                break;
            }
            case "unregisterQuickFixProvider": {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String id = (String)object;
                this.unregisterQuickFixProvider(id);
                unit = Unit.INSTANCE;
                break;
            }
            case "setEnvironmentVariableCollection": {
                Object[] id = new Class[]{String.class, Boolean.TYPE, Map.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])id), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String extensionIdentifier = (String)object;
                Object object9 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean persistent = (Boolean)object9;
                Map collection = (Map)realArgs.get(2);
                Object object10 = realArgs.get(3);
                Intrinsics.checkNotNull((Object)object10, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map descriptionMap = (Map)object10;
                this.setEnvironmentVariableCollection(extensionIdentifier, persistent, collection, descriptionMap);
                unit = Unit.INSTANCE;
                break;
            }
            case "startSendingDataEvents": {
                this.startSendingDataEvents();
                unit = Unit.INSTANCE;
                break;
            }
            case "stopSendingDataEvents": {
                this.stopSendingDataEvents();
                unit = Unit.INSTANCE;
                break;
            }
            case "startSendingCommandEvents": {
                this.startSendingCommandEvents();
                unit = Unit.INSTANCE;
                break;
            }
            case "stopSendingCommandEvents": {
                this.stopSendingCommandEvents();
                unit = Unit.INSTANCE;
                break;
            }
            case "startLinkProvider": {
                this.startLinkProvider();
                unit = Unit.INSTANCE;
                break;
            }
            case "stopLinkProvider": {
                this.stopLinkProvider();
                unit = Unit.INSTANCE;
                break;
            }
            case "sendProcessData": {
                Object[] extensionIdentifier = new Class[]{Integer.TYPE, String.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])extensionIdentifier), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int terminalId = (Integer)object;
                Object object11 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object11, (String)"null cannot be cast to non-null type kotlin.String");
                String data = (String)object11;
                this.sendProcessData(terminalId, data);
                unit = Unit.INSTANCE;
                break;
            }
            case "sendProcessReady": {
                Object[] terminalId = new Class[]{Integer.TYPE, Integer.TYPE, String.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])terminalId), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int terminalId2 = (Integer)object;
                Object object12 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object12, (String)"null cannot be cast to non-null type kotlin.Int");
                int pid = (Integer)object12;
                Object object13 = realArgs.get(2);
                Intrinsics.checkNotNull((Object)object13, (String)"null cannot be cast to non-null type kotlin.String");
                String cwd = (String)object13;
                Map windowsPty = (Map)realArgs.get(3);
                this.sendProcessReady(terminalId2, pid, cwd, windowsPty);
                unit = Unit.INSTANCE;
                break;
            }
            case "sendProcessProperty": {
                Object[] terminalId2 = new Class[]{Integer.TYPE, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])terminalId2), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int terminalId3 = (Integer)object;
                Object object14 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)object14, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map property = (Map)object14;
                this.sendProcessProperty(terminalId3, property);
                unit = Unit.INSTANCE;
                break;
            }
            case "sendProcessExit": {
                Object[] terminalId3 = new Class[]{Integer.TYPE, Integer.TYPE};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])terminalId3), args);
                Object object = realArgs.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int terminalId4 = (Integer)object;
                Integer exitCode = (Integer)realArgs.get(1);
                this.sendProcessExit(terminalId4, exitCode);
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                unit = null;
            }
        }
        return unit;
    }

    public void dispose() {
        this.logger.info("\ud83e\uddf9 Disposing main thread terminal service");
        try {
            CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
            this.logger.info("\u2705 Main thread terminal service disposed");
        }
        catch (Exception e) {
            this.logger.error("\u274c Failed to dispose main thread terminal service", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadTerminalServiceShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

