/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadLoggerShape;
import com.sina.weibo.agent.util.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00102\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\r2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\fH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\bH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadLogger;", "Lcom/sina/weibo/agent/actors/MainThreadLoggerShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "log", "", "file", "Lcom/sina/weibo/agent/util/URI;", "messages", "", "", "flush", "createLogger", "", "options", "", "registerLogger", "deregisterLogger", "resource", "setVisibility", "visible", "", "dispatcher", "methodName", "args", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coderider-kilo-jetbrains"})
public final class MainThreadLogger
implements MainThreadLoggerShape {
    @NotNull
    private final Logger logger;

    public MainThreadLogger() {
        Logger logger = Logger.getInstance(MainThreadLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    public void log(@NotNull URI file, @NotNull List<String> messages) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.logger.info("Logging to file: " + file);
    }

    @Override
    public void flush(@NotNull URI file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.logger.info("Flushing log file: " + file);
    }

    @Override
    @NotNull
    public Object createLogger(@NotNull URI file, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.logger.info("Creating logger for file: " + file + " with options: " + options);
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Object registerLogger(@NotNull Map<String, ? extends Object> log) {
        Intrinsics.checkNotNullParameter(log, (String)"log");
        this.logger.info("Registering logger: " + log);
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Object deregisterLogger(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.logger.info("Deregistering logger for resource: " + resource);
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Object setVisibility(@NotNull String resource, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.logger.info("Setting visibility for resource: " + resource + " to " + visible);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        return switch (methodName) {
            case "log" -> {
                Object[] var6_5 = new Class[]{URI.class, List.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])var6_5), args);
                Object v0 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.sina.weibo.agent.util.URI");
                URI file = (URI)v0;
                Object v1 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                List messages = (List)v1;
                this.log(file, messages);
                yield Unit.INSTANCE;
            }
            case "flush" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(URI.class), args);
                Object v3 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type com.sina.weibo.agent.util.URI");
                URI file = (URI)v3;
                this.flush(file);
                yield Unit.INSTANCE;
            }
            case "createLogger" -> {
                Object file = new Class[]{URI.class, Map.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])file), args);
                Object v4 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type com.sina.weibo.agent.util.URI");
                file = (URI)v4;
                Object v5 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map options = (Map)v5;
                yield this.createLogger((URI)file, options);
            }
            case "registerLogger" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(Map.class), args);
                Object v6 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map logger = (Map)v6;
                yield this.registerLogger(logger);
            }
            case "deregisterLogger" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
                Object v7 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type kotlin.String");
                String resource = (String)v7;
                yield this.deregisterLogger(resource);
            }
            case "setVisibility" -> {
                Object resource = new Class[]{String.class, Boolean.TYPE};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])resource), args);
                Object v8 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type kotlin.String");
                resource = (String)v8;
                Object v9 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean visible = (Boolean)v9;
                yield this.setVisibility((String)resource, visible);
            }
            default -> null;
        };
    }

    public void dispose() {
        this.logger.info("Disposing MainThreadLogger");
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadLoggerShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

