/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadLanguageModelToolsShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000bH\u0016J6\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\bH\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/sina/weibo/agent/actors/MainThreadLanguageModelTools;", "Lcom/sina/weibo/agent/actors/MainThreadLanguageModelToolsShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "tools", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/sina/weibo/agent/actors/MainThreadLanguageModelTools$ToolInfo;", "getTools", "", "", "", "invokeTool", "dto", "token", "countTokensForInvocation", "", "callId", "input", "registerTool", "", "id", "unregisterTool", "name", "dispatcher", "methodName", "args", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "ToolInfo", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMainThreadLanguageModelToolsShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainThreadLanguageModelToolsShape.kt\ncom/sina/weibo/agent/actors/MainThreadLanguageModelTools\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n14#2:171\n774#3:172\n865#3,2:173\n1563#3:175\n1634#3,3:176\n*S KotlinDebug\n*F\n+ 1 MainThreadLanguageModelToolsShape.kt\ncom/sina/weibo/agent/actors/MainThreadLanguageModelTools\n*L\n61#1:171\n75#1:172\n75#1:173,2\n75#1:175\n75#1:176,3\n*E\n"})
public final class MainThreadLanguageModelTools
implements MainThreadLanguageModelToolsShape {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, ToolInfo> tools;

    public MainThreadLanguageModelTools() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MainThreadLanguageModelTools.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.tools = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Map<String, Object>> getTools() {
        void $this$mapTo$iv$iv;
        ToolInfo it;
        Iterable $this$filterTo$iv$iv;
        this.logger.info("Get available language model tool list");
        Collection<ToolInfo> collection = this.tools.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ToolInfo)element$iv$iv;
            boolean bl = false;
            if (!it.getRegistered()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ToolInfo)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)it.getId())));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Map<String, Object> invokeTool(@NotNull Map<String, ? extends Object> dto, @Nullable Object token) {
        Intrinsics.checkNotNullParameter(dto, (String)"dto");
        Object object = dto.get("id");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            throw new IllegalArgumentException("Tool ID cannot be empty");
        }
        String toolId = string;
        Object object2 = dto.get("params");
        if (object2 == null) {
            object2 = MapsKt.emptyMap();
        }
        Object params = object2;
        this.logger.info("Invoke language model tool: " + toolId);
        ToolInfo toolInfo = this.tools.get(toolId);
        if (toolInfo == null) {
            throw new IllegalArgumentException("Tool with ID " + toolId + " not found");
        }
        ToolInfo toolInfo2 = toolInfo;
        if (!toolInfo2.getRegistered()) {
            throw new IllegalStateException("Tool " + toolId + " is not registered");
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"result", (Object)("Tool " + toolId + " invoked successfully")), TuplesKt.to((Object)"id", (Object)toolId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public int countTokensForInvocation(@NotNull String callId, @NotNull String input, @Nullable Object token) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.logger.info("Calculate token count for tool invocation " + callId);
        return input.length() / 4 + 1;
    }

    @Override
    public void registerTool(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.logger.info("Register language model tool: " + id);
        ((Map)this.tools).put(id, new ToolInfo(id, true));
    }

    @Override
    public void unregisterTool(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.logger.info("Unregister language model tool: " + name);
        if (this.tools.containsKey(name)) {
            Map map = this.tools;
            ToolInfo toolInfo = this.tools.get(name);
            Intrinsics.checkNotNull((Object)toolInfo);
            map.put(name, ToolInfo.copy$default(toolInfo, null, false, 1, null));
        } else {
            this.logger.warn("Attempting to unregister non-existent tool: " + name);
        }
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        return switch (methodName) {
            case "getTools" -> this.getTools();
            case "invokeTool" -> {
                Object[] var6_5 = new Class[]{Map.class, Object.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])var6_5), args);
                Object v1 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                Map dto = (Map)v1;
                Object token = realArgs.get(1);
                yield this.invokeTool(dto, token);
            }
            case "countTokensForInvocation" -> {
                Object[] dto = new Class[]{String.class, String.class, Object.class};
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf((Object[])dto), args);
                Object v2 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type kotlin.String");
                String callId = (String)v2;
                Object v3 = realArgs.get(1);
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.String");
                String input = (String)v3;
                Object token = realArgs.get(2);
                yield Boxing.boxInt((int)this.countTokensForInvocation(callId, input, token));
            }
            case "registerTool" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
                Object v4 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type kotlin.String");
                String id = (String)v4;
                this.registerTool(id);
                yield Unit.INSTANCE;
            }
            case "unregisterTool" -> {
                List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
                Object v5 = realArgs.get(0);
                Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type kotlin.String");
                String name = (String)v5;
                this.unregisterTool(name);
                yield Unit.INSTANCE;
            }
            default -> null;
        };
    }

    public void dispose() {
        this.logger.info("Dispose MainThreadLanguageModelTools resources");
        this.tools.clear();
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadLanguageModelToolsShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadLanguageModelTools$ToolInfo;", "", "id", "", "registered", "", "<init>", "(Ljava/lang/String;Z)V", "getId", "()Ljava/lang/String;", "getRegistered", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class ToolInfo {
        @NotNull
        private final String id;
        private final boolean registered;

        public ToolInfo(@NotNull String id, boolean registered) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.registered = registered;
        }

        public /* synthetic */ ToolInfo(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(string, bl);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final boolean getRegistered() {
            return this.registered;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        public final boolean component2() {
            return this.registered;
        }

        @NotNull
        public final ToolInfo copy(@NotNull String id, boolean registered) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new ToolInfo(id, registered);
        }

        public static /* synthetic */ ToolInfo copy$default(ToolInfo toolInfo, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = toolInfo.id;
            }
            if ((n & 2) != 0) {
                bl = toolInfo.registered;
            }
            return toolInfo.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "ToolInfo(id=" + this.id + ", registered=" + this.registered + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.registered);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolInfo)) {
                return false;
            }
            ToolInfo toolInfo = (ToolInfo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)toolInfo.id)) {
                return false;
            }
            return this.registered == toolInfo.registered;
        }
    }
}

