/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.agent.actors;

import com.intellij.openapi.diagnostic.Logger;
import com.sina.weibo.agent.actors.MainThreadClipboardShape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\nH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/sina/weibo/agent/actors/MainThreadClipboard;", "Lcom/sina/weibo/agent/actors/MainThreadClipboardShape;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "readText", "", "writeText", "", "value", "dispatcher", "", "methodName", "args", "", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coderider-kilo-jetbrains"})
public final class MainThreadClipboard
implements MainThreadClipboardShape {
    @NotNull
    private final Logger logger;

    public MainThreadClipboard() {
        Logger logger = Logger.getInstance(MainThreadClipboardShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @Nullable
    public String readText() {
        String string;
        this.logger.info("Reading clipboard text");
        try {
            Object object;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable data = clipboard.getContents(null);
            string = data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor) ? ((object = data.getTransferData(DataFlavor.stringFlavor)) instanceof String ? (String)object : null) : null;
        }
        catch (Exception e) {
            this.logger.error("Failed to read clipboard", (Throwable)e);
            string = null;
        }
        return string;
    }

    @Override
    public void writeText(@Nullable String value) {
        block2: {
            String string = value;
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            this.logger.info("Writing clipboard text: " + value);
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(value);
                clipboard.setContents(selection, selection);
            }
            catch (Exception e) {
                this.logger.error("Failed to write to clipboard", (Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public Object dispatcher(@NotNull String methodName, @NotNull List<? extends Object> args, @NotNull Continuation<Object> $completion) {
        String string;
        String string2 = methodName;
        if (Intrinsics.areEqual((Object)string2, (Object)"readText")) {
            string = this.readText();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"writeText")) {
            List<Object> realArgs = this.resolveTrueParameterTypes(CollectionsKt.listOf(String.class), args);
            String value = (String)realArgs.get(0);
            this.writeText(value);
            string = Unit.INSTANCE;
        } else {
            string = null;
        }
        return string;
    }

    public void dispose() {
        this.logger.info("Releasing resources: MainThreadClipboard");
    }

    @Override
    @NotNull
    public List<Object> resolveTrueParameterTypes(@NotNull List<? extends Class<?>> parameterTypes, @NotNull List<? extends Object> args) {
        return MainThreadClipboardShape.DefaultImpls.resolveTrueParameterTypes(this, parameterTypes, args);
    }
}

