/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.util.Arrays;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\u0010"}, d2={"extractPackageFromPrefix", "", "prefix", "handleAppendToFile", "", "project", "Lcom/intellij/openapi/project/Project;", "text", "writeFile", "filename", "chooseDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "promptFileName", "createAndOpenFile", "directory", "fileName", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncn/gitlab/kilo/jetbrains/utils/FileUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class FileUtilsKt {
    @Nullable
    public static final String extractPackageFromPrefix(@NotNull String prefix) {
        String packageName;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Regex packageRegex = new Regex("package\\s+([a-zA-Z0-9_.]+)");
        Object object = Regex.find$default((Regex)packageRegex, (CharSequence)prefix, (int)0, (int)2, null);
        String string = packageName = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
        return string != null ? "package " + string : null;
    }

    public static final void handleAppendToFile(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> FileUtilsKt.handleAppendToFile$lambda$0(project, text));
    }

    public static final void writeFile(@NotNull Project project, @NotNull String filename, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ApplicationManager.getApplication().invokeLater(() -> FileUtilsKt.writeFile$lambda$2(project, filename, text));
    }

    @Nullable
    public static final VirtualFile chooseDirectory(@NotNull Project project) {
        FileChooserDescriptor fileChooserDescriptor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileChooserDescriptor $this$chooseDirectory_u24lambda_u243 = fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        boolean bl = false;
        $this$chooseDirectory_u24lambda_u243.setTitle(I18nKt.getMessage("choose_dir"));
        return FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null);
    }

    @Nullable
    public static final String promptFileName(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Messages.showInputDialog((Project)project, (String)I18nKt.getMessage("save_as"), (String)I18nKt.getMessage("new_file"), (Icon)Messages.getQuestionIcon());
    }

    public static final void createAndOpenFile(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String fileName, @NotNull String text) {
        block2: {
            VirtualFile createdVirtualFile;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(directory);
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory psiDirectory2 = psiDirectory;
            VirtualFile virtualFile = directory.findChild(fileName);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                String string = I18nKt.getMessage("file.exists");
                Object[] objectArray = new Object[]{it};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                Messages.showErrorDialog((Project)project, (String)string2, (String)I18nKt.getMessage("error"));
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> FileUtilsKt.createAndOpenFile$lambda$6(project, fileName, text, psiDirectory2));
            VirtualFile virtualFile2 = createdVirtualFile = directory.findChild(fileName);
            if (virtualFile2 == null) break block2;
            VirtualFile it = virtualFile2;
            boolean bl = false;
            FileEditorManager.getInstance((Project)project).openFile(it, true);
        }
    }

    private static final void handleAppendToFile$lambda$0(Project $project, String $text) {
        VirtualFile virtualFile = FileUtilsKt.chooseDirectory($project);
        if (virtualFile == null) {
            return;
        }
        VirtualFile selectedDir = virtualFile;
        String string = FileUtilsKt.promptFileName($project);
        if (string == null) {
            return;
        }
        String fileName = string;
        FileUtilsKt.createAndOpenFile($project, selectedDir, fileName, $text);
    }

    private static final void writeFile$lambda$2$lambda$1(VirtualFile $selectedDir, Ref.ObjectRef $targetName, Project $project, String $text) {
        VirtualFile virtualFile = $selectedDir.findChild((String)$targetName.element);
        if (virtualFile == null) {
            VirtualFile virtualFile2 = $selectedDir.createChildData((Object)$project, (String)$targetName.element);
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
        }
        VirtualFile vf = virtualFile;
        VfsUtil.saveText((VirtualFile)vf, (String)$text);
    }

    private static final void writeFile$lambda$2(Project $project, String $filename, String $text) {
        boolean exists;
        VirtualFile virtualFile = FileUtilsKt.chooseDirectory($project);
        if (virtualFile == null) {
            return;
        }
        VirtualFile selectedDir = virtualFile;
        Ref.ObjectRef targetName = new Ref.ObjectRef();
        targetName.element = $filename;
        boolean bl = exists = selectedDir.findChild((String)targetName.element) != null;
        if (exists) {
            String string = I18nKt.getMessageByChatLocale("confirm.overwrite");
            Object[] objectArray = new Object[]{targetName.element};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            int res = Messages.showYesNoDialog((Project)$project, (String)string2, (String)I18nKt.getMessageByChatLocale("file.conflict"), (String)I18nKt.getMessageByChatLocale("confirm.yes"), (String)I18nKt.getMessageByChatLocale("confirm.no"), (Icon)Messages.getQuestionIcon());
            if (res != 0) {
                String string3;
                String base;
                int dot = StringsKt.lastIndexOf$default((CharSequence)$filename, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dot >= 0) {
                    String string4 = $filename.substring(0, dot);
                    v4 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                } else {
                    v4 = base = $filename;
                }
                if (dot >= 0) {
                    String string5 = $filename.substring(dot);
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                } else {
                    string3 = "";
                }
                String ext = string3;
                int counter = 1;
                while (selectedDir.findChild((String)targetName.element) != null) {
                    targetName.element = base + "_" + counter++ + ext;
                }
            }
        }
        WriteCommandAction.runWriteCommandAction((Project)$project, () -> FileUtilsKt.writeFile$lambda$2$lambda$1(selectedDir, targetName, $project, $text));
    }

    private static final void createAndOpenFile$lambda$6(Project $project, String $fileName, String $text, PsiDirectory $psiDirectory) {
        PsiFile it = PsiFileFactory.getInstance((Project)$project).createFileFromText($fileName, (FileType)PlainTextFileType.INSTANCE, (CharSequence)$text);
        boolean bl = false;
        $psiDirectory.add((PsiElement)it);
    }
}

