/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.utils.OS;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.UriUtilKt;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0015\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\t\u001a\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\t\u00a8\u0006\u001f"}, d2={"getAltKeyLabel", "", "getOS", "Lcn/gitlab/kilo/jetbrains/utils/OS;", "getMetaKeyLabel", "getShiftKeyLabel", "getShortcutDisplayString", "actionId", "findFileOrScratch", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "uriString", "getCurrentLineIndentation", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffset", "", "getFileErrors", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCursorErrorsAtCurrentPosition", "getHighlightsRange", "Lcn/gitlab/kilo/jetbrains/common/Range;", "myHighlights", "document", "Lcom/intellij/openapi/editor/Document;", "getTestSourceRootsForFile", "file", "getSrcSourceRootsForFile", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nEditUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditUtil.kt\ncn/gitlab/kilo/jetbrains/utils/EditUtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n648#2,5:273\n774#3:278\n865#3,2:279\n*S KotlinDebug\n*F\n+ 1 EditUtil.kt\ncn/gitlab/kilo/jetbrains/utils/EditUtilKt\n*L\n188#1:273,5\n225#1:278\n225#1:279,2\n*E\n"})
public final class EditUtilKt {
    @NotNull
    public static final String getAltKeyLabel() {
        return switch (WhenMappings.$EnumSwitchMapping$0[EditUtilKt.getOS().ordinal()]) {
            case 1 -> "\u2325";
            case 2 -> "Alt";
            case 3 -> "Alt";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final OS getOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String osName = string2;
        OS os = StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"darwin", (boolean)false, (int)2, null) ? OS.MAC : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"win", (boolean)false, (int)2, null) ? OS.WINDOWS : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"nix", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"nux", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"aix", (boolean)false, (int)2, null) ? OS.LINUX : OS.LINUX));
        return os;
    }

    @NotNull
    public static final String getMetaKeyLabel() {
        return switch (WhenMappings.$EnumSwitchMapping$0[EditUtilKt.getOS().ordinal()]) {
            case 1 -> "\u2318";
            case 2 -> "^";
            case 3 -> "^";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String getShiftKeyLabel() {
        return switch (WhenMappings.$EnumSwitchMapping$0[EditUtilKt.getOS().ordinal()]) {
            case 1 -> "\u21e7";
            case 2, 3 -> "\u2191";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public static final String getShortcutDisplayString(@NotNull String actionId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Shortcut[] shortcutArray = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        Shortcut shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])shortcutArray);
        if (shortcut != null) {
            Shortcut it = shortcut;
            boolean bl = false;
            string = KeymapUtil.getShortcutText((Shortcut)it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final VirtualFile findFileOrScratch(@NotNull Project project, @NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        try {
            URI uRI;
            URI uri = URI.create(uriString);
            if (StringsKt.startsWith$default((String)uriString, (String)"untitled", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)uri);
                uRI = UriUtilKt.withScheme((URI)uri, (String)"file");
            } else {
                uRI = uri;
            }
            URI fixedUri = uRI;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNull((Object)fixedUri);
            Path path = Paths.get(fixedUri);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return localFileSystem.refreshAndFindFileByNioFile(path);
        }
        catch (URISyntaxException e) {
            char[] cArray = new char[]{'/', '\\'};
            String fileName = StringsKt.trimStart((String)StringsKt.substringAfterLast$default((String)uriString, (char)':', null, (int)2, null), (char[])cArray);
            return ScratchRootType.getInstance().findFile(project, fileName, ScratchFileService.Option.existing_only);
        }
    }

    @NotNull
    public static final String getCurrentLineIndentation(@NotNull Editor editor, int startOffset) {
        String string;
        block1: {
            String lineText;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int lineNumber = document2.getLineNumber(startOffset);
            int lineStartOffset = document2.getLineStartOffset(lineNumber);
            int lineEndOffset = document2.getLineEndOffset(lineNumber);
            String string2 = document2.getText(new TextRange(lineStartOffset, lineEndOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String $this$takeWhile$iv = lineText = string2;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string3 = $this$takeWhile$iv;
                int n2 = 0;
                String string4 = string3.substring(n2, index$iv);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                break block1;
            }
            string = $this$takeWhile$iv;
        }
        String indentation = string;
        return indentation;
    }

    @Nullable
    public static final Object getFileErrors(@NotNull Editor editor, @NotNull Continuation<? super List<? extends HighlightInfo>> $completion) {
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<HighlightInfo>>, Object>(editor, project2, null){
            int label;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;
            {
                this.$editor = $editor;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Document document = this.$editor.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                        Document document2 = document;
                        List highlightInfos = new ArrayList<E>();
                        DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)this.$project, (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document2.getTextLength(), (Processor)Processors.cancelableCollectProcessor((Collection)highlightInfos));
                        return highlightInfos;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<HighlightInfo>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HighlightInfo> getCursorErrorsAtCurrentPosition(@NotNull Editor editor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int currentOffset = editor.getCaretModel().getOffset();
        List highlightInfos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)project2, (HighlightSeverity)HighlightSeverity.ERROR, (int)currentOffset, (int)document2.getTextLength(), (Processor)Processors.cancelableCollectProcessor((Collection)highlightInfos));
        Iterable $this$filter$iv = highlightInfos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HighlightInfo highlight = (HighlightInfo)element$iv$iv;
            boolean bl = false;
            if (!(highlight.startOffset <= currentOffset && currentOffset <= highlight.endOffset)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Range getHighlightsRange(@NotNull List<? extends HighlightInfo> myHighlights, @NotNull Document document) {
        Intrinsics.checkNotNullParameter(myHighlights, (String)"myHighlights");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (myHighlights.isEmpty()) {
            throw new IllegalArgumentException("The list of highlights cannot be empty");
        }
        int startLine = Integer.MAX_VALUE;
        int endLine = Integer.MIN_VALUE;
        for (HighlightInfo highlightInfo : myHighlights) {
            int startLineNum = document.getLineNumber(highlightInfo.startOffset);
            int endLineNum = document.getLineNumber(highlightInfo.endOffset);
            startLine = Math.min(startLine, startLineNum);
            endLine = Math.max(endLine, endLineNum);
        }
        int startOffset = document.getLineStartOffset(startLine);
        int n = document.getLineEndOffset(endLine);
        return new Range(startOffset, n);
    }

    @NotNull
    public static final List<VirtualFile> getTestSourceRootsForFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        ModuleRootManager rootModel = ModuleRootManager.getInstance((Module)module2);
        List list = rootModel.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        return list;
    }

    @NotNull
    public static final List<VirtualFile> getSrcSourceRootsForFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        ModuleRootManager rootModel = ModuleRootManager.getInstance((Module)module2);
        List list = rootModel.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.MAC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

