/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.utils.ThemeUtil;
import com.intellij.openapi.editor.Editor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J'\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\rJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\rJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018J\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018\u00a8\u0006!"}, d2={"Lcn/gitlab/kilo/jetbrains/utils/EditUtil;", "", "<init>", "()V", "isTerminal", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "setComponentName", "T", "Ljavax/swing/JComponent;", "component", "name", "", "(Ljavax/swing/JComponent;Ljava/lang/String;)Ljavax/swing/JComponent;", "namedButton", "Ljavax/swing/JButton;", "namedLabel", "Ljavax/swing/JLabel;", "namedPanel", "Ljavax/swing/JPanel;", "removeAllListeners", "", "getThemeColor", "Ljava/awt/Color;", "key", "getEnhancedThemeColor", "getSubduedThemeColor", "getMutedThemeColor", "enhance", "color", "subdue", "mute", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nEditUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditUtil.kt\ncn/gitlab/kilo/jetbrains/utils/EditUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,272:1\n13472#2,2:273\n13472#2,2:275\n13472#2,2:277\n13472#2,2:279\n13472#2,2:281\n*S KotlinDebug\n*F\n+ 1 EditUtil.kt\ncn/gitlab/kilo/jetbrains/utils/EditUtil\n*L\n53#1:273,2\n56#1:275,2\n59#1:277,2\n62#1:279,2\n65#1:281,2\n*E\n"})
public final class EditUtil {
    @NotNull
    public static final EditUtil INSTANCE = new EditUtil();

    private EditUtil() {
    }

    public final boolean isTerminal(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = editor.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Terminal", (boolean)false, (int)2, null);
    }

    private final <T extends JComponent> T setComponentName(T component, String name) {
        component.putClientProperty("name", name);
        return component;
    }

    @NotNull
    public final JButton namedButton(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (JButton)this.setComponentName((JComponent)new JButton(), name);
    }

    @NotNull
    public final JLabel namedLabel(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (JLabel)this.setComponentName((JComponent)new JLabel(), name);
    }

    @NotNull
    public final JPanel namedPanel(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (JPanel)this.setComponentName((JComponent)new JPanel(), name);
    }

    public final void removeAllListeners(@NotNull JComponent component) {
        EventListener it;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
        Object[] $this$forEach$iv = mouseListenerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MouseListener)element$iv;
            boolean bl = false;
            component.removeMouseListener((MouseListener)it);
        }
        MouseMotionListener[] mouseMotionListenerArray = component.getMouseMotionListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseMotionListenerArray, (String)"getMouseMotionListeners(...)");
        $this$forEach$iv = mouseMotionListenerArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MouseMotionListener)element$iv;
            boolean bl = false;
            component.removeMouseMotionListener((MouseMotionListener)it);
        }
        ActionListener[] actionListenerArray = component instanceof AbstractButton ? (ActionListener[])component : null;
        if (actionListenerArray != null && (actionListenerArray = actionListenerArray.getActionListeners()) != null) {
            ActionListener[] $this$forEach$iv2 = actionListenerArray;
            boolean $i$f$forEach2 = false;
            int it2 = $this$forEach$iv2.length;
            for (int element$iv = 0; element$iv < it2; ++element$iv) {
                ActionListener element$iv2;
                ActionListener it3 = element$iv2 = $this$forEach$iv2[element$iv];
                boolean bl = false;
                ((AbstractButton)component).removeActionListener(it3);
            }
        }
        KeyListener[] keyListenerArray = component.getKeyListeners();
        Intrinsics.checkNotNullExpressionValue((Object)keyListenerArray, (String)"getKeyListeners(...)");
        $this$forEach$iv = keyListenerArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyListener it4 = (KeyListener)element$iv;
            boolean bl = false;
            component.removeKeyListener(it4);
        }
        Component[] componentArray = component.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        $this$forEach$iv = componentArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it5 = (Component)element$iv;
            boolean bl = false;
            if (!(it5 instanceof JComponent)) continue;
            INSTANCE.removeAllListeners((JComponent)it5);
        }
    }

    @Nullable
    public final Color getThemeColor(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return UIManager.getColor(key);
    }

    @Nullable
    public final Color getEnhancedThemeColor(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Color color = this.getThemeColor(key);
        if (color == null) {
            return null;
        }
        return this.enhance(color);
    }

    @Nullable
    public final Color getSubduedThemeColor(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Color color = this.getThemeColor(key);
        if (color == null) {
            return null;
        }
        return this.subdue(color);
    }

    @Nullable
    public final Color getMutedThemeColor(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Color color = this.getThemeColor(key);
        if (color == null) {
            return null;
        }
        return this.mute(color);
    }

    @NotNull
    public final Color enhance(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (ThemeUtil.INSTANCE.isDarkTheme()) {
            Color color3 = color.darker();
            Intrinsics.checkNotNull((Object)color3);
            color2 = color3;
        } else {
            Color color4 = color.brighter();
            Intrinsics.checkNotNull((Object)color4);
            color2 = color4;
        }
        return color2;
    }

    @NotNull
    public final Color subdue(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (ThemeUtil.INSTANCE.isDarkTheme()) {
            Color color3 = color.brighter();
            Intrinsics.checkNotNull((Object)color3);
            color2 = color3;
        } else {
            Color color4 = color.darker();
            Intrinsics.checkNotNull((Object)color4);
            color2 = color4;
        }
        return color2;
    }

    @NotNull
    public final Color mute(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (ThemeUtil.INSTANCE.isDarkTheme()) {
            color2 = color;
        } else {
            Color color3 = color.darker();
            Intrinsics.checkNotNull((Object)color3);
            color2 = color3;
        }
        return color2;
    }
}

