/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import cn.gitlab.kilo.jetbrains.services.context.CachedRetriever;
import cn.gitlab.kilo.jetbrains.services.context.ContextRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.RecentViewPortRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.TrackedViewPort;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.sina.weibo.agent.provider.LoggerAdapter;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\n\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020$H\u0002J\u001a\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010,\u001a\u00020\u0007H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\f\u001aB\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f \u000e* \u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/RecentViewPortRetriever;", "Lcn/gitlab/kilo/jetbrains/services/context/CachedRetriever;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "options", "Lcn/gitlab/kilo/jetbrains/services/context/RecentViewPortRetrieverOptions;", "viewPortCache", "", "kotlin.jvm.PlatformType", "Lcn/gitlab/kilo/jetbrains/services/context/TrackedViewPort;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "debounceJobs", "Lkotlinx/coroutines/Job;", "visibleAreaListeners", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "attachVisibleAreaListener", "", "editor", "detachVisibleAreaListener", "scheduleViewPortTracking", "trackViewPort", "doRetrieval", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "reconcileOutdatedViewPorts", "currentTime", "", "calculateScore", "", "content", "timeSinceAccessMs", "shouldUseAsContext", "", "currentLanguage", "targetLanguage", "isSupportedForLanguageId", "languageId", "dispose", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRecentViewPortRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentViewPortRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentViewPortRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,299:1\n774#2:300\n865#2,2:301\n1068#2:303\n1869#2,2:304\n1068#2:306\n774#2:307\n865#2,2:308\n1563#2:310\n1634#2,3:311\n1869#2,2:314\n1788#2,4:316\n1869#2,2:320\n216#3,2:322\n*S KotlinDebug\n*F\n+ 1 RecentViewPortRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentViewPortRetriever\n*L\n173#1:300\n173#1:301,2\n181#1:303\n186#1:304,2\n217#1:306\n223#1:307\n223#1:308,2\n224#1:310\n224#1:311,3\n226#1:314,2\n240#1:316,4\n275#1:320,2\n279#1:322,2\n*E\n"})
public final class RecentViewPortRetriever
extends CachedRetriever {
    @NotNull
    private final Project project;
    @NotNull
    private final String identifier;
    @NotNull
    private final RecentViewPortRetrieverOptions options;
    private final Map<String, TrackedViewPort> viewPortCache;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Map<String, Job> debounceJobs;
    @NotNull
    private final Map<Editor, VisibleAreaListener> visibleAreaListeners;

    public RecentViewPortRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.identifier = "RecentViewPort";
        this.options = new RecentViewPortRetrieverOptions(0, 0, 0L, 0L, 15, null);
        int n = this.options.getMaxTrackedViewPorts();
        this.viewPortCache = Collections.synchronizedMap(new LinkedHashMap<String, TrackedViewPort>(this, n){
            final /* synthetic */ RecentViewPortRetriever this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, 0.75f, true);
            }

            protected boolean removeEldestEntry(Map.Entry<String, TrackedViewPort> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                return this.size() > RecentViewPortRetriever.access$getOptions$p(this.this$0).getMaxTrackedViewPorts();
            }
        });
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.debounceJobs = new LinkedHashMap();
        this.visibleAreaListeners = new LinkedHashMap();
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ApplicationManager.getApplication().invokeLater(() -> 1.fileOpened$lambda$1(source, file, this));
            }

            /*
             * WARNING - void declaration
             */
            public void fileClosed(FileEditorManager source, VirtualFile file) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors();
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
                Object[] objectArray = fileEditorArray;
                RecentViewPortRetriever recentViewPortRetriever = this;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    Editor editor;
                    FileEditor fileEditor = (FileEditor)element$iv;
                    boolean bl = false;
                    TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                    Editor editor2 = editor = textEditor != null ? textEditor.getEditor() : null;
                    if (!Intrinsics.areEqual((Object)(editor2 != null ? editor2.getVirtualFile() : null), (Object)file)) continue;
                    recentViewPortRetriever.detachVisibleAreaListener(editor);
                }
            }

            private static final void fileOpened$lambda$1(FileEditorManager $source, VirtualFile $file, RecentViewPortRetriever this$0) {
                block0: {
                    Editor editor;
                    FileEditor fileEditor = $source.getSelectedEditor($file);
                    TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                    Editor editor2 = editor = textEditor != null ? textEditor.getEditor() : null;
                    if (editor2 == null) break block0;
                    Editor it = editor2;
                    boolean bl = false;
                    this$0.trackViewPort(it);
                    this$0.attachVisibleAreaListener(it);
                }
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> RecentViewPortRetriever._init_$lambda$1(this));
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    private final void attachVisibleAreaListener(Editor editor) {
        if (editor.isDisposed() || this.visibleAreaListeners.containsKey(editor)) {
            return;
        }
        VisibleAreaListener listener2 = arg_0 -> RecentViewPortRetriever.attachVisibleAreaListener$lambda$2(this, editor, arg_0);
        editor.getScrollingModel().addVisibleAreaListener(listener2);
        this.visibleAreaListeners.put(editor, listener2);
    }

    private final void detachVisibleAreaListener(Editor editor) {
        block1: {
            VisibleAreaListener visibleAreaListener = this.visibleAreaListeners.remove(editor);
            if (visibleAreaListener == null) break block1;
            VisibleAreaListener listener2 = visibleAreaListener;
            boolean bl = false;
            if (!editor.isDisposed()) {
                editor.getScrollingModel().removeVisibleAreaListener(listener2);
            }
        }
    }

    private final void scheduleViewPortTracking(Editor editor) {
        if (editor.isDisposed()) {
            return;
        }
        String string = (String)ActionsKt.runReadAction(() -> RecentViewPortRetriever.scheduleViewPortTracking$lambda$4(editor));
        if (string == null) {
            return;
        }
        String filePath = string;
        Job job = this.debounceJobs.get(filePath);
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.debounceJobs.put(filePath, BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, filePath, editor, null){
            int label;
            final /* synthetic */ RecentViewPortRetriever this$0;
            final /* synthetic */ String $filePath;
            final /* synthetic */ Editor $editor;
            {
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                this.$editor = $editor;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)RecentViewPortRetriever.access$getOptions$p(this.this$0).getDebounceDelayMs(), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(com.intellij.openapi.editor.Editor cn.gitlab.kilo.jetbrains.services.context.RecentViewPortRetriever ), ()V)((Editor)this.$editor, (RecentViewPortRetriever)this.this$0));
                        RecentViewPortRetriever.access$getDebounceJobs$p(this.this$0).remove(this.$filePath);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(Editor $editor, RecentViewPortRetriever this$0) {
                if (!$editor.isDisposed()) {
                    RecentViewPortRetriever.access$trackViewPort(this$0, $editor);
                }
            }
        }), (int)3, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void trackViewPort(Editor editor) {
        void it;
        void it2;
        if (editor.isDisposed()) {
            return;
        }
        VirtualFile virtualFile = editor.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        String string2 = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String filePath = string2;
        String languageId = LanguageUtilsKt.getLanguageFromPath(filePath);
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(visibleArea.getLocation());
        Document document = editor.getDocument();
        boolean $i$a$-let-RecentViewPortRetriever$trackViewPort$startLine$22 = false;
        int n = editor.logicalPositionToOffset((LogicalPosition)it2);
        int startLine = document.getLineNumber(n);
        LogicalPosition $i$a$-let-RecentViewPortRetriever$trackViewPort$startLine$22 = editor.xyToLogicalPosition(new Point(visibleArea.x, visibleArea.y + visibleArea.height));
        document = editor.getDocument();
        boolean bl = false;
        n = editor.logicalPositionToOffset((LogicalPosition)it);
        int endLine = RangesKt.coerceAtMost((int)document.getLineNumber(n), (int)(editor.getDocument().getLineCount() - 1));
        long now = System.currentTimeMillis();
        String key = filePath + ":" + startLine + "-" + endLine;
        Map<String, TrackedViewPort> map = this.viewPortCache;
        Intrinsics.checkNotNullExpressionValue(map, (String)"viewPortCache");
        Map<String, TrackedViewPort> map2 = map;
        TrackedViewPort trackedViewPort = new TrackedViewPort(filePath, languageId, startLine, endLine, now);
        map2.put(key, trackedViewPort);
        LoggerAdapter.DefaultImpls.debug$default(ConstantsKt.getLogger(), "Tracked viewport: " + key + " (" + (endLine - startLine + 1) + " lines)", null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContextSnippet> doRetrieval(@NotNull ContextRetrieverOptions options) {
        List list;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long currentTime = System.currentTimeMillis();
        VirtualFile virtualFile = options.getEditor().getVirtualFile();
        String currentFilePath = virtualFile != null ? virtualFile.getPath() : null;
        String currentLanguage = options.getLanguage();
        this.reconcileOutdatedViewPorts(currentTime);
        List matches = new ArrayList();
        Map<String, TrackedViewPort> map = this.viewPortCache;
        Intrinsics.checkNotNullExpressionValue(map, (String)"viewPortCache");
        Map<String, TrackedViewPort> map2 = map;
        synchronized (map2) {
            void $this$sortedByDescending$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            boolean bl = false;
            Iterable iterable = this.viewPortCache.values();
            boolean $i$f$filter = false;
            void var13_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TrackedViewPort viewport = (TrackedViewPort)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)viewport.getFilePath(), (Object)currentFilePath) && this.shouldUseAsContext(currentLanguage, viewport.getLanguageId()) && currentTime - viewport.getLastAccessTimestamp() < this.options.getMaxAgeMs())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            list = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TrackedViewPort it = (TrackedViewPort)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getLastAccessTimestamp());
                    it = (TrackedViewPort)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastAccessTimestamp()));
                }
            }), (int)this.options.getMaxRetrievedViewPorts());
        }
        List sortedViewPorts = list;
        Iterable $this$forEach$iv = sortedViewPorts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackedViewPort viewport = (TrackedViewPort)element$iv;
            boolean bl = false;
            try {
                ActionsKt.runReadAction(() -> RecentViewPortRetriever.doRetrieval$lambda$11$lambda$10(viewport, currentTime, this, matches));
            }
            catch (Exception e) {
                LoggerAdapter.DefaultImpls.warn$default(ConstantsKt.getLogger(), "Failed to extract viewport content from " + viewport.getFilePath() + ": " + e.getMessage(), null, 2, null);
            }
        }
        Iterable $this$sortedByDescending$iv = matches;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ContextSnippet it = (ContextSnippet)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (ContextSnippet)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void reconcileOutdatedViewPorts(long currentTime) {
        Map<String, TrackedViewPort> map = this.viewPortCache;
        Intrinsics.checkNotNullExpressionValue(map, (String)"viewPortCache");
        Map<String, TrackedViewPort> map2 = map;
        synchronized (map2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            boolean bl = false;
            Iterable iterable = this.viewPortCache.entrySet();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                if (!(currentTime - ((TrackedViewPort)it.getValue()).getLastAccessTimestamp() >= this.options.getMaxAgeMs())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add((String)it.getKey());
            }
            List outdatedKeys = (List)destination$iv$iv;
            Iterable $this$forEach$iv = outdatedKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl4 = false;
                this.viewPortCache.remove(it2);
            }
            if (!((Collection)outdatedKeys).isEmpty()) {
                LoggerAdapter.DefaultImpls.debug$default(ConstantsKt.getLogger(), "Removed " + outdatedKeys.size() + " outdated viewports", null, 2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final double calculateScore(String content2, long timeSinceAccessMs) {
        int n;
        double timeScore = Math.max(0.0, 1.0 - (double)timeSinceAccessMs / (double)this.options.getMaxAgeMs());
        List lines = StringsKt.lines((CharSequence)content2);
        Iterable $this$count$iv = lines;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int nonEmptyLines = n;
        double contentScore = nonEmptyLines < 3 ? 0.3 : ((3 <= nonEmptyLines ? nonEmptyLines < 31 : false) ? 1.0 : (nonEmptyLines > 30 ? 0.8 : 0.5));
        return timeScore * 0.8 + contentScore * 0.2;
    }

    private final boolean shouldUseAsContext(String currentLanguage, String targetLanguage) {
        if (currentLanguage == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)currentLanguage, (Object)targetLanguage)) {
            return true;
        }
        Object[] objectArray = new String[]{"html", "css", "javascript", "typescript", "jsx", "tsx"};
        Set webLanguages = SetsKt.setOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"java", "kotlin", "groovy"};
        Set jvmLanguages = SetsKt.setOf((Object[])objectArray2);
        return webLanguages.contains(currentLanguage) && webLanguages.contains(targetLanguage) ? true : jvmLanguages.contains(currentLanguage) && jvmLanguages.contains(targetLanguage);
    }

    @Override
    public boolean isSupportedForLanguageId(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return true;
    }

    @Override
    public void dispose() {
        Object element$iv;
        super.dispose();
        Object $this$forEach$iv = this.debounceJobs.values();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Job it = (Job)element$iv;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
        }
        this.debounceJobs.clear();
        $this$forEach$iv = this.visibleAreaListeners;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Editor editor = (Editor)object.getKey();
            VisibleAreaListener listener2 = (VisibleAreaListener)object.getValue();
            if (editor.isDisposed()) continue;
            try {
                editor.getScrollingModel().removeVisibleAreaListener(listener2);
            }
            catch (Exception e) {
                LoggerAdapter.DefaultImpls.warn$default(ConstantsKt.getLogger(), "Failed to remove visible area listener: " + e.getMessage(), null, 2, null);
            }
        }
        this.visibleAreaListeners.clear();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.viewPortCache.clear();
        LoggerAdapter.DefaultImpls.debug$default(ConstantsKt.getLogger(), "RecentViewPortRetriever disposed", null, 2, null);
    }

    private static final void _init_$lambda$1(RecentViewPortRetriever this$0) {
        block0: {
            Editor editor = FileEditorManager.getInstance((Project)this$0.project).getSelectedTextEditor();
            if (editor == null) break block0;
            Editor editor2 = editor;
            boolean bl = false;
            this$0.trackViewPort(editor2);
            this$0.attachVisibleAreaListener(editor2);
        }
    }

    private static final void attachVisibleAreaListener$lambda$2(RecentViewPortRetriever this$0, Editor $editor, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduleViewPortTracking($editor);
    }

    private static final String scheduleViewPortTracking$lambda$4(Editor $editor) {
        VirtualFile virtualFile = $editor.getVirtualFile();
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    private static final Unit doRetrieval$lambda$11$lambda$10(TrackedViewPort $viewport, long $currentTime, RecentViewPortRetriever this$0, List $matches) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath($viewport.getFilePath());
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return Unit.INSTANCE;
        }
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List lines = StringsKt.lines((CharSequence)string);
        int startLine = RangesKt.coerceIn((int)$viewport.getStartLine(), (int)0, (int)(lines.size() - 1));
        int endLine = RangesKt.coerceIn((int)$viewport.getEndLine(), (int)startLine, (int)(lines.size() - 1));
        String content2 = CollectionsKt.joinToString$default((Iterable)lines.subList(startLine, endLine + 1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)content2)).toString()).length() > 0) {
            long timeSinceAccess = $currentTime - $viewport.getLastAccessTimestamp();
            double score = this$0.calculateScore(content2, timeSinceAccess);
            $matches.add(new ContextSnippet($viewport.getFilePath(), startLine, endLine, content2, score, null, null, 96, null));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ RecentViewPortRetrieverOptions access$getOptions$p(RecentViewPortRetriever $this) {
        return $this.options;
    }

    public static final /* synthetic */ Map access$getDebounceJobs$p(RecentViewPortRetriever $this) {
        return $this.debounceJobs;
    }
}

