/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.common.BackendServer;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.GlobalStatus;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.LoginServerDiscovery;
import cn.gitlab.kilo.jetbrains.common.LoginViaOAuth;
import cn.gitlab.kilo.jetbrains.common.LoginViaPAT;
import cn.gitlab.kilo.jetbrains.common.MessageTip;
import cn.gitlab.kilo.jetbrains.common.OAuthLoginPayload;
import cn.gitlab.kilo.jetbrains.common.Routed;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.services.GitlabHandler;
import cn.gitlab.kilo.jetbrains.services.IssueHandler;
import cn.gitlab.kilo.jetbrains.services.ProxyMessageService;
import cn.gitlab.kilo.jetbrains.services.ProxyMessageServiceKt;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.FileUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.sina.weibo.agent.core.PluginContext;
import com.sina.weibo.agent.core.ServiceProxyRegistry;
import com.sina.weibo.agent.ipc.proxy.IRPCProtocol;
import com.sina.weibo.agent.ipc.proxy.interfaces.ExtHostCommandsProxy;
import com.sina.weibo.agent.provider.LoggerAdapter;
import com.sina.weibo.agent.util.PromiseUtilsKt;
import com.sina.weibo.agent.webview.WebViewInstance;
import com.sina.weibo.agent.webview.WebviewMessageProxy;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002<=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010'\u001a\u00020\u0016H\u0002J(\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0002J(\u0010.\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\u0012\u00101\u001a\u00020\t2\b\b\u0002\u00102\u001a\u00020\u0007H\u0002J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0002J\u001e\u00105\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t062\b\u00107\u001a\u0004\u0018\u00010\tH\u0002J \u00108\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\tH\u0002J(\u0010;\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcn/gitlab/kilo/jetbrains/services/ProxyMessageService;", "Lcom/sina/weibo/agent/webview/WebviewMessageProxy;", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "oauthCallbackPort", "", "oauthRedirectUri", "", "oauthScopes", "oauthServerLock", "", "handle", "", "msg", "project", "Lcom/intellij/openapi/project/Project;", "webViewInstance", "Lcom/sina/weibo/agent/webview/WebViewInstance;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/sina/weibo/agent/webview/WebViewInstance;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "injectVSUserAgent", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleDiscoverServers", "url", "handleLoginViaPAT", "PAT", "startOAuthSession", "session", "Lcn/gitlab/kilo/jetbrains/services/ProxyMessageService$OAuthLoginSession;", "finishOAuthSession", "ensureOAuthServer", "handleOAuthCallback", "exchange", "Lcom/sun/net/httpserver/HttpExchange;", "handleLoginViaOAuth", "payload", "Lcn/gitlab/kilo/jetbrains/common/OAuthLoginPayload;", "logUserIn", "exchangeOAuthToken", "Lcn/gitlab/kilo/jetbrains/services/ProxyMessageService$OAuthTokenResponse;", "gitlabHost", "clientId", "code", "codeVerifier", "buildOAuthAuthorizeUrl", "state", "codeChallenge", "generateSecret", "bytes", "createCodeChallenge", "verifier", "parseQueryParams", "", "query", "respondHtml", "status", "message", "execute", "OAuthLoginSession", "OAuthTokenResponse", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nProxyMessageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyMessageService.kt\ncn/gitlab/kilo/jetbrains/services/ProxyMessageService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,521:1\n1#2:522\n1#2:533\n1617#3,9:523\n1869#3:532\n1870#3:534\n1626#3:535\n*S KotlinDebug\n*F\n+ 1 ProxyMessageService.kt\ncn/gitlab/kilo/jetbrains/services/ProxyMessageService\n*L\n481#1:533\n481#1:523,9\n481#1:532\n481#1:534\n481#1:535\n*E\n"})
public final class ProxyMessageService
implements WebviewMessageProxy {
    @NotNull
    private final Logger logger = Logger.Companion.getInstance("LoginMessageService");
    private final int oauthCallbackPort;
    @NotNull
    private final String oauthRedirectUri = "http://localhost:" + this.oauthCallbackPort;
    @NotNull
    private final String oauthScopes;
    @NotNull
    private final Object oauthServerLock = new Object();

    public ProxyMessageService() {
        this.oauthCallbackPort = 8203;
        this.oauthScopes = "api";
    }

    @Nullable
    public final Object handle(@Nullable String msg, @NotNull Project project, @Nullable WebViewInstance webViewInstance, @NotNull Continuation<? super Boolean> $completion) {
        Object object;
        Object command;
        JsonObject jsonObject2 = JsonParser.parseString((String)msg).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
        JsonObject msgJsonObject = jsonObject2;
        Object object2 = msgJsonObject.get("command");
        if (object2 == null || (object2 = object2.getAsString()) == null) {
            object2 = command = "";
        }
        if ((object = msgJsonObject.get("requestId")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        Object requestId = object;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String os = string2;
        LoggerAdapter.DefaultImpls.debug$default(this.logger, "command: " + (String)command + ", requestId: " + (String)requestId + ", msg: " + msg, null, 2, null);
        try {
            switch (command) {
                case "loginViaPAT": {
                    LoginViaPAT login;
                    String string3 = msg;
                    if (string3 != null) {
                        String it = string3;
                        boolean bl = false;
                        v6 = (LoginViaPAT)new Gson().fromJson(it, LoginViaPAT.class);
                    } else {
                        v6 = login = null;
                    }
                    if (login != null) {
                        this.handleLoginViaPAT(StringsKt.removeSuffix((String)login.getCoderiderHost(), (CharSequence)"/"), login.getToken(), project);
                        CockpitConfiguration.Companion.getInstance().getState().setSavePAT(login.getSavePAT());
                        if (login.getSavePAT()) {
                            CockpitConfiguration.Companion.getInstance().getState().setGitlabPAT(login.getToken());
                        }
                        CoderiderClientKt.refreshOtherProjects(project);
                    }
                    break;
                }
                case "loginViaOAuth": {
                    LoginViaOAuth login;
                    String string4 = msg;
                    if (string4 != null) {
                        String it = string4;
                        boolean bl = false;
                        v8 = (LoginViaOAuth)new Gson().fromJson(it, LoginViaOAuth.class);
                    } else {
                        v8 = login = null;
                    }
                    if (login != null) {
                        ThemeUtilKt.webLaunchInScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, login, project, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ ProxyMessageService this$0;
                            final /* synthetic */ LoginViaOAuth $login;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$login = $login;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Object object2;
                                        CoroutineScope $this$webLaunchInScope;
                                        ResultKt.throwOnFailure((Object)object);
                                        Object object3 = $this$webLaunchInScope = (CoroutineScope)this.L$0;
                                        ProxyMessageService proxyMessageService = this.this$0;
                                        LoginViaOAuth loginViaOAuth = this.$login;
                                        Object object4 = this.$project;
                                        try {
                                            boolean bl = false;
                                            ProxyMessageService.access$handleLoginViaOAuth(proxyMessageService, loginViaOAuth.getPayload(), (Project)object4);
                                            object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                                        }
                                        catch (Throwable bl) {
                                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                                        }
                                        object3 = object2;
                                        proxyMessageService = this.this$0;
                                        loginViaOAuth = this.$project;
                                        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                                        if (throwable != null) {
                                            Object e = object4 = throwable;
                                            boolean bl = false;
                                            ProxyMessageService.access$getLogger$p(proxyMessageService).warn("OAuth login failed: " + ((Throwable)e).getMessage(), (Throwable)e);
                                            String string = ((Throwable)e).getMessage();
                                            if (string == null) {
                                                string = "unknown error";
                                            }
                                            ThemeUtilKt.sendToWebview((ExtensionMessage)new MessageTip(null, "error", "OAuth login failed: " + string, 1, null), (Project)loginViaOAuth);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                    }
                    return Boxing.boxBoolean((boolean)true);
                }
                case "routed": {
                    String it = msg;
                    boolean bl = false;
                    Routed routed = (Routed)new Gson().fromJson(it, Routed.class);
                    if (routed != null) {
                        Routed routed2 = routed;
                        boolean bl2 = false;
                        String string5 = System.getProperty("os.name");
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProperty(...)");
                        String string6 = string5.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                        String os2 = string6;
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"os", (Object)(SystemInfo.isMac ? "darwin" : os2)), TuplesKt.to((Object)"theme", (Object)ThemeUtilKt.getThemeIsDark())};
                        ThemeUtilKt.sendToWebview((ExtensionMessage)new GlobalStatus(null, MapsKt.mutableMapOf((Pair[])pairArray), 1, null), project);
                        if (Intrinsics.areEqual((Object)routed2.getPage(), (Object)"/issue_mr")) {
                            LoggerAdapter.DefaultImpls.debug$default(this.logger, "initIssueMr begin", null, 2, null);
                            IssueHandler.INSTANCE.initIssueMr(project);
                            LoggerAdapter.DefaultImpls.debug$default(this.logger, "initIssueMr end", null, 2, null);
                            return Boxing.boxBoolean((boolean)true);
                        }
                    }
                    break;
                }
                case "issueMrOpenProject": 
                case "issueMrGetIssue": 
                case "command": 
                case "issueMrGetDiff": {
                    String string7 = msg;
                    if (string7 != null) {
                        String it = string7;
                        boolean bl = false;
                        return GitlabHandler.INSTANCE.handle(project, (String)command, it);
                    }
                    break;
                }
                case "exportModelList": {
                    LoggerAdapter.DefaultImpls.debug$default(this.logger, "exportModelList: Handling model export", null, 2, null);
                    JsonElement models = msgJsonObject.get("models");
                    if (models == null || models.isJsonNull()) {
                        LoggerAdapter.DefaultImpls.warn$default(this.logger, "exportModelList: No model data in message payload", null, 2, null);
                        return Boxing.boxBoolean((boolean)false);
                    }
                    String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    String filename = "coderider_model_" + timestamp + ".json";
                    String string8 = new GsonBuilder().setPrettyPrinting().create().toJson(models);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toJson(...)");
                    FileUtilsKt.writeFile(project, filename, string8);
                    LoggerAdapter.DefaultImpls.info$default(this.logger, "exportModelList: Successfully saved VSCode model data with " + models.getAsJsonArray().size() + " models", null, 2, null);
                    return Boxing.boxBoolean((boolean)true);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private final Object injectVSUserAgent(Project project, Continuation<? super Unit> $completion) {
        IRPCProtocol iRPCProtocol = PluginContext.Companion.getInstance(project).getRPCProtocol();
        if (iRPCProtocol == null) {
            throw new IllegalStateException("RPC protocol is null; cannot inject UA");
        }
        IRPCProtocol rpc = iRPCProtocol;
        ExtHostCommandsProxy extHostCommandsProxy = rpc.getProxy(ServiceProxyRegistry.ExtHostContext.INSTANCE.getExtHostCommands());
        if (extHostCommandsProxy == null) {
            throw new IllegalStateException("ExtHostCommands proxy not found; cannot inject UA");
        }
        ExtHostCommandsProxy proxy = extHostCommandsProxy;
        String ua = ClientUtilsKt.getSystemInfo();
        Object[] objectArray = new Object[]{ua};
        Object object = PromiseUtilsKt.await(proxy.executeContributedCommand("coderider-kilo.setUserAgent", objectArray), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void handleDiscoverServers(String url, Project project) {
        CoderiderClientKt.setCoderiderClient(new CoderiderClient(url));
        CoderiderClientKt.getCoderiderClient().queryPublicConfig();
        CockpitConfiguration.PluginState state = CockpitConfiguration.Companion.getInstance().getState();
        String gitlabUrl = state.getGitlabHost();
        LoginServerDiscovery msg = new LoginServerDiscovery(null, new BackendServer(null, gitlabUrl, 1, null), 1, null);
        ThemeUtilKt.sendToWebview((ExtensionMessage)msg, project);
    }

    private final void handleLoginViaPAT(String url, String PAT, Project project) {
        String tempUrl = url;
        if (tempUrl.equals("https://jihulab.com")) {
            tempUrl = "https://coderider.jihulab.com";
        }
        CoderiderClientKt.setCoderiderClient(new CoderiderClient(tempUrl));
        try {
            CockpitConfiguration.Companion.getInstance().getState().setGitlabAccessToken(null);
            CockpitConfiguration.Companion.getInstance().getState().setGitlabRefreshToken(null);
            CockpitConfiguration.Companion.getInstance().getState().setGitlabAccessTokenExpiresAt(null);
            CockpitConfiguration.Companion.getInstance().getState().setGitlabOAuthClientId(null);
            CockpitConfiguration.Companion.getInstance().getState().setGitlabOAuthScopes(null);
            CockpitConfiguration.Companion.getInstance().getState().setGitlabPAT(PAT);
            CoderiderClient.refreshMetaData$default(CoderiderClientKt.getCoderiderClient(), 0, 0L, 3, null);
        }
        catch (CustomException e) {
            Object message = "\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbf\u95ee\u4ee4\u724c\u662f\u5426\u6709\u6548: " + e.getMessage();
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"License Invalid", (boolean)false, (int)2, null) : false;
            if (bl) {
                message = I18nKt.getMessage("enterprise.coderider.license.invalid");
            }
            e.printStackTrace();
            MessageTip msg = new MessageTip(null, "error", (String)message, 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, project);
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            MessageTip msg = new MessageTip(null, "error", "\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbf\u95ee\u4ee4\u724c\u662f\u5426\u6709\u6548: " + e.getMessage(), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, project);
            return;
        }
        this.logUserIn();
        LoggerAdapter.DefaultImpls.info$default(this.logger, "command: handleLoginViaPAT, User Login Success!,url:" + url, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean startOAuthSession(OAuthLoginSession session) {
        Object object = this.oauthServerLock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                OAuthLoginSession activeSession = ProxyMessageServiceKt.access$getOauthLoginSession$p();
                if (activeSession == null || activeSession.getCodeFuture().isDone()) break block4;
                boolean bl2 = false;
                return bl2;
            }
            ProxyMessageServiceKt.access$setOauthLoginSession$p(session);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishOAuthSession(OAuthLoginSession session) {
        Object object = this.oauthServerLock;
        synchronized (object) {
            boolean bl = false;
            if (ProxyMessageServiceKt.access$getOauthLoginSession$p() != session) {
                return;
            }
            HttpServer httpServer = ProxyMessageServiceKt.access$getOauthServer$p();
            if (httpServer != null) {
                httpServer.stop(0);
            }
            ExecutorService executorService = ProxyMessageServiceKt.access$getOauthServerExecutor$p();
            if (executorService != null) {
                executorService.shutdownNow();
            }
            ProxyMessageServiceKt.access$setOauthServer$p(null);
            ProxyMessageServiceKt.access$setOauthServerExecutor$p(null);
            ProxyMessageServiceKt.access$setOauthLoginSession$p(null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureOAuthServer() {
        Object object = this.oauthServerLock;
        synchronized (object) {
            HttpServer httpServer;
            boolean bl = false;
            if (ProxyMessageServiceKt.access$getOauthServer$p() != null) {
                return;
            }
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                httpServer = HttpServer.create(new InetSocketAddress("127.0.0.1", this.oauthCallbackPort), 0);
            }
            catch (Throwable e) {
                executor.shutdownNow();
                throw e;
            }
            HttpServer server = httpServer;
            server.createContext("/", arg_0 -> ProxyMessageService.ensureOAuthServer$lambda$8$lambda$7(this, arg_0));
            server.setExecutor(executor);
            try {
                server.start();
            }
            catch (Throwable e) {
                server.stop(0);
                executor.shutdownNow();
                throw e;
            }
            ProxyMessageServiceKt.access$setOauthServer$p(server);
            ProxyMessageServiceKt.access$setOauthServerExecutor$p(executor);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleOAuthCallback(HttpExchange exchange) {
        if (!Intrinsics.areEqual((Object)exchange.getRequestMethod(), (Object)"GET")) {
            this.respondHtml(exchange, 405, "Method not allowed.");
            return;
        }
        Map<String, String> params = this.parseQueryParams(exchange.getRequestURI().getRawQuery());
        String code = params.get("code");
        String returnedState = params.get("state");
        OAuthLoginSession session = ProxyMessageServiceKt.access$getOauthLoginSession$p();
        if (session == null) {
            this.respondHtml(exchange, 409, "No login in progress.");
        } else {
            CharSequence charSequence = code;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)returnedState) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this.respondHtml(exchange, 400, "Missing code or state.");
            } else {
                try {
                    this.respondHtml(exchange, 200, "Login completed. You can close this tab.");
                }
                finally {
                    if (!session.getCodeFuture().isDone()) {
                        session.getCodeFuture().complete(code);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleLoginViaOAuth(OAuthLoginPayload payload, Project project) {
        CockpitConfiguration.PluginState pluginState;
        Long l;
        String string;
        String inviteCode;
        String gitlabHost = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)payload.getGitlabHost())).toString(), (CharSequence)"/");
        String coderiderHost = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)payload.getCoderiderHost())).toString(), (CharSequence)"/");
        String clientId = payload.getClientId();
        String string2 = payload.getInviteCode();
        if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            v1 = ((CharSequence)it).length() > 0 ? string3 : null;
        } else {
            v1 = inviteCode = null;
        }
        if (StringsKt.isBlank((CharSequence)gitlabHost) || StringsKt.isBlank((CharSequence)coderiderHost) || StringsKt.isBlank((CharSequence)clientId)) {
            ThemeUtilKt.sendToWebview((ExtensionMessage)new MessageTip(null, "error", "OAuth configuration is incomplete. Check host and client ID.", 1, null), project);
            return;
        }
        String state = ProxyMessageService.generateSecret$default(this, 0, 1, null);
        String codeVerifier = ProxyMessageService.generateSecret$default(this, 0, 1, null);
        String codeChallenge = this.createCodeChallenge(codeVerifier);
        String authUrl = this.buildOAuthAuthorizeUrl(gitlabHost, clientId, state, codeChallenge);
        CompletableFuture<String> codeFuture = new CompletableFuture<String>();
        OAuthLoginSession session = new OAuthLoginSession(state, codeFuture);
        if (!this.startOAuthSession(session)) {
            ThemeUtilKt.sendToWebview((ExtensionMessage)new MessageTip(null, "error", "OAuth login is already in progress. Please wait.", 1, null), project);
            return;
        }
        try {
            this.ensureOAuthServer();
        }
        catch (Throwable e) {
            this.finishOAuthSession(session);
            throw e;
        }
        ThemeUtilKt.sendToWebview((ExtensionMessage)new MessageTip(null, "info", "OAuth login started. Waiting for the redirect...", 1, null), project);
        try {
            BrowserUtil.browse((String)authUrl);
            string = codeFuture.get(120L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            Object object;
            if (e instanceof TimeoutException) {
                object = "OAuth login timed out. Please try again.";
            } else {
                String string4 = e.getMessage();
                if (string4 == null) {
                    string4 = "unknown error";
                }
                object = "OAuth login failed: " + string4;
            }
            String message = object;
            ThemeUtilKt.sendToWebview((ExtensionMessage)new MessageTip(null, "error", message, 1, null), project);
            return;
        }
        finally {
            this.finishOAuthSession(session);
        }
        String code = string;
        Intrinsics.checkNotNull((Object)code);
        OAuthTokenResponse tokenResponse = this.exchangeOAuthToken(gitlabHost, clientId, code, codeVerifier);
        if (StringsKt.isBlank((CharSequence)tokenResponse.getAccessToken())) {
            ThemeUtilKt.sendToWebview((ExtensionMessage)new MessageTip(null, "error", "OAuth login failed: empty access token.", 1, null), project);
            return;
        }
        CoderiderClientKt.setCoderiderClient(new CoderiderClient(coderiderHost));
        Long l2 = tokenResponse.getCreatedAt();
        if (l2 != null) {
            long created = ((Number)l2).longValue();
            boolean bl = false;
            Long l3 = tokenResponse.getExpiresIn();
            if (l3 != null) {
                long it = ((Number)l3).longValue();
                boolean bl2 = false;
                l = created + it;
            } else {
                l = null;
            }
        } else {
            l = null;
        }
        Long expiresAtSeconds = l;
        CockpitConfiguration.PluginState $this$handleLoginViaOAuth_u24lambda_u2412 = pluginState = CockpitConfiguration.Companion.getInstance().getState();
        boolean bl = false;
        $this$handleLoginViaOAuth_u24lambda_u2412.setGitlabAccessToken(tokenResponse.getAccessToken());
        $this$handleLoginViaOAuth_u24lambda_u2412.setGitlabRefreshToken(tokenResponse.getRefreshToken());
        $this$handleLoginViaOAuth_u24lambda_u2412.setGitlabAccessTokenExpiresAt(expiresAtSeconds);
        $this$handleLoginViaOAuth_u24lambda_u2412.setGitlabOAuthClientId(clientId);
        $this$handleLoginViaOAuth_u24lambda_u2412.setGitlabOAuthScopes(this.oauthScopes);
        if (!$this$handleLoginViaOAuth_u24lambda_u2412.getSavePAT()) {
            $this$handleLoginViaOAuth_u24lambda_u2412.setGitlabPAT(null);
        }
        $this$handleLoginViaOAuth_u24lambda_u2412.setGitlabHost(gitlabHost);
        $this$handleLoginViaOAuth_u24lambda_u2412.setCoderiderServerHost(coderiderHost);
        CoderiderClientKt.getCoderiderClient().loginWithGitlabToken(tokenResponse.getAccessToken(), true, inviteCode);
        this.logUserIn();
        CoderiderClientKt.refreshOtherProjects$default(null, 1, null);
        ThemeUtilKt.sendToWebview((ExtensionMessage)new MessageTip(null, "success", "OAuth login succeeded.", 1, null), project);
    }

    private final void logUserIn() {
        TrackService.INSTANCE.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OAuthTokenResponse exchangeOAuthToken(String gitlabHost, String clientId, String code, String codeVerifier) {
        String url = StringsKt.removeSuffix((String)gitlabHost, (CharSequence)"/") + "/oauth/token";
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)clientId), TuplesKt.to((Object)"redirect_uri", (Object)this.oauthRedirectUri), TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"code_verifier", (Object)codeVerifier)};
        String body = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"&", null, null, (int)0, null, ProxyMessageService::exchangeOAuthToken$lambda$13, (int)30, null);
        Request request = new Request.Builder().url(url).post(RequestBody.Companion.create(body, MediaType.Companion.get("application/x-www-form-urlencoded"))).build();
        OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().build();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            String responseBody;
            Response response = (Response)closeable;
            boolean bl = false;
            ResponseBody responseBody2 = response.body();
            String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
            if (!response.isSuccessful() || responseBody == null) {
                throw new CustomException("OAuth token exchange failed: " + response.code() + " " + response.message());
            }
            Object object = new Gson().fromJson(responseBody, OAuthTokenResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            OAuthTokenResponse oAuthTokenResponse = (OAuthTokenResponse)object;
            return oAuthTokenResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String buildOAuthAuthorizeUrl(String gitlabHost, String clientId, String state, String codeChallenge) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)clientId), TuplesKt.to((Object)"redirect_uri", (Object)this.oauthRedirectUri), TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"state", (Object)state), TuplesKt.to((Object)"scope", (Object)this.oauthScopes), TuplesKt.to((Object)"code_challenge", (Object)codeChallenge), TuplesKt.to((Object)"code_challenge_method", (Object)"S256")};
        String query = CollectionsKt.joinToString$default((Iterable)MapsKt.mapOf((Pair[])pairArray).entrySet(), (CharSequence)"&", null, null, (int)0, null, ProxyMessageService::buildOAuthAuthorizeUrl$lambda$15, (int)30, null);
        return StringsKt.removeSuffix((String)gitlabHost, (CharSequence)"/") + "/oauth/authorize?" + query;
    }

    private final String generateSecret(int bytes) {
        byte[] buffer = new byte[bytes];
        new SecureRandom().nextBytes(buffer);
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(buffer);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    static /* synthetic */ String generateSecret$default(ProxyMessageService proxyMessageService, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 32;
        }
        return proxyMessageService.generateSecret(n);
    }

    private final String createCodeChallenge(String verifier) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = verifier;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] digest = messageDigest.digest(byArray);
        String string2 = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseQueryParams(String query) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = (String[])query;
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
            return MapsKt.emptyMap();
        }
        stringArray = new String[]{"&"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)query, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String part = (String)element$iv$iv;
            boolean bl2 = false;
            int idx = StringsKt.indexOf$default((CharSequence)part, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (idx <= 0) {
                pair = null;
            } else {
                String string = part.substring(0, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String key = URLDecoder.decode(string, StandardCharsets.UTF_8);
                String string2 = part.substring(idx + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String value = URLDecoder.decode(string2, StandardCharsets.UTF_8);
                pair = TuplesKt.to((Object)key, (Object)value);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void respondHtml(HttpExchange exchange, int status, String message) {
        String body = StringsKt.trimIndent((String)("\n            <!doctype html>\n            <html lang=\"en\">\n              <head>\n                <meta charset=\"utf-8\" />\n                <title>OAuth Login</title>\n              </head>\n              <body>\n                <p>" + message + "</p>\n              </body>\n            </html>\n        "));
        Object object = body;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        exchange.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
        exchange.sendResponseHeaders(status, bytes.length);
        object = exchange.getResponseBody();
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl = false;
            it.write(bytes);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        exchange.close();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object execute(@Nullable String var1_1, @NotNull Project var2_2, @NotNull WebViewInstance var3_3, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var7_5 = $completion;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ProxyMessageService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = JsonParser.parseString((String)msg).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAsJsonObject(...)");
                msgJsonObject = v0;
                v1 /* !! */  = msgJsonObject.get("command");
                if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getAsString()) == null) {
                    v1 /* !! */  = "";
                }
                $continuation.label = 1;
                v2 = this.handle((String)msg, (Project)project, (WebViewInstance)webViewInstance, (Continuation<? super Boolean>)$continuation);
                if (v2 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl26:
                // 2 sources

                v3 = (Boolean)v2;
                return Boxing.boxBoolean((boolean)(v3 != null ? v3 : false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void ensureOAuthServer$lambda$8$lambda$7(ProxyMessageService this$0, HttpExchange exchange) {
        Intrinsics.checkNotNull((Object)exchange);
        this$0.handleOAuthCallback(exchange);
    }

    private static final CharSequence exchangeOAuthToken$lambda$13(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String key = (String)pair.component1();
        String value = (String)pair.component2();
        return key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private static final CharSequence buildOAuthAuthorizeUrl$lambda$15(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        return key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ void access$handleLoginViaOAuth(ProxyMessageService $this, OAuthLoginPayload payload, Project project) {
        $this.handleLoginViaOAuth(payload, project);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ProxyMessageService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$injectVSUserAgent(ProxyMessageService $this, Project project, Continuation $completion) {
        return $this.injectVSUserAgent(project, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcn/gitlab/kilo/jetbrains/services/ProxyMessageService$OAuthLoginSession;", "", "state", "", "codeFuture", "Ljava/util/concurrent/CompletableFuture;", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/CompletableFuture;)V", "getState", "()Ljava/lang/String;", "getCodeFuture", "()Ljava/util/concurrent/CompletableFuture;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    public static final class OAuthLoginSession {
        @NotNull
        private final String state;
        @NotNull
        private final CompletableFuture<String> codeFuture;

        public OAuthLoginSession(@NotNull String state, @NotNull CompletableFuture<String> codeFuture) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter(codeFuture, (String)"codeFuture");
            this.state = state;
            this.codeFuture = codeFuture;
        }

        @NotNull
        public final String getState() {
            return this.state;
        }

        @NotNull
        public final CompletableFuture<String> getCodeFuture() {
            return this.codeFuture;
        }

        @NotNull
        public final String component1() {
            return this.state;
        }

        @NotNull
        public final CompletableFuture<String> component2() {
            return this.codeFuture;
        }

        @NotNull
        public final OAuthLoginSession copy(@NotNull String state, @NotNull CompletableFuture<String> codeFuture) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter(codeFuture, (String)"codeFuture");
            return new OAuthLoginSession(state, codeFuture);
        }

        public static /* synthetic */ OAuthLoginSession copy$default(OAuthLoginSession oAuthLoginSession, String string, CompletableFuture completableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                string = oAuthLoginSession.state;
            }
            if ((n & 2) != 0) {
                completableFuture = oAuthLoginSession.codeFuture;
            }
            return oAuthLoginSession.copy(string, completableFuture);
        }

        @NotNull
        public String toString() {
            return "OAuthLoginSession(state=" + this.state + ", codeFuture=" + this.codeFuture + ")";
        }

        public int hashCode() {
            int result2 = this.state.hashCode();
            result2 = result2 * 31 + this.codeFuture.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OAuthLoginSession)) {
                return false;
            }
            OAuthLoginSession oAuthLoginSession = (OAuthLoginSession)other;
            if (!Intrinsics.areEqual((Object)this.state, (Object)oAuthLoginSession.state)) {
                return false;
            }
            return Intrinsics.areEqual(this.codeFuture, oAuthLoginSession.codeFuture);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ<\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcn/gitlab/kilo/jetbrains/services/ProxyMessageService$OAuthTokenResponse;", "", "accessToken", "", "refreshToken", "expiresIn", "", "createdAt", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)V", "getAccessToken", "()Ljava/lang/String;", "getRefreshToken", "getExpiresIn", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getCreatedAt", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)Lcn/gitlab/kilo/jetbrains/services/ProxyMessageService$OAuthTokenResponse;", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class OAuthTokenResponse {
        @SerializedName(value="access_token")
        @NotNull
        private final String accessToken;
        @SerializedName(value="refresh_token")
        @Nullable
        private final String refreshToken;
        @SerializedName(value="expires_in")
        @Nullable
        private final Long expiresIn;
        @SerializedName(value="created_at")
        @Nullable
        private final Long createdAt;

        public OAuthTokenResponse(@NotNull String accessToken, @Nullable String refreshToken, @Nullable Long expiresIn, @Nullable Long createdAt) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expiresIn = expiresIn;
            this.createdAt = createdAt;
        }

        public /* synthetic */ OAuthTokenResponse(String string, String string2, Long l, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                l = null;
            }
            if ((n & 8) != 0) {
                l2 = null;
            }
            this(string, string2, l, l2);
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @Nullable
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @Nullable
        public final Long getExpiresIn() {
            return this.expiresIn;
        }

        @Nullable
        public final Long getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @Nullable
        public final String component2() {
            return this.refreshToken;
        }

        @Nullable
        public final Long component3() {
            return this.expiresIn;
        }

        @Nullable
        public final Long component4() {
            return this.createdAt;
        }

        @NotNull
        public final OAuthTokenResponse copy(@NotNull String accessToken, @Nullable String refreshToken, @Nullable Long expiresIn, @Nullable Long createdAt) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return new OAuthTokenResponse(accessToken, refreshToken, expiresIn, createdAt);
        }

        public static /* synthetic */ OAuthTokenResponse copy$default(OAuthTokenResponse oAuthTokenResponse, String string, String string2, Long l, Long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = oAuthTokenResponse.accessToken;
            }
            if ((n & 2) != 0) {
                string2 = oAuthTokenResponse.refreshToken;
            }
            if ((n & 4) != 0) {
                l = oAuthTokenResponse.expiresIn;
            }
            if ((n & 8) != 0) {
                l2 = oAuthTokenResponse.createdAt;
            }
            return oAuthTokenResponse.copy(string, string2, l, l2);
        }

        @NotNull
        public String toString() {
            return "OAuthTokenResponse(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresIn=" + this.expiresIn + ", createdAt=" + this.createdAt + ")";
        }

        public int hashCode() {
            int result2 = this.accessToken.hashCode();
            result2 = result2 * 31 + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
            result2 = result2 * 31 + (this.expiresIn == null ? 0 : ((Object)this.expiresIn).hashCode());
            result2 = result2 * 31 + (this.createdAt == null ? 0 : ((Object)this.createdAt).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OAuthTokenResponse)) {
                return false;
            }
            OAuthTokenResponse oAuthTokenResponse = (OAuthTokenResponse)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)oAuthTokenResponse.accessToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)oAuthTokenResponse.refreshToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiresIn, (Object)oAuthTokenResponse.expiresIn)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.createdAt, (Object)oAuthTokenResponse.createdAt);
        }
    }
}

