/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BG\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u001a\u001a\u00020\n2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bJ,\u0010\u001e\u001a\u00020\u001f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcn/gitlab/kilo/jetbrains/services/CockpitHintRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "multilineKeyMap", "", "multilineText", "enhanceKeyMap", "enhanceText", "editor", "Lcom/intellij/openapi/editor/Editor;", "pointX", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/editor/Editor;I)V", "getMultilineKeyMap", "()Ljava/lang/String;", "getMultilineText", "getEnhanceKeyMap", "getEnhanceText", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getPointX", "()I", "themeAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "icon", "Ljavax/swing/Icon;", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getTextAttributesForEditor", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "fontInfoForText", "Lcom/intellij/openapi/editor/impl/FontInfo;", "text", "getCurrentTextColor", "Ljava/awt/Color;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nHintRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HintRender.kt\ncn/gitlab/kilo/jetbrains/services/CockpitHintRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public class CockpitHintRenderer
implements EditorCustomElementRenderer {
    @Nullable
    private final String multilineKeyMap;
    @Nullable
    private final String multilineText;
    @Nullable
    private final String enhanceKeyMap;
    @Nullable
    private final String enhanceText;
    @NotNull
    private final Editor editor;
    private final int pointX;
    @NotNull
    private final TextAttributes themeAttributes;
    @NotNull
    private final Icon icon;

    public CockpitHintRenderer(@Nullable String multilineKeyMap, @Nullable String multilineText, @Nullable String enhanceKeyMap, @Nullable String enhanceText, @NotNull Editor editor, int pointX) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.multilineKeyMap = multilineKeyMap;
        this.multilineText = multilineText;
        this.enhanceKeyMap = enhanceKeyMap;
        this.enhanceText = enhanceText;
        this.editor = editor;
        this.pointX = pointX;
        this.icon = IconLoader.getIcon((String)"/icons/common/coderider-gray.svg", this.getClass());
        this.themeAttributes = this.getTextAttributesForEditor(this.editor);
    }

    public /* synthetic */ CockpitHintRenderer(String string, String string2, String string3, String string4, Editor editor, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            string4 = null;
        }
        this(string, string2, string3, string4, editor, n);
    }

    @Nullable
    public final String getMultilineKeyMap() {
        return this.multilineKeyMap;
    }

    @Nullable
    public final String getMultilineText() {
        return this.multilineText;
    }

    @Nullable
    public final String getEnhanceKeyMap() {
        return this.enhanceKeyMap;
    }

    @Nullable
    public final String getEnhanceText() {
        return this.enhanceText;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final int getPointX() {
        return this.pointX;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        int iconWidth = this.icon.getIconWidth();
        int spaceWidth = this.fontInfoForText(" ").fontMetrics().stringWidth(" ");
        int keyMapWidth = CockpitHintRenderer.calcWidthInPixels$calculateWidth(spaceWidth, this, this.multilineKeyMap);
        int textWidth = CockpitHintRenderer.calcWidthInPixels$calculateWidth(spaceWidth, this, this.multilineText);
        int enhanceKeyMapWidth = CockpitHintRenderer.calcWidthInPixels$calculateWidth(spaceWidth, this, this.enhanceKeyMap);
        int enhanceTextWidth = CockpitHintRenderer.calcWidthInPixels$calculateWidth(spaceWidth, this, this.enhanceText);
        return iconWidth + spaceWidth + keyMapWidth + spaceWidth + textWidth + spaceWidth + enhanceKeyMapWidth + spaceWidth + enhanceTextWidth + spaceWidth;
    }

    @NotNull
    public final TextAttributes getTextAttributesForEditor(@NotNull Editor editor) {
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        try {
            textAttributes = editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLAY_TEXT_WITHOUT_BACKGROUND);
            Intrinsics.checkNotNull((Object)textAttributes);
        }
        catch (Exception ignored) {
            TextAttributes textAttributes2 = editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
            Intrinsics.checkNotNull((Object)textAttributes2);
            textAttributes = textAttributes2;
        }
        return textAttributes;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        block11: {
            Font enhanceTextFont;
            Font font;
            Font enhanceKeyMapFont;
            Font font2;
            Font multilineTextFont;
            Font font3;
            Font multilineKeyMapFont;
            Font font4;
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            int spaceWidth = this.fontInfoForText(" ").fontMetrics().stringWidth(" ");
            int iconX = targetRegion.x + this.pointX;
            int iconY = targetRegion.y + (targetRegion.height - this.icon.getIconHeight()) / 2;
            this.icon.paintIcon(null, g, iconX, iconY);
            Ref.IntRef currentX = new Ref.IntRef();
            currentX.element = iconX + this.icon.getIconWidth() + spaceWidth;
            Color keyMapColor = new Color(173, 216, 230);
            Color textColor = this.getCurrentTextColor(this.editor);
            String string = this.multilineKeyMap;
            if (string != null) {
                String it = string;
                boolean bl = false;
                font4 = this.fontInfoForText(it).getFont().deriveFont(0);
            } else {
                font4 = null;
            }
            Font font5 = multilineKeyMapFont = font4;
            if (font5 != null) {
                Font it = font5;
                boolean bl = false;
                CockpitHintRenderer.paint$drawTextIfNotNull(g, currentX, targetRegion, spaceWidth, this.multilineKeyMap, it, keyMapColor);
            }
            String string2 = this.multilineText;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                font3 = this.fontInfoForText(it).getFont();
            } else {
                font3 = null;
            }
            Font font6 = multilineTextFont = font3;
            if (font6 != null) {
                Font it = font6;
                boolean bl = false;
                CockpitHintRenderer.paint$drawTextIfNotNull(g, currentX, targetRegion, spaceWidth, this.multilineText, it, textColor);
            }
            String string3 = this.enhanceKeyMap;
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                font2 = this.fontInfoForText(it).getFont();
            } else {
                font2 = null;
            }
            Font font7 = enhanceKeyMapFont = font2;
            if (font7 != null) {
                Font it = font7;
                boolean bl = false;
                CockpitHintRenderer.paint$drawTextIfNotNull(g, currentX, targetRegion, spaceWidth, this.enhanceKeyMap, it, keyMapColor);
            }
            String string4 = this.enhanceText;
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                font = this.fontInfoForText(it).getFont();
            } else {
                font = null;
            }
            Font font8 = enhanceTextFont = font;
            if (font8 == null) break block11;
            Font it = font8;
            boolean bl = false;
            CockpitHintRenderer.paint$drawTextIfNotNull(g, currentX, targetRegion, spaceWidth, this.enhanceText, it, textColor);
        }
    }

    @NotNull
    public final FontInfo fontInfoForText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        FontPreferencesImpl preferences = new FontPreferencesImpl();
        this.editor.getColorsScheme().getFontPreferences().copyTo((FontPreferences)preferences);
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((CharSequence)text, (int)0, (int)text.length(), (int)2, (FontPreferences)((FontPreferences)preferences), (FontRenderContext)FontInfo.getFontRenderContext((Component)this.editor.getContentComponent()));
        Intrinsics.checkNotNullExpressionValue((Object)fontInfo, (String)"getFontAbleToDisplay(...)");
        return fontInfo;
    }

    @NotNull
    public final Color getCurrentTextColor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme colorsScheme = editorColorsScheme;
        Color color = colorsScheme.getColor(EditorColors.ANNOTATIONS_COLOR);
        if (color == null) {
            Color color2 = Color.BLACK;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        }
        return color;
    }

    private static final int calcWidthInPixels$calculateWidth(int spaceWidth, CockpitHintRenderer this$0, String text) {
        int n;
        String string = text;
        if (string != null) {
            String it = string;
            boolean bl = false;
            n = spaceWidth + this$0.fontInfoForText(it).fontMetrics().stringWidth(it);
        } else {
            n = 0;
        }
        return n;
    }

    private static final void paint$drawTextIfNotNull(Graphics $g, Ref.IntRef currentX, Rectangle $targetRegion, int spaceWidth, String text, Font font, Color color) {
        if (text != null) {
            $g.setFont(font);
            $g.setColor(color);
            $g.drawString(text, currentX.element, $targetRegion.y + ($targetRegion.height + $g.getFontMetrics().getAscent()) / 2 - $g.getFontMetrics().getDescent());
            currentX.element += $g.getFontMetrics().stringWidth(text) + spaceWidth;
        }
    }
}

