/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.auth.MissingJcefPanel;
import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.ComposerProvider;
import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import cn.gitlab.kilo.jetbrains.factories.CustomLifeSpanHandler;
import cn.gitlab.kilo.jetbrains.factories.CustomerRequestHandler;
import cn.gitlab.kilo.jetbrains.factories.SchemeHandlerRegistrar;
import cn.gitlab.kilo.jetbrains.services.BrowserServiceKt;
import cn.gitlab.kilo.jetbrains.services.CockpitChatPluginServiceKt;
import cn.gitlab.kilo.jetbrains.services.MessageHandler;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.sina.weibo.agent.provider.LoggerAdapter;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcn/gitlab/kilo/jetbrains/services/CockpitChatWindow;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "ioCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getLogger", "()Lcn/gitlab/kilo/jetbrains/common/Logger;", "startTime", "", "webView", "Lcom/intellij/ui/jcef/JBCefBrowser;", "getWebView", "()Lcom/intellij/ui/jcef/JBCefBrowser;", "setWebView", "(Lcom/intellij/ui/jcef/JBCefBrowser;)V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "composerProvider", "Lcn/gitlab/kilo/jetbrains/composer/ComposerProvider;", "reload", "", "onThemeChanged", "()Lkotlin/Unit;", "dispose", "createBrowser", "getContentPane", "Ljavax/swing/JComponent;", "registerAppSchemeHandler", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCockpitChatPluginService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CockpitChatPluginService.kt\ncn/gitlab/kilo/jetbrains/services/CockpitChatWindow\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n31#2,2:184\n1#3:186\n*S KotlinDebug\n*F\n+ 1 CockpitChatPluginService.kt\ncn/gitlab/kilo/jetbrains/services/CockpitChatWindow\n*L\n68#1:184,2\n*E\n"})
public final class CockpitChatWindow
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope ioCoroutineScope;
    @NotNull
    private final Logger logger;
    private final long startTime;
    @Nullable
    private JBCefBrowser webView;
    @NotNull
    private final Gson gson;
    @NotNull
    private final ComposerProvider composerProvider;

    public CockpitChatWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.ioCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.logger = Logger.Companion.getInstance("CockpitChatWindow");
        this.startTime = System.currentTimeMillis();
        this.gson = new Gson();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ComposerProvider> serviceClass$iv = ComposerProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.composerProvider = (ComposerProvider)object;
        try {
            this.webView = JBCefApp.isSupported() ? this.createBrowser(this.project) : null;
        }
        catch (Exception e) {
            this.logger.error(e);
        }
        JBCefBrowser jBCefBrowser = this.webView;
        if (jBCefBrowser != null) {
            jBCefBrowser.loadURL(ConstantsKt.getPluginWebViewUrl());
        }
        this.composerProvider.setBrowser(this.webView);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final JBCefBrowser getWebView() {
        return this.webView;
    }

    public final void setWebView(@Nullable JBCefBrowser jBCefBrowser) {
        this.webView = jBCefBrowser;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    public final void reload() {
        ActionsKt.invokeLater$default(null, () -> CockpitChatWindow.reload$lambda$0(this), (int)1, null);
    }

    private final Unit onThemeChanged() {
        Unit unit;
        JBCefBrowser jBCefBrowser = this.webView;
        if (jBCefBrowser != null) {
            JBCefBrowser it = jBCefBrowser;
            boolean bl = false;
            ThemeUtilKt.updateTheme(this.project);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public void dispose() {
        Object $this$dispose_u24lambda_u242;
        Object object = this;
        try {
            $this$dispose_u24lambda_u242 = object;
            boolean bl = false;
            TrackService.INSTANCE.pageLeave(System.currentTimeMillis() - ((CockpitChatWindow)$this$dispose_u24lambda_u242).startTime);
            $this$dispose_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$dispose_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$dispose_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            e.printStackTrace();
        }
        JBCefBrowser jBCefBrowser = this.webView;
        if (jBCefBrowser != null) {
            jBCefBrowser.dispose();
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.ioCoroutineScope, null, (int)1, null);
    }

    private final JBCefBrowser createBrowser(Project project) {
        JBCefClient jBCefClient;
        JBCefBrowser jBCefBrowser = new JBCefBrowserBuilder().setEnableOpenDevToolsMenuItem(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        JBCefBrowser browser = jBCefBrowser;
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)browser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery myJSQueryOpenInBrowser = jBCefJSQuery;
        myJSQueryOpenInBrowser.addHandler(arg_0 -> CockpitChatWindow.createBrowser$lambda$5(arg_0 -> CockpitChatWindow.createBrowser$lambda$4(this, project, browser, arg_0), arg_0));
        JBCefClient $this$createBrowser_u24lambda_u246 = jBCefClient = browser.getJBCefClient();
        boolean bl = false;
        $this$createBrowser_u24lambda_u246.addLifeSpanHandler((CefLifeSpanHandler)new CustomLifeSpanHandler(), browser.getCefBrowser());
        $this$createBrowser_u24lambda_u246.addRequestHandler((CefRequestHandler)new CustomerRequestHandler(), browser.getCefBrowser());
        this.registerAppSchemeHandler();
        $this$createBrowser_u24lambda_u246.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(myJSQueryOpenInBrowser, this){
            final /* synthetic */ JBCefJSQuery $myJSQueryOpenInBrowser;
            final /* synthetic */ CockpitChatWindow this$0;
            {
                this.$myJSQueryOpenInBrowser = $myJSQueryOpenInBrowser;
                this.this$0 = $receiver;
            }

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                if (!isLoading) {
                    BrowserServiceKt.executeInitJavaScript(browser, this.$myJSQueryOpenInBrowser);
                    CockpitChatWindow.access$onThemeChanged(this.this$0);
                }
            }
        }, browser.getCefBrowser());
        Disposer.register((Disposable)((Disposable)project), (Disposable)((Disposable)browser));
        ChatHandler.INSTANCE.init(project);
        return browser;
    }

    @NotNull
    public final JComponent getContentPane() {
        JComponent jComponent;
        if (this.webView == null) {
            jComponent = new MissingJcefPanel();
        } else {
            JBCefBrowser jBCefBrowser = this.webView;
            Intrinsics.checkNotNull((Object)jBCefBrowser);
            JComponent jComponent2 = jBCefBrowser.getComponent();
            jComponent = jComponent2;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        }
        return jComponent;
    }

    private final void registerAppSchemeHandler() {
        SchemeHandlerRegistrar.INSTANCE.ensureRegistered();
    }

    private static final Unit reload$lambda$0(CockpitChatWindow this$0) {
        block0: {
            JBCefBrowser jBCefBrowser = this$0.webView;
            if (jBCefBrowser == null || (jBCefBrowser = jBCefBrowser.getCefBrowser()) == null) break block0;
            jBCefBrowser.loadURL(ConstantsKt.getPluginWebViewUrl());
        }
        return Unit.INSTANCE;
    }

    private static final JBCefJSQuery.Response createBrowser$lambda$4(CockpitChatWindow this$0, Project $project, JBCefBrowser $browser, String msg) {
        if (msg == null) {
            return null;
        }
        JsonObject jsonObject2 = JsonParser.parseString((String)msg).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
        JsonObject msgJsonObject = jsonObject2;
        if (!msgJsonObject.has("command")) {
            BuildersKt.launch$default((CoroutineScope)this$0.ioCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, msg, $browser, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $msg;
                final /* synthetic */ JBCefBrowser $browser;
                {
                    this.$project = $project;
                    this.$msg = $msg;
                    this.$browser = $browser;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object object2;
                            CoroutineScope $this$launch;
                            ResultKt.throwOnFailure((Object)object);
                            Object object3 = $this$launch = (CoroutineScope)this.L$0;
                            Project project = this.$project;
                            String string = this.$msg;
                            JBCefBrowser jBCefBrowser = this.$browser;
                            try {
                                boolean bl = false;
                                ComponentManager $this$service$iv = (ComponentManager)project;
                                boolean $i$f$service = false;
                                Class<ComposerProvider> serviceClass$iv = ComposerProvider.class;
                                Object object4 = $this$service$iv.getService(serviceClass$iv);
                                if (object4 == null) {
                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                }
                                ((ComposerProvider)object4).execute(string, jBCefBrowser);
                                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable throwable) {
                                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            object3 = object2;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                            if (throwable != null) {
                                Throwable e = throwable;
                                boolean bl = false;
                                e.printStackTrace();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return null;
        }
        String command = msgJsonObject.get("command").getAsString();
        Object object = msgJsonObject.get("requestId");
        if (object == null || (object = object.getAsString()) == null) {
            object = "";
        }
        Object requestId = object;
        LoggerAdapter.DefaultImpls.debug$default(ConstantsKt.getLogger(), "command: " + command + ", requestId: " + (String)requestId + ", msg: " + msg, null, 2, null);
        BuildersKt.launch$default((CoroutineScope)this$0.ioCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, $browser, command, (String)requestId, msg, msgJsonObject, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JBCefBrowser $browser;
            final /* synthetic */ String $command;
            final /* synthetic */ String $requestId;
            final /* synthetic */ String $msg;
            final /* synthetic */ JsonObject $msgJsonObject;
            {
                this.$project = $project;
                this.$browser = $browser;
                this.$command = $command;
                this.$requestId = $requestId;
                this.$msg = $msg;
                this.$msgJsonObject = $msgJsonObject;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        CoroutineScope $this$launch;
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = $this$launch = (CoroutineScope)this.L$0;
                        Project project = this.$project;
                        Object object4 = this.$browser;
                        String string = this.$command;
                        String string2 = this.$requestId;
                        String string3 = this.$msg;
                        JsonObject jsonObject2 = this.$msgJsonObject;
                        try {
                            boolean bl = false;
                            MessageHandler messageHandler = new MessageHandler(project, (JBCefBrowser)object4);
                            Intrinsics.checkNotNull((Object)string);
                            object2 = Result.constructor-impl((Object)messageHandler.handle(string, string2, string3, jsonObject2));
                        }
                        catch (Throwable throwable) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object3 = object2;
                        project = this.$browser;
                        object4 = this.$command;
                        string = this.$requestId;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                        if (throwable != null) {
                            Throwable e = throwable;
                            boolean bl = false;
                            e.printStackTrace();
                            Intrinsics.checkNotNull((Object)object4);
                            CockpitChatPluginServiceKt.handleError$default((JBCefBrowser)project, (String)object4, string, null, e.getMessage(), null, 40, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return null;
    }

    private static final JBCefJSQuery.Response createBrowser$lambda$5(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Unit access$onThemeChanged(CockpitChatWindow $this) {
        return $this.onThemeChanged();
    }
}

