/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.prompt;

import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.LLMParam;
import cn.gitlab.kilo.jetbrains.common.PromptResult;
import cn.gitlab.kilo.jetbrains.common.PrompterOpts;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.ContextUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.LanguageConfig;
import cn.gitlab.kilo.jetbrains.services.context.PromptString;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J:\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u00a8\u0006\u001e"}, d2={"Lcn/gitlab/kilo/jetbrains/prompt/CodeCompletionPrompter;", "", "<init>", "()V", "getFileNameFromPath", "", "path", "getFileRepoFromPath", "prompt", "Lcn/gitlab/kilo/jetbrains/common/PromptResult;", "opts", "Lcn/gitlab/kilo/jetbrains/common/PrompterOpts;", "getStopWords", "", "modelKey", "shouldDoMultiline", "", "forgeInfillingPrompt", "filename", "intro", "prefix", "suffix", "model", "repoName", "countTokens", "", "text", "trimTextToTokenBudget", "tokenBudget", "fromEnd", "coderider-kilo-jetbrains"})
public final class CodeCompletionPrompter {
    @NotNull
    public static final CodeCompletionPrompter INSTANCE = new CodeCompletionPrompter();

    private CodeCompletionPrompter() {
    }

    private final String getFileNameFromPath(String path) {
        String string = new File(path).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private final String getFileRepoFromPath(String path) {
        String string = new File(path).getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @NotNull
    public final PromptResult prompt(@NotNull PrompterOpts opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        String modelKey = opts.getModelKey();
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getCodeModels().get(modelKey);
        LLMParam llmParam = modelConfig != null ? modelConfig.getParams(false) : null;
        Object object = llmParam;
        Integer outputTokens = object != null && (object = ((LLMParam)object).getContextWindow()) != null && (object = (String)object.get("output")) != null ? StringsKt.toIntOrNull((String)object) : null;
        Object object2 = llmParam;
        int dynamicTokenLimit = object2 != null && (object2 = ((LLMParam)object2).getContextWindow()) != null && (object2 = (String)object2.get("input")) != null ? Integer.parseInt((String)object2) : 1024;
        int tokenLimit = (int)((double)dynamicTokenLimit * 3.5 * 0.9);
        List<ContextSnippet> context = opts.getContext();
        String string = opts.getLanguageId();
        Intrinsics.checkNotNull((Object)string);
        LanguageConfig languageConfig = ContextUtilsKt.getLanguageConfig(string);
        List intros = new ArrayList();
        Collection collection = context;
        if (!(collection == null || collection.isEmpty())) {
            for (ContextSnippet snippet : context) {
                PromptString promptString;
                CharSequence charSequence = snippet.getSymbol();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    promptString = new PromptString("Additional documentation for `" + snippet.getSymbol() + "`:\n\n" + snippet.getContent());
                } else {
                    String string2 = this.getFileNameFromPath(snippet.getUri());
                    String string3 = snippet.getContent();
                    String string4 = opts.getLanguageId();
                    Object object3 = llmParam;
                    if (object3 == null || (object3 = ((LLMParam)object3).getProvider()) == null) {
                        object3 = "";
                    }
                    promptString = ContextUtilsKt.getContextPrompt(string2, string3, string4, modelKey, (String)object3);
                }
                PromptString contextPrompt = promptString;
                intros.add(contextPrompt);
            }
        }
        PromptString introString = ContextUtilsKt.getIntroString(intros, languageConfig, modelKey);
        String intro = introString.getValue();
        String string5 = this.getFileNameFromPath(opts.getFilePath());
        String string6 = opts.getPrefix();
        Intrinsics.checkNotNull((Object)string6);
        String string7 = opts.getSuffix();
        Intrinsics.checkNotNull((Object)string7);
        String text = this.forgeInfillingPrompt(string5, intro, string6, string7, modelKey, this.getFileRepoFromPath(opts.getFilePath()));
        String prefix = opts.getPrefix();
        String suffix = opts.getSuffix();
        if (this.countTokens(text) > tokenLimit) {
            String filename = opts.getFilePath();
            if ((double)this.countTokens(filename) > 0.1 * (double)tokenLimit) {
                String string8 = new File(filename).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
                filename = string8;
            }
            String string9 = filename;
            Intrinsics.checkNotNull((Object)string9);
            int tokenBudget = tokenLimit - this.countTokens(string9);
            int prefixBudget = (int)(0.4 * (double)tokenBudget);
            int suffixBudget = (int)(0.4 * (double)tokenBudget);
            int introBudget = (int)(0.2 * (double)tokenBudget);
            if (this.countTokens(prefix) > prefixBudget) {
                prefix = this.trimTextToTokenBudget(prefix, prefixBudget, true);
            }
            if (this.countTokens(suffix) > suffixBudget) {
                suffix = this.trimTextToTokenBudget(suffix, suffixBudget, false);
            }
            if (this.countTokens(intro) > introBudget) {
                intro = this.trimTextToTokenBudget(intro, introBudget, false);
            }
            String string10 = prefix;
            Intrinsics.checkNotNull((Object)string10);
            String string11 = suffix;
            Intrinsics.checkNotNull((Object)string11);
            text = this.forgeInfillingPrompt(filename, intro, string10, string11, modelKey, this.getFileRepoFromPath(opts.getFilePath()));
        }
        String string12 = text;
        List<String> list = this.getStopWords(modelKey, opts.getShouldDoMultiline());
        int n = opts.getShouldDoMultiline() ? 256 : 32;
        String string13 = intro;
        String string14 = suffix;
        String string15 = prefix;
        Object object4 = llmParam;
        double d = object4 != null && (object4 = ((LLMParam)object4).getTemperature()) != null && (object4 = StringsKt.toDoubleOrNull((String)object4)) != null ? (Double)object4 : 0.0;
        return new PromptResult(string12, list, n, 30000L, string15, string14, string13, outputTokens, d);
    }

    private final List<String> getStopWords(String modelKey, boolean shouldDoMultiline) {
        List list;
        Object[] objectArray;
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getCodeModels().get(modelKey);
        LLMParam llmParam = modelConfig != null ? modelConfig.getParams(false) : null;
        List output = new ArrayList();
        LLMParam lLMParam = llmParam;
        if (Intrinsics.areEqual((Object)(lLMParam != null ? lLMParam.getProvider() : null), (Object)"qwen")) {
            Object[] objectArray2 = new String[]{"<|fim_pad|>", "<|file_sep|>", "<|fim_prefix|>", "<|cursor|>"};
            output.addAll(CollectionsKt.listOf((Object[])objectArray2));
        }
        if (shouldDoMultiline) {
            objectArray = new String[]{"\n\n", "\r\n\r\n"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new String[]{"\n", "\r\n"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List multilineStops = list;
        if (StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"starcoder", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"local", (boolean)false, (int)2, null)) {
            v3 = output.addAll(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"<|endoftext|>"), (Iterable)multilineStops));
        } else if (StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"deepseek", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"maas-completion-model", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"server-completion-model", (boolean)false, (int)2, null)) {
            v3 = output.addAll(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"<|end_of_sentence|>"), (Iterable)multilineStops));
        } else if (StringsKt.contains$default((CharSequence)modelKey, (CharSequence)"SenseChat-CodeCompletion", (boolean)false, (int)2, null)) {
            objectArray = new String[]{"<EOT>", "\n", "\r\n"};
            v3 = output.addAll(CollectionsKt.listOf((Object[])objectArray));
        } else {
            throw new CustomException("CompletionPrompter.getStopWords: unexpected model key: " + modelKey);
        }
        return output;
    }

    private final String forgeInfillingPrompt(String filename, String intro, String prefix, String suffix, String model, String repoName) {
        String string;
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getCodeModels().get(model);
        LLMParam llmParam = modelConfig != null ? modelConfig.getParams(false) : null;
        Object object = llmParam;
        if (object == null || (object = ((LLMParam)object).getProvider()) == null) {
            object = "";
        }
        Object provider = object;
        if (StringsKt.contains$default((CharSequence)model, (CharSequence)"starcoder", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)model, (CharSequence)"local", (boolean)false, (int)2, null)) {
            string = "<|filename|>" + filename + "<|fim_prefix|>" + intro + prefix + "<|fim_suffix|>" + suffix + "<|fim_middle|>";
        } else if (StringsKt.contains$default((CharSequence)model, (CharSequence)"maas", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)model, (CharSequence)"server", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)model, (CharSequence)"deepseek", (boolean)false, (int)2, null)) {
            String prompt = intro + "\n#" + filename + "\n<|fim\u2581begin|>" + prefix + "<|fim\u2581hole|>" + suffix + "<|fim\u2581end|>";
            if (Intrinsics.areEqual((Object)provider, (Object)"qwen")) {
                prompt = intro + "\n<|file_sep|>\n" + filename + "\n<|fim_prefix|>" + prefix + "<|fim_suffix|>" + suffix + "<|fim_middle|>";
                CharSequence charSequence = repoName;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    prompt = "<|repo_name|>" + repoName + "\n" + prompt;
                }
            }
            string = prompt;
        } else {
            string = intro + prefix;
        }
        return string;
    }

    private final int countTokens(String text) {
        return text.length();
    }

    private final String trimTextToTokenBudget(String text, int tokenBudget, boolean fromEnd) {
        List lines = StringsKt.lines((CharSequence)text);
        int tokens = 0;
        IntProgression indices = fromEnd ? RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)lines))) : (IntProgression)CollectionsKt.getIndices((Collection)lines);
        int i = indices.getFirst();
        int n = indices.getLast();
        int n2 = indices.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                if ((tokens += this.countTokens((String)lines.get(i)) + 1) > tokenBudget) {
                    return fromEnd && i < lines.size() - 1 ? CollectionsKt.joinToString$default((Iterable)lines.subList(i + 1, lines.size()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : (!fromEnd && i > 0 ? CollectionsKt.joinToString$default((Iterable)lines.subList(0, i), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : "");
                }
                if (i == n) break;
                i += n2;
            }
        }
        return text;
    }
}

