/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.widget;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidgetGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H&J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H&J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H&J\b\u0010-\u001a\u00020'H\u0016J\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00102\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0016J\b\u00103\u001a\u00020'H\u0016J\u0018\u00107\u001a\u00020'2\u0006\u00108\u001a\u0002092\u0006\u0010/\u001a\u00020:H\u0004J\b\u0010;\u001a\u00020'H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0016\u00104\u001a\n 5*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\n 5*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidget;", "Lcom/intellij/openapi/Disposable;", "parentGroup", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "<init>", "(Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;)V", "getParentGroup", "()Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getLogger", "()Lcn/gitlab/kilo/jetbrains/common/Logger;", "mouseInBounds", "", "getMouseInBounds", "()Z", "setMouseInBounds", "(Z)V", "baseTextColor", "Ljava/awt/Color;", "getBaseTextColor$annotations", "()V", "getBaseTextColor", "()Ljava/awt/Color;", "showingTooltip", "tooltip", "Lcom/intellij/ui/LightweightHint;", "lastPaintedBounds", "Ljava/awt/geom/Rectangle2D$Float;", "getLastPaintedBounds", "()Ljava/awt/geom/Rectangle2D$Float;", "setLastPaintedBounds", "(Ljava/awt/geom/Rectangle2D$Float;)V", "calcWidthInPixels", "", "fontMetrics", "Ljava/awt/FontMetrics;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics2D;", "x", "", "y", "update", "onClick", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "onMouseEnter", "onMouseExit", "dispose", "tooltipBackground", "kotlin.jvm.PlatformType", "tooltipForeground", "showTooltip", "text", "", "Ljava/awt/event/MouseEvent;", "hideTooltip", "coderider-kilo-jetbrains"})
public abstract class LensWidget
implements Disposable {
    @NotNull
    private final LensWidgetGroup parentGroup;
    @NotNull
    private final Logger logger;
    private boolean mouseInBounds;
    @NotNull
    private final Color baseTextColor;
    private boolean showingTooltip;
    @Nullable
    private LightweightHint tooltip;
    @Nullable
    private Rectangle2D.Float lastPaintedBounds;
    private final Color tooltipBackground;
    private final Color tooltipForeground;

    public LensWidget(@NotNull LensWidgetGroup parentGroup) {
        Intrinsics.checkNotNullParameter((Object)parentGroup, (String)"parentGroup");
        this.parentGroup = parentGroup;
        this.logger = Logger.Companion.getInstance(LensWidget.class);
        this.baseTextColor = (Color)new JBColor(3750720, 14672357);
        this.tooltipBackground = UIManager.getColor("ToolTip.background");
        this.tooltipForeground = UIManager.getColor("ToolTip.foreground");
    }

    @NotNull
    public final LensWidgetGroup getParentGroup() {
        return this.parentGroup;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final boolean getMouseInBounds() {
        return this.mouseInBounds;
    }

    protected final void setMouseInBounds(boolean bl) {
        this.mouseInBounds = bl;
    }

    @NotNull
    protected final Color getBaseTextColor() {
        return this.baseTextColor;
    }

    protected static /* synthetic */ void getBaseTextColor$annotations() {
    }

    @Nullable
    protected final Rectangle2D.Float getLastPaintedBounds() {
        return this.lastPaintedBounds;
    }

    protected final void setLastPaintedBounds(@Nullable Rectangle2D.Float float_) {
        this.lastPaintedBounds = float_;
    }

    public abstract int calcWidthInPixels(@NotNull FontMetrics var1);

    public abstract int calcHeightInPixels(@NotNull FontMetrics var1);

    public abstract void paint(@NotNull Graphics2D var1, float var2, float var3);

    public void update() {
    }

    public boolean onClick(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return true;
    }

    public void onMouseEnter(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.mouseInBounds = true;
        this.hideTooltip();
    }

    public void onMouseExit(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.mouseInBounds = false;
        this.hideTooltip();
    }

    public void dispose() {
        this.hideTooltip();
    }

    protected final void showTooltip(@NotNull String text, @NotNull MouseEvent e) {
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.hideTooltip();
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme globalScheme = editorColorsScheme;
        JLabel $this$showTooltip_u24lambda_u240 = jLabel = new JLabel(text);
        boolean bl = false;
        Color color = globalScheme.getColor(ColorKey.createColorKey((String)"TOOLTIP_FOREGROUND", (Color)this.tooltipForeground));
        if (color == null) {
            Color color2 = globalScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        $this$showTooltip_u24lambda_u240.setForeground(color);
        Color color3 = globalScheme.getColor(ColorKey.createColorKey((String)"TOOLTIP_BACKGROUND", (Color)this.tooltipBackground));
        if (color3 == null) {
            Color color4 = globalScheme.getDefaultBackground();
            color3 = color4;
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getDefaultBackground(...)");
        }
        $this$showTooltip_u24lambda_u240.setBackground(color3);
        $this$showTooltip_u24lambda_u240.setOpaque(true);
        $this$showTooltip_u24lambda_u240.setFont(this.parentGroup.getWidgetFont().get());
        $this$showTooltip_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder(2, 8, 0, 8));
        JLabel tooltipLabel = jLabel;
        LightweightHint hint = new LightweightHint((JComponent)tooltipLabel);
        Point p = this.parentGroup.widgetXY(this);
        HintHint hintHint = new HintHint(e.getComponent(), p).setPreferredPosition(Balloon.Position.above).setMayCenterPosition(false);
        hint.show((JComponent)this.parentGroup.getEditor().getContentComponent(), p.x, p.y, (JComponent)this.parentGroup.getEditor().getContentComponent(), hintHint);
        this.showingTooltip = true;
        this.tooltip = hint;
    }

    protected final void hideTooltip() {
        if (this.showingTooltip) {
            LightweightHint lightweightHint = this.tooltip;
            if (lightweightHint != null) {
                LightweightHint lightweightHint2;
                LightweightHint $this$hideTooltip_u24lambda_u241 = lightweightHint2 = lightweightHint;
                boolean bl = false;
                $this$hideTooltip_u24lambda_u241.hide();
                this.tooltip = null;
            }
            this.showingTooltip = false;
        }
    }
}

