/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.widget;

import cn.gitlab.kilo.jetbrains.edit.lenses.LensEditAction;
import cn.gitlab.kilo.jetbrains.edit.widget.LabelHighlight;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidget;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidgetGroup;
import cn.gitlab.kilo.jetbrains.utils.EditUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#J\u001a\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010&\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensAction;", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidget;", "group", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "text", "", "actionId", "taskId", "<init>", "(Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "getText", "()Ljava/lang/String;", "getActionId", "highlight", "Lcn/gitlab/kilo/jetbrains/edit/widget/LabelHighlight;", "calcWidthInPixels", "", "fontMetrics", "Ljava/awt/FontMetrics;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics2D;", "x", "", "y", "onClick", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "triggerAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "toString", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nLensAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LensAction.kt\ncn/gitlab/kilo/jetbrains/edit/widget/LensAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class LensAction
extends LensWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LensWidgetGroup group;
    @NotNull
    private final String text;
    @VisibleForTesting
    @NotNull
    private final String actionId;
    @Nullable
    private final String taskId;
    @NotNull
    private final LabelHighlight highlight;
    public static final int SIDE_MARGIN = 9;
    @NotNull
    private static final JBColor actionColor = new JBColor(5000532, 3750720);
    @NotNull
    private static final JBColor acceptColor = new JBColor(3577424, 3703065);
    @NotNull
    private static final JBColor undoColor = new JBColor(13383237, 8071212);
    @NotNull
    private static final AtomicReference<String> lastLensActionPerformed = new AtomicReference<Object>(null);

    public LensAction(@NotNull LensWidgetGroup group, @NotNull String text, @NotNull String actionId, @Nullable String taskId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        super(group);
        this.group = group;
        this.text = text;
        this.actionId = actionId;
        this.taskId = taskId;
        String string = this.actionId;
        this.highlight = new LabelHighlight((Color)(Intrinsics.areEqual((Object)string, (Object)"coderider-kilo.fixup.codelens.accept") ? acceptColor : (Intrinsics.areEqual((Object)string, (Object)"coderider-kilo.fixup.codelens.undo") ? undoColor : actionColor)));
    }

    @NotNull
    public final LensWidgetGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getActionId() {
        return this.actionId;
    }

    @Override
    public int calcWidthInPixels(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return fontMetrics.stringWidth(this.text) + 18;
    }

    @Override
    public int calcHeightInPixels(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return fontMetrics.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics2D g, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Font originalFont = g.getFont();
        Color originalColor = g.getColor();
        try {
            g.setBackground(EditUtil.INSTANCE.getEnhancedThemeColor("Panel.background"));
            FontMetrics metrics = g.getFontMetrics();
            Intrinsics.checkNotNull((Object)metrics);
            int width = this.calcWidthInPixels(metrics) - 4;
            int textHeight = metrics.getHeight();
            this.highlight.drawHighlight(g, x, y + 1.0f, width, textHeight - 2);
            if (this.getMouseInBounds()) {
                g.setFont(g.getFont().deriveFont(1).deriveFont((float)g.getFont().getSize() * 0.85f));
                g.setColor(UIUtil.shade((Color)((Color)new JBColor(0xFFFFFF, 0xFFFFFF)), (double)1.0, (double)0.95));
            } else {
                g.setFont(g.getFont().deriveFont(1).deriveFont((float)g.getFont().getSize() * 0.85f));
                g.setColor(UIUtil.shade((Color)((Color)new JBColor(0xFFFFFF, 0xFFFFFF)), (double)1.0, (double)0.9));
            }
            g.drawString(this.text, x + (float)9, y + (float)g.getFontMetrics().getAscent() + 1.0f);
            this.setLastPaintedBounds(new Rectangle2D.Float(x, y - (float)metrics.getAscent(), width, textHeight));
        }
        finally {
            g.setFont(originalFont);
            g.setColor(originalColor);
        }
    }

    @Override
    public boolean onClick(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = e.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        this.triggerAction(editor);
        return true;
    }

    public final void triggerAction(@NotNull Editor editor) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            lastLensActionPerformed.set(this.actionId);
            AnAction action = ActionManager.getInstance().getAction(this.actionId);
            if (action == null) break block3;
            DataContext dataContext = this.createDataContext(editor, this.taskId);
            AnActionEvent actionEvent = new AnActionEvent(null, dataContext, "", action.getTemplatePresentation().clone(), ActionManager.getInstance(), 0);
            if (action instanceof LensEditAction) {
                Project project = editor.getProject();
                if (project != null) {
                    Project it = project;
                    boolean bl = false;
                    String string = this.taskId;
                    if (string != null) {
                        String it1 = string;
                        boolean bl2 = false;
                        ((LensEditAction)action).getEditAction().invoke((Object)it, (Object)actionEvent, (Object)editor, (Object)it1);
                    }
                }
            }
        }
    }

    private final DataContext createDataContext(Editor editor, String taskId) {
        return arg_0 -> LensAction.createDataContext$lambda$2(this, editor, taskId, arg_0);
    }

    @NotNull
    public String toString() {
        return "LensAction(text=" + this.text + ")";
    }

    private static final Object createDataContext$lambda$2(LensAction this$0, Editor $editor, String $taskId, String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String string = dataId;
        return Intrinsics.areEqual((Object)string, (Object)PlatformDataKeys.CONTEXT_COMPONENT.getName()) ? this$0 : (Intrinsics.areEqual((Object)string, (Object)PlatformDataKeys.EDITOR.getName()) ? $editor : (Intrinsics.areEqual((Object)string, (Object)PlatformDataKeys.PROJECT.getName()) ? $editor.getProject() : (Intrinsics.areEqual((Object)string, (Object)"TASK_ID_KEY") ? $taskId : null)));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensAction$Companion;", "", "<init>", "()V", "SIDE_MARGIN", "", "actionColor", "Lcom/intellij/ui/JBColor;", "getActionColor", "()Lcom/intellij/ui/JBColor;", "acceptColor", "undoColor", "lastLensActionPerformed", "Ljava/util/concurrent/atomic/AtomicReference;", "", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBColor getActionColor() {
            return actionColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

