/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.action;

import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffViewProvider;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffVirtualFile;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffVirtualFileSystem;
import cn.gitlab.kilo.jetbrains.composer.service.diff.EditType;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import cn.gitlab.kilo.jetbrains.edit.common.ProtocolCodeLens;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.utils.DiffService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"generateDiffStreamHandler", "Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "newEditor", "targetStartLine", "", "generateTestDiffFile", "", "oldFilePath", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nDiffStreamUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffStreamUtils.kt\ncn/gitlab/kilo/jetbrains/edit/action/DiffStreamUtilsKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,145:1\n31#2,2:146\n*S KotlinDebug\n*F\n+ 1 DiffStreamUtils.kt\ncn/gitlab/kilo/jetbrains/edit/action/DiffStreamUtilsKt\n*L\n141#1:146,2\n*E\n"})
public final class DiffStreamUtilsKt {
    @NotNull
    public static final EditStreamHandler generateDiffStreamHandler(@NotNull Editor editor, @NotNull Project project, @Nullable Editor newEditor, int targetStartLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LensesService lensesService = LensesService.Companion.getInstance(project);
        Editor editor2 = newEditor;
        if (editor2 == null) {
            editor2 = editor;
        }
        Editor targetEditor = editor2;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String taskId = string;
        String string2 = editor.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String path = string2;
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        int startOffset = selectionModel2.getSelectionStart();
        int endOffset = selectionModel2.getSelectionEnd();
        int startLine = editor.offsetToLogicalPosition((int)startOffset).line;
        int endLine = editor.offsetToLogicalPosition((int)endOffset).line;
        int expandedStartOffset = editor.getDocument().getLineStartOffset(startLine);
        int expandedEndOffset = editor.getDocument().getLineEndOffset(endLine);
        String string3 = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String originFileText = string3;
        return new EditStreamHandler(() -> DiffStreamUtilsKt.generateDiffStreamHandler$lambda$1(lensesService, targetEditor), () -> DiffStreamUtilsKt.generateDiffStreamHandler$lambda$2(lensesService, targetEditor, taskId, expandedStartOffset, expandedEndOffset, targetStartLine), project, targetEditor, startLine, endLine, DiffStreamUtilsKt::generateDiffStreamHandler$lambda$3, () -> DiffStreamUtilsKt.generateDiffStreamHandler$lambda$4(lensesService, targetEditor, taskId, expandedStartOffset, expandedEndOffset, targetStartLine), path, originFileText, expandedStartOffset, expandedEndOffset, editor, targetStartLine, null, null, 49152, null);
    }

    public static /* synthetic */ EditStreamHandler generateDiffStreamHandler$default(Editor editor, Project project, Editor editor2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            editor2 = null;
        }
        return DiffStreamUtilsKt.generateDiffStreamHandler(editor, project, editor2, n);
    }

    public static final void generateTestDiffFile(@NotNull Editor newEditor, @NotNull Project project, @NotNull String oldFilePath) {
        Intrinsics.checkNotNullParameter((Object)newEditor, (String)"newEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)oldFilePath, (String)"oldFilePath");
        Ref.ObjectRef editedTest = new Ref.ObjectRef();
        String string = newEditor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        editedTest.element = string;
        ApplicationManager.getApplication().invokeLater(() -> DiffStreamUtilsKt.generateTestDiffFile$lambda$8(oldFilePath, project, editedTest, newEditor));
    }

    private static final Range generateDiffStreamHandler$buildRange(int expandedStartOffset, int expandedEndOffset, int $targetStartLine) {
        Range range;
        Range $this$generateDiffStreamHandler_u24buildRange_u24lambda_u240 = range = new Range(expandedStartOffset, expandedEndOffset);
        boolean bl = false;
        if ($targetStartLine == 0) {
            $this$generateDiffStreamHandler_u24buildRange_u24lambda_u240.setStart(0);
            $this$generateDiffStreamHandler_u24buildRange_u24lambda_u240.setEnd(0);
        }
        return range;
    }

    private static final void generateDiffStreamHandler$updateLensesWithLense(Editor targetEditor, String taskId, LensesService lensesService, int expandedStartOffset, int expandedEndOffset, int $targetStartLine, Function2<? super Range, ? super String, ? extends List<ProtocolCodeLens>> generate) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(targetEditor.getDocument());
        if (virtualFile != null) {
            Range range = DiffStreamUtilsKt.generateDiffStreamHandler$buildRange(expandedStartOffset, expandedEndOffset, $targetStartLine);
            List lens = (List)generate.invoke((Object)range, (Object)taskId);
            String string = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            lensesService.updateLenses(targetEditor, string, virtualFile, lens);
        }
    }

    private static final Unit generateDiffStreamHandler$lambda$1(LensesService $lensesService, Editor $targetEditor) {
        $lensesService.clearLenses($targetEditor);
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$2(LensesService $lensesService, Editor $targetEditor, String $taskId, int $expandedStartOffset, int $expandedEndOffset, int $targetStartLine) {
        DiffStreamUtilsKt.generateDiffStreamHandler$updateLensesWithLense($targetEditor, $taskId, $lensesService, $expandedStartOffset, $expandedEndOffset, $targetStartLine, (Function2<? super Range, ? super String, ? extends List<ProtocolCodeLens>>)((Function2)new Function2<Range, String, List<? extends ProtocolCodeLens>>((Object)$lensesService){

            public final List<ProtocolCodeLens> invoke(Range p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((LensesService)this.receiver).generateInlineEditStartLense(p0, p1);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$4(LensesService $lensesService, Editor $targetEditor, String $taskId, int $expandedStartOffset, int $expandedEndOffset, int $targetStartLine) {
        DiffStreamUtilsKt.generateDiffStreamHandler$updateLensesWithLense($targetEditor, $taskId, $lensesService, $expandedStartOffset, $expandedEndOffset, $targetStartLine, (Function2<? super Range, ? super String, ? extends List<ProtocolCodeLens>>)((Function2)new Function2<Range, String, List<? extends ProtocolCodeLens>>((Object)$lensesService){

            public final List<ProtocolCodeLens> invoke(Range p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((LensesService)this.receiver).generateInlineEditEndLense(p0, p1);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit generateTestDiffFile$lambda$8$lambda$6$lambda$5(Pair diffResult) {
        Intrinsics.checkNotNullParameter((Object)diffResult, (String)"diffResult");
        CoderiderTrackClient.INSTANCE.recordAICodeAdoptDiffEvent(CoderiderTrackClient.SceneType.INLINE, ((Number)diffResult.getFirst()).intValue(), ((Number)diffResult.getSecond()).intValue(), ModelsConfiguration.Companion.getInstance().getDefaultLoomModel().getKey());
        return Unit.INSTANCE;
    }

    private static final Unit generateTestDiffFile$lambda$8$lambda$6(Ref.ObjectRef $editedTest, Ref.ObjectRef $originText) {
        CoderiderTrackClient.INSTANCE.recordAICodeSuggestionAdoptEvent(CoderiderTrackClient.SceneType.INLINE, 1, StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)((String)$editedTest.element))).toString()).size(), ModelsConfiguration.Companion.getInstance().getDefaultLoomModel().getKey());
        DiffService.INSTANCE.submitDiff((CharSequence)$originText.element, (CharSequence)$editedTest.element, (Function1<? super Pair<Integer, Integer>, Unit>)((Function1)DiffStreamUtilsKt::generateTestDiffFile$lambda$8$lambda$6$lambda$5));
        CoderiderTrackClient.INSTANCE.recordAICodeGenerationEvent(CoderiderTrackClient.SceneType.INLINE, ((String)$editedTest.element).length(), ModelsConfiguration.Companion.getInstance().getDefaultLoomModel().getKey());
        return Unit.INSTANCE;
    }

    private static final Unit generateTestDiffFile$lambda$8$lambda$7() {
        CoderiderTrackClient.INSTANCE.recordAIGenerateRejectEvent(CoderiderTrackClient.SceneType.INLINE, ModelsConfiguration.Companion.getInstance().getDefaultLoomModel().getKey());
        return Unit.INSTANCE;
    }

    private static final void generateTestDiffFile$lambda$8(String $oldFilePath, Project $project, Ref.ObjectRef $editedTest, Editor $newEditor) {
        VirtualFile currentFile = LocalFileSystem.getInstance().refreshAndFindFileByPath($oldFilePath);
        if (currentFile == null) {
            return;
        }
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor($project, currentFile);
        Editor editor = FileEditorManager.getInstance((Project)$project).openTextEditor(openFileDescriptor, true);
        if (editor == null) {
            throw new IllegalStateException("Failed to create or find file at " + $oldFilePath);
        }
        Editor editor2 = editor;
        String string = editor2.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        DiffVirtualFile diffVirtualFile = DiffVirtualFileSystem.INSTANCE.get(path);
        String string2 = currentFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String title = string2;
        Ref.ObjectRef originText = new Ref.ObjectRef();
        Object object = VirtualFileUtil.findDocument((VirtualFile)currentFile);
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        originText.element = object;
        String string3 = currentFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String string4 = (String)originText.element;
        String string5 = (String)$editedTest.element;
        FileType fileType = currentFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        diffVirtualFile = DiffVirtualFileSystem.INSTANCE.getOrCreate(string3, string4, string5, title, fileType, EditType.MODIFY, currentFile, false, true);
        diffVirtualFile.setAcceptCallback((Function0<Unit>)((Function0)() -> DiffStreamUtilsKt.generateTestDiffFile$lambda$8$lambda$6($editedTest, originText)));
        diffVirtualFile.setRejectCallback((Function0<Unit>)((Function0)DiffStreamUtilsKt::generateTestDiffFile$lambda$8$lambda$7));
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<DiffViewProvider> serviceClass$iv = DiffViewProvider.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DiffViewProvider provider = (DiffViewProvider)object2;
        provider.showDiffEditor(diffVirtualFile);
        FileEditorManager.getInstance((Project)$project).closeFile($newEditor.getVirtualFile());
    }
}

