/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import cn.gitlab.kilo.jetbrains.utils.EditUtilKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a4\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"createNewFileEditor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "createTemporaryVirtualFileAndOpen", "fileName", "fileContent", "openFileInEditor", "createTestFileNameSafe", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "callback", "Lkotlin/Function1;", "createTestFileName", "fileExists", "", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCockpitInlineQuickCommandRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CockpitInlineQuickCommandRender.kt\ncn/gitlab/kilo/jetbrains/edit/CockpitInlineQuickCommandRenderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,445:1\n774#2:446\n865#2,2:447\n774#2:449\n865#2,2:450\n*S KotlinDebug\n*F\n+ 1 CockpitInlineQuickCommandRender.kt\ncn/gitlab/kilo/jetbrains/edit/CockpitInlineQuickCommandRenderKt\n*L\n416#1:446\n416#1:447,2\n421#1:449\n421#1:450,2\n*E\n"})
public final class CockpitInlineQuickCommandRenderKt {
    @Nullable
    public static final Editor createNewFileEditor(@NotNull Project project, @NotNull String filePath) {
        File newFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File parentDir = new File(filePath).getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!(newFile = new File(filePath)).exists()) {
            newFile.createNewFile();
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(newFile.getAbsolutePath());
        if (virtualFile == null) {
            throw new IllegalStateException("Failed to create or find file at " + filePath);
        }
        VirtualFile virtualFile2 = virtualFile;
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile2);
        return FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
    }

    @Nullable
    public static final Editor createTemporaryVirtualFileAndOpen(@NotNull Project project, @NotNull String fileName, @NotNull String fileContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String pureFileName = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        LightVirtualFile virtualFile = new LightVirtualFile(pureFileName, (CharSequence)fileContent);
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, (VirtualFile)virtualFile);
        return FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
    }

    public static /* synthetic */ Editor createTemporaryVirtualFileAndOpen$default(Project project, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return CockpitInlineQuickCommandRenderKt.createTemporaryVirtualFileAndOpen(project, string, string2);
    }

    @Nullable
    public static final Editor openFileInEditor(@NotNull Project project, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
        if (virtualFile == null) {
            throw new IllegalStateException("Failed to create or find file at " + filePath);
        }
        VirtualFile virtualFile2 = virtualFile;
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile2);
        return FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
    }

    public static final void createTestFileNameSafe(@NotNull Project project, @Nullable VirtualFile virtualFile, @NotNull String filePath, @NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        String defaultName = CockpitInlineQuickCommandRenderKt.createTestFileName(filePath);
        if (virtualFile == null) {
            callback.invoke((Object)defaultName);
            return;
        }
        ReadAction.nonBlocking(() -> CockpitInlineQuickCommandRenderKt.createTestFileNameSafe$lambda$2(project, virtualFile, defaultName, filePath)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> CockpitInlineQuickCommandRenderKt.createTestFileNameSafe$lambda$4(arg_0 -> CockpitInlineQuickCommandRenderKt.createTestFileNameSafe$lambda$3(callback, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public static final String createTestFileName(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)filePath, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastDotIndex != -1) {
            String string = filePath.substring(0, lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = filePath.substring(lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string + "Test" + string2;
        }
        return filePath + "Test";
    }

    public static final boolean fileExists(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        return file.exists();
    }

    /*
     * Unable to fully structure code
     */
    private static final String createTestFileNameSafe$lambda$2(Project $project, VirtualFile $virtualFile, String $defaultName, String $filePath) {
        var5_4 = EditUtilKt.getTestSourceRootsForFile($project, $virtualFile);
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            $i$a$-filter-CockpitInlineQuickCommandRenderKt$createTestFileNameSafe$1$testFolders$1 = false;
            v0 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
            if (!(StringsKt.contains$default((CharSequence)v0, (CharSequence)"target", (boolean)false, (int)2, null) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        testFolders = (List)destination$iv$iv;
        if (testFolders.isEmpty()) {
            return $defaultName;
        }
        testFolder = (VirtualFile)testFolders.get(0);
        $this$filterTo$iv$iv = EditUtilKt.getSrcSourceRootsForFile($project, $virtualFile);
        $i$f$filter = false;
        $i$f$filterTo = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            $i$a$-filter-CockpitInlineQuickCommandRenderKt$createTestFileNameSafe$1$resourceFolders$1 = false;
            v1 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
            if (StringsKt.contains$default((CharSequence)v1, (CharSequence)"target", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v2 = $filePath;
            v3 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPath(...)");
            if (StringsKt.contains$default((CharSequence)v2, (CharSequence)v3, (boolean)false, (int)2, null)) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        resourceFolders = (List)destination$iv$iv;
        if (resourceFolders.isEmpty()) {
            return $defaultName;
        }
        resFolder = (VirtualFile)resourceFolders.get(0);
        v5 = resFolder.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getPath(...)");
        v6 = testFolder.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getPath(...)");
        return StringsKt.replace$default((String)$defaultName, (String)v5, (String)v6, (boolean)false, (int)4, null);
    }

    private static final Unit createTestFileNameSafe$lambda$3(Function1 $callback, String result2) {
        Intrinsics.checkNotNull((Object)result2);
        $callback.invoke((Object)result2);
        return Unit.INSTANCE;
    }

    private static final void createTestFileNameSafe$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

