/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.util;

import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.composer.util.DiffUtilKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0002J\b\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/NewFileContentConstructor;", "", "originalContent", "", "isFinal", "", "<init>", "(Ljava/lang/String;Z)V", "state", "Lcn/gitlab/kilo/jetbrains/composer/util/NewFileContentConstructor$ProcessingState;", "pendingNonStandardLines", "", "result", "lastProcessedIndex", "", "currentSearchContent", "searchMatchIndex", "searchEndIndex", "processLine", "", "line", "getResult", "Lkotlin/Pair;", "internalProcessLine", "canWritePendingNonStandardLines", "pendingNonStandardLineLimit", "beforeReplace", "resetForNextBlock", "activateSearchState", "activateReplaceState", "isSearchingActive", "isReplacingActive", "updateProcessingState", "newState", "hasPendingNonStandardLines", "findLastMatchingLineIndex", "regex", "Lkotlin/text/Regex;", "lineLimit", "tryFixSearchBlock", "tryFixReplaceBlock", "tryFixSearchReplaceBlock", "trimPendingNonStandardTrailingEmptyLines", "ProcessingState", "Companion", "coderider-kilo-jetbrains"})
public final class NewFileContentConstructor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String originalContent;
    private final boolean isFinal;
    @NotNull
    private ProcessingState state;
    @NotNull
    private final List<String> pendingNonStandardLines;
    @NotNull
    private String result;
    private int lastProcessedIndex;
    @NotNull
    private String currentSearchContent;
    private int searchMatchIndex;
    private int searchEndIndex;
    @NotNull
    public static final String SEARCH_BLOCK_START = "<<<<<<< SEARCH";
    @NotNull
    public static final String SEARCH_BLOCK_END = "=======";
    @NotNull
    public static final String REPLACE_BLOCK_END = ">>>>>>> REPLACE";
    @NotNull
    private static final Regex SEARCH_BLOCK_START_REGEX = new Regex("^[<]{3,} SEARCH>?$");
    @NotNull
    private static final Regex SEARCH_BLOCK_END_REGEX = new Regex("^[=]{3,}$");
    @NotNull
    private static final Regex REPLACE_BLOCK_END_REGEX = new Regex("^[>]{3,} REPLACE>?$");

    public NewFileContentConstructor(@NotNull String originalContent, boolean isFinal) {
        Intrinsics.checkNotNullParameter((Object)originalContent, (String)"originalContent");
        this.originalContent = originalContent;
        this.isFinal = isFinal;
        this.state = ProcessingState.IDLE;
        this.pendingNonStandardLines = new ArrayList();
        this.result = "";
        this.currentSearchContent = "";
        this.searchMatchIndex = -1;
        this.searchEndIndex = -1;
    }

    public final void processLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.internalProcessLine(line, true, this.pendingNonStandardLines.size());
    }

    @NotNull
    public final Pair<String, String> getResult() {
        String replaceLines = this.result;
        if (this.isFinal && this.lastProcessedIndex < this.originalContent.length()) {
            String string = this.originalContent.substring(this.lastProcessedIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.result = this.result + string;
        }
        if (this.isFinal && this.state != ProcessingState.IDLE) {
            throw new CustomException("File processing incomplete - SEARCH/REPLACE operations still active during finalization");
        }
        return TuplesKt.to((Object)this.result, (Object)replaceLines);
    }

    private final int internalProcessLine(String line, boolean canWritePendingNonStandardLines, int pendingNonStandardLineLimit) {
        int removeLineCount = 0;
        int n = -1;
        switch (line.hashCode()) {
            case 306789516: {
                if (line.equals(SEARCH_BLOCK_START)) {
                    n = 1;
                }
                break;
            }
            case 107740509: {
                if (line.equals(SEARCH_BLOCK_END)) {
                    n = 2;
                }
                break;
            }
            case -1584816782: {
                if (line.equals(REPLACE_BLOCK_END)) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                removeLineCount = this.trimPendingNonStandardTrailingEmptyLines(pendingNonStandardLineLimit);
                int newLimit = pendingNonStandardLineLimit - removeLineCount;
                if (this.hasPendingNonStandardLines(newLimit)) {
                    this.tryFixSearchReplaceBlock(newLimit);
                    if (canWritePendingNonStandardLines) {
                        this.pendingNonStandardLines.clear();
                    }
                }
                this.activateSearchState();
                break;
            }
            case 2: {
                if (!this.isSearchingActive()) {
                    this.tryFixSearchBlock(pendingNonStandardLineLimit);
                    if (canWritePendingNonStandardLines) {
                        this.pendingNonStandardLines.clear();
                    }
                }
                this.activateReplaceState();
                this.beforeReplace();
                break;
            }
            case 3: {
                if (!this.isReplacingActive()) {
                    this.tryFixReplaceBlock(pendingNonStandardLineLimit);
                    if (canWritePendingNonStandardLines) {
                        this.pendingNonStandardLines.clear();
                    }
                }
                this.lastProcessedIndex = this.searchEndIndex;
                this.resetForNextBlock();
                break;
            }
            default: {
                if (this.isReplacingActive()) {
                    if (this.searchMatchIndex == -1) break;
                    this.result = this.result + line + "\n";
                    break;
                }
                if (this.isSearchingActive()) {
                    this.currentSearchContent = this.currentSearchContent + line + "\n";
                    break;
                }
                if (!canWritePendingNonStandardLines) break;
                this.pendingNonStandardLines.add(line);
            }
        }
        return removeLineCount;
    }

    private final void beforeReplace() {
        if (((CharSequence)this.currentSearchContent).length() == 0) {
            this.searchMatchIndex = 0;
            this.searchEndIndex = ((CharSequence)this.originalContent).length() == 0 ? 0 : this.originalContent.length();
        } else {
            Pair<Integer, Integer> pair;
            int exactIndex = StringsKt.indexOf$default((CharSequence)this.originalContent, (String)this.currentSearchContent, (int)this.lastProcessedIndex, (boolean)false, (int)4, null);
            if (exactIndex != -1) {
                pair = TuplesKt.to((Object)exactIndex, (Object)(exactIndex + this.currentSearchContent.length()));
            } else {
                pair = DiffUtilKt.lineTrimmedFallbackMatch(this.originalContent, this.currentSearchContent, this.lastProcessedIndex);
                if (pair == null) {
                    pair = DiffUtilKt.blockAnchorFallbackMatch(this.originalContent, this.currentSearchContent, this.lastProcessedIndex);
                }
            }
            if (pair == null) {
                throw new IllegalStateException("The SEARCH block:\n" + ((Object)StringsKt.trimEnd((CharSequence)this.currentSearchContent)).toString() + "\n...does not match anything in the file.");
            }
            Pair<Integer, Integer> match = pair;
            this.searchMatchIndex = ((Number)match.getFirst()).intValue();
            this.searchEndIndex = ((Number)match.getSecond()).intValue();
        }
        if (this.searchMatchIndex < this.lastProcessedIndex) {
            throw new CustomException("The SEARCH block:\n" + ((Object)StringsKt.trimEnd((CharSequence)this.currentSearchContent)).toString() + "\n...matched an incorrect content in the file.");
        }
        String string = this.originalContent.substring(this.lastProcessedIndex, this.searchMatchIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        this.result = this.result + string;
    }

    private final void resetForNextBlock() {
        this.state = ProcessingState.IDLE;
        this.currentSearchContent = "";
        this.searchMatchIndex = -1;
        this.searchEndIndex = -1;
    }

    private final void activateSearchState() {
        this.updateProcessingState(ProcessingState.SEARCH);
        this.currentSearchContent = "";
    }

    private final void activateReplaceState() {
        this.updateProcessingState(ProcessingState.REPLACE);
    }

    private final boolean isSearchingActive() {
        return this.state == ProcessingState.SEARCH;
    }

    private final boolean isReplacingActive() {
        return this.state == ProcessingState.REPLACE;
    }

    private final void updateProcessingState(ProcessingState newState) {
        boolean isValidTransition;
        boolean bl = this.state == ProcessingState.IDLE && newState == ProcessingState.SEARCH ? true : (isValidTransition = this.state == ProcessingState.SEARCH && newState == ProcessingState.REPLACE);
        if (!isValidTransition) {
            throw new CustomException("Invalid state transition.\nValid transitions are:\n- Idle \u2192 Search\n- Search \u2192 Replace");
        }
        this.state = newState;
    }

    private final boolean hasPendingNonStandardLines(int pendingNonStandardLineLimit) {
        return pendingNonStandardLineLimit < this.pendingNonStandardLines.size();
    }

    private final int findLastMatchingLineIndex(Regex regex, int lineLimit) {
        for (int i = lineLimit - 1; -1 < i; --i) {
            if (!regex.matches((CharSequence)this.pendingNonStandardLines.get(i))) continue;
            return i;
        }
        return -1;
    }

    private final int tryFixSearchBlock(int lineLimit) {
        int actualLimit;
        int removeLineCount = 0;
        int n = actualLimit = lineLimit < 0 ? this.pendingNonStandardLines.size() : lineLimit;
        if (actualLimit == 0) {
            throw new CustomException("Invalid SEARCH/REPLACE block structure - no lines available to process");
        }
        Regex searchTagRegex = SEARCH_BLOCK_START_REGEX;
        int searchTagIndex = this.findLastMatchingLineIndex(searchTagRegex, actualLimit);
        if (searchTagIndex != -1) {
            List<String> fixLines = this.pendingNonStandardLines.subList(searchTagIndex, actualLimit);
            fixLines.set(0, SEARCH_BLOCK_START);
            Iterator<String> iterator = fixLines.iterator();
            while (iterator.hasNext()) {
                String line;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                removeLineCount += this.internalProcessLine(line, false, searchTagIndex);
            }
        } else {
            throw new CustomException("Invalid REPLACE marker detected - could not find matching SEARCH block starting from line " + (searchTagIndex + 1));
        }
        return removeLineCount;
    }

    private final int tryFixReplaceBlock(int lineLimit) {
        int actualLimit;
        int removeLineCount = 0;
        int n = actualLimit = lineLimit < 0 ? this.pendingNonStandardLines.size() : lineLimit;
        if (actualLimit == 0) {
            throw new CustomException("");
        }
        Regex replaceBeginTagRegex = SEARCH_BLOCK_END_REGEX;
        int replaceBeginTagIndex = this.findLastMatchingLineIndex(replaceBeginTagRegex, actualLimit);
        if (replaceBeginTagIndex != -1) {
            List<String> fixLines = this.pendingNonStandardLines.subList(replaceBeginTagIndex - removeLineCount, actualLimit - removeLineCount);
            fixLines.set(0, SEARCH_BLOCK_END);
            Iterator<String> iterator = fixLines.iterator();
            while (iterator.hasNext()) {
                String line;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                removeLineCount += this.internalProcessLine(line, false, replaceBeginTagIndex - removeLineCount);
            }
        } else {
            throw new CustomException("Malformed REPLACE block - missing valid separator after line " + (replaceBeginTagIndex + 1));
        }
        return removeLineCount;
    }

    private final int tryFixSearchReplaceBlock(int lineLimit) {
        boolean likeReplaceEndTag;
        int actualLimit;
        int removeLineCount = 0;
        int n = actualLimit = lineLimit < 0 ? this.pendingNonStandardLines.size() : lineLimit;
        if (actualLimit == 0) {
            throw new CustomException("");
        }
        Regex replaceEndTagRegex = REPLACE_BLOCK_END_REGEX;
        int replaceEndTagIndex = this.findLastMatchingLineIndex(replaceEndTagRegex, actualLimit);
        boolean bl = likeReplaceEndTag = replaceEndTagIndex == actualLimit - 1;
        if (likeReplaceEndTag) {
            List<String> fixLines = this.pendingNonStandardLines.subList(replaceEndTagIndex - removeLineCount, actualLimit - removeLineCount);
            fixLines.set(fixLines.size() - 1, REPLACE_BLOCK_END);
            Iterator<String> iterator = fixLines.iterator();
            while (iterator.hasNext()) {
                String line;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                removeLineCount += this.internalProcessLine(line, false, replaceEndTagIndex - removeLineCount);
            }
        } else {
            throw new CustomException("Malformed SEARCH/REPLACE block structure: Missing valid closing REPLACE marker");
        }
        return removeLineCount;
    }

    private final int trimPendingNonStandardTrailingEmptyLines(int lineLimit) {
        int removedCount = 0;
        for (int i = Math.min(lineLimit, this.pendingNonStandardLines.size()) - 1; i >= 0 && ((CharSequence)((Object)StringsKt.trim((CharSequence)this.pendingNonStandardLines.get(i))).toString()).length() == 0; --i) {
            this.pendingNonStandardLines.remove(this.pendingNonStandardLines.size() - 1);
            ++removedCount;
        }
        return removedCount;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/NewFileContentConstructor$Companion;", "", "<init>", "()V", "SEARCH_BLOCK_START", "", "SEARCH_BLOCK_END", "REPLACE_BLOCK_END", "SEARCH_BLOCK_START_REGEX", "Lkotlin/text/Regex;", "getSEARCH_BLOCK_START_REGEX", "()Lkotlin/text/Regex;", "SEARCH_BLOCK_END_REGEX", "getSEARCH_BLOCK_END_REGEX", "REPLACE_BLOCK_END_REGEX", "getREPLACE_BLOCK_END_REGEX", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSEARCH_BLOCK_START_REGEX() {
            return SEARCH_BLOCK_START_REGEX;
        }

        @NotNull
        public final Regex getSEARCH_BLOCK_END_REGEX() {
            return SEARCH_BLOCK_END_REGEX;
        }

        @NotNull
        public final Regex getREPLACE_BLOCK_END_REGEX() {
            return REPLACE_BLOCK_END_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/NewFileContentConstructor$ProcessingState;", "", "<init>", "(Ljava/lang/String;I)V", "IDLE", "SEARCH", "REPLACE", "coderider-kilo-jetbrains"})
    public static final class ProcessingState
    extends Enum<ProcessingState> {
        public static final /* enum */ ProcessingState IDLE = new ProcessingState();
        public static final /* enum */ ProcessingState SEARCH = new ProcessingState();
        public static final /* enum */ ProcessingState REPLACE = new ProcessingState();
        private static final /* synthetic */ ProcessingState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProcessingState[] values() {
            return (ProcessingState[])$VALUES.clone();
        }

        public static ProcessingState valueOf(String value) {
            return Enum.valueOf(ProcessingState.class, value);
        }

        @NotNull
        public static EnumEntries<ProcessingState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = processingStateArray = new ProcessingState[]{ProcessingState.IDLE, ProcessingState.SEARCH, ProcessingState.REPLACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

