/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.util;

import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\rJ$\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\u0001J\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\u001bJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\t\u0010&\u001a\u00020\nH\u00c6\u0003JC\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010(\u001a\u00020\n2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001J\t\u0010+\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/FileNode;", "", "file", "Ljava/io/File;", "depth", "", "children", "", "parent", "allChildrenIncluded", "", "<init>", "(Ljava/io/File;ILjava/util/List;Lcn/gitlab/kilo/jetbrains/composer/util/FileNode;Z)V", "(Ljava/io/File;Lcn/gitlab/kilo/jetbrains/composer/util/FileNode;)V", "getFile", "()Ljava/io/File;", "getDepth", "()I", "getChildren", "()Ljava/util/List;", "getParent", "()Lcn/gitlab/kilo/jetbrains/composer/util/FileNode;", "getAllChildrenIncluded", "()Z", "setAllChildrenIncluded", "(Z)V", "fmt", "", "prefix", "isRoot", "isLast", "dict", "json", "huffman", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncn/gitlab/kilo/jetbrains/composer/util/FileNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,750:1\n1878#2,3:751\n1563#2:754\n1634#2,3:755\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncn/gitlab/kilo/jetbrains/composer/util/FileNode\n*L\n64#1:751,3\n76#1:754\n76#1:755,3\n*E\n"})
public final class FileNode {
    @NotNull
    private final File file;
    private final int depth;
    @NotNull
    private final List<FileNode> children;
    @Nullable
    private final FileNode parent;
    private boolean allChildrenIncluded;

    public FileNode(@NotNull File file, int depth, @NotNull List<FileNode> children, @Nullable FileNode parent, boolean allChildrenIncluded) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.file = file;
        this.depth = depth;
        this.children = children;
        this.parent = parent;
        this.allChildrenIncluded = allChildrenIncluded;
    }

    public /* synthetic */ FileNode(File file, int n, List list, FileNode fileNode, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            list = new ArrayList();
        }
        if ((n2 & 8) != 0) {
            fileNode = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(file, n, list, fileNode, bl);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final int getDepth() {
        return this.depth;
    }

    @NotNull
    public final List<FileNode> getChildren() {
        return this.children;
    }

    @Nullable
    public final FileNode getParent() {
        return this.parent;
    }

    public final boolean getAllChildrenIncluded() {
        return this.allChildrenIncluded;
    }

    public final void setAllChildrenIncluded(boolean bl) {
        this.allChildrenIncluded = bl;
    }

    public FileNode(@NotNull File file, @NotNull FileNode parent) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this(file, parent.depth + 1, null, parent, false, 20, null);
        parent.children.add(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String fmt(@NotNull String prefix, boolean isRoot, boolean isLast) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        StringBuilder builder2 = new StringBuilder();
        if (!isRoot) {
            builder2.append(prefix + (isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 "));
        }
        builder2.append(this.file.getName() + (this.file.isDirectory() ? "/" : "")).append('\n');
        if (!((Collection)this.children).isEmpty()) {
            String newPrefix = isRoot ? prefix : prefix + (isLast ? "    " : "\u2502   ");
            Iterable $this$forEachIndexed$iv = this.children;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void child;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FileNode fileNode = (FileNode)item$iv;
                int i = n;
                boolean bl = false;
                builder2.append(child.fmt(newPrefix, false, i == this.children.size() - 1));
            }
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String fmt$default(FileNode fileNode, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return fileNode.fmt(string, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object dict() {
        Object object;
        if (this.file.isFile()) {
            object = this.file.getName();
        } else if (this.children.isEmpty()) {
            object = this.file.getName() + "/";
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.children;
            String string = this.file.getName() + "/";
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileNode fileNode = (FileNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.dict());
            }
            object = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)((List)destination$iv$iv)));
        }
        String string = object;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String json() {
        String string = new Gson().toJson(this.dict());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @NotNull
    public final String huffman() {
        StringBuilder stringBuilder;
        StringBuilder $this$huffman_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$huffman_u24lambda_u244.append(this.file.getName());
        if (this.file.isDirectory()) {
            $this$huffman_u24lambda_u244.append('(');
            String it = CollectionsKt.joinToString$default((Iterable)this.children, (CharSequence)",", null, null, (int)0, null, FileNode::huffman$lambda$4$lambda$2, (int)30, null);
            boolean bl2 = false;
            $this$huffman_u24lambda_u244.append(it);
            if (!this.allChildrenIncluded) {
                $this$huffman_u24lambda_u244.append(((CharSequence)it).length() > 0 ? "," : "");
                $this$huffman_u24lambda_u244.append("...");
            }
            $this$huffman_u24lambda_u244.append(')');
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final File component1() {
        return this.file;
    }

    public final int component2() {
        return this.depth;
    }

    @NotNull
    public final List<FileNode> component3() {
        return this.children;
    }

    @Nullable
    public final FileNode component4() {
        return this.parent;
    }

    public final boolean component5() {
        return this.allChildrenIncluded;
    }

    @NotNull
    public final FileNode copy(@NotNull File file, int depth, @NotNull List<FileNode> children, @Nullable FileNode parent, boolean allChildrenIncluded) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new FileNode(file, depth, children, parent, allChildrenIncluded);
    }

    public static /* synthetic */ FileNode copy$default(FileNode fileNode, File file, int n, List list, FileNode fileNode2, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file = fileNode.file;
        }
        if ((n2 & 2) != 0) {
            n = fileNode.depth;
        }
        if ((n2 & 4) != 0) {
            list = fileNode.children;
        }
        if ((n2 & 8) != 0) {
            fileNode2 = fileNode.parent;
        }
        if ((n2 & 0x10) != 0) {
            bl = fileNode.allChildrenIncluded;
        }
        return fileNode.copy(file, n, list, fileNode2, bl);
    }

    @NotNull
    public String toString() {
        return "FileNode(file=" + this.file + ", depth=" + this.depth + ", children=" + this.children + ", parent=" + this.parent + ", allChildrenIncluded=" + this.allChildrenIncluded + ")";
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.depth);
        result2 = result2 * 31 + ((Object)this.children).hashCode();
        result2 = result2 * 31 + (this.parent == null ? 0 : this.parent.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.allChildrenIncluded);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileNode)) {
            return false;
        }
        FileNode fileNode = (FileNode)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)fileNode.file)) {
            return false;
        }
        if (this.depth != fileNode.depth) {
            return false;
        }
        if (!Intrinsics.areEqual(this.children, fileNode.children)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parent, (Object)fileNode.parent)) {
            return false;
        }
        return this.allChildrenIncluded == fileNode.allChildrenIncluded;
    }

    private static final CharSequence huffman$lambda$4$lambda$2(FileNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.huffman();
    }
}

